/* get the directory tree */

#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>

#include "main.h"
#include "getdir.h"
#include "dirlow.h" // finally,some step towards "highspeed"
#include "dndsetup.h"
#include "menusys.h"
#include "vfs.h"
#include "helpings.h"

/* uncomment for debugging */
/* #define DEBUG */

gchar getdir_dnd_receiverstring[2048];

char *getdir_drag(gpointer data)
{
   getdir_dirinfo *info=data;
   char *uri=vfs_buildvfsuri(info->fs,info->dirname);
   strcpy(getdir_dnd_receiverstring,uri);
   free(uri);
   strcat(getdir_dnd_receiverstring,CRLF);
   return getdir_dnd_receiverstring;
}
;

void getdir_cb_collapse(GtkWidget *item,getdir_dirinfo *info);
void getdir_cb_expand(GtkWidget *item,getdir_dirinfo *info) // this is the internal callback for reloading directory contents
{
   int subdirs=0;
   if (vfs_islink(info->fs,info->dirname))
     {
	char *dest=vfs_getlinkdestination(info->fs,info->dirname);
	if (dest)
	  {
	     subdirs=vfs_numberofsubdirs(info->fs,dest);
	     free(dest);
	  };
     };
   if (vfs_isdirectory(info->fs,info->dirname))
     subdirs=vfs_numberofsubdirs(info->fs,info->dirname);
   /* only remove if present - may not be present if chdir is executed
    * from the filelist by double clicking on a directory within a
    * newly mounted partition */
   if (GTK_TREE_ITEM_SUBTREE(GTK_TREE_ITEM(item))!=NULL)
     gtk_tree_item_remove_subtree(GTK_TREE_ITEM(item));

   if ((subdirs>2)||(info->parent==NULL))
     {
	/* check this existance of subdir entries once more to fix a drawing error */
	/* do not remove expand sign if parent tree item */
	gtk_signal_disconnect_by_func(GTK_OBJECT(item),
				      GTK_SIGNAL_FUNC(getdir_cb_expand),
				      info);
	getdir_tree(GTK_TREE_ITEM(item),
		    info);
	gtk_signal_connect(GTK_OBJECT(item),"collapse",
			   GTK_SIGNAL_FUNC(getdir_cb_collapse),info);
	gtk_tree_item_expand(GTK_TREE_ITEM(item));
     }
   ;
}
; // do only call this the first time a directory is expanded,afterwards disable signal handler
// this call would end up in some infinite recursion otherwise
//
//
void getdir_cb_collapse(GtkWidget *item,getdir_dirinfo *info) // remove directory from memory once its leaf has been closed
{
   GList *selection;

   selection=GTK_TREE_SELECTION(GTK_TREE_ITEM_SUBTREE(GTK_ITEM(item)));
   if ((selection==NULL) || (selection->data!=item))
     gtk_tree_select_child(GTK_TREE_ROOT_TREE
			   (GTK_TREE_ITEM_SUBTREE
			    (GTK_ITEM(item)))
			   ,item);
   gtk_signal_connect(GTK_OBJECT(item),"expand",    // reconnect reading routine
		      GTK_SIGNAL_FUNC(getdir_cb_expand),info);
   gtk_signal_disconnect_by_func(GTK_OBJECT(item),
				 GTK_SIGNAL_FUNC(getdir_cb_collapse),
				 info);
   gtk_tree_item_remove_subtree(GTK_TREE_ITEM(item));
   gtk_tree_item_set_subtree(GTK_TREE_ITEM(item),
			     gtk_tree_new());            // add dummy tree instead of the real directory

}
;

/* on the destroy of a widget, free the associated getdir_expanddirinfo */
void getdir_cb_destroy(GtkWidget *item,getdir_dirinfo *info)
{
#ifdef DEBUG
   printf ("getdir_cb_destroy: got destroy event for tree item %s\n",info->dirname);
#endif
   getdir_dirinfo_delete(info);
};

/* select parent tree item to be the current one */
void getdir_selectparentdir(GtkWidget *treeitem)
{
   GtkTree *parenttree = GTK_TREE(treeitem->parent);
   if (parenttree)
     {
	GtkTreeItem *parentitem = GTK_TREE_ITEM(parenttree->tree_owner);
	if (parentitem)
	  {
	     gtk_tree_select_child(GTK_TREE_ROOT_TREE(GTK_TREE_ITEM_SUBTREE(parentitem)),
				   GTK_WIDGET(parentitem));
	  };
     };
};

/* select item with name "name" from "tree",which is expanded automatically
 * if this shouldnt be already the case.
 *  name: item name
 *  tree: GtkTreeItem,as the tree has to be expandable on demand */
GtkTreeItem* getdir_selectsubdir(GtkWidget *tree,
			 char *name)
{
   GtkTree *subtree;
   GList *current;
   GtkTreeItem *found;
   GtkLabel *label;
   char *labeltext;

   /* the item has to take care of expand event count for itself
    * anyway,so why should we care about that here then ? ;-) */
   gtk_tree_item_expand(GTK_TREE_ITEM(tree));
   subtree=GTK_TREE(GTK_TREE_ITEM_SUBTREE(tree));
   if (subtree)
     current=subtree->children;
   else
     current=NULL;
   found=NULL;
   while ((current!=NULL)&&(found==NULL))
     {
	label=GTK_LABEL(gtk_container_children(GTK_CONTAINER(current->data))->data);
	gtk_label_get(label,&labeltext);
	if (!strcmp(name,labeltext))
	  found=GTK_TREE_ITEM(current->data);

	current=current->next;
     };
   if (found!=NULL)
     gtk_tree_select_child(GTK_TREE_ROOT_TREE(GTK_TREE_ITEM_SUBTREE(tree)),
			   GTK_WIDGET(found));

   return found;
}
;

void getdir_selectsubdir_recursive(GtkWidget* tree,
		char* name)
{
	GtkTreeItem* item = tree;
	char* filename=strdup(name);
	char* pos=filename;
	char* nextpos;

	if (!(tree&&name))
		return NULL;

	/* Check if first character is a slash, if yes, ignore it */
	if (*pos=='/')
		++pos;

	do
	{
	/* Find position of next slash */
		nextpos=strstr(pos, "/");
		if (nextpos)
		{
			*nextpos=0;
			++nextpos;
		}

		/* Jump into directory */
		item = getdir_selectsubdir(GTK_WIDGET(item), pos);

		pos=nextpos;
	}
	while (pos&&item);
	
	free(filename);
	return item;
}

getdir_dirinfo *getdir_dirinfo_create(char *path,
				      vfs_filesystem *filesystem,
				      GtkSignalFunc select,
				      GtkSignalFunc unselect,
				      void *data,
				      int allowdrag,
				      dndsetup_dropcallback receiver,
				      menusys_menu *popup)
{
   getdir_dirinfo *di;
   di=(getdir_dirinfo*)malloc(sizeof(getdir_dirinfo));
   di->dirname=strdup(path);
   di->fs=filesystem;
   di->select=select;
   di->unselect=unselect;
   di->data=data;
   di->allowdrag=allowdrag;
   di->receiver=receiver;
   di->popup=popup;
   return di;
}
;

void getdir_dirinfo_delete(getdir_dirinfo *info)
{
   if (info)
     {
	if (info->dirname)
	  free(info->dirname);
	free(info);
     };
};

menusys_menu *getdir_providedynpopup(gpointer data)
{
   /* FIXME: update dynamic structures here */
   getdir_dirinfo *info=(getdir_dirinfo*)data;
   return (info->popup);
}

void getdir_connectstdsignals(GtkWidget *item,
			      GtkWidget *parent,
			      getdir_dirinfo *info)
{
   info->referringto=item;
   info->parent=parent;
   gtk_signal_connect(GTK_OBJECT(item),"expand",
		      GTK_SIGNAL_FUNC(getdir_cb_expand),info);
   gtk_signal_connect(GTK_OBJECT(item),"select",
		      info->select,info);
   gtk_signal_connect(GTK_OBJECT(item),"deselect",
		      info->unselect,info);
   gtk_signal_connect(GTK_OBJECT(item),"destroy",
		      GTK_SIGNAL_FUNC(getdir_cb_destroy),info);
   if (info->allowdrag)
     {
	dndsetup_drag(item,
		      getdir_drag,
		      NULL,
		      info);
     }
   ;

   if (info->receiver!=NULL)
     {
	dndsetup_drop(item,
		      info->receiver,
		      info);
     }
   ;

   if (info->popup!=NULL)
     menusys_attachpopupmenu(item,
			     info->popup,
			     info);
}
;

/* GtkTreeItem *host is new: it is necessary to make drag and drop support
 * work,as when drag and drop is enabled a Tree Item has to be connected
 * all the way down to the root tree,which has to be attached to some visible
 * widget already. To maintain getdir_trees full functionality,you are
 * allowed to pass a NULL pointer instead of the GtkTreeItem,if the tree
 * you intend to create is a root tree. otherwise getdir_tree will
 * automatically attach the created tree to the passed GtkTreeItem. */
GtkWidget *getdir_tree(GtkTreeItem *host,getdir_dirinfo *di)
{
   GtkWidget *dirtree;
   GtkWidget *entrytree;
   gtoaster_handle_t dir;
   char *newdir;
   getdir_dirinfo *getdir_expanddirinfo;

   dirtree=gtk_tree_new();
   if (host!=NULL)
     {
	gtk_tree_item_set_subtree(host,dirtree);
	gtk_widget_show(dirtree);
     }
   ;

   gtk_tree_append(GTK_TREE(dirtree),
		   gtk_tree_item_new_with_label("Test"));

   /* this line seems to solve a major problem ;-)
    * the thing is that I do not know why yet ....
    * This time it really looks like some bug in the GtkTree Widget
    * see Changelog for Details on that...
    * and btw: it is intended that the widget added here is never
    * actually shown within the tree,as it is not even intended to
    * exist at all */

   dir=vfs_opendir(di->fs,di->dirname);
   if (dir)
     {
	GList *items=NULL;
	while ((newdir=vfs_readdirentry(di->fs,dir))!=NULL)
	  items=g_list_prepend(items,(gpointer)newdir);
	items=g_list_sort(items,(GCompareFunc)strcmp);
	vfs_closedir(di->fs,dir);

	while (items)
	  {
	     int isdir=0;
	     newdir=(char*)items->data;
	     items=g_list_remove(items,items->data);
	     if (vfs_islink(di->fs,newdir))
	       {
		  char *dest=vfs_getlinkdestination(di->fs,newdir);
		  if (dest)
		    {
		       if (vfs_isdirectory(di->fs,dest))
			 isdir=vfs_numberofsubdirs(di->fs,dest);
		       free(dest);
		    };
	       };
	     if (vfs_isdirectory(di->fs,newdir))
	       isdir=vfs_numberofsubdirs(di->fs,newdir);

	     if (isdir)
	       {
		  char *nameonly=helpings_rpathcomponent(newdir);
		  entrytree=gtk_tree_item_new_with_label(nameonly);
		  gtk_tree_append(GTK_TREE(dirtree),entrytree);

		  free(nameonly);
		  if (isdir>2)
		    gtk_tree_item_set_subtree(GTK_TREE_ITEM(entrytree),
					      gtk_tree_new());
		  // do add a dummy tree only - real directory is read within expand callback
		  gtk_widget_show(entrytree);
		  getdir_expanddirinfo=
		    getdir_dirinfo_create(newdir,
					  di->fs,
					  di->select,
					  di->unselect,
					  di->data,
					  di->allowdrag,
					  di->receiver,
					  di->popup);
		  getdir_connectstdsignals(entrytree,
					   GTK_WIDGET(host),
					   getdir_expanddirinfo);
	       }
	     ;
	     free(newdir);
	  }
	;
     }
   return dirtree;
}
;

