/* get the directory tree */

#ifndef GETDIR_H
#define GETDIR_H

#include <gtk/gtk.h>

#include "menusys.h"
#include "dndsetup.h"
#include "vfs.h"

typedef struct // used for internal purposes,needed for dynamically opening directories
{
   GtkWidget *referringto; /* this is filled out by connectstdsignals */
   GtkWidget *parent;      /* this is filled out by connectstdsignals */
   /* parent is a pointer to the parent TREE_ITEM,not the parent tree itself ! */
   GtkSignalFunc select;
   GtkSignalFunc unselect;

   char *dirname;
   vfs_filesystem *fs;
   void *data;
   int allowdrag;
   dndsetup_dropcallback receiver;
   menusys_menu *popup;
}
getdir_dirinfo;

GtkWidget *getdir_tree(GtkTreeItem *host,getdir_dirinfo*);
// The host item the tree should get connected to,
// if NULL,tree is assumed to be a root tree
//
getdir_dirinfo *getdir_dirinfo_create(char*,
				      vfs_filesystem *filesystem,
				      GtkSignalFunc,
				      GtkSignalFunc,
				      void*,
				      int allowdrag,
				      dndsetup_dropcallback receiver,
				      menusys_menu *popup
				      );
// create directory info entry as it is needed by the various callback functions
//   * Name of the Directory
//   * filesystem where the referenced directory is located
//   * Handler to call when a directory is selected
//   * Handler to call when a directory is unselected
//   * Data to pass to the handler functions
//   * allow directories to be dragged from tree
//   * if (!NULL) call this handler whenever someting is dropped onto a
//     tree item,otherwise ignore dropped items (drop will be rejected)
// those informations are handed down to the subtrees,Directoryname is adapted
// appropriately
//
void getdir_dirinfo_delete(getdir_dirinfo *info);
/* delete a dirinfo structure, handling the dynamically managed parts */

void getdir_connectstdsignals(GtkWidget *item,
			      GtkWidget *parent, // set this to NULL if this is a root item
			      getdir_dirinfo*);  // useful almost always except when you display a getdir_tree directly

/* The returned items are only for temporary use, do not free them */
GtkTreeItem* getdir_selectsubdir(GtkWidget *treeitem,char *name);

/* Same as funtion before, but working recursively */
void getdir_selectsubdir_recursive(GtkWidget* tree,
		char* name);
// make the parent tree item the current one
void getdir_selectparentdir(GtkWidget *treeitem);

#endif // GETDIR_H

