/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Configuration.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2006/03/16 11:20:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.util;

import java.io.File;
import java.io.ByteArrayInputStream;
import java.util.Vector;
import java.net.URL;
import org.w3c.dom.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory; 
import org.xml.sax.InputSource;

public final class Configuration {
    public static Element configElementFromArgs(String[] args) throws Exception {
	URL configURL = null;
	for (int i = 0; i < args.length ; i++)
	    if (args[i].equals("-configFile") || args[i].equals("-cf")) {
		File config = new File(args[++i]);
		if (config.exists())
		    configURL = config.toURL();
		else
		    throw new Exception("config file doesn't exist");
	    }
	    else if (args[i].equals("-configURL") || args[i].equals("-cu"))
		configURL = new URL(args[++i]);
      
	if (configURL == null) {
	    System.err.println("No configuration specified!");
	    System.err.println("use: -configFile file | -configURL url");
	    return null;
	}
	else
	    return parse(configURL);
    }

    public static Element parse(URL location) throws Exception {
	DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setValidating(false);
        DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
        Document document = dBuilder.parse(location.openStream());
	return document.getDocumentElement();
    }

    public static Element parse(byte[] xmlBytes) throws Exception {
	ByteArrayInputStream input = new ByteArrayInputStream(xmlBytes);
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setValidating(false);
        DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
        Document document = dBuilder.parse(input);
	return document.getDocumentElement();
    }

    /** arg: Element that can be direct parent of PrefixTranslation-s
	either in indexing or search engine configurations
    */
    public static String[] processPrefixTranslations(Element el) {
	NodeList list = el.getElementsByTagName("PrefixTranslation");
	if (list.getLength() > 0) {
	    Vector translations = new Vector();
	    for (int i = 0; i < list.getLength(); i++) {
		final Element ptEl = (Element)list.item(i);
		translations.addElement(ptEl.getAttribute("prefix"));
		translations.addElement(ptEl.getAttribute("replacement"));
	    }
	    String[] prefixTranslations = new String[translations.size()];
	    return (String[])translations.toArray(prefixTranslations);
	}
	else
	return null;
    }
}
