/*
 * HsqlDatabase.java
 *
 * Created on 18. Januar 2006, 11:40
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package complex.dbaccess;

import java.io.File;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.sdb.*;
import com.sun.star.sdbc.*;
import com.sun.star.lang.*;
import com.sun.star.beans.*;
import com.sun.star.frame.*;

/**
 *
 * @author fs93730
 */
public class HsqlDatabase
{
    // the service factory
    XMultiServiceFactory    m_orb;
    // the URL of the temporary file used for the database document
    String                  m_databaseDocumentFile;
    // the data source belonging to the database document
    XOfficeDatabaseDocument m_databaseDocument;
    // the default connection
    XConnection             m_connection;
    
    /** Creates a new instance of HsqlDatabase */
    public HsqlDatabase( XMultiServiceFactory orb ) throws Exception
    {
        m_orb = orb;
        createDBDocument();
    }

    private void createDBDocument() throws Exception
    {
        m_databaseDocumentFile = new String();
        String str = File.createTempFile("testdb",".odb").getCanonicalPath();
        str = str.replaceAll(" ","%20");
        str = "file:///" +str;
        m_databaseDocumentFile = str.replace('\\','/');            

        m_databaseDocument = (XOfficeDatabaseDocument)UnoRuntime.queryInterface(
            XOfficeDatabaseDocument.class, m_orb.createInstance( "com.sun.star.sdb.OfficeDatabaseDocument" ) );
        XDataSource dataSource = m_databaseDocument.getDataSource();
        XPropertySet dsProperties = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, dataSource );
        dsProperties.setPropertyValue("URL", "sdbc:embedded:hsqldb");

        XStorable storable = (XStorable)UnoRuntime.queryInterface( XStorable.class, m_databaseDocument );
        storable.storeAsURL(m_databaseDocumentFile,new PropertyValue[]{});
    }

    /** returns a connection to the database
     *
     * Multiple calls to this method return the same connection. The HsqlDatabase object keeps
     * the ownership of the connection, so you don't need to (and should not) dispose/close it.
     *
     */
    public XConnection defaultConnection() throws SQLException
    {
        if ( m_connection != null )
            return m_connection;
        m_connection  = m_databaseDocument.getDataSource().getConnection(new String(),new String());
        return m_connection;
    }

    /** executes the given SQL statement via the defaultConnection
     */
    public void executeStatement( String statementString ) throws SQLException
    {
        XStatement statement = defaultConnection().createStatement();
        statement.execute( statementString );
    }

    protected void finalize() throws Throwable
    {
        if ( m_connection != null )
        {
            ((XComponent)UnoRuntime.queryInterface(XComponent.class,m_connection)).dispose();
            ((XComponent)UnoRuntime.queryInterface(XComponent.class,m_databaseDocument)).dispose();
        }

        try{
            File file = new File(m_databaseDocumentFile);
            file.delete();
        }
        catch(Exception e)
        {
        }
        super.finalize();
    }
}
