/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: b2dmline.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:21:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _B2D_MLINE_HXX
#include "b2dmline.hxx"
#endif

#ifndef _SV_OUTDEV_HXX
#include <vcl/outdev.hxx>
#endif

//************************************************************
//   InterActionObjectLine
//************************************************************

TYPEINIT1(B2dIAOLine, B2dIAObject);

B2dIAOLine::B2dIAOLine(B2dIAOManager* pMan, Point aStartPos, Point aEndPos)
:	B2dIAObject(pMan, aStartPos, Color(COL_LIGHTGREEN)),
	a2ndPosition(GetGeomPositions(), aEndPos)
{
}

B2dIAOLine::~B2dIAOLine() 
{
}

void B2dIAOLine::CreateGeometry()
{
	Region aOverRegion = GetManager()->GetClipRegion();
	aOverRegion.Intersect(Region(GetBaseRect()));

	if(!aOverRegion.IsEmpty())
		AddLine(GetBasePositionPixel(), Get2ndPositionPixel());
}

void B2dIAOLine::CreateBaseRect()
{
	Rectangle aRect = Rectangle(GetBasePositionPixel(), Get2ndPositionPixel());
	aRect.Justify();
	SetBaseRect(aRect);
}

void B2dIAOLine::Set2ndPosition(Point aNew) 
{ 
	if(aNew != a2ndPosition.GetPosition()) 
	{ 
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// save new position
		a2ndPosition.SetPosition(aNew); 
	}
}

BOOL B2dIAOLine::IsHit(const Point& rPixelPos, UINT16 nTol) const
{
	if(IsHittable())
	{
		INT32 nLenX = Get2ndPositionPixel().X() - GetBasePositionPixel().X();
		INT32 nLenY = Get2ndPositionPixel().Y() - GetBasePositionPixel().Y();
		double fMyLen = sqrt((double)((nLenX * nLenX) + (nLenY * nLenY)));
		
		// add minimal tolerance if none is set (1/100 of own length)
		double fTol = (nTol) ? (double)nTol : fMyLen * 0.01;

		nLenX = rPixelPos.X() - GetBasePositionPixel().X();
		nLenY = rPixelPos.Y() - GetBasePositionPixel().Y();
		double fOuterLen = sqrt((double)((nLenX * nLenX) + (nLenY * nLenY)) - fTol);

		nLenX = rPixelPos.X() - Get2ndPositionPixel().X();
		nLenY = rPixelPos.Y() - Get2ndPositionPixel().Y();
		fOuterLen += sqrt((double)((nLenX * nLenX) + (nLenY * nLenY)));

		if(fOuterLen <= fMyLen)
			return TRUE;
	}
	return FALSE;
}

//************************************************************
//   InterActionObjectLineStriped
//************************************************************

TYPEINIT1(B2dIAOLineStriped, B2dIAOLine);

B2dIAOLineStriped::B2dIAOLineStriped(B2dIAOManager* pMan, Point aStartPos, Point aEndPos, UINT16 nSLen)
:	B2dIAOLine(pMan, aStartPos, aEndPos),
	nStripeLen(nSLen)
{
}

B2dIAOLineStriped::~B2dIAOLineStriped() 
{
}

BOOL B2dIAOLineStriped::AddLinePixel(const Point& rPos, UINT32 nPixelNum)
{
	UINT32 nMod = nPixelNum % (GetStripeLength()<<1);
	if(nMod < GetStripeLength())
		AddPixel(rPos, GetBaseColor());
	return TRUE;
}

void B2dIAOLineStriped::SetStripeLength(UINT16 nNew)
{
	if(nNew != GetStripeLength())
	{
		BaseRectChange();
		nStripeLen = nNew;
	}
}

//************************************************************
//   InterActionObjectLineTwoColor
//************************************************************

TYPEINIT1(B2dIAOLineTwoColor, B2dIAOLineStriped);

B2dIAOLineTwoColor::B2dIAOLineTwoColor(B2dIAOManager* pMan, Point aStartPos, Point aEndPos, UINT16 nSLen)
:	B2dIAOLineStriped(pMan, aStartPos, aEndPos, nSLen)
{
	// Init vars
	a2ndColor = Color(COL_BLACK);
}

B2dIAOLineTwoColor::~B2dIAOLineTwoColor() 
{
}

BOOL B2dIAOLineTwoColor::AddLinePixel(const Point& rPos, UINT32 nPixelNum)
{
	UINT32 nMod = nPixelNum % (GetStripeLength()<<1);
	AddPixel(rPos, (nMod < GetStripeLength()) ? GetBaseColor() : Get2ndColor());
	return TRUE;
}

void B2dIAOLineTwoColor::Set2ndColor(Color aNew) 
{ 
	if(aNew != a2ndColor) 
	{
		// throw away geometry
		GeometryChange(); 

		// remember new color
		a2ndColor = aNew; 
	}
}

//************************************************************
//   InterActionObjectLineTwoColorAnim
//************************************************************

TYPEINIT1(B2dIAOLineTwoColorAnim, B2dIAOLineTwoColor);

B2dIAOLineTwoColorAnim::B2dIAOLineTwoColorAnim(B2dIAOManager* pMan, Point aStartPos, Point aEndPos, UINT16 nSLen)
:	B2dIAOLineTwoColor(pMan, aStartPos, aEndPos, nSLen)
{
	nStartCount = 0;
	nStartAdd = 0;
	SetAnimation(TRUE);
}

B2dIAOLineTwoColorAnim::~B2dIAOLineTwoColorAnim() 
{
}

BOOL B2dIAOLineTwoColorAnim::AddLinePixel(const Point& rPos, UINT32 nPixelNum)
{
	UINT32 nMod = (nPixelNum + nStartAdd) % (GetStripeLength()<<1);
	AddPixel(rPos, (nMod < GetStripeLength()) ? GetBaseColor() : Get2ndColor());
	return TRUE;
}

void B2dIAOLineTwoColorAnim::AnimationStep(UINT32 nAnimCounter)
{
	nStartCount++;
	if(nStartCount == 10)
	{
		// all three times when the counter comes
		nStartAdd++;
		if(nStartAdd == (GetStripeLength()<<1))
			nStartAdd = 0;
		GeometryChange();

		// reset counter
		nStartCount = 0;
	}
}


