/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: light3d.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 22:39:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//BFS01#ifndef _SVDIO_HXX
//BFS01#include "svdio.hxx"
//BFS01#endif

//BFS01#ifndef _E3D_GLOBL3D_HXX
//BFS01#include "globl3d.hxx"
//BFS01#endif

#ifndef _E3D_LIGHT3D_HXX
#include "light3d.hxx"
#endif

//BFS01#ifndef _SVDPAGE_HXX
//BFS01#include "svdpage.hxx"
//BFS01#endif

//BFS01TYPEINIT1(E3dLight, E3dPointObj);

/*************************************************************************
|*
|* E3dLight-Konstruktor
|*
\************************************************************************/

//BFS01E3dLight::E3dLight(const Vector3D& rPos, const Color& rColor,
//BFS01					double fLightIntensity) :
//BFS01	E3dPointObj(rPos),
//BFS01	fIntensity(fLightIntensity),
//BFS01	bOn(TRUE),
//BFS01	bVisible(FALSE)
//BFS01{
//BFS01	SetColor(rColor);
//BFS01	aLocalBoundVol = Volume3D();
//BFS01	bBoundVolValid = FALSE;
//BFS01}

/*************************************************************************
|*
|* E3dLight-Konstruktor 2
|*
\************************************************************************/

//BFS01E3dLight::E3dLight() :
//BFS01	E3dPointObj(Vector3D()),
//BFS01
//BFS01	aColor(255, 255, 255),
//BFS01
//BFS01	fRed(1.0),
//BFS01	fGreen(1.0),
//BFS01	fBlue(1.0),
//BFS01	fIntensity(1.0),
//BFS01	bOn(TRUE),
//BFS01	bVisible(FALSE)
//BFS01{
//BFS01}

/*************************************************************************
|*
|* protected, daher kein Einfuegen von Objekten von aussen moeglich
|*
\************************************************************************/

//BFS01void E3dLight::Insert3DObj(E3dObject* p3DObj)
//BFS01{
//BFS01//	E3dPointObj::Insert3DObj(p3DObj);
//BFS01	GetSubList()->InsertObject(p3DObj);
//BFS01}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

//BFS01UINT16 E3dLight::GetObjIdentifier() const
//BFS01{
//BFS01	return E3D_LIGHT_ID;
//BFS01}

/*************************************************************************
|*
|* Lichtstaerke an uebergeben Punkt bestimmen und die akkumulierte
|* Punktfarbe berechnen; Return = TRUE bedeutet, dass die maximale
|* Farbintensitaet aller Farbanteile erreicht ist.
|*
\************************************************************************/

//BFS01FASTBOOL E3dLight::ImpCalcLighting(Color& rNewColor, const Color& rPntColor,
//BFS01									double fR, double fG, double fB) const
//BFS01{
//BFS01	ULONG	nR(rNewColor.GetRed()),
//BFS01			nG(rNewColor.GetGreen()),
//BFS01			nB(rNewColor.GetBlue());
//BFS01	ULONG	nPntR(rPntColor.GetRed()),
//BFS01			nPntG(rPntColor.GetGreen()),
//BFS01			nPntB(rPntColor.GetBlue());
//BFS01
//BFS01	if ( bOn )
//BFS01	{
//BFS01		nR += (ULONG) (fR * nPntR);
//BFS01		nG += (ULONG) (fG * nPntG);
//BFS01		nB += (ULONG) (fB * nPntB);
//BFS01
//BFS01		nR = Min(nR, nPntR);
//BFS01		nG = Min(nG, nPntG);
//BFS01		nB = Min(nB, nPntB);
//BFS01
//BFS01		rNewColor.SetRed((sal_uInt8) nR);
//BFS01		rNewColor.SetGreen((sal_uInt8) nG);
//BFS01		rNewColor.SetBlue((sal_uInt8) nB);
//BFS01	}
//BFS01	return ( nR == nPntR && nG == nPntG && nB == nPntB );
//BFS01}

/*************************************************************************
|*
|* Lichtstaerke an uebergeben Punkt bestimmen und die akkumulierte
|* Punktfarbe berechnen
|*
\************************************************************************/

//BFS01FASTBOOL E3dLight::CalcLighting(Color& rNewColor,
//BFS01								const Vector3D& rPnt,
//BFS01								const Vector3D& rPntNormal,
//BFS01								const Color& rPntColor)
//BFS01{
//BFS01	return ImpCalcLighting(rNewColor, rPntColor, fRed, fGreen, fBlue);
//BFS01}

/*************************************************************************
|*
|* neue Position setzen und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

//BFS01void E3dLight::SetPosition(const Vector3D& rNewPos)
//BFS01{
//BFS01	E3dPointObj::SetPosition(rNewPos);
//BFS01	CreateLightObj();
//BFS01}

/*************************************************************************
|*
|* neue Intensitaet setzen und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

//BFS01void E3dLight::SetIntensity(double fNew)
//BFS01{
//BFS01	if ( fIntensity != fNew )
//BFS01	{
//BFS01		fIntensity = fNew;
//BFS01		StructureChanged(this);
//BFS01		SetColor(aColor);
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* neue Farbe setzen und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

//BFS01void E3dLight::SetColor(const Color& rNewColor)
//BFS01{
//BFS01	if ( aColor != rNewColor )
//BFS01	{
//BFS01		aColor = rNewColor;
//BFS01		StructureChanged(this);
//BFS01	}
//BFS01
//BFS01	fRed    = fIntensity * aColor.GetRed()   / 255;
//BFS01	fGreen  = fIntensity * aColor.GetGreen() / 255;
//BFS01	fBlue   = fIntensity * aColor.GetBlue()  / 255;
//BFS01}

/*************************************************************************
|*
|* Lichtquelle ein-/ausschalten und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

//BFS01void E3dLight::SetOn(FASTBOOL bNewOn)
//BFS01{
//BFS01	if ( bOn != bNewOn )
//BFS01	{
//BFS01		bOn = bNewOn;
//BFS01		StructureChanged(this);
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Darstellung des Lichtobjekts in der Szene ein-/ausschalten
|*
\************************************************************************/

//BFS01void E3dLight::SetLightObjVisible(FASTBOOL bNewVisible)
//BFS01{
//BFS01	if ( bVisible != bNewVisible )
//BFS01	{
//BFS01		bVisible = bNewVisible;
//BFS01		CreateLightObj();
//BFS01
//BFS01		if ( bVisible )
//BFS01			aLocalBoundVol = Volume3D(aPosition, Vector3D(), FALSE);
//BFS01		else
//BFS01			aLocalBoundVol = Volume3D();
//BFS01
//BFS01		bBoundVolValid = FALSE;
//BFS01		StructureChanged(this);
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Darstellung des Lichtobjekts in der Szene ein-/ausschalten
|*
\************************************************************************/

//BFS01void E3dLight::CreateLightObj()
//BFS01{
//BFS01}

/*************************************************************************
|*
|* sichern
|*
\************************************************************************/

//BFS01void E3dLight::WriteData(SvStream& rOut) const
//BFS01{
//BFS01#ifndef SVX_LIGHT
//BFS01	E3dPointObj::WriteData(rOut);
//BFS01
//BFS01#ifdef E3D_STREAMING
//BFS01
//BFS01	SdrDownCompat aCompat(rOut, STREAM_WRITE);
//BFS01#ifdef DBG_UTIL
//BFS01	aCompat.SetID("E3dLight");
//BFS01#endif
//BFS01
//BFS01	rOut << aColor;
//BFS01	rOut << fIntensity;
//BFS01	rOut << fRed;
//BFS01	rOut << fGreen;
//BFS01	rOut << fBlue;
//BFS01	rOut << BOOL(bOn);
//BFS01	rOut << BOOL(bVisible);
//BFS01#endif
//BFS01#endif	// #ifndef SVX_LIGHT
//BFS01}

/*************************************************************************
|*
|* laden
|*
\************************************************************************/

//BFS01void E3dLight::ReadData(const SdrObjIOHeader& rHead, SvStream& rIn)
//BFS01{
//BFS01	if (ImpCheckSubRecords (rHead, rIn))
//BFS01	{
//BFS01		E3dPointObj::ReadData(rHead, rIn);
//BFS01
//BFS01		SdrDownCompat aCompat(rIn, STREAM_READ);
//BFS01#ifdef DBG_UTIL
//BFS01		aCompat.SetID("E3dLight");
//BFS01#endif
//BFS01
//BFS01		BOOL bTmp;
//BFS01
//BFS01		rIn >> aColor;
//BFS01		rIn >> fIntensity;
//BFS01		rIn >> fRed;
//BFS01		rIn >> fGreen;
//BFS01		rIn >> fBlue;
//BFS01		rIn >> bTmp; bOn = bTmp;
//BFS01		rIn >> bTmp; bVisible = bTmp;
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

//BFS01void E3dLight::operator=(const SdrObject& rObj)
//BFS01{
//BFS01	E3dPointObj::operator=(rObj);
//BFS01
//BFS01	const E3dLight& r3DObj = (const E3dLight&) rObj;
//BFS01
//BFS01	aColor		= r3DObj.aColor;
//BFS01	fIntensity	= r3DObj.fIntensity;
//BFS01	fRed		= r3DObj.fRed;
//BFS01	fGreen		= r3DObj.fGreen;
//BFS01	fBlue		= r3DObj.fBlue;
//BFS01	bOn			= r3DObj.bOn;
//BFS01	bVisible	= r3DObj.bVisible;
//BFS01}
