/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mac.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:16:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _mac_hxx_
#define _mac_hxx_

#define private     public
#define protected   public

#include <string.h>
#include <mac_start.h>
#include <fcntl.h>
#include <files.h>
#include <finder.h>
#include <strings.h>
#include <mac_end.h>
#include <solar.h>
#include <fsys.hxx>

#define FSYS_UNIX FALSE
#define DRIVE_EXISTS(c) ( TRUE )

#define MAXPATHLEN  256
#ifndef _MAX_PATH
#define _MAX_PATH   MAXPATHLEN
#endif

struct DIR
{
    CInfoPBRec   aInfo;
    short        nioVRefNum;    //Working-Directory-ID
    USHORT       nFileNum;      //File Index whithin WD-ID
    char        *d_name;
};

#define dirent DIR

int            mkdir( char *pPath );
int            rmdir( char *pPath );
char*          getcwd( char *pBuf, int nMaxLen );
char          *strdup( const char *pChar );
FSysError      MoveFile( DirEntry& rSource, DirEntry& rDest );
OSErr          CopyData( BOOL bResource, DirEntry& rDest,
                         DirEntry& rSource, short nSourceVol,
                         short nDestVol, long nSpace );

#define DEFSTYLE        FSYS_STYLE_MAC
#define _mkdir          mkdir
#define _rmdir          rmdir
#define _chdir          chdir
#define _unlink         unlink
#define _getcwd         getcwd
#define CMP_LOWER(s) 	(s.Lower())
#define TEMPNAME()      tmpnam(0)

#include <OSUtils.h>

inline Time Mac2Time( long nTime )
{
    DateTimeRec aDTRec;
    SecondsToDate( nTime, &aDTRec );
    return Time( aDTRec.hour, aDTRec.minute, aDTRec.second );
}

inline Date Mac2Date( long nDate )
{
    DateTimeRec aDTRec;
    SecondsToDate( nDate, &aDTRec );
    return Date( aDTRec.day, aDTRec.month, aDTRec.year );
}

const char* TempDirImpl( char *pBuf );
String ImpConvertNameToSystem( const String& rName );
String ImpConvertSystemToName( const String& rName );

#define FSysFailOnErrorImpl()

#endif
