/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xeroot.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:56:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// ============================================================================

#ifndef SC_XEROOT_HXX
#define SC_XEROOT_HXX

#ifndef SC_XLROOT_HXX
#include "xlroot.hxx"
#endif
namespace binfilter {


// Global data ================================================================

class XclExpSst;
class XclExpPalette;
class XclExpFontBuffer;
class XclExpNumFmtBuffer;
class XclExpXFBuffer;
class XclExpTabIdBuffer;
class XclExpLinkManager;

/** Stores global buffers and data needed for Excel export filter. */
struct XclExpRootData : public XclRootData
{
    typedef ::std::auto_ptr< XclExpSst >            XclExpSstPtr;
    typedef ::std::auto_ptr< XclExpPalette >        XclExpPalettePtr;
    typedef ::std::auto_ptr< XclExpFontBuffer >     XclExpFontBufferPtr;
    typedef ::std::auto_ptr< XclExpNumFmtBuffer >   XclExpNumFmtBufferPtr;
    typedef ::std::auto_ptr< XclExpXFBuffer >       XclExpXFBufferPtr;
    typedef ::std::auto_ptr< XclExpTabIdBuffer >    XclExpTabIdBufferPtr;
    typedef ::std::auto_ptr< XclExpLinkManager >    XclExpLinkManagerPtr;

    XclExpSstPtr                mpSst;              /// The shared string table.

    XclExpPalettePtr            mpPalette;          /// The color buffer.
    XclExpFontBufferPtr         mpFontBuffer;       /// All fonts in the file.
    XclExpNumFmtBufferPtr       mpNumFmtBuffer;     /// All number formats in the file.
    XclExpXFBufferPtr           mpXFBuffer;         /// All XF records in the file.

    XclExpTabIdBufferPtr        mpTabIdBuffer;      /// Calc->Excel sheet index conversion.
    XclExpLinkManagerPtr        mpLinkManager;      /// Manager for internal/external links.

    bool                        mbRelUrl;           /// true = Store URLs relative.

    explicit                    XclExpRootData(
                                    XclBiff eBiff,
                                    ScDocument& rDocument,
                                    const String& rBasePath,
                                    CharSet eCharSet,
                                    bool bRelUrl );
    virtual                     ~XclExpRootData();
};


// ----------------------------------------------------------------------------

/** Access to global data from other classes. */
class XclExpRoot : public XclRoot
{
    mutable XclExpRootData&     mrExpData;      /// Reference to the global export data struct.

public:
                                XclExpRoot( const XclExpRoot& rRoot );

    XclExpRoot&                 operator=( const XclExpRoot& rRoot );

    /** Returns this root instance - for code readability in derived classes. */
    inline const XclExpRoot&    GetRoot() const { return *this; }
    /** Returns true, if URLs should be stored relative to the document location. */
    inline bool                 IsRelUrl() const { return mrExpData.mbRelUrl; }

    /** Returns the shared string table. */
    XclExpSst&                  GetSst() const;

    /** Returns the color buffer. */
    XclExpPalette&              GetPalette() const;
    /** Returns the font buffer. */
    XclExpFontBuffer&           GetFontBuffer() const;
    /** Returns the number format buffer. */
    XclExpNumFmtBuffer&         GetNumFmtBuffer() const;
    /** Returns the cell formatting attributes buffer. */
    XclExpXFBuffer&             GetXFBuffer() const;

    /** Returns the buffer for Calc->Excel sheet index conversion. */
    XclExpTabIdBuffer&          GetTabIdBuffer() const;
    /** Returns the link manager. */
    XclExpLinkManager&          GetLinkManager() const;

    /** Returns the Excel add-in function name for a Calc function name. */
    String                      GetXclAddInName( const String& rScName ) const;

    /** Checks if the passed cell address is a valid Excel cell position.
        @descr  See XclRoot::CheckCellAddress for details. */
    bool                        CheckCellAddress( const ScAddress& rPos ) const;
    /** Checks and eventually crops the cell range to valid Excel dimensions.
        @descr  See XclRoot::CheckCellRange for details. */
    bool                        CheckCellRange( ScRange& rRange ) const;
    /** Checks and eventually crops the cell ranges to valid Excel dimensions.
        @descr  See XclRoot::CheckCellRangeList for details. */
    void                        CheckCellRangeList( ScRangeList& rRanges ) const;

protected:
    explicit                    XclExpRoot( XclExpRootData& rExpRootData );
};


// ============================================================================

} //namespace binfilter
#endif

