#!/usr/bin/env ruby

require 'yaml'
require 'pp'
require 'stringio'

class Array
#  def almostflatten # now we use getprimmap indeed
#    a = []
#    each { |x| 
#      if (! x.is_a? Array) or (! x.find { |y| y.is_a? Array })
#        a << x
#        next
#      end
#      a.concat x.almostflatten
#    }
#    a
#  end
#  def recrange # now we use getprimmap indeed
#    map { |x,y| 
#      if y
#        y.is_a?(Array) ? y.recrange : y
#      else
#        x
#      end
#    }.flatten
#  end
  # extract "atomic" [a, b] pairs from ary 
  def getprimmap
    a=[]
    each {|e|
      e.is_a? Array or (a << e; next)
      case e.size
      when 0,1
        e.is_a?(Array) ? a.concat(e.getprimmap) : a << e
      when 2
	e[0].is_a? Array and (a.concat(e.getprimmap); next)
        e[1].is_a?(Array) ? a.concat(e[1].getprimmap) : a << e
      else a.concat e.getprimmap
      end
    }
    a
  end
  def intersect oa
    ia = []
    each { |x|
      oa.include? x and ia << x
    }
    ia
  end
end

class Object
  def deepcopy
    Marshal.load Marshal.dump(self)
  end
  alias _cl class
end

#######


class Fuse

  # To be run on header files
  def self.parse_raw raw, pat=""
    struct = nil
    h = {}
    raw.each { |l|
      if (block_given? ? yield(l) : (l =~ /^struct#{pat}/))
        struct and raise "nested toplevel structs? bad, bad indentation"
        struct = l.split[1]
        h[struct] = []
        next
      end
      l =~ /^\}/ and struct = nil
      struct or next
      (ll=l.dup).sub! /;.*/, ";" and h[struct] << ll # outrageous assumption: given line is prog code iff it contains a ";"
    }
    h
  end

  def initialize data, *args 
    data.is_a? Hash and @data = data
    @data ||= 
    if File.exist? data
      open(data) { |f| YAML.load f }
    else
      YAML.load data
    end
    ocs,ios = args.partition { |x| x.respond_to? :new }
    @opclass = 
    case ocs.size
    when 0; FuseOp
    when 1; ocs[0]
    else raise ArgumentError, "ambiguous opclass"
    end
    io = 
    case ios.size
    when 0; StringIO.new
    when 1; ios[0]
    else raise ArgumentError, "ambiguous io"
    end
    @file =
    case io
    when String
      @fname = io
      open(io,"w")
    when IO, StringIO; io
    end
    parse
    @data[:opcodes].each_key { |k| install k }
    @file
  end

  attr_accessor :file, :fname
  attr_reader :structs, :data

  def parse
    sdata1={}
    @data[:structs_raw].each{ |k,v| 
      w=[]
      v.each{ |l|
        t,n = l.sub(/;.*/,"").split[-2..-1]
        w << [n.to_sym, (ty=t[2..-1].to_sym; @data[:zipcodes].key?(ty) ? ty : t)]
      }
      sdata1[k] = w 
    }
    sdata2 = sdata1.deepcopy
    shitlist1,shitlist2 = [], [] 
    sdata2.each{ |k,v|
      v.each{ |a|
        if (u=a[-1]).is_a?(String)
          shitlist1 << v
          shitlist2 << u
          a[-1]=sdata1[u]
        end
      }
    } 
    @structs = { :types => sdata1 }
    (bada=(shitlist2.intersect shitlist1)).empty? or
      raise "You are SOL: a deep hierarchy of structs is used and that's not supported: #{bada.inspect} can't be resolved"
    @structs[:map] = sdata2
  end

  def install opn
    me = self
    op = @opclass.new opn, self
    class << self
      self
    end.send(:define_method,opn) { op } 
  end

  def write *arg 
    @file.syswrite *arg
  end

  def teardown
    @file.close
  end
  
  def reset
    teardown
  rescue NoMethodError
  end  

  def renew #unq=false
    @fname or raise "can't renew in lack of knowing the filename"
    begin 
      teardown
    rescue IOError, SystemCallError
    end
    @file = open(@fname,"w")
    #unq and self::FuseOp.init_unq
    #self::FuseOp.unique
  end  
   
end

class FuseOp

#  def self.init_unq
#    @unique = 1
#  end
#  init_unq
#
#  class << self
#    attr_accessor :unique
#  end

  def initialize name, be
    @name = name
    @backend = be
  end

  attr_reader :name

  def map
    @backend.data[:typemap][@name]
  end

  def get_type
    a = [@backend.structs[:map]["fuse_in_header"].deepcopy]
    a[0].each{ |b| 
      if b[0] == :opcode
        b[1]=@backend.data[:opcodes][@name] 
        break
      end
    }
    mapt = map.is_a?(Array) ? map : [map]
    mapt.each { |t|
      case t
      when /^fuse/
        a << @backend.structs[:map][t]
      when nil
      else a << t
      end
    }
    a
  end

  def get_type_flat
    get_type.getprimmap.map { |x|
       if x.is_a? Array 
         x[0] == :padding and next false # "next nil" would be more appropriate, but that's hosed by yaml bug
         next x[-1]
       end
       x
    }
  end   

  def show out=$>
    PP::pp get_type, out
  end  

  def pack *a
    aa=a.dup
    pa=[]
    ps = ""
    get_type_flat.each { |x|
      x ||= 0 #padding
      pa <<
      case x
      when Symbol, String
        pc = @backend.data[:zipcodes][x] or raise ArgumentError, "unkown input type: #{x.inspect}"
        dat = aa.shift or raise ArgumentError, "not enough input data"
        (x.is_a? Symbol and dat.is_a? Integer) or (x.is_a? String and dat.is_a? String) or
         raise ArgumentError, "malformed input: #{dat.inspect} given as #{x.inspect}"
        dat 
      else
        pc = @backend.data[:zipcodes][:u32]
        x
      end
      ps << pc
    }
    aa.empty? or raise ArgumentError, "too much input data"
    return pa, ps
  end

  def show_pack
    # I code around my own code, like it was damn braindead 3rdparty protocol
    get_type_flat.each_with_index { |x,i|
      begin
        return pack(*([0]*i))
      rescue ArgumentError
      end
    }
  end

  def send_raw *a
    u,v = pack *a
    @backend.write u.pack(v)
  end

  def headgen nid, nvals={}
    vals = {
     :len => 0,
    # [:opcode, 15],
    # [:unique, :u64],
    # [:nodeid, :u64],
     :uid => 0,
     :gid => 0,
     :pid => 1
    # [:padding, :u32]]
    }
    vals.merge! nvals
    slots =  @backend.structs[:types]["fuse_in_header"].transpose[0] - [:opcode,:padding]
    ra = []
    slots.each { |s|      
      v = vals[s]
      case s
      when :unique
        #v ? _cl.unique = v : v = (_cl.unique += 1)
        v ||= 0 # as of now, kernel module ignores this value and fills the field
                # properly
      when :nodeid
        v = nid
      else
        v or raise "The known header format is too old: no value for #{s.inspect}"
      end
      ra << v
    }
    ra
  end 

  def send nid, *a
#    unq = _cl.unique
    ha, na = a.partition { |x| x.is_a? Hash }
    send_raw *(headgen(nid,*ha) + na)
#  rescue
#    _cl.unique = unq
#    raise   
  end
 
  def method_missing *a
    x = a[0]
    if y = @backend.data[x]
      a.size == 1 or raise ArgumentError, "wrong number of arguments"
      return y[@name]
    end
    raise NoMethodError, x.to_s
  end

end 

class FuseAnswer < FuseOp

  def get_type
    case map
    when /^fuse/
      @backend.structs[:map][map]
    when nil
    else map
    end
  end

end
