/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.TimeZone;

public class Log {
    public static final int CONN = 1;
    public static final int RESP = 2;
    public static final int DEMUX = 4;
    public static final int AUTH = 8;
    public static final int COOKI = 16;
    public static final int MODS = 32;
    public static final int SOCKS = 64;
    public static final int URLC = 128;
    public static final int ALL = -1;
    private static final String NL = System.getProperty("line.separator");
    private static final long TZ_OFF;
    private static int facMask;
    private static Writer logWriter;
    private static boolean closeWriter;

    private Log() {
    }

    public static void write(int facility, String msg) {
        if ((facMask & facility) == 0) {
            return;
        }
        try {
            Log.writePrefix();
            logWriter.write(msg);
            logWriter.write(NL);
            logWriter.flush();
        }
        catch (IOException ioe) {
            System.err.println("Failed to write to log: " + ioe);
            System.err.println("Failed log Entry was: " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(int facility, String prefix, Throwable t) {
        if ((facMask & facility) == 0) {
            return;
        }
        Class clazz = Log.class;
        synchronized (clazz) {
            if (!(logWriter instanceof PrintWriter)) {
                logWriter = new PrintWriter(logWriter);
            }
        }
        try {
            Log.writePrefix();
            if (prefix != null) {
                logWriter.write(prefix);
            }
            t.printStackTrace((PrintWriter)logWriter);
            logWriter.flush();
        }
        catch (IOException ioe) {
            System.err.println("Failed to write to log: " + ioe);
            System.err.print("Failed log Entry was: " + prefix);
            t.printStackTrace(System.err);
        }
    }

    public static void write(int facility, String prefix, ByteArrayOutputStream buf) {
        if ((facMask & facility) == 0) {
            return;
        }
        try {
            Log.writePrefix();
            if (prefix != null) {
                logWriter.write(prefix);
            }
            logWriter.write(NL);
            logWriter.write(new String(buf.toByteArray(), "ISO_8859-1"));
            logWriter.flush();
        }
        catch (IOException ioe) {
            System.err.println("Failed to write to log: " + ioe);
            System.err.println("Failed log Entry was: " + prefix);
            System.err.println(new String(buf.toByteArray()));
        }
    }

    private static final void writePrefix() throws IOException {
        logWriter.write("{" + Thread.currentThread().getName() + "} ");
        int mill = (int)((System.currentTimeMillis() + TZ_OFF) % 86400000L);
        int secs = mill / 1000;
        int mins = secs / 60;
        int hours = mins / 60;
        logWriter.write("[" + Log.fill2(hours) + ':' + Log.fill2(mins - hours * 60) + ':' + Log.fill2(secs - mins * 60) + '.' + Log.fill3(mill - secs * 1000) + "] ");
    }

    private static final String fill2(int num) {
        return (num < 10 ? "0" : "") + num;
    }

    private static final String fill3(int num) {
        return (num < 10 ? "00" : (num < 100 ? "0" : "")) + num;
    }

    public static boolean isEnabled(int facility) {
        return (facMask & facility) != 0;
    }

    public static void setLogging(int facilities, boolean enable) {
        facMask = enable ? (facMask |= facilities) : (facMask &= ~facilities);
    }

    public static void setLogWriter(Writer log, boolean closeWhenDone) {
        if (log == null) {
            return;
        }
        if (closeWriter) {
            try {
                logWriter.close();
            }
            catch (IOException ioe) {
                System.err.println("Error closing log stream: " + ioe);
            }
        }
        logWriter = log;
        closeWriter = closeWhenDone;
    }

    static {
        facMask = 0;
        logWriter = new OutputStreamWriter(System.err);
        closeWriter = false;
        Calendar now = Calendar.getInstance();
        TZ_OFF = TimeZone.getDefault().getOffset(now.get(0), now.get(1), now.get(2), now.get(5), now.get(7), now.get(14));
        try {
            String file = System.getProperty("HTTPClient.log.file");
            if (file != null) {
                try {
                    Log.setLogWriter(new FileWriter(file), true);
                }
                catch (IOException ioe) {
                    System.err.println("failed to open file log stream `" + file + "': " + ioe);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            facMask = Integer.getInteger("HTTPClient.log.mask", 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

