/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "q3timeedit_plugin.h"

#include <QtCore/qplugin.h>
#include <QtGui/QIcon>
#include <Qt3Support/Q3TimeEdit>

Q3TimeEditPlugin::Q3TimeEditPlugin(QObject *parent)
        : QObject(parent), m_initialized(false)
{}

QString Q3TimeEditPlugin::name() const
{ return QLatin1String("Q3TimeEdit"); }

QString Q3TimeEditPlugin::group() const
{ return QLatin1String("Qt 3 Support"); }

QString Q3TimeEditPlugin::toolTip() const
{ return QString(); }

QString Q3TimeEditPlugin::whatsThis() const
{ return QString(); }

QString Q3TimeEditPlugin::includeFile() const
{ return QLatin1String("Qt3Support/Q3TimeEdit"); }

QIcon Q3TimeEditPlugin::icon() const
{ return QIcon(); }

bool Q3TimeEditPlugin::isContainer() const
{ return false; }

QWidget *Q3TimeEditPlugin::createWidget(QWidget *parent)
{ return new Q3TimeEdit(parent); }

bool Q3TimeEditPlugin::isInitialized() const
{ return m_initialized; }

void Q3TimeEditPlugin::initialize(QDesignerFormEditorInterface *core)
{
    Q_UNUSED(core);
    m_initialized = true;
}
