/*
 * system_environment.h - namespace systemEnvironment, providing interface for transparent use of operating-system-dependent functions
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _SYSTEM_ENVIRONMENT
#define _SYSTEM_ENVIRONMENT

#include <qstring.h>
#include <qmap.h>


class client;


namespace systemEnvironment
{
	QMap<QString, QString> localIPAddresses( void );
	QString localUser( void );
	bool hostAvailable( const QString & _host_ip );
	QString realUserName( const QString & _user );
	void execBg( const QString & _cmds );
	void execInTerminal( const QString & _cmds );
	void startClientViewer( const QString & _ip, const QString & _user );
	void executePythonCode( const QString & _pc );
	void distributeFile( const QString & _file, client * _client );
	void collectFiles( const QString & _files, const QString & _user );

	namespace demoServer
	{
		void start( void );
		void allowClient( const QString & _ip );
		void denyClient( const QString & _ip );
		void stop( void );
	}

}

#endif
