/*
 * user_list.h - declaration of user-list for side-bar
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifndef _USER_LIST_H
#define _USER_LIST_H

#include "side_bar_widget.h"


class client;
class QPushButton;
class QListBox;
class QListBoxItem;


class userList : public sideBarWidget
{
	Q_OBJECT
public:
	userList( QWidget * _parent );
	virtual ~userList();

	static QStringList getLoggedInUsers( void );
	static client * getClientFromUser( const QString _user );
	static QString getUserFromClient( const QString _ip );

	void reload( void );


private slots:
	void contextMenuHandler( QListBoxItem * _i, const QPoint & );
	void clickedExportToFile( void );


private:
	QListBox * m_list;
	QPushButton * m_exportToFileBtn;

} ;


#endif
