#ifndef EKG_CMDS_H
#define EKG_CMDS_H

#include <qobject.h>
#include <qstringlist.h>

class Chat;
class UserGroup;

/*!
 * This class implements EKG commands to be used in chat window.
 * \brief EKG commands class
 */
class EKGCmds : public QObject
{
	Q_OBJECT
	public:
		/*!
		 * Default constructor
		 * \param parent Parent object.
		 * \param name Object's name.
		 */
		EKGCmds(QObject *parent, const char *name);

		/*!
		 * Default destructor
		 */
		~EKGCmds();

	protected slots:
		/*!
		 * \fn void busyCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
		 * "Change the status to busy" command.
		 * \param chat %Ignored.
		 * \param users %Ignored.
		 * \param args The description (if present).
		 * \param cmd Command name: "busy".
		 * \param msg %Ignored.
		 */
		void busyCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg);
	
		/*!
		 * \fn void invisibleCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
		 * "Change the status to invisible" command.
		 * \param chat %Ignored.
		 * \param users %Ignored.
		 * \param args The description (if present).
		 * \param cmd Command name: "invisible".
		 * \param msg %Ignored.
		 */
		void invisibleCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg);

		/*!
		 * \fn void offlineCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
		 * "Change the status to offline" command.
		 * \param chat %Ignored.
		 * \param users %Ignored.
		 * \param args The description (if present).
		 * \param cmd Command name: "offline".
		 * \param msg %Ignored.
		 */
		void offlineCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg);
		
		/*!
		 * \fn void onlineCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
		 * "Change the status to online" command.
		 * \param chat %Ignored.
		 * \param users %Ignored.
		 * \param args The description (if present).
		 * \param cmd Command name: "online".
		 * \param msg %Ignored.
		 */
		void onlineCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg);
	
		/*!
		 * \fn void clearCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
		 * "Clear the chat window" command.
		 * \param chat This chat window will be cleared.
		 * \param users %Ignored.
		 * \param args %Ignored.
		 * \param cmd Command name: "clear".
		 * \param msg %Ignored.
		 */
		void clearCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg);

		/*!
		 * \fn void closeCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
		 * "Close the chat window" command.
		 * \param chat This chat window will be closed.
		 * \param users %Ignored.
		 * \param args %Ignored.
		 * \param cmd Command name: "close".
		 * \param msg %Ignored.
		 */
		void closeCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg);
		
		/*!
		 * \fn void minimizeCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
		 * "Minimize the chat window" command.
		 * \param chat This chat window will be minimized.
		 * \param users %Ignored.
		 * \param args %Ignored.
		 * \param cmd Command name: "minimize".
		 * \param msg %Ignored.
		 */
		void minimizeCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg);

		/*!
		 * \fn void massMsg(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
		 * Sends command to all active chats.
		 * \param users Users list.
		 * \param chat %Ignored.
		 * \param args The command.
		 * \param cmd Command name: "massmsg".
		 * \param msg The whole message (including "/massmsg ") that is going to be truncated and sent.
		*/
		void massMsg(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg);
};
	
#endif
