.\" Man page for LyX.
.\" Use the following command to view man page:
.\"
.\"  tbl lyx.1 | nroff -man | less
.\"
.TH LYX 1 "Jan 2003" "Version 1.4" "LyX 1.4"
.SH NAME
lyx \- A Document Processor
.\"
.\" setup
.de Cr
.ie n (c)
.el \(co
..
.SH SYNOPSIS
\fBlyx\fR [ \fIcommand\-line switches\fR ] [ \fIname[.lyx] ...\fR ]
.br
.SH DESCRIPTION
\fBLyX\fR is too complex to be described completely in the "man" page
format. If your system is properly configured, you can access the full
documentation within \fBLyX\fR under the Help menu.

\fBLyX\fR is a document preparation system. It excels at letting you
create complex technical and scientific articles with mathematics,
cross\-references, bibliographies, indices, etc. It is very good at
documents of any length in which the usual processing abilities are
required: automatic sectioning and pagination, spellchecking, and so
forth. It can also be used to write a letter to your mom, though
granted, there are probably simpler programs available for that. It is
definitely not the best tool for creating banners, flyers, or
advertisements, though with some effort all these can be done, too.
Some examples of what it is used for: memos, letters, dissertations
and theses, lecture notes, seminar notebooks, conference proceedings,
software documentation, books (on PostgreSQL, remote sensing,
cryptology, fictional novels, poetry, and even a children's book or
two), articles in refereed scientific journals, scripts for plays and
movies, business proposals... you get the idea.

Currently, \fBLyX\fR uses either the XForms or Qt library as a
toolkit. \fBLyX\fR should run everywhere, where these libraries run.
This is on all major Unix platforms as well as Windows, Mac OS X
(which actually is a unix platform) and OS/2.
.SH OPTIONS
\fBLyX\fR supports the following command\-line switches.
.TP 6
.BI \-help
summarizes LyX usage
.TP
.BI \-version
provides version information on the build of LyX.
.TP
.BI \-sysdir " directory"
sets system directory. Normally not needed.
.TP
.BI \-userdir " directory"
sets user directory. Needed if you want to use LyX with different lyxrc
settings.
.TP
.BI \-dbg " feature[,feature...]"
where feature is a name or number.
Use "\fBlyx \-dbg\fR" to see the list of available debug features.
.TP
\fB \-x [\-\-execute]\fP \fIcommand
where command is a lyx command.
.TP
\fB \-e [\-\-export]\fP \fIfmt
where fmt is the export format of choice.
.TP
\fB \-i [\-\-import]\fP \fIfmt file.xxx
where fmt is the import format of choice and file.xxx is the file to be imported.

.SH XFORMS FRONTEND OPTIONS
When compiled with the XForms frontend, \fBLyX\fR understands the
following generic command line options from the \fBForms Library\fR,
which can also be specified as X resources (e. g. in .Xdefaults) with
class name \fBLyX\fR.
.TP 6
.BI \-geometry " WxH+X+Y"
specifies the preferred size and position of the main \fBLyX\fR
window; see \fIX(1)\fR.
.TP
.BI \-display " host:display"
specifies the server to connect to.
.TP
.BI \-bw " borderwidth"
specifies the border width to use to built\-in objects.
.TP
.BI \-visual " visualName"
requests a visual by name such as TrueColor etc. By default the
.B Forms Library
always selects the visual that has the most depth.
.TP
.BI \-depth " depth"
requests a specific depth. Try "\fB\-depth\fR best" or "\fB\-depth\fR
8" if you get a bad match.
.TP
.BI \-debug " level"
generates some info about the state of the
.B XForms.
where
.I level
is an integer between 1\-5 and controls the amount of
information to output. Depending on the options used
when the
.B Forms Library
was built, a level more than 3 might not be available.
.TP
.B \-sync
runs the application in synchronous mode with debug level set to 4.
.TP
.B \-private
requests a private colormap for the application.
.TP
.B \-shared
requests a shared colormap even if the application needs more
colors than available. For those colors that can't be allocated
in the shared colormap, substitutions are made so the closest
matching color is used.
.TP
.B \-stdcmap
requests a standard colormap.
.TP
.B \-name " newname"
specifies the application name under which resources are to be
obtained, rather than the default executable file name.
.SH ENVIRONMENT
.TP
.B LYX_DIR_14x
can be used to specify which system directory to use.
.PP
The system directory is determined by searching for the file
"chkconfig.ltx". Directories are searched in this order:
.br
1) \-sysdir command line parameter
.br
2) LYX_DIR_14x environment variable
.br
3) Maybe <path of binary>/TOP_SRCDIR/lib
.br
4) <path of binary>/../share/<name of binary>/
.br
5) hardcoded lyx_dir (usually /usr/local/share/lyx on UNIX and %X11ROOT%\\XFree86\\lib\\X11\\lyx on OS/2 with XFree)
.TP
.B LYX_USERDIR_14x
can be used to specify which user directory to use.
.PP
The user directory is, in order of precedence:
.br
1) \-userdir command line parameter
.br
2) LYX_USERDIR_14x environment variable
.br
3) $HOME/.<name of binary> if no explicit setting is made

.TP
.B LYX_LOCALEDIR
can be used to tell LyX where to look for the translations of its GUI
strings in other languages.
.SH FILES
.nf
.ta \w'\fILIBDIR\fR/lyxrc.in  'u
~/.lyx/preferences      Personal configuration file
~/.lyx/lyxrc.defaults   Personal autodetected configuration file
\fILIBDIR\fR/lyxrc      System wide configuration file
\fILIBDIR\fR/lyxrc.defaults System wide autodetected configuration file
\fILIBDIR\fR/configure  Updates \fBLyX\fR if config has changed
\fILIBDIR\fR/bind/      Keybindings
\fILIBDIR\fR/clipart/   Clipart pictures
\fILIBDIR\fR/doc/       Documentation in \fBLyX\fR format.
\fILIBDIR\fR/examples/  Example documents
\fILIBDIR\fR/images/    Images used as icons or in popups
\fILIBDIR\fR/kbd/       Keyboard mappings
\fILIBDIR\fR/layouts/   Layout descriptions
\fILIBDIR\fR/templates/ Templates for documents
\fILIBDIR\fR/tex/       Extra TeX files
.Sp
.fi

.I LIBDIR
is the system directory. This is usually /usr/local/share/lyx on UNIX and %X11ROOT%\\XFree86\\lib\\X11\\lyx on OS/2 with XFree.
.SH SEE ALSO
tex2lyx(1), latex(1).

Full documentation in either native \fBLyX\fR or postscript format.
.SH BUGS/LIMITATIONS
There are still some bugs in \fBLyX\fR. To report one, read if
possible the Introduction found under the Help menu in LyX. You'll
find detailed info on submitting bug reports there. If you can't do
that, send details to the LyX Developers mailing list
lyx\-devel@lists.lyx.org, or use the LyX bug tracker at
http://bugzilla.lyx.org/. Don't forget to mention which version you
are having problems with!

\fBLaTeX\fR import is still not perfect and may produce buggy *.lyx
files. Consult the \fBtex2lyx\fR documentation.

.SH AUTHORS
Copyright       
.Cr
1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002 by Matthias Ettrich
(ettrich@informatik.uni\-tuebingen.de) and the rest of the \fBLyX
Team\fR (See About LyX under the Help menu item).
