/**
 * \file FormMathsStyle.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Alejandro Aguilar Sierra
 * \author Pablo De Napoli
 * \author John Levon
 * \author Angus Leeming
 *
 * Full author contact details are available in file CREDITS.
 * Adapted from FormMathsSpace martin.vermeer@hut.fi
 */

#include <config.h>

#include "FormMathsStyle.h"
#include "forms/form_maths_style.h"
#include "ControlMath.h"
#include "xformsBC.h"

#include "lyx_forms.h"
#include "bmtable.h"

#include "style.xbm"
#include "font.xbm"

namespace lyx {
namespace frontend {

namespace {

char const * latex_mathstyle[] = {
	"displaystyle", "textstyle", "scriptstyle", "scriptscriptstyle"
};

kb_action latex_mathfontcmds[] = {
	LFUN_BOLD, LFUN_SANS, LFUN_ROMAN, LFUN_ITAL, LFUN_CODE,
	LFUN_NOUN, LFUN_FRAK, LFUN_EMPH, LFUN_FREEFONT_APPLY, LFUN_DEFAULT
};

} // namespace anon


typedef FormController<ControlMath, FormView<FD_maths_style> > base_class;

FormMathsStyle::FormMathsStyle(Dialog & parent)
	: base_class(parent, _("Math Styles & Fonts"), false),
	  style_(-1)
{}


void FormMathsStyle::build()
{
	dialog_.reset(build_maths_style(this));

	fl_set_bmtable_data(dialog_->bmtable_style1, 1, 1,
			    style1_width, style1_height, style1_bits);
	fl_set_bmtable_maxitems(dialog_->bmtable_style1, 1);
	bcview().addReadOnly(dialog_->bmtable_style1);

	fl_set_bmtable_data(dialog_->bmtable_style2, 1, 3,
			    style2_width, style2_height, style2_bits);
	fl_set_bmtable_maxitems(dialog_->bmtable_style2, 3);
	bcview().addReadOnly(dialog_->bmtable_style2);

	fl_set_bmtable_data(dialog_->bmtable_font1, 1, 5,
			    font1_width, font1_height, font1_bits);
	fl_set_bmtable_maxitems(dialog_->bmtable_font1, 5);
	bcview().addReadOnly(dialog_->bmtable_font1);

	fl_set_bmtable_data(dialog_->bmtable_font2, 1, 3,
			    font2_width, font2_height, font2_bits);
	fl_set_bmtable_maxitems(dialog_->bmtable_font2, 3);
	bcview().addReadOnly(dialog_->bmtable_font2);

	bcview().setCancel(dialog_->button_close);
}


void FormMathsStyle::apply()
{
	if ((style_ >= 0) && (style_ < 4))
		controller().dispatchInsert(latex_mathstyle[style_]);
	else if ((style_ >= 4) && (style_ < 14))
		controller().dispatchFunc(latex_mathfontcmds[style_-4]);
}


ButtonPolicy::SMInput FormMathsStyle::input(FL_OBJECT * ob, long data)
{
	style_ = fl_get_bmtable(ob);
	if (style_ < 0) return ButtonPolicy::SMI_INVALID;

	//if (ob == dialog_->bmtable_style1) style_ += 0;
	if (ob == dialog_->bmtable_style2) style_ += 1;
	if (ob == dialog_->bmtable_font1)  style_ += 4;
	if (ob == dialog_->bmtable_font2)  style_ += 9;
	if (data >= 12) style_ = short(data);
	apply();

	return ButtonPolicy::SMI_VALID;
}

} // namespace frontend
} // namespace lyx
