/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * PrintAllFunctions.java
 * ------------
 */

package org.pentaho.reporting.libraries.formula.demo;

import java.util.Arrays;
import java.util.Locale;

import org.pentaho.reporting.libraries.formula.LibFormulaBoot;
import org.pentaho.reporting.libraries.formula.function.FunctionCategory;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;

/**
 * Creation-Date: 02.11.2007, 13:28:42
 *
 * @author Thomas Morgner
 */
public class PrintAllFunctions
{
  private PrintAllFunctions()
  {
  }

  public static void main(String[] args)
  {
    LibFormulaBoot.getInstance().start();

    final DemoFormulaContext context = new DemoFormulaContext();
    final FunctionRegistry functionRegistry = context.getFunctionRegistry();
    final FunctionCategory[] categories = functionRegistry.getCategories();
    for (int c = 0; c < categories.length; c++)
    {
      final FunctionCategory category = categories[c];
      System.out.println();
      System.out.println("Category " + category.getDisplayName(Locale.US));
      final String[] strings = functionRegistry.getFunctionNamesByCategory(category);
      Arrays.sort(strings);
      for (int i = 0; i < strings.length; i++)
      {
        if (i != 0)
        {
          System.out.print(", ");
        }
        final String string = strings[i];
        System.out.print(string);
      }

    }
  }
}
