//
// ProjectSolutionPad.cs
//
// Author:
//   Lluis Sanchez Gual
//
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;
using System.Resources;

using MonoDevelop.Projects;
using MonoDevelop.Core;
using MonoDevelop.Core.Properties;
using MonoDevelop.Ide.Gui;

namespace MonoDevelop.Ide.Gui.Pads.ProjectPad
{
	public class ProjectSolutionPad: SolutionPad
	{
		public ProjectSolutionPad ()
		{
			IdeApp.Workbench.ActiveDocumentChanged += new EventHandler (OnWindowChanged);
		}
		
		protected override void OnSelectionChanged (object sender, EventArgs args)
		{
			base.OnSelectionChanged (sender, args);
			ITreeNavigator nav = GetSelectedNode ();
			if (nav != null) {
				Project p = (Project) nav.GetParentDataItem (typeof(Project), true);
				IdeApp.ProjectOperations.CurrentSelectedProject = p;
				Combine c = (Combine) nav.GetParentDataItem (typeof(Combine), true);
				IdeApp.ProjectOperations.CurrentSelectedCombine = c;
			}
		}
		
		protected override void OnCloseCombine (object sender, CombineEventArgs e)
		{
			base.OnCloseCombine (sender, e);
			IdeApp.ProjectOperations.CurrentSelectedProject = null;
			IdeApp.ProjectOperations.CurrentSelectedCombine = null;
		}
		
		void OnWindowChanged (object ob, EventArgs args)
		{
			Document doc = IdeApp.Workbench.ActiveDocument;
			if (doc != null && doc.Project != null) {
				string file = doc.FileName;
				if (file != null) {
					ProjectFile pf = doc.Project.ProjectFiles.GetFile (doc.FileName);
					if (pf != null) {
						ITreeNavigator nav = GetNodeAtObject (pf, true);
						if (nav != null) {
							nav.ExpandToNode ();
							nav.Selected = true;
						}
					}
				}
			}
		}
	}
}

