unit AdminServerInfo;

interface

uses
  gnugettext, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, AdditionalClasses, Buttons, PNGImage,
  InstanceSections, AuxFuncs, myx_public_interface,
  ApplicationDataModule, MySQLConnection, MyxError, TntExtCtrls,
  TntStdCtrls;

type
  TAdminServerInfoForm = class(TInstanceSectionForm)
    ServerInfoPnl: TTntPanel;
    LogoImg: TTntImage;
    RightBGImg: TTntImage;
    ConnectionGBox: TTntGroupBox;
    UserLbl: TTntLabel;
    HostLbl: TTntLabel;
    ClientInfoGBox: TTntGroupBox;
    ClientVersionCaptionLbl: TTntLabel;
    ClientHardwareCaptionLbl: TTntLabel;
    ClientOSCaptionLbl: TTntLabel;
    ClientNetworkNameCaptionLbl: TTntLabel;
    UserCaptionLbl: TTntLabel;
    HostCaptionLbl: TTntLabel;
    PortCaptionLbl: TTntLabel;
    PortLbl: TTntLabel;
    InstanceCaptionLbl: TTntLabel;
    InstanceNameLbl: TTntLabel;
    ClientNetworkNameLbl: TTntLabel;
    ClientOSLbl: TTntLabel;
    ClientHardwareLabel: TTntLabel;
    ClientVersionLbl: TTntLabel;
    ClientIPCaptionLabel: TTntLabel;
    ClientIPLbl: TTntLabel;
    ServiceStatusImg: TTntImage;
    Label5: TTntLabel;
    ServerStatusLbl: TTntLabel;
    ServerInfoGBox: TTntGroupBox;
    ServerVersionCaptionLbl: TTntLabel;
    ServerHardwareCaptionLbl: TTntLabel;
    ServerOSCaptionLbl: TTntLabel;
    ServerNetworkNameCaptionLbl: TTntLabel;
    ServerNetworkNameLbl: TTntLabel;
    ServerOSLbl: TTntLabel;
    ServerHardwareLbl: TTntLabel;
    ServerVersionLbl: TTntLabel;
    ServerIPCaptionLbl: TTntLabel;
    ServerIPLbl: TTntLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ServerStatusLblMouseEnter(Sender: TObject);
    procedure ServerStatusLblMouseLeave(Sender: TObject);
    procedure ServerStatusLblClick(Sender: TObject);
    procedure ServerInfoPnlResize(Sender: TObject);

    procedure SetServerInfos(Sender: TObject);
    procedure SetClientInfos(Sender: TObject);
    procedure FetchInfos(Sender: TObject);

    procedure GetInfos;
    procedure ClearInfos;

    function GetFormContentAsText: WideString; override;

    procedure Disconnected(var Message: TMessage); message WM_Disconnected;
    procedure Reconnected(var Message: TMessage); message WM_Reconnected;
  private
    { Private declarations }
    RightBGPNGImg,
    MySQLLogoPNGImg: TPNGObject;

    ServiceStatusRunningPNGImg,
    //ServiceStatusStoppedPNGImg,
    ServiceStatusUnknownPNGImg: TPNGObject;

    machine_info: PMYX_MACHINE_INFO;
  public
    { Public declarations }
  end;

const
  CaptionTextWidth = 25;

var
  AdminServerInfoForm: TAdminServerInfoForm;

implementation

{$R *.dfm}

uses
  Main, PNGTools;

procedure TAdminServerInfoForm.FormCreate(Sender: TObject);
begin
  InitForm(self);

  RightBGImg.Width:=RightBGImg.Width;

  DockedPanel:=ServerInfoPnl;

  RightBGPNGImg:=LoadPNGImageFromResource('dockpnl_bg', RightBGImg);
  MySQLLogoPNGImg:=LoadPNGImageFromResource('mysql_logo', LogoImg);

  ServiceStatusRunningPNGImg:=LoadPNGImageFromResource('service_status_running');
  //ServiceStatusStoppedPNGImg:=LoadPNGImageFromResource('service_status_stopped');
  ServiceStatusUnknownPNGImg:=LoadPNGImageFromResource('service_status_unknown');

  ServiceStatusImg.Picture.Graphic:=ServiceStatusRunningPNGImg;

  GetInfos;
end;

procedure TAdminServerInfoForm.FormDestroy(Sender: TObject);
begin
  RightBGPNGImg.Free;
  MySQLLogoPNGImg.Free;
  ServiceStatusRunningPNGImg.Free;
  ServiceStatusUnknownPNGImg.Free;
end;

procedure TAdminServerInfoForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  //
end;

procedure TAdminServerInfoForm.ServerStatusLblMouseEnter(Sender: TObject);
begin
  ServerStatusLbl.Font.Style:=[fsBold, fsUnderline];
  ServerStatusLbl.Font.Color:=clBlue;
end;

procedure TAdminServerInfoForm.ServerStatusLblMouseLeave(Sender: TObject);
begin
  ServerStatusLbl.Font.Style:=[fsBold];
  ServerStatusLbl.Font.Color:=clBlack;
end;

procedure TAdminServerInfoForm.ServerStatusLblClick(Sender: TObject);
begin
  if(Owner is TMainForm)then
  begin
    TMainForm(Owner).SectionControls.AdminTreeView.Selected:=TMainForm(Owner).SectionControls.AdminTreeView.Items[1];
  end;
end;

procedure TAdminServerInfoForm.ServerInfoPnlResize(Sender: TObject);
begin
  LogoImg.Left:=ServerInfoPnl.Width-636+484;
end;

procedure TAdminServerInfoForm.SetServerInfos(Sender: TObject);
begin
  ServerVersionLbl.Caption:=machine_info.version;
  ServerNetworkNameLbl.Caption:=machine_info.network_name;
  ServerIPLbl.Caption:=machine_info.IP;
  ServerOSLbl.Caption:=machine_info.OS;
  ServerHardwareLbl.Caption:=machine_info.hardware;
end;

procedure TAdminServerInfoForm.SetClientInfos(Sender: TObject);
begin
  ClientVersionLbl.Caption:=machine_info.version;
  if(machine_info.network_name<>'')then
    ClientNetworkNameLbl.Caption:=machine_info.network_name
  else
  begin
    if(machine_info.IP='127.0.0.1')then
      ClientNetworkNameLbl.Caption:=_('localhost')
    else
      ClientNetworkNameLbl.Caption:=_('unknown');
  end;
  ClientIPLbl.Caption:=machine_info.IP;
  ClientOSLbl.Caption:=machine_info.OS;
  ClientHardwareLabel.Caption:=machine_info.hardware;
end;

procedure TAdminServerInfoForm.FetchInfos(Sender: TObject);
var PMySQL: Pointer;
begin
  PMySQL:=myx_mysql_init;
  try
    if(myx_connect_to_instance(MySQLConn.user_connection.get_record_pointer,
      PMySQL)<>0)then
      raise EMyxSQLError.Create(_('Cannot clone MySQL connection.'),
        myx_mysql_errno(PMySQL), myx_mysql_error(PMySQL));

    //Display client infos
    machine_info:=myx_get_client_info(PMySQL);

    TFetchDataThread(Sender).ExecuteSynchronized(SetClientInfos);

    myx_free_pc_info(machine_info);

    //Display server infos
    machine_info:=myx_get_server_info(
      MySQLConn.user_connection.get_record_pointer,
      PMySQL);

    TFetchDataThread(Sender).ExecuteSynchronized(SetServerInfos);

    myx_free_pc_info(machine_info);
  finally
    myx_mysql_close(PMySQL);
  end;
end;

procedure TAdminServerInfoForm.GetInfos;
var NewHeight: integer;
begin
  //Start Thread fetching data
  MySQLConn.FetchData(KindOfData_StatusVars,
    FetchInfos, nil,
    nil, _('Fetching Server Status ...'), True);

  //Display connection Infos
  UserLbl.Caption:=
    MySQLConn.user_connection.username;
  HostLbl.Caption:=
    MySQLConn.user_connection.hostname;
  PortLbl.Caption:=
    IntToStr(MySQLConn.user_connection.port);
  InstanceNameLbl.Caption:='';

  //Hide unknown fields
  NewHeight:=105;
  if(InstanceNameLbl.Caption='-')or
    (InstanceNameLbl.Caption='')then
  begin
    InstanceCaptionLbl.Hide;
    InstanceNameLbl.Hide;
    NewHeight:=NewHeight-18;
  end;
  ConnectionGBox.Height:=NewHeight;

  ServerInfoGBox.Top:=ConnectionGBox.Top+ConnectionGBox.Height+9;

  NewHeight:=127;

  if(ServerOSLbl.Caption='-')then
  begin
    ServerOSCaptionLbl.Hide;
    ServerOSLbl.Hide;
    NewHeight:=NewHeight-18;
  end;

  if(ServerHardwareLbl.Caption='-')then
  begin
    ServerHardwareCaptionLbl.Hide;
    ServerHardwareLbl.Hide;
    NewHeight:=NewHeight-18;
  end;

  ServerInfoGBox.Height:=NewHeight;

  ClientInfoGBox.Top:=ServerInfoGBox.Top+ServerInfoGBox.Height+9;
end;

procedure TAdminServerInfoForm.ClearInfos;
begin
  UserLbl.Caption:='-';
  HostLbl.Caption:='-';
  PortLbl.Caption:='-';
  InstanceNameLbl.Caption:='-';

  ServerVersionLbl.Caption:='-';
  ServerNetworkNameLbl.Caption:='-';
  ServerIPLbl.Caption:='-';
  ServerOSLbl.Caption:='-';
  ServerHardwareLbl.Caption:='-';

  ClientVersionLbl.Caption:='-';
  ClientNetworkNameLbl.Caption:='-';
  ClientIPLbl.Caption:='-';
  ClientOSLbl.Caption:='-';
  ClientHardwareLabel.Caption:='-';
end;

procedure TAdminServerInfoForm.Disconnected(var Message: TMessage);
begin
  ClearInfos;

  ServerStatusLbl.Caption:=_('Disconnected from Server.');
  ServiceStatusImg.Picture.Assign(ServiceStatusUnknownPNGImg);
end;

procedure TAdminServerInfoForm.Reconnected(var Message: TMessage);
begin
  GetInfos;

  ServerStatusLbl.Caption:=_('MySQL Server is running.');
  ServiceStatusImg.Picture.Assign(ServiceStatusRunningPNGImg);
end;

function TAdminServerInfoForm.GetFormContentAsText: WideString;
var s: WideString;
begin
  s:=_('MySQL Server Information')+#13#10+
    StringOfChar('-', 80)+#13#10+
    ConnectionGBox.Caption+#13#10+
    '  '+StringAlignLeft(UserCaptionLbl.Caption, CaptionTextWidth)+
      UserLbl.Caption+#13#10+
    '  '+StringAlignLeft(HostCaptionLbl.Caption, CaptionTextWidth)+
      HostLbl.Caption+#13#10+
    '  '+StringAlignLeft(PortCaptionLbl.Caption, CaptionTextWidth)+
      PortLbl.Caption+#13#10;

  if(InstanceCaptionLbl.Visible)then
    s:=s+'  '+StringAlignLeft(InstanceCaptionLbl.Caption, CaptionTextWidth)+
      InstanceNameLbl.Caption+#13#10;

  s:=s+StringOfChar('-', 80)+#13#10+
    ServerInfoGBox.Caption+#13#10+
    '  '+StringAlignLeft(ServerVersionCaptionLbl.Caption, CaptionTextWidth)+
      ServerVersionLbl.Caption+#13#10+
    '  '+StringAlignLeft(ServerNetworkNameCaptionLbl.Caption, CaptionTextWidth)+
      ServerNetworkNameLbl.Caption+#13#10+
    '  '+StringAlignLeft(ServerIPCaptionLbl.Caption, CaptionTextWidth)+
      ServerIPLbl.Caption+#13#10;

  if(ServerOSLbl.Visible)then
    s:=s+'  '+StringAlignLeft(ServerOSCaptionLbl.Caption, CaptionTextWidth)+ServerOSLbl.Caption+#13#10;
  if(ServerHardwareLbl.Visible)then
    s:=s+'  '+StringAlignLeft(ServerHardwareCaptionLbl.Caption, CaptionTextWidth)+ServerHardwareLbl.Caption+#13#10;

  s:=s+StringOfChar('-', 80)+#13#10+
    ClientInfoGBox.Caption+#13#10+
    '  '+StringAlignLeft(ClientVersionCaptionLbl.Caption, CaptionTextWidth)+
      ClientVersionLbl.Caption+#13#10+
    '  '+StringAlignLeft(ClientNetworkNameCaptionLbl.Caption, CaptionTextWidth)+
      ClientNetworkNameLbl.Caption+#13#10+
    '  '+StringAlignLeft(ClientIPCaptionLabel.Caption, CaptionTextWidth)+
      ClientIPLbl.Caption+#13#10+
    '  '+StringAlignLeft(ClientOSCaptionLbl.Caption, CaptionTextWidth)+
      ClientOSLbl.Caption+#13#10+
    '  '+StringAlignLeft(ClientHardwareCaptionLbl.Caption, CaptionTextWidth)+
      ClientHardwareLabel.Caption+#13#10;

  Result:=s;
end;

end.
