/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: shadowprimitive3d.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: aw $ $Date: 2008-05-27 14:11:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_drawinglayer.hxx"

#include <drawinglayer/primitive3d/shadowprimitive3d.hxx>
#include <drawinglayer/primitive3d/drawinglayer_primitivetypes3d.hxx>

//////////////////////////////////////////////////////////////////////////////

using namespace com::sun::star;

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace primitive3d
	{
		ShadowPrimitive3D::ShadowPrimitive3D(
			const basegfx::B2DHomMatrix& rShadowTransform, 
			const basegfx::BColor& rShadowColor, 
			double fShadowTransparence, 
			bool bShadow3D, 
			const Primitive3DSequence& rChildren)
		:	GroupPrimitive3D(rChildren),
			maShadowTransform(rShadowTransform),
			maShadowColor(rShadowColor),
			mfShadowTransparence(fShadowTransparence),
			mbShadow3D(bShadow3D)
		{
		}

		bool ShadowPrimitive3D::operator==(const BasePrimitive3D& rPrimitive) const
		{
			if(GroupPrimitive3D::operator==(rPrimitive))
			{
				const ShadowPrimitive3D& rCompare = (ShadowPrimitive3D&)rPrimitive;

				return (getShadowTransform() == rCompare.getShadowTransform()
					&& getShadowColor() == rCompare.getShadowColor()
					&& getShadowTransparence() == rCompare.getShadowTransparence()
					&& getShadow3D() == rCompare.getShadow3D());
			}

			return false;
		}

		// provide unique ID
		ImplPrimitrive3DIDBlock(ShadowPrimitive3D, PRIMITIVE3D_ID_SHADOWPRIMITIVE3D)

	} // end of namespace primitive3d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////
// eof
