/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef REVSVIEW_H
#define REVSVIEW_H

#include <qguardedptr.h>
#include "exceptionmanager.h"
#include "common.h"
#include "domain.h"

class Git;
class QListBoxItem;
class QPopupMenu;
class QTextEdit;
class QTextBrowser;
class QListBox;
class QListViewItem;
class ListView;
class ListViewItem;
class RevDesc;
class ListBoxFiles;
class PatchView;
class TreeView;
class MainImpl;

class RevsView : public Domain {
Q_OBJECT
public:
	RevsView(MainImpl* parent, Git* git);
	void clear(bool keepState);
	void setPatchView(bool b);

private slots:
	void on_loadCompleted(const QString& stats);
	void on_lanesContextMenuRequested(const QStringList&, const QStringList&);
	void on_droppedRevisions(const QString&, const QStringList&, const QString&);

private:
	friend class MainImpl;

	virtual bool doUpdate();

	bool listBoxFiles_mouseMoveEvent();
	bool listBoxFiles_mouseReleaseEvent();
	void updateLineEditSHA(bool clear = false);

	EM_DECLARE(exSetRepositoryCalled);
	EM_DECLARE(exExiting);

	QWidget* tabPage;
	QGuardedPtr<PatchView> patchView;
	TreeView* treeView;
	ListView* listViewLog;
	RevDesc* textBrowserDesc;
	RevDesc* textBrowserDesc_2;
	ListBoxFiles* listBoxFiles;
	ListBoxFiles* listBoxFiles_2;
};

#endif
