
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 1 "cfg-grammar.y"


#include "syslog-ng.h"
#include "cfg.h"
#include "sgroup.h"
#include "dgroup.h"
#include "center.h"
#include "filter.h"
#include "templates.h"
#include "logreader.h"
#include "logparser.h"
#include "logrewrite.h"

#if ENABLE_SSL /* BEGIN MARK: tls */
#include "tlscontext.h"
#endif         /* END MARK */

#include "affile.h"
#include "afinter.h"
#include "afsocket.h"
#include "afinet.h"
#include "afunix.h"
#include "afstreams.h"
#include "afuser.h"
#include "afprog.h"
#if ENABLE_SQL
#include "afsql.h"
#endif

#include "messages.h"

#include "syslog-names.h"

#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* FIXME: the lexer allocates strings with strdup instead of g_strdup,
 * therefore there are unnecessary g_strdup/free pairs in the grammar. These
 * should be removed. */

void yyerror(char *msg);
int yylex();

LogDriver *last_driver;
LogReaderOptions *last_reader_options;
LogWriterOptions *last_writer_options;
LogTemplate *last_template;
SocketOptions *last_sock_options;
LogParser *last_parser;
FilterRE *last_re_filter;
LogRewrite *last_rewrite;
gint last_addr_family = AF_INET;
gchar *last_include_file;

#if ENABLE_SSL
TLSContext *last_tls_context;
#endif


#if ! ENABLE_IPV6
#undef AF_INET6
#define AF_INET6 0; g_assert_not_reached()

#endif

static struct _LogTemplate *
cfg_check_inline_template(GlobalConfig *cfg, const gchar *template_or_name)
{
  struct _LogTemplate *template = cfg_lookup_template(configuration, template_or_name);
  if (template == NULL)
    {
      template = log_template_new(NULL, template_or_name);
      template->def_inline = TRUE;
    }
  return template;
}

static gboolean
cfg_check_template(LogTemplate *template)
{
  GError *error = NULL;
  if (!log_template_compile(template, &error))
    {
      msg_error("Error compiling template",
                evt_tag_str("template", template->template),
                evt_tag_str("error", error->message),
                NULL);
      g_clear_error(&error);
      return FALSE;
    }
  return TRUE;
}




/* Line 189 of yacc.c  */
#line 172 "cfg-grammar.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     KW_SOURCE = 258,
     KW_FILTER = 259,
     KW_PARSER = 260,
     KW_DESTINATION = 261,
     KW_LOG = 262,
     KW_OPTIONS = 263,
     KW_INCLUDE = 264,
     KW_INTERNAL = 265,
     KW_FILE = 266,
     KW_PIPE = 267,
     KW_UNIX_STREAM = 268,
     KW_UNIX_DGRAM = 269,
     KW_TCP = 270,
     KW_UDP = 271,
     KW_TCP6 = 272,
     KW_UDP6 = 273,
     KW_USERTTY = 274,
     KW_DOOR = 275,
     KW_SUN_STREAMS = 276,
     KW_PROGRAM = 277,
     KW_SQL = 278,
     KW_TYPE = 279,
     KW_COLUMNS = 280,
     KW_INDEXES = 281,
     KW_VALUES = 282,
     KW_PASSWORD = 283,
     KW_DATABASE = 284,
     KW_USERNAME = 285,
     KW_TABLE = 286,
     KW_ENCODING = 287,
     KW_DELIMITERS = 288,
     KW_QUOTES = 289,
     KW_QUOTE_PAIRS = 290,
     KW_NULL = 291,
     KW_SYSLOG = 292,
     KW_TRANSPORT = 293,
     KW_FSYNC = 294,
     KW_MARK_FREQ = 295,
     KW_STATS_FREQ = 296,
     KW_STATS_LEVEL = 297,
     KW_FLUSH_LINES = 298,
     KW_SUPPRESS = 299,
     KW_FLUSH_TIMEOUT = 300,
     KW_LOG_MSG_SIZE = 301,
     KW_FILE_TEMPLATE = 302,
     KW_PROTO_TEMPLATE = 303,
     KW_CHAIN_HOSTNAMES = 304,
     KW_NORMALIZE_HOSTNAMES = 305,
     KW_KEEP_HOSTNAME = 306,
     KW_CHECK_HOSTNAME = 307,
     KW_BAD_HOSTNAME = 308,
     KW_KEEP_TIMESTAMP = 309,
     KW_USE_DNS = 310,
     KW_USE_FQDN = 311,
     KW_DNS_CACHE = 312,
     KW_DNS_CACHE_SIZE = 313,
     KW_DNS_CACHE_EXPIRE = 314,
     KW_DNS_CACHE_EXPIRE_FAILED = 315,
     KW_DNS_CACHE_HOSTS = 316,
     KW_PERSIST_ONLY = 317,
     KW_TZ_CONVERT = 318,
     KW_TS_FORMAT = 319,
     KW_FRAC_DIGITS = 320,
     KW_LOG_FIFO_SIZE = 321,
     KW_LOG_DISK_FIFO_SIZE = 322,
     KW_LOG_FETCH_LIMIT = 323,
     KW_LOG_IW_SIZE = 324,
     KW_LOG_PREFIX = 325,
     KW_PROGRAM_OVERRIDE = 326,
     KW_HOST_OVERRIDE = 327,
     KW_THROTTLE = 328,
     KW_TLS = 329,
     KW_PEER_VERIFY = 330,
     KW_KEY_FILE = 331,
     KW_CERT_FILE = 332,
     KW_CA_DIR = 333,
     KW_CRL_DIR = 334,
     KW_TRUSTED_KEYS = 335,
     KW_TRUSTED_DN = 336,
     KW_FLAGS = 337,
     KW_PAD_SIZE = 338,
     KW_TIME_ZONE = 339,
     KW_RECV_TIME_ZONE = 340,
     KW_SEND_TIME_ZONE = 341,
     KW_LOCAL_TIME_ZONE = 342,
     KW_TIME_REOPEN = 343,
     KW_TIME_REAP = 344,
     KW_TIME_SLEEP = 345,
     KW_TMPL_ESCAPE = 346,
     KW_OPTIONAL = 347,
     KW_CREATE_DIRS = 348,
     KW_OWNER = 349,
     KW_GROUP = 350,
     KW_PERM = 351,
     KW_DIR_OWNER = 352,
     KW_DIR_GROUP = 353,
     KW_DIR_PERM = 354,
     KW_TEMPLATE = 355,
     KW_TEMPLATE_ESCAPE = 356,
     KW_FOLLOW_FREQ = 357,
     KW_OVERWRITE_IF_OLDER = 358,
     KW_DEFAULT_FACILITY = 359,
     KW_DEFAULT_LEVEL = 360,
     KW_KEEP_ALIVE = 361,
     KW_MAX_CONNECTIONS = 362,
     KW_LOCALIP = 363,
     KW_IP = 364,
     KW_LOCALPORT = 365,
     KW_PORT = 366,
     KW_DESTPORT = 367,
     KW_IP_TTL = 368,
     KW_SO_BROADCAST = 369,
     KW_IP_TOS = 370,
     KW_SO_SNDBUF = 371,
     KW_SO_RCVBUF = 372,
     KW_SO_KEEPALIVE = 373,
     KW_SPOOF_SOURCE = 374,
     KW_USE_TIME_RECVD = 375,
     KW_FACILITY = 376,
     KW_LEVEL = 377,
     KW_HOST = 378,
     KW_MATCH = 379,
     KW_MESSAGE = 380,
     KW_NETMASK = 381,
     KW_TAGS = 382,
     KW_CSV_PARSER = 383,
     KW_VALUE = 384,
     KW_DB_PARSER = 385,
     KW_REWRITE = 386,
     KW_SET = 387,
     KW_SUBST = 388,
     KW_YES = 389,
     KW_NO = 390,
     KW_GC_IDLE_THRESHOLD = 391,
     KW_GC_BUSY_THRESHOLD = 392,
     KW_COMPRESS = 393,
     KW_MAC = 394,
     KW_AUTH = 395,
     KW_ENCRYPT = 396,
     KW_IFDEF = 397,
     KW_ENDIF = 398,
     LL_DOTDOT = 399,
     LL_IDENTIFIER = 400,
     LL_NUMBER = 401,
     LL_FLOAT = 402,
     LL_STRING = 403,
     KW_OR = 404,
     KW_AND = 405,
     KW_NOT = 406
   };
#endif
/* Tokens.  */
#define KW_SOURCE 258
#define KW_FILTER 259
#define KW_PARSER 260
#define KW_DESTINATION 261
#define KW_LOG 262
#define KW_OPTIONS 263
#define KW_INCLUDE 264
#define KW_INTERNAL 265
#define KW_FILE 266
#define KW_PIPE 267
#define KW_UNIX_STREAM 268
#define KW_UNIX_DGRAM 269
#define KW_TCP 270
#define KW_UDP 271
#define KW_TCP6 272
#define KW_UDP6 273
#define KW_USERTTY 274
#define KW_DOOR 275
#define KW_SUN_STREAMS 276
#define KW_PROGRAM 277
#define KW_SQL 278
#define KW_TYPE 279
#define KW_COLUMNS 280
#define KW_INDEXES 281
#define KW_VALUES 282
#define KW_PASSWORD 283
#define KW_DATABASE 284
#define KW_USERNAME 285
#define KW_TABLE 286
#define KW_ENCODING 287
#define KW_DELIMITERS 288
#define KW_QUOTES 289
#define KW_QUOTE_PAIRS 290
#define KW_NULL 291
#define KW_SYSLOG 292
#define KW_TRANSPORT 293
#define KW_FSYNC 294
#define KW_MARK_FREQ 295
#define KW_STATS_FREQ 296
#define KW_STATS_LEVEL 297
#define KW_FLUSH_LINES 298
#define KW_SUPPRESS 299
#define KW_FLUSH_TIMEOUT 300
#define KW_LOG_MSG_SIZE 301
#define KW_FILE_TEMPLATE 302
#define KW_PROTO_TEMPLATE 303
#define KW_CHAIN_HOSTNAMES 304
#define KW_NORMALIZE_HOSTNAMES 305
#define KW_KEEP_HOSTNAME 306
#define KW_CHECK_HOSTNAME 307
#define KW_BAD_HOSTNAME 308
#define KW_KEEP_TIMESTAMP 309
#define KW_USE_DNS 310
#define KW_USE_FQDN 311
#define KW_DNS_CACHE 312
#define KW_DNS_CACHE_SIZE 313
#define KW_DNS_CACHE_EXPIRE 314
#define KW_DNS_CACHE_EXPIRE_FAILED 315
#define KW_DNS_CACHE_HOSTS 316
#define KW_PERSIST_ONLY 317
#define KW_TZ_CONVERT 318
#define KW_TS_FORMAT 319
#define KW_FRAC_DIGITS 320
#define KW_LOG_FIFO_SIZE 321
#define KW_LOG_DISK_FIFO_SIZE 322
#define KW_LOG_FETCH_LIMIT 323
#define KW_LOG_IW_SIZE 324
#define KW_LOG_PREFIX 325
#define KW_PROGRAM_OVERRIDE 326
#define KW_HOST_OVERRIDE 327
#define KW_THROTTLE 328
#define KW_TLS 329
#define KW_PEER_VERIFY 330
#define KW_KEY_FILE 331
#define KW_CERT_FILE 332
#define KW_CA_DIR 333
#define KW_CRL_DIR 334
#define KW_TRUSTED_KEYS 335
#define KW_TRUSTED_DN 336
#define KW_FLAGS 337
#define KW_PAD_SIZE 338
#define KW_TIME_ZONE 339
#define KW_RECV_TIME_ZONE 340
#define KW_SEND_TIME_ZONE 341
#define KW_LOCAL_TIME_ZONE 342
#define KW_TIME_REOPEN 343
#define KW_TIME_REAP 344
#define KW_TIME_SLEEP 345
#define KW_TMPL_ESCAPE 346
#define KW_OPTIONAL 347
#define KW_CREATE_DIRS 348
#define KW_OWNER 349
#define KW_GROUP 350
#define KW_PERM 351
#define KW_DIR_OWNER 352
#define KW_DIR_GROUP 353
#define KW_DIR_PERM 354
#define KW_TEMPLATE 355
#define KW_TEMPLATE_ESCAPE 356
#define KW_FOLLOW_FREQ 357
#define KW_OVERWRITE_IF_OLDER 358
#define KW_DEFAULT_FACILITY 359
#define KW_DEFAULT_LEVEL 360
#define KW_KEEP_ALIVE 361
#define KW_MAX_CONNECTIONS 362
#define KW_LOCALIP 363
#define KW_IP 364
#define KW_LOCALPORT 365
#define KW_PORT 366
#define KW_DESTPORT 367
#define KW_IP_TTL 368
#define KW_SO_BROADCAST 369
#define KW_IP_TOS 370
#define KW_SO_SNDBUF 371
#define KW_SO_RCVBUF 372
#define KW_SO_KEEPALIVE 373
#define KW_SPOOF_SOURCE 374
#define KW_USE_TIME_RECVD 375
#define KW_FACILITY 376
#define KW_LEVEL 377
#define KW_HOST 378
#define KW_MATCH 379
#define KW_MESSAGE 380
#define KW_NETMASK 381
#define KW_TAGS 382
#define KW_CSV_PARSER 383
#define KW_VALUE 384
#define KW_DB_PARSER 385
#define KW_REWRITE 386
#define KW_SET 387
#define KW_SUBST 388
#define KW_YES 389
#define KW_NO 390
#define KW_GC_IDLE_THRESHOLD 391
#define KW_GC_BUSY_THRESHOLD 392
#define KW_COMPRESS 393
#define KW_MAC 394
#define KW_AUTH 395
#define KW_ENCRYPT 396
#define KW_IFDEF 397
#define KW_ENDIF 398
#define LL_DOTDOT 399
#define LL_IDENTIFIER 400
#define LL_NUMBER 401
#define LL_FLOAT 402
#define LL_STRING 403
#define KW_OR 404
#define KW_AND 405
#define KW_NOT 406




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 99 "cfg-grammar.y"

        gint token;
	gint64 num;
	double fnum;
	char *cptr;
	void *ptr;
	FilterExprNode *node;



/* Line 214 of yacc.c  */
#line 521 "cfg-grammar.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 533 "cfg-grammar.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  58
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1711

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  157
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  171
/* YYNRULES -- Number of rules.  */
#define YYNRULES  458
/* YYNRULES -- Number of states.  */
#define YYNSTATES  1149

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   406

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     155,   156,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,   152,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   153,     2,   154,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    12,    15,    18,    21,
      24,    27,    30,    33,    36,    39,    44,    50,    56,    61,
      66,    72,    74,    78,    79,    84,    89,    94,    99,   104,
     107,   108,   116,   122,   123,   126,   127,   131,   132,   138,
     142,   143,   148,   153,   158,   163,   168,   173,   175,   180,
     185,   189,   190,   192,   194,   196,   198,   200,   202,   206,
     211,   216,   217,   221,   222,   226,   231,   233,   238,   243,
     244,   250,   251,   257,   258,   264,   265,   271,   272,   276,
     277,   281,   284,   285,   290,   295,   300,   305,   307,   309,
     311,   312,   315,   318,   319,   321,   326,   331,   336,   341,
     343,   345,   346,   349,   352,   353,   355,   356,   362,   364,
     369,   374,   375,   381,   382,   385,   388,   389,   391,   396,
     401,   406,   411,   412,   418,   420,   425,   426,   430,   432,
     437,   439,   440,   444,   447,   448,   450,   455,   457,   460,
     461,   466,   471,   476,   481,   486,   491,   496,   501,   506,
     511,   516,   521,   526,   531,   536,   541,   546,   551,   556,
     561,   566,   571,   576,   579,   580,   584,   585,   587,   589,
     591,   593,   595,   597,   599,   604,   605,   609,   612,   613,
     615,   620,   625,   630,   635,   640,   645,   650,   655,   660,
     665,   670,   675,   676,   680,   683,   684,   686,   691,   696,
     701,   706,   711,   712,   718,   719,   725,   726,   732,   733,
     739,   740,   744,   745,   749,   752,   753,   755,   757,   759,
     760,   764,   767,   768,   773,   778,   783,   788,   790,   792,
     794,   796,   801,   802,   806,   809,   810,   812,   813,   819,
     824,   829,   830,   834,   837,   838,   840,   845,   850,   855,
     860,   865,   866,   872,   877,   882,   883,   887,   892,   893,
     896,   899,   900,   902,   907,   912,   917,   922,   927,   932,
     937,   942,   947,   952,   957,   962,   967,   972,   977,   982,
     984,   987,   988,   993,   998,  1003,  1008,  1013,  1018,  1023,
    1028,  1033,  1038,  1043,  1046,  1047,  1051,  1052,  1057,  1062,
    1067,  1072,  1077,  1082,  1087,  1092,  1097,  1102,  1107,  1112,
    1117,  1122,  1127,  1132,  1137,  1142,  1147,  1152,  1157,  1162,
    1167,  1172,  1177,  1182,  1187,  1192,  1197,  1202,  1207,  1212,
    1217,  1222,  1227,  1232,  1237,  1242,  1247,  1252,  1257,  1262,
    1265,  1266,  1268,  1273,  1278,  1283,  1288,  1293,  1298,  1303,
    1305,  1307,  1310,  1314,  1318,  1322,  1327,  1332,  1337,  1342,
    1347,  1352,  1353,  1360,  1361,  1368,  1369,  1376,  1377,  1384,
    1385,  1392,  1395,  1396,  1398,  1403,  1406,  1407,  1412,  1417,
    1420,  1421,  1424,  1426,  1429,  1431,  1435,  1437,  1438,  1444,
    1445,  1451,  1454,  1455,  1460,  1462,  1467,  1472,  1475,  1476,
    1478,  1483,  1488,  1493,  1498,  1503,  1506,  1507,  1509,  1512,
    1513,  1514,  1523,  1524,  1532,  1535,  1536,  1541,  1546,  1551,
    1553,  1555,  1557,  1559,  1561,  1563,  1565,  1567,  1569,  1571,
    1573,  1575,  1577,  1579,  1581,  1583,  1585,  1587,  1589,  1591,
    1593,  1595,  1597,  1599,  1601,  1603,  1605,  1607,  1609,  1611,
    1613,  1615,  1617,  1619,  1621,  1624,  1625,  1627,  1629
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     158,     0,    -1,   159,    -1,    -1,   161,   152,   160,   159,
      -1,    -1,     3,   162,    -1,     6,   166,    -1,     7,   167,
      -1,     4,   163,    -1,     5,   164,    -1,   131,   165,    -1,
     100,   176,    -1,     8,   175,    -1,     9,   168,    -1,   321,
     153,   182,   154,    -1,   321,   153,   287,   152,   154,    -1,
     321,   153,   302,   152,   154,    -1,   321,   153,   312,   154,
      -1,   321,   153,   231,   154,    -1,   153,   169,   171,   173,
     154,    -1,   321,    -1,   170,   152,   169,    -1,    -1,     3,
     155,   321,   156,    -1,     4,   155,   321,   156,    -1,     5,
     155,   321,   156,    -1,   131,   155,   321,   156,    -1,     6,
     155,   321,   156,    -1,   172,   171,    -1,    -1,     7,   153,
     169,   171,   173,   154,   152,    -1,    82,   155,   174,   156,
     152,    -1,    -1,   321,   174,    -1,    -1,   153,   283,   154,
      -1,    -1,   321,   177,   153,   178,   154,    -1,   179,   152,
     178,    -1,    -1,   100,   155,   321,   156,    -1,   101,   155,
     319,   156,    -1,   116,   155,   146,   156,    -1,   117,   155,
     146,   156,    -1,   114,   155,   319,   156,    -1,   118,   155,
     319,   156,    -1,   180,    -1,   113,   155,   146,   156,    -1,
     115,   155,   146,   156,    -1,   183,   152,   182,    -1,    -1,
     184,    -1,   185,    -1,   191,    -1,   213,    -1,   223,    -1,
     220,    -1,    10,   155,   156,    -1,    11,   155,   186,   156,
      -1,    12,   155,   188,   156,    -1,    -1,   321,   187,   228,
      -1,    -1,   321,   189,   190,    -1,    92,   155,   319,   156,
      -1,   228,    -1,    14,   155,   196,   156,    -1,    13,   155,
     198,   156,    -1,    -1,    16,   192,   155,   202,   156,    -1,
      -1,    15,   193,   155,   207,   156,    -1,    -1,    18,   194,
     155,   202,   156,    -1,    -1,    17,   195,   155,   207,   156,
      -1,    -1,   321,   197,   200,    -1,    -1,   321,   199,   200,
      -1,   201,   200,    -1,    -1,    94,   155,   323,   156,    -1,
      95,   155,   323,   156,    -1,    96,   155,   146,   156,    -1,
      92,   155,   319,   156,    -1,   212,    -1,   229,    -1,   180,
      -1,    -1,   203,   204,    -1,   205,   204,    -1,    -1,   206,
      -1,   108,   155,   321,   156,    -1,   109,   155,   321,   156,
      -1,   110,   155,   323,   156,    -1,   111,   155,   323,   156,
      -1,   229,    -1,   181,    -1,    -1,   208,   209,    -1,   210,
     209,    -1,    -1,   206,    -1,    -1,    74,   211,   155,   285,
     156,    -1,   212,    -1,   106,   155,   319,   156,    -1,   107,
     155,   146,   156,    -1,    -1,    37,   214,   155,   215,   156,
      -1,    -1,   216,   217,    -1,   218,   217,    -1,    -1,   206,
      -1,    38,   155,   321,   156,    -1,    38,   155,    15,   156,
      -1,    38,   155,    16,   156,    -1,    38,   155,    74,   156,
      -1,    -1,    74,   219,   155,   285,   156,    -1,   212,    -1,
      22,   155,   221,   156,    -1,    -1,   321,   222,   228,    -1,
     142,    -1,    21,   155,   224,   156,    -1,   143,    -1,    -1,
     321,   225,   226,    -1,   227,   226,    -1,    -1,   142,    -1,
      20,   155,   321,   156,    -1,   143,    -1,   229,   228,    -1,
      -1,    69,   155,   146,   156,    -1,    49,   155,   319,   156,
      -1,    50,   155,   319,   156,    -1,    51,   155,   319,   156,
      -1,    56,   155,   319,   156,    -1,    55,   155,   320,   156,
      -1,    57,   155,   319,   156,    -1,    71,   155,   321,   156,
      -1,    72,   155,   321,   156,    -1,    70,   155,   321,   156,
      -1,    84,   155,   321,   156,    -1,    52,   155,   319,   156,
      -1,    82,   155,   230,   156,    -1,    46,   155,   146,   156,
      -1,    68,   155,   146,   156,    -1,    83,   155,   146,   156,
      -1,   102,   155,   147,   156,    -1,   102,   155,   146,   156,
      -1,    54,   155,   319,   156,    -1,    32,   155,   321,   156,
      -1,   127,   155,   324,   156,    -1,   105,   155,   326,   156,
      -1,   104,   155,   327,   156,    -1,   321,   230,    -1,    -1,
     232,   152,   231,    -1,    -1,   233,    -1,   238,    -1,   243,
      -1,   271,    -1,   272,    -1,   265,    -1,   275,    -1,    11,
     155,   234,   156,    -1,    -1,   321,   235,   236,    -1,   237,
     236,    -1,    -1,   281,    -1,    92,   155,   319,   156,    -1,
      94,   155,   323,   156,    -1,    95,   155,   323,   156,    -1,
      96,   155,   146,   156,    -1,    97,   155,   323,   156,    -1,
      98,   155,   323,   156,    -1,    99,   155,   146,   156,    -1,
      93,   155,   319,   156,    -1,   103,   155,   146,   156,    -1,
      39,   155,   319,   156,    -1,    87,   155,   321,   156,    -1,
      12,   155,   239,   156,    -1,    -1,   321,   240,   241,    -1,
     242,   241,    -1,    -1,   281,    -1,    94,   155,   323,   156,
      -1,    95,   155,   323,   156,    -1,    96,   155,   146,   156,
      -1,    14,   155,   248,   156,    -1,    13,   155,   250,   156,
      -1,    -1,    16,   244,   155,   254,   156,    -1,    -1,    15,
     245,   155,   259,   156,    -1,    -1,    18,   246,   155,   254,
     156,    -1,    -1,    17,   247,   155,   259,   156,    -1,    -1,
     321,   249,   252,    -1,    -1,   321,   251,   252,    -1,   252,
     253,    -1,    -1,   281,    -1,   264,    -1,   180,    -1,    -1,
     321,   255,   256,    -1,   256,   258,    -1,    -1,   108,   155,
     321,   156,    -1,   110,   155,   323,   156,    -1,   111,   155,
     323,   156,    -1,   112,   155,   323,   156,    -1,   181,    -1,
     281,    -1,   264,    -1,   257,    -1,   119,   155,   319,   156,
      -1,    -1,   321,   260,   261,    -1,   261,   262,    -1,    -1,
     257,    -1,    -1,    74,   263,   155,   285,   156,    -1,   106,
     155,   319,   156,    -1,    37,   155,   266,   156,    -1,    -1,
     321,   267,   268,    -1,   268,   269,    -1,    -1,   257,    -1,
      38,   155,   321,   156,    -1,    38,   155,    15,   156,    -1,
      38,   155,    16,   156,    -1,    38,   155,    74,   156,    -1,
     119,   155,   319,   156,    -1,    -1,    74,   270,   155,   285,
     156,    -1,    19,   155,   321,   156,    -1,    22,   155,   273,
     156,    -1,    -1,   321,   274,   280,    -1,    23,   155,   276,
     156,    -1,    -1,   277,   278,    -1,   279,   278,    -1,    -1,
     142,    -1,    24,   155,   321,   156,    -1,   123,   155,   321,
     156,    -1,   111,   155,   323,   156,    -1,    30,   155,   321,
     156,    -1,    28,   155,   321,   156,    -1,    29,   155,   321,
     156,    -1,    31,   155,   321,   156,    -1,    25,   155,   324,
     156,    -1,    26,   155,   324,   156,    -1,    27,   155,   324,
     156,    -1,    66,   155,   146,   156,    -1,    67,   155,   146,
     156,    -1,    65,   155,   146,   156,    -1,    84,   155,   321,
     156,    -1,    87,   155,   321,   156,    -1,    36,   155,   321,
     156,    -1,   143,    -1,   281,   280,    -1,    -1,    82,   155,
     282,   156,    -1,    66,   155,   146,   156,    -1,    43,   155,
     146,   156,    -1,    45,   155,   146,   156,    -1,    44,   155,
     146,   156,    -1,   100,   155,   321,   156,    -1,   101,   155,
     319,   156,    -1,    84,   155,   321,   156,    -1,    64,   155,
     321,   156,    -1,    65,   155,   146,   156,    -1,    73,   155,
     146,   156,    -1,   321,   282,    -1,    -1,   284,   152,   283,
      -1,    -1,    40,   155,   146,   156,    -1,    41,   155,   146,
     156,    -1,    42,   155,   146,   156,    -1,    43,   155,   146,
     156,    -1,    45,   155,   146,   156,    -1,    49,   155,   319,
     156,    -1,    50,   155,   319,   156,    -1,    51,   155,   319,
     156,    -1,    52,   155,   319,   156,    -1,    53,   155,   321,
     156,    -1,   120,   155,   319,   156,    -1,    56,   155,   319,
     156,    -1,    55,   155,   320,   156,    -1,    88,   155,   146,
     156,    -1,    89,   155,   146,   156,    -1,    90,   155,   146,
     156,    -1,    66,   155,   146,   156,    -1,    69,   155,   146,
     156,    -1,    68,   155,   146,   156,    -1,    46,   155,   146,
     156,    -1,    54,   155,   319,   156,    -1,    64,   155,   321,
     156,    -1,    65,   155,   146,   156,    -1,   137,   155,   146,
     156,    -1,   136,   155,   146,   156,    -1,    93,   155,   319,
     156,    -1,    94,   155,   323,   156,    -1,    95,   155,   323,
     156,    -1,    96,   155,   146,   156,    -1,    97,   155,   323,
     156,    -1,    98,   155,   323,   156,    -1,    99,   155,   146,
     156,    -1,    57,   155,   319,   156,    -1,    58,   155,   146,
     156,    -1,    59,   155,   146,   156,    -1,    60,   155,   146,
     156,    -1,    61,   155,   321,   156,    -1,    47,   155,   321,
     156,    -1,    48,   155,   321,   156,    -1,    85,   155,   321,
     156,    -1,    86,   155,   321,   156,    -1,    87,   155,   321,
     156,    -1,   286,   285,    -1,    -1,   142,    -1,    75,   155,
     321,   156,    -1,    76,   155,   321,   156,    -1,    77,   155,
     321,   156,    -1,    78,   155,   321,   156,    -1,    79,   155,
     321,   156,    -1,    80,   155,   324,   156,    -1,    81,   155,
     324,   156,    -1,   143,    -1,   288,    -1,   151,   287,    -1,
     287,   149,   287,    -1,   287,   150,   287,    -1,   155,   287,
     156,    -1,   121,   155,   299,   156,    -1,   121,   155,   146,
     156,    -1,   122,   155,   300,   156,    -1,     4,   155,   321,
     156,    -1,   126,   155,   321,   156,    -1,   127,   155,   324,
     156,    -1,    -1,    22,   155,   321,   289,   296,   156,    -1,
      -1,   123,   155,   321,   290,   296,   156,    -1,    -1,   124,
     155,   321,   291,   294,   156,    -1,    -1,   125,   155,   321,
     292,   296,   156,    -1,    -1,     3,   155,   321,   293,   296,
     156,    -1,   295,   294,    -1,    -1,   297,    -1,   129,   155,
     321,   156,    -1,   297,   296,    -1,    -1,    24,   155,   321,
     156,    -1,    82,   155,   298,   156,    -1,   321,   298,    -1,
      -1,   327,   299,    -1,   327,    -1,   301,   300,    -1,   301,
      -1,   326,   144,   326,    -1,   326,    -1,    -1,   128,   155,
     303,   309,   156,    -1,    -1,   130,   155,   304,   305,   156,
      -1,   306,   305,    -1,    -1,    11,   155,   321,   156,    -1,
     308,    -1,    25,   155,   324,   156,    -1,   100,   155,   321,
     156,    -1,   310,   309,    -1,    -1,   307,    -1,    82,   155,
     311,   156,    -1,    33,   155,   321,   156,    -1,    34,   155,
     321,   156,    -1,    35,   155,   321,   156,    -1,    36,   155,
     321,   156,    -1,   321,   311,    -1,    -1,   313,    -1,   314,
     313,    -1,    -1,    -1,   133,   155,   321,   321,   315,   317,
     156,   152,    -1,    -1,   132,   155,   321,   316,   317,   156,
     152,    -1,   318,   317,    -1,    -1,   129,   155,   321,   156,
      -1,    24,   155,   321,   156,    -1,    82,   155,   298,   156,
      -1,   134,    -1,   135,    -1,   146,    -1,   319,    -1,    62,
      -1,   145,    -1,   148,    -1,   322,    -1,     5,    -1,   131,
      -1,     9,    -1,    25,    -1,    33,    -1,    34,    -1,    35,
      -1,    36,    -1,   128,    -1,   130,    -1,    32,    -1,   132,
      -1,   133,    -1,   129,    -1,    71,    -1,    72,    -1,    38,
      -1,    80,    -1,    81,    -1,   125,    -1,    24,    -1,    23,
      -1,   104,    -1,   105,    -1,   321,    -1,   146,    -1,   325,
      -1,   321,   325,    -1,    -1,   321,    -1,   321,    -1,    37,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   317,   317,   322,   321,   336,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   352,   356,   360,   363,   366,
     370,   374,   377,   378,   382,   383,   384,   385,   386,   390,
     391,   395,   399,   400,   405,   406,   411,   416,   415,   424,
     425,   429,   430,   434,   435,   436,   437,   441,   442,   443,
     447,   448,   452,   453,   454,   455,   456,   457,   461,   465,
     466,   471,   470,   481,   480,   490,   491,   495,   496,   497,
     497,   498,   498,   499,   499,   500,   500,   505,   504,   518,
     517,   531,   532,   536,   537,   538,   539,   540,   541,   542,
     547,   547,   558,   559,   563,   567,   568,   569,   570,   571,
     572,   577,   577,   588,   589,   593,   596,   595,   608,   612,
     613,   617,   617,   622,   622,   633,   634,   638,   639,   640,
     641,   642,   644,   643,   655,   659,   664,   663,   673,   676,
     677,   684,   683,   694,   695,   699,   702,   703,   709,   710,
     714,   715,   716,   717,   718,   719,   720,   721,   722,   723,
     724,   725,   726,   727,   728,   729,   730,   731,   732,   733,
     734,   735,   741,   750,   751,   756,   757,   761,   762,   763,
     764,   765,   766,   768,   773,   778,   777,   788,   789,   793,
     794,   795,   796,   797,   798,   799,   800,   801,   802,   803,
     804,   808,   813,   812,   823,   824,   828,   829,   830,   831,
     835,   836,   837,   837,   838,   838,   839,   839,   840,   840,
     845,   844,   856,   855,   866,   867,   871,   872,   873,   878,
     877,   890,   891,   896,   897,   898,   899,   900,   901,   902,
     906,   907,   912,   911,   924,   925,   929,   931,   930,   945,
     950,   954,   953,   965,   966,   970,   971,   972,   973,   974,
     975,   977,   976,   992,   996,  1001,  1000,  1012,  1017,  1017,
    1026,  1027,  1031,  1034,  1035,  1036,  1037,  1038,  1039,  1040,
    1041,  1042,  1043,  1044,  1045,  1046,  1047,  1048,  1049,  1051,
    1059,  1060,  1064,  1065,  1066,  1067,  1068,  1069,  1077,  1078,
    1079,  1080,  1081,  1085,  1086,  1091,  1092,  1096,  1097,  1098,
    1099,  1100,  1101,  1102,  1103,  1104,  1105,  1106,  1107,  1108,
    1109,  1110,  1111,  1120,  1121,  1122,  1123,  1124,  1125,  1126,
    1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,  1135,  1136,
    1137,  1138,  1139,  1141,  1142,  1143,  1144,  1145,  1146,  1151,
    1152,  1156,  1160,  1165,  1170,  1175,  1180,  1185,  1189,  1193,
    1201,  1202,  1203,  1204,  1205,  1209,  1210,  1211,  1212,  1213,
    1214,  1216,  1215,  1228,  1227,  1240,  1239,  1263,  1262,  1274,
    1273,  1288,  1289,  1293,  1294,  1310,  1311,  1315,  1320,  1324,
    1325,  1330,  1331,  1335,  1336,  1340,  1344,  1353,  1352,  1359,
    1358,  1367,  1368,  1373,  1377,  1378,  1382,  1395,  1396,  1400,
    1401,  1402,  1403,  1404,  1405,  1409,  1410,  1414,  1418,  1419,
    1424,  1423,  1436,  1435,  1444,  1445,  1449,  1469,  1480,  1484,
    1485,  1486,  1490,  1491,  1495,  1496,  1497,  1502,  1503,  1504,
    1505,  1506,  1507,  1508,  1509,  1510,  1511,  1512,  1513,  1514,
    1515,  1516,  1517,  1518,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1529,  1530,  1534,  1538,  1539,  1543,  1560,  1574
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "KW_SOURCE", "KW_FILTER", "KW_PARSER",
  "KW_DESTINATION", "KW_LOG", "KW_OPTIONS", "KW_INCLUDE", "KW_INTERNAL",
  "KW_FILE", "KW_PIPE", "KW_UNIX_STREAM", "KW_UNIX_DGRAM", "KW_TCP",
  "KW_UDP", "KW_TCP6", "KW_UDP6", "KW_USERTTY", "KW_DOOR",
  "KW_SUN_STREAMS", "KW_PROGRAM", "KW_SQL", "KW_TYPE", "KW_COLUMNS",
  "KW_INDEXES", "KW_VALUES", "KW_PASSWORD", "KW_DATABASE", "KW_USERNAME",
  "KW_TABLE", "KW_ENCODING", "KW_DELIMITERS", "KW_QUOTES",
  "KW_QUOTE_PAIRS", "KW_NULL", "KW_SYSLOG", "KW_TRANSPORT", "KW_FSYNC",
  "KW_MARK_FREQ", "KW_STATS_FREQ", "KW_STATS_LEVEL", "KW_FLUSH_LINES",
  "KW_SUPPRESS", "KW_FLUSH_TIMEOUT", "KW_LOG_MSG_SIZE", "KW_FILE_TEMPLATE",
  "KW_PROTO_TEMPLATE", "KW_CHAIN_HOSTNAMES", "KW_NORMALIZE_HOSTNAMES",
  "KW_KEEP_HOSTNAME", "KW_CHECK_HOSTNAME", "KW_BAD_HOSTNAME",
  "KW_KEEP_TIMESTAMP", "KW_USE_DNS", "KW_USE_FQDN", "KW_DNS_CACHE",
  "KW_DNS_CACHE_SIZE", "KW_DNS_CACHE_EXPIRE", "KW_DNS_CACHE_EXPIRE_FAILED",
  "KW_DNS_CACHE_HOSTS", "KW_PERSIST_ONLY", "KW_TZ_CONVERT", "KW_TS_FORMAT",
  "KW_FRAC_DIGITS", "KW_LOG_FIFO_SIZE", "KW_LOG_DISK_FIFO_SIZE",
  "KW_LOG_FETCH_LIMIT", "KW_LOG_IW_SIZE", "KW_LOG_PREFIX",
  "KW_PROGRAM_OVERRIDE", "KW_HOST_OVERRIDE", "KW_THROTTLE", "KW_TLS",
  "KW_PEER_VERIFY", "KW_KEY_FILE", "KW_CERT_FILE", "KW_CA_DIR",
  "KW_CRL_DIR", "KW_TRUSTED_KEYS", "KW_TRUSTED_DN", "KW_FLAGS",
  "KW_PAD_SIZE", "KW_TIME_ZONE", "KW_RECV_TIME_ZONE", "KW_SEND_TIME_ZONE",
  "KW_LOCAL_TIME_ZONE", "KW_TIME_REOPEN", "KW_TIME_REAP", "KW_TIME_SLEEP",
  "KW_TMPL_ESCAPE", "KW_OPTIONAL", "KW_CREATE_DIRS", "KW_OWNER",
  "KW_GROUP", "KW_PERM", "KW_DIR_OWNER", "KW_DIR_GROUP", "KW_DIR_PERM",
  "KW_TEMPLATE", "KW_TEMPLATE_ESCAPE", "KW_FOLLOW_FREQ",
  "KW_OVERWRITE_IF_OLDER", "KW_DEFAULT_FACILITY", "KW_DEFAULT_LEVEL",
  "KW_KEEP_ALIVE", "KW_MAX_CONNECTIONS", "KW_LOCALIP", "KW_IP",
  "KW_LOCALPORT", "KW_PORT", "KW_DESTPORT", "KW_IP_TTL", "KW_SO_BROADCAST",
  "KW_IP_TOS", "KW_SO_SNDBUF", "KW_SO_RCVBUF", "KW_SO_KEEPALIVE",
  "KW_SPOOF_SOURCE", "KW_USE_TIME_RECVD", "KW_FACILITY", "KW_LEVEL",
  "KW_HOST", "KW_MATCH", "KW_MESSAGE", "KW_NETMASK", "KW_TAGS",
  "KW_CSV_PARSER", "KW_VALUE", "KW_DB_PARSER", "KW_REWRITE", "KW_SET",
  "KW_SUBST", "KW_YES", "KW_NO", "KW_GC_IDLE_THRESHOLD",
  "KW_GC_BUSY_THRESHOLD", "KW_COMPRESS", "KW_MAC", "KW_AUTH", "KW_ENCRYPT",
  "KW_IFDEF", "KW_ENDIF", "LL_DOTDOT", "LL_IDENTIFIER", "LL_NUMBER",
  "LL_FLOAT", "LL_STRING", "KW_OR", "KW_AND", "KW_NOT", "';'", "'{'",
  "'}'", "'('", "')'", "$accept", "start", "stmts", "$@1", "stmt",
  "source_stmt", "filter_stmt", "parser_stmt", "rewrite_stmt", "dest_stmt",
  "log_stmt", "include_stmt", "log_items", "log_item", "log_forks",
  "log_fork", "log_flags", "log_flags_items", "options_stmt",
  "template_stmt", "$@2", "template_items", "template_item",
  "socket_option", "inet_socket_option", "source_items", "source_item",
  "source_afinter", "source_affile", "source_affile_params", "$@3",
  "source_afpipe_params", "$@4", "source_afpipe_options",
  "source_afsocket", "$@5", "$@6", "$@7", "$@8",
  "source_afunix_dgram_params", "$@9", "source_afunix_stream_params",
  "$@10", "source_afunix_options", "source_afunix_option",
  "source_afinet_udp_params", "$@11", "source_afinet_udp_options",
  "source_afinet_udp_option", "source_afinet_option",
  "source_afinet_tcp_params", "$@12", "source_afinet_tcp_options",
  "source_afinet_tcp_option", "$@13", "source_afsocket_stream_params",
  "source_afsyslog", "$@14", "source_afsyslog_params", "$@15",
  "source_afsyslog_options", "source_afsyslog_option", "$@16",
  "source_afprogram", "source_afprogram_params", "$@17",
  "source_afstreams", "source_afstreams_params", "$@18",
  "source_afstreams_options", "source_afstreams_option",
  "source_reader_options", "source_reader_option",
  "source_reader_option_flags", "dest_items", "dest_item", "dest_affile",
  "dest_affile_params", "$@19", "dest_affile_options",
  "dest_affile_option", "dest_afpipe", "dest_afpipe_params", "$@20",
  "dest_afpipe_options", "dest_afpipe_option", "dest_afsocket", "$@21",
  "$@22", "$@23", "$@24", "dest_afunix_dgram_params", "$@25",
  "dest_afunix_stream_params", "$@26", "dest_afunix_options",
  "dest_afunix_option", "dest_afinet_udp_params", "$@27",
  "dest_afinet_udp_options", "dest_afinet_option",
  "dest_afinet_udp_option", "dest_afinet_tcp_params", "$@28",
  "dest_afinet_tcp_options", "dest_afinet_tcp_option", "$@29",
  "dest_afsocket_option", "dest_afsyslog", "dest_afsyslog_params", "$@30",
  "dest_afsyslog_options", "dest_afsyslog_option", "$@31", "dest_afuser",
  "dest_afprogram", "dest_afprogram_params", "$@32", "dest_afsql",
  "dest_afsql_params", "$@33", "dest_afsql_options", "dest_afsql_option",
  "dest_writer_options", "dest_writer_option", "dest_writer_options_flags",
  "options_items", "options_item", "tls_options", "tls_option",
  "filter_expr", "filter_simple_expr", "$@34", "$@35", "$@36", "$@37",
  "$@38", "filter_match_opts", "filter_match_opt", "filter_re_opts",
  "filter_re_opt", "regexp_option_flags", "filter_fac_list",
  "filter_level_list", "filter_level", "parser_expr", "$@39", "$@40",
  "parser_db_opts", "parser_db_opt", "parser_column_opt", "parser_opt",
  "parser_csv_opts", "parser_csv_opt", "parser_csv_flags",
  "rewrite_expr_list", "rewrite_expr_list_build", "rewrite_expr", "$@41",
  "$@42", "rewrite_expr_opts", "rewrite_expr_opt", "yesno", "dnsmode",
  "string", "reserved_words_as_strings", "string_or_number", "string_list",
  "string_list_build", "level_string", "facility_string", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,    59,   123,   125,    40,    41
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   157,   158,   160,   159,   159,   161,   161,   161,   161,
     161,   161,   161,   161,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   169,   170,   170,   170,   170,   170,   171,
     171,   172,   173,   173,   174,   174,   175,   177,   176,   178,
     178,   179,   179,   180,   180,   180,   180,   181,   181,   181,
     182,   182,   183,   183,   183,   183,   183,   183,   184,   185,
     185,   187,   186,   189,   188,   190,   190,   191,   191,   192,
     191,   193,   191,   194,   191,   195,   191,   197,   196,   199,
     198,   200,   200,   201,   201,   201,   201,   201,   201,   201,
     203,   202,   204,   204,   205,   206,   206,   206,   206,   206,
     206,   208,   207,   209,   209,   210,   211,   210,   210,   212,
     212,   214,   213,   216,   215,   217,   217,   218,   218,   218,
     218,   218,   219,   218,   218,   220,   222,   221,   223,   223,
     223,   225,   224,   226,   226,   227,   227,   227,   228,   228,
     229,   229,   229,   229,   229,   229,   229,   229,   229,   229,
     229,   229,   229,   229,   229,   229,   229,   229,   229,   229,
     229,   229,   229,   230,   230,   231,   231,   232,   232,   232,
     232,   232,   232,   232,   233,   235,   234,   236,   236,   237,
     237,   237,   237,   237,   237,   237,   237,   237,   237,   237,
     237,   238,   240,   239,   241,   241,   242,   242,   242,   242,
     243,   243,   244,   243,   245,   243,   246,   243,   247,   243,
     249,   248,   251,   250,   252,   252,   253,   253,   253,   255,
     254,   256,   256,   257,   257,   257,   257,   257,   257,   257,
     258,   258,   260,   259,   261,   261,   262,   263,   262,   264,
     265,   267,   266,   268,   268,   269,   269,   269,   269,   269,
     269,   270,   269,   271,   272,   274,   273,   275,   277,   276,
     278,   278,   279,   279,   279,   279,   279,   279,   279,   279,
     279,   279,   279,   279,   279,   279,   279,   279,   279,   279,
     280,   280,   281,   281,   281,   281,   281,   281,   281,   281,
     281,   281,   281,   282,   282,   283,   283,   284,   284,   284,
     284,   284,   284,   284,   284,   284,   284,   284,   284,   284,
     284,   284,   284,   284,   284,   284,   284,   284,   284,   284,
     284,   284,   284,   284,   284,   284,   284,   284,   284,   284,
     284,   284,   284,   284,   284,   284,   284,   284,   284,   285,
     285,   286,   286,   286,   286,   286,   286,   286,   286,   286,
     287,   287,   287,   287,   287,   288,   288,   288,   288,   288,
     288,   289,   288,   290,   288,   291,   288,   292,   288,   293,
     288,   294,   294,   295,   295,   296,   296,   297,   297,   298,
     298,   299,   299,   300,   300,   301,   301,   303,   302,   304,
     302,   305,   305,   306,   307,   307,   308,   309,   309,   310,
     310,   310,   310,   310,   310,   311,   311,   312,   313,   313,
     315,   314,   316,   314,   317,   317,   318,   318,   318,   319,
     319,   319,   320,   320,   321,   321,   321,   322,   322,   322,
     322,   322,   322,   322,   322,   322,   322,   322,   322,   322,
     322,   322,   322,   322,   322,   322,   322,   322,   322,   322,
     322,   323,   323,   324,   325,   325,   326,   327,   327
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     0,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     4,     5,     5,     4,     4,
       5,     1,     3,     0,     4,     4,     4,     4,     4,     2,
       0,     7,     5,     0,     2,     0,     3,     0,     5,     3,
       0,     4,     4,     4,     4,     4,     4,     1,     4,     4,
       3,     0,     1,     1,     1,     1,     1,     1,     3,     4,
       4,     0,     3,     0,     3,     4,     1,     4,     4,     0,
       5,     0,     5,     0,     5,     0,     5,     0,     3,     0,
       3,     2,     0,     4,     4,     4,     4,     1,     1,     1,
       0,     2,     2,     0,     1,     4,     4,     4,     4,     1,
       1,     0,     2,     2,     0,     1,     0,     5,     1,     4,
       4,     0,     5,     0,     2,     2,     0,     1,     4,     4,
       4,     4,     0,     5,     1,     4,     0,     3,     1,     4,
       1,     0,     3,     2,     0,     1,     4,     1,     2,     0,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     2,     0,     3,     0,     1,     1,     1,
       1,     1,     1,     1,     4,     0,     3,     2,     0,     1,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     0,     3,     2,     0,     1,     4,     4,     4,
       4,     4,     0,     5,     0,     5,     0,     5,     0,     5,
       0,     3,     0,     3,     2,     0,     1,     1,     1,     0,
       3,     2,     0,     4,     4,     4,     4,     1,     1,     1,
       1,     4,     0,     3,     2,     0,     1,     0,     5,     4,
       4,     0,     3,     2,     0,     1,     4,     4,     4,     4,
       4,     0,     5,     4,     4,     0,     3,     4,     0,     2,
       2,     0,     1,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     1,
       2,     0,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     2,     0,     3,     0,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     2,
       0,     1,     4,     4,     4,     4,     4,     4,     4,     1,
       1,     2,     3,     3,     3,     4,     4,     4,     4,     4,
       4,     0,     6,     0,     6,     0,     6,     0,     6,     0,
       6,     2,     0,     1,     4,     2,     0,     4,     4,     2,
       0,     2,     1,     2,     1,     3,     1,     0,     5,     0,
       5,     2,     0,     4,     1,     4,     4,     2,     0,     1,
       4,     4,     4,     4,     4,     2,     0,     1,     2,     0,
       0,     8,     0,     7,     2,     0,     4,     4,     4,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     0,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     2,     0,   427,   429,   448,   447,   430,   437,   431,
     432,   433,   434,   443,   441,   442,   444,   445,   449,   450,
     446,   435,   440,   436,   428,   438,   439,   424,   425,     6,
       0,   426,     9,     0,    10,     0,     7,     0,    23,     8,
     296,    13,    14,    21,    12,    37,    11,     0,     1,     3,
      51,     0,     0,   166,     0,     0,     0,     0,     0,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     5,     0,     0,
       0,     0,     0,    71,    69,    75,    73,     0,     0,   111,
     128,   130,     0,     0,    52,    53,    54,    55,    57,    56,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   350,     0,     0,     0,     0,     0,     0,
       0,   204,   202,   208,   206,     0,     0,     0,     0,     0,
       0,   167,   168,   169,   172,   170,   171,   173,     0,     0,
       0,     0,     0,     0,    33,    30,    23,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
     296,    40,     0,     0,     0,   407,   409,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      15,    51,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   351,     0,     0,     0,     0,   387,   389,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     258,     0,    19,   166,     0,     0,     0,     0,     0,    23,
       0,     0,    29,    22,     0,     0,     0,     0,     0,     0,
       0,     0,   419,   420,   421,     0,     0,     0,     0,     0,
       0,   423,   422,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   452,   451,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   295,     0,     0,     0,     0,     0,     0,
      18,   408,    58,     0,    61,     0,    63,     0,    79,     0,
      77,   101,    90,   101,    90,     0,   131,     0,   126,   113,
      50,   369,     0,   361,   458,     0,     0,   457,   382,     0,
     384,   456,   386,   363,   365,   367,     0,   455,     0,   453,
     354,   352,   353,    16,   398,   392,    17,     0,   175,     0,
     192,     0,   212,     0,   210,     0,     0,     0,     0,     0,
       0,   255,     0,   261,     0,   241,   165,    24,    25,    26,
      28,    27,    30,    35,    20,   297,   298,   299,   300,   301,
     316,   334,   335,   302,   303,   304,   305,   306,   317,   309,
     308,   329,   330,   331,   332,   333,   318,   319,   313,   315,
     314,   336,   337,   338,   310,   311,   312,   322,   323,   324,
     325,   326,   327,   328,   307,   321,   320,     0,     0,    38,
      40,   412,     0,    59,   139,    60,   139,    68,    82,    67,
      82,     0,   104,     0,    93,     0,     0,   129,   134,   125,
     139,     0,   116,   376,   358,   376,   356,   355,   381,   357,
     383,     0,   376,   372,   376,   359,   454,   360,     0,     0,
       0,     0,     0,     0,     0,   399,   394,     0,   398,     0,
       0,   392,   174,   178,   191,   195,   201,   215,   200,   215,
       0,   232,     0,   219,     0,     0,   253,   254,   281,   257,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   262,   279,   259,   261,
     240,   244,    33,     0,    35,     0,     0,    39,   415,   410,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    62,   139,     0,    64,    66,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    89,    80,    82,
      87,    88,    78,    72,   106,     0,     0,     0,     0,     0,
       0,    47,   100,   105,   102,   104,   108,    99,    70,    91,
      93,    94,    76,    74,     0,   135,   137,   132,   134,   127,
     112,     0,   122,   117,   124,   114,   116,     0,     0,     0,
     376,     0,   385,     0,     0,     0,   372,   373,     0,   455,
       0,     0,     0,     0,   406,     0,   388,   397,     0,   390,
     391,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   176,   178,   179,     0,     0,     0,   193,
     195,   196,   213,   211,   205,   235,   203,   222,   209,   207,
     256,   281,     0,   455,   455,   455,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   260,   242,
       0,     0,    34,    41,    42,     0,     0,     0,     0,   415,
     415,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
       0,     0,   455,   138,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,     0,     0,     0,     0,
       0,     0,     0,   103,    92,     0,   133,     0,     0,   115,
       0,   380,   370,   375,   362,   364,     0,   366,   371,   368,
       0,     0,     0,     0,     0,     0,   406,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   294,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   177,     0,     0,     0,   194,     0,   218,   214,   217,
     216,   233,   220,   280,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   251,     0,     0,     0,     0,     0,   227,   245,   229,
     243,   228,     0,    32,     0,   380,     0,     0,   414,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   340,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   340,     0,     0,
     380,     0,   395,   401,   402,   403,   404,   400,   405,   396,
     393,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     294,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   237,   236,
     234,     0,   230,   221,   263,   270,   271,   272,   267,   268,
     266,   269,   278,   275,   273,   274,   276,   277,   265,   264,
       0,     0,     0,     0,     0,     0,     0,    31,     0,     0,
       0,   413,     0,   159,   153,   141,   142,   143,   151,   158,
     145,   144,   146,   154,   140,   149,   147,   148,   152,   163,
     155,   150,   157,   156,   162,   161,   160,    65,    86,    83,
      84,    85,   109,   110,    45,    43,    44,    46,     0,     0,
       0,     0,     0,     0,     0,   341,   349,     0,   340,    95,
      96,    97,    98,    48,    49,   136,   119,   120,   121,   118,
       0,   377,   378,   379,   374,   189,   284,   286,   285,   290,
     291,   283,   292,   282,   293,   289,   190,   180,   187,   181,
     182,   183,   184,   185,   186,   287,   288,   188,   197,   198,
     199,     0,     0,     0,     0,     0,     0,     0,   340,     0,
       0,     0,     0,     0,   417,   418,   416,   411,     0,     0,
       0,     0,     0,   455,   455,   107,   339,   123,   239,   340,
       0,   247,   248,   249,   246,     0,   223,   224,   225,   226,
     250,     0,     0,     0,     0,     0,     0,     0,     0,   231,
     252,   342,   343,   344,   345,   346,   347,   348,   238
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    10,    11,   117,    12,    39,    42,    44,    56,    46,
      49,    52,    69,    70,   184,   185,   291,   563,    51,    54,
     115,   346,   347,   621,   622,   132,   133,   134,   135,   353,
     474,   355,   476,   595,   136,   244,   243,   246,   245,   359,
     480,   357,   478,   608,   609,   483,   484,   629,   630,   623,
     481,   482,   624,   625,   776,   610,   137,   249,   491,   492,
     645,   646,   788,   138,   367,   490,   139,   365,   488,   637,
     638,   592,   627,   895,   169,   170,   171,   397,   523,   693,
     694,   172,   399,   525,   699,   700,   173,   275,   274,   277,
     276,   403,   529,   401,   527,   702,   838,   532,   707,   842,
     868,   973,   530,   705,   841,   970,  1092,   869,   174,   414,
     561,   729,   870,   991,   175,   176,   410,   538,   177,   412,
     413,   558,   559,   710,   871,   949,   113,   114,  1047,  1048,
     152,   153,   495,   502,   503,   504,   493,   655,   656,   649,
     650,   929,   376,   379,   380,   156,   394,   395,   520,   521,
     515,   516,   517,   518,   805,   234,   235,   236,   740,   568,
     738,   739,   312,   313,   333,    41,   334,   388,   389,   382,
     378
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -912
static const yytype_int16 yypact[] =
{
      85,  1049,  1049,  1049,  1049,  -102,   -85,  1049,  1049,  1049,
      71,  -912,   -70,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
     -66,  -912,  -912,   -53,  -912,   -51,  -912,   -42,    58,  -912,
    1158,  -912,  -912,  -912,  -912,  -912,  -912,   -34,  -912,  -912,
      62,    44,   -63,   505,   -25,   -24,   -23,   -22,   -21,   128,
     -14,   -13,   -12,   -11,   -10,    -9,    -8,    -6,    -4,    -2,
       3,     6,     9,    27,    31,    33,    41,    42,    46,    60,
      63,    64,    65,    66,    67,    68,    69,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    87,    90,    93,    94,
      95,   107,   108,     0,    22,   111,   -47,    85,   112,   113,
     118,   121,   126,  -912,  -912,  -912,  -912,   127,   129,  -912,
    -912,  -912,   133,   114,  -912,  -912,  -912,  -912,  -912,  -912,
     134,   135,   152,   154,   155,   156,   157,   158,   159,   160,
      44,    44,   -95,  -912,   161,   168,   136,   169,   170,   173,
     175,  -912,  -912,  -912,  -912,   176,   177,   178,   179,   182,
     187,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  1049,  1049,
    1049,  1049,  1049,   190,    59,   128,    58,   199,   200,   203,
     206,   209,   212,  1049,  1049,   -65,   -65,   -65,   -65,  1049,
     -65,   -26,   -65,   -65,   214,   216,   227,  1049,  1049,   230,
     232,   234,   235,  1049,  1049,  1049,   236,   237,   238,   -65,
     888,   888,   239,   888,   888,   241,   -65,   242,   243,  -912,
    1158,    -3,   254,   255,   240,  -912,   -47,  -912,   252,  1049,
    1049,  1049,  1049,   257,   259,   261,   264,  1049,  1049,   265,
    -912,    62,  1049,  1049,  1049,   805,  1049,  1049,  1049,  1049,
    1049,  1049,  -912,   -44,    44,    44,   267,  -912,  -912,   271,
    1049,  1049,  1049,  1049,   272,   273,   274,   275,  1049,  1049,
    -912,  1049,  -912,   505,   281,   282,   283,   289,   291,    58,
     293,   295,  -912,  -912,   294,   296,   297,   298,   304,   305,
     306,   307,  -912,  -912,  -912,   309,   311,   312,   313,   314,
     316,  -912,  -912,   318,   320,   321,   322,   325,   327,   328,
     329,   330,   331,   334,   337,   338,   339,   340,   342,   355,
     358,   359,  -912,  -912,   369,   370,   373,   374,   375,   376,
     379,   387,   388,  -912,   390,   392,   394,   244,  1049,  1049,
    -912,  -912,  -912,   393,  -912,   395,  -912,   396,  -912,   398,
    -912,  -912,  -912,  -912,  -912,   399,  -912,   401,  -912,  -912,
    -912,  -912,   420,  -912,  -912,   421,   425,  -912,   971,   426,
    1049,  -912,     8,  -912,  -912,  -912,   427,  1049,   429,  -912,
    -912,   247,  -912,  -912,   192,   380,  -912,   434,  -912,   435,
    -912,   436,  -912,   437,  -912,  1049,  1049,  1049,  1049,   438,
     439,  -912,   440,   542,   441,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,   128,  1049,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  1049,   -65,  -912,
      -3,  -912,  1049,  -912,   623,  -912,   800,  -912,  1390,  -912,
    1390,   442,  1310,   443,  1469,   444,   445,  -912,    30,  -912,
     623,   446,  1230,    21,  -912,    21,  -912,  -912,  -912,  -912,
    -912,  1049,    21,    19,    21,  -912,  -912,  -912,   448,   449,
     450,   451,   455,   456,   457,  -912,  -912,   458,   192,   460,
     461,   380,  -912,  1608,  -912,  1091,  -912,  -912,  -912,  -912,
     462,  -912,   463,  -912,   464,   465,  -912,  -912,   256,  -912,
     467,   468,   470,   472,   473,   477,   482,   483,   484,   487,
     488,   490,   491,   492,   493,   494,  -912,  -912,  -912,   542,
    -912,  -912,    59,   495,  1049,   496,   498,  -912,    28,  -912,
     501,   502,   511,   513,   515,   516,   521,   526,   527,   528,
     531,   532,   533,   534,   535,   541,   543,   544,   545,   546,
     547,   548,  -912,   623,   549,  -912,  -912,   553,   554,   555,
     565,   566,   567,   574,   575,   576,   577,  -912,  -912,  1390,
    -912,  -912,  -912,  -912,  -912,   578,   579,   580,   581,   582,
     583,  -912,  -912,  -912,  -912,  1310,  -912,  -912,  -912,  -912,
    1469,  -912,  -912,  -912,   584,  -912,  -912,  -912,    30,  -912,
    -912,   586,  -912,  -912,  -912,  -912,  1230,   587,   588,   589,
      21,   590,  -912,   591,   593,   595,    19,  -912,   600,  1049,
    1049,  1049,  1049,  1049,  1049,  1049,  -912,  -912,  1049,  -912,
    -912,   594,   603,   607,   608,   609,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   624,   625,   626,
     628,   630,   632,  -912,  1608,  -912,   633,   636,   637,  -912,
    1091,  -912,  1549,  1549,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,   256,  1049,  1049,  1049,  1049,  1049,  1049,  1049,  1049,
    1049,   246,   280,   400,  1049,  1049,   888,  1049,  -912,   253,
     459,   299,  -912,  -912,  -912,   638,   639,   641,   622,    28,
      28,  1049,   404,   -65,   -65,   -65,   -65,   -65,   -26,   -65,
     -65,   504,   551,  1049,  1049,  1049,  1049,   598,  1049,   -33,
     971,  1049,  1049,  -912,   -65,   -65,   888,   888,   651,   -65,
     652,   -65,   653,   654,   -65,  -912,   649,  1049,  1049,   888,
     888,   660,   661,  -912,  -912,  1049,  -912,   270,   658,  -912,
    1049,  1049,  -912,  -912,  -912,  -912,  1049,  -912,  -912,  -912,
     659,   663,   664,   665,   666,   667,  1049,   668,   669,   -65,
     662,   680,   685,  1049,   687,   688,   689,  1049,  1049,  1049,
     -65,   -65,   888,   888,   690,   888,   888,   698,  1049,   -65,
     699,  -912,   888,   888,   701,  -912,   693,  -912,  -912,  -912,
    -912,  1524,   391,  -912,   697,   702,   703,   704,   705,   706,
     707,   708,   709,   710,   711,   722,   723,   724,   725,   731,
     733,  -912,   734,   735,   736,   739,   741,  -912,  -912,  -912,
    -912,  -912,   657,  -912,  1049,  1049,  1049,   746,  -912,   743,
     744,   745,   747,   750,   751,   758,   759,   760,   761,   762,
     763,   769,   772,   775,   776,   783,  1049,   784,   785,   786,
     787,   788,   789,   790,   791,   792,   796,   798,   799,   801,
     802,   806,   807,   808,   809,    48,   810,   811,   814,   815,
     816,   817,   818,   819,   821,   822,   823,    48,   825,   826,
    1049,   827,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,   828,   829,   830,   831,   832,   834,   841,   842,   843,
    1049,   844,   845,   846,   854,   855,   856,   858,   859,   866,
     867,   868,   869,   870,   871,   872,   873,   -65,  -912,  -912,
    -912,   875,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
     408,   876,  1049,   888,   888,   888,   -65,  -912,   879,   881,
     882,  -912,   804,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,   877,   884,
     885,   886,   889,   890,   891,  -912,  -912,   892,    48,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
     893,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,   894,   898,   -65,   899,   900,   901,   903,    48,   904,
     905,   906,   907,   908,  -912,  -912,  -912,  -912,  1049,  1049,
    1049,  1049,  1049,  1049,  1049,  -912,  -912,  -912,  -912,    48,
     909,  -912,  -912,  -912,  -912,   910,  -912,  -912,  -912,  -912,
    -912,   911,   912,   913,   914,   915,   921,   922,   923,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -912,  -912,   276,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -153,  -912,  -161,  -912,  -172,    52,  -912,  -912,
    -912,   -59,  -912,  -459,  -702,   835,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -454,  -912,   597,  -912,   417,  -912,  -470,
     717,  -912,   466,  -912,  -912,  -462,  -912,  -912,  -912,  -912,
     447,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,   452,
    -912,  -437,  -434,   193,   812,  -912,  -912,  -912,  -912,   403,
    -912,  -912,  -912,  -912,   405,  -912,  -912,  -912,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,   559,  -912,   684,  -912,  -912,
    -726,  -912,   691,  -912,  -912,  -912,  -912,  -585,  -912,  -912,
    -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,  -912,
    -912,   556,  -912,   383,  -500,   164,   887,  -912,  -911,  -912,
     -55,  -912,  -912,  -912,  -912,  -912,  -912,   469,  -912,  -467,
    -494,  -826,   728,   738,  -912,  -912,  -912,  -912,   601,  -912,
    -912,  -912,   605,  -912,   326,  -912,   895,  -912,  -912,  -912,
    -618,  -912,  -185,   378,    -1,  -912,  -192,  -655,   737,  -496,
     367
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint16 yytable[] =
{
      40,    43,    45,    47,   800,   652,    53,    55,    57,   657,
     305,   306,   307,   308,   631,   310,  1060,   314,   315,   607,
     626,   607,   643,   695,   292,   701,   612,   867,   651,   335,
     644,   337,   338,   293,   331,   653,   311,   658,   711,   596,
     593,   340,   593,   647,   611,   647,   611,   140,   141,   999,
     634,    48,   735,   639,   264,   265,   593,   266,   845,   846,
     847,    64,    65,    66,    67,   154,   142,   155,    50,   302,
     303,    58,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   304,    59,   127,   128,   232,   233,    60,     1,     2,
       3,     4,     5,     6,     7,   262,   263,   344,   345,   129,
      61,   648,    62,   648,  1063,   264,   265,   903,   302,   303,
     736,    63,   390,   899,   900,   969,   972,   839,   839,   116,
     304,   878,   879,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
     178,   179,   180,   181,   182,   183,   422,  1116,   186,   867,
     867,   290,   187,   188,   189,   190,   191,   192,   654,   193,
     607,   194,   501,   195,   229,   775,   763,   737,   196,   593,
     631,   197,   657,   626,   198,   143,   144,   145,   146,   147,
     148,   149,   635,   636,   230,   611,   643,   284,   285,   286,
     287,   288,   199,   793,   644,     8,   200,  1125,   201,    68,
    1045,  1046,   300,   301,   695,   150,   202,   203,   309,   151,
     701,   204,   840,   840,   130,   131,   319,   320,  1138,   391,
     392,   711,   325,   326,   327,   205,     9,   508,   206,   207,
     208,   209,   210,   211,   212,   509,   510,   511,   512,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   354,   356,
     358,   360,   222,   837,   837,   223,   366,   368,   224,   225,
     226,   371,   372,   373,   377,   381,   383,   384,   385,   386,
     387,   562,   227,   228,   231,   902,   251,   238,   239,   398,
     400,   402,   404,   240,   513,    13,   241,   409,   411,    14,
     415,   242,   247,   566,   248,   923,   924,   250,   269,   252,
     253,   860,   514,    15,    16,    17,   672,   673,   674,   672,
     673,   674,    18,    19,    20,    21,    22,   254,    23,   255,
     256,   257,   258,   259,   260,   261,   267,   675,   676,   677,
     675,   676,   677,   268,   270,   271,   678,   861,   272,   678,
     273,   278,   279,   280,   281,   679,   282,   680,   679,   283,
     680,    24,    25,   289,   925,   294,   295,   471,   472,   296,
      26,    27,   297,   690,   691,   298,   690,   691,   299,   836,
     316,   862,   317,   863,   864,   865,   619,   603,   620,   604,
     605,   606,   866,   318,    28,    29,   321,   377,   322,   381,
     323,   324,   328,   329,   330,   336,   387,   339,   341,   342,
     730,   519,   853,   237,   350,    30,   470,   265,    31,    32,
      33,    34,    35,    36,   531,   533,   531,   533,   352,   348,
     349,   567,   361,    13,   362,    37,   363,    14,    38,   364,
     369,   393,   564,  1094,  1095,   396,   854,   405,   406,   407,
     408,    15,    16,    17,   672,   673,   674,   417,   418,   419,
      18,    19,    20,    21,    22,   420,    23,   421,   423,   424,
     425,   873,   426,   427,   428,   675,   676,   677,  1136,  1137,
     429,   430,   431,   432,   678,   433,   565,   434,   435,   436,
     437,   569,   438,   679,   439,   680,   440,   441,   442,    24,
      25,   443,  1096,   444,   445,   446,   447,   448,    26,    27,
     449,   690,   691,   450,   451,   452,   453,   836,   454,   862,
     381,   863,   864,   865,   619,   603,   620,   604,   605,   606,
     971,   455,    28,    29,   456,   457,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   458,   459,   166,   167,   460,
     461,   462,   463,    30,   858,   464,    31,    32,    33,    34,
      35,    36,   168,   465,   466,   467,   855,   468,   469,   473,
     881,   475,   477,    37,   479,   487,    38,   489,   882,   883,
     884,   885,   886,   564,   888,   889,   540,   541,   542,   543,
     544,   545,   546,   547,   906,   907,   494,   496,   548,   904,
     905,   497,   499,   505,   909,   507,   911,   918,   919,   914,
     522,   524,   526,   528,   536,   537,   539,   560,   613,   628,
     632,   633,   640,   659,   660,   661,   662,   549,   550,   551,
     663,   664,   665,   872,   666,   668,   732,   669,   704,   706,
     708,   709,   712,   713,   941,   714,   552,   715,   716,   553,
     955,   956,   717,   958,   959,   953,   954,   718,   719,   720,
     964,   965,   721,   722,   962,   723,   724,   725,   726,   727,
     890,   731,   733,   554,   734,   570,   741,   742,   387,   801,
     802,   803,   804,   806,   807,   555,   743,   808,   744,   571,
     745,   746,   572,   573,   574,   575,   747,   576,   577,   578,
     579,   748,   749,   750,   556,   557,   751,   752,   753,   754,
     755,   580,   581,   582,   583,   584,   756,   891,   757,   758,
     759,   760,   761,   762,   764,   585,   586,   587,   765,   766,
     767,   844,   387,   387,   387,   848,   849,   850,   851,   852,
     768,   769,   770,   856,   857,   588,   859,   589,   590,   771,
     772,   773,   774,   777,   778,   779,   780,   781,   782,   785,
     880,   787,   790,   791,   897,   792,   794,   795,   796,   809,
     591,   797,   892,   893,   894,   896,   799,   898,   810,   377,
     381,   387,   811,   812,   813,   814,   815,   816,   817,   818,
     819,   820,   821,   822,   823,   824,   916,   917,   877,   825,
     826,   827,  1091,   828,   922,   829,   926,   830,   832,   928,
     930,   833,   834,   874,   875,   931,   876,   908,   910,   912,
     913,  1100,  1101,  1102,   915,   806,   920,   921,   942,   997,
      13,  1103,   945,   927,    14,   932,   950,   951,   952,   933,
     934,   935,   936,   937,   939,   940,   943,   961,    15,    16,
      17,   944,   570,   946,   947,   948,   957,    18,    19,    20,
      21,    22,   374,    23,   960,   963,   571,   966,   967,   572,
     573,   574,   575,   974,   576,   577,   578,   579,   975,   976,
     977,   978,   979,   980,   981,   982,   983,   984,   580,   581,
     582,   583,   584,   998,   930,  1000,    24,    25,   985,   986,
     987,   988,   585,   586,   587,    26,    27,   989,   990,   992,
     993,   994,   594,    13,   995,   896,   996,    14,  1001,  1002,
    1003,  1004,   588,  1005,   589,   590,  1006,  1007,  1120,    28,
      29,    15,    16,    17,  1008,  1009,  1010,  1011,  1012,  1013,
      18,    19,    20,    21,    22,  1014,    23,   591,  1015,   930,
      30,  1016,  1017,    31,    32,    33,    34,    35,    36,  1018,
    1020,  1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,   950,
      37,   375,  1029,    38,  1030,  1031,  1107,  1032,  1033,    24,
      25,   486,  1034,  1035,  1036,  1037,  1049,  1050,    26,    27,
    1051,  1052,  1053,  1054,  1055,  1056,    13,  1057,  1058,  1059,
      14,  1061,  1062,  1064,  1065,  1066,  1067,  1068,  1069,  1097,
    1070,  1099,    28,    29,    15,    16,    17,  1071,  1072,  1073,
    1075,  1076,  1077,    18,    19,    20,    21,    22,   374,    23,
    1078,  1079,  1080,    30,  1081,  1082,    31,    32,    33,    34,
      35,    36,  1083,  1084,  1085,  1086,  1087,  1088,  1089,  1090,
    1093,  1098,  1108,    37,   332,  1104,    38,  1105,  1106,  1109,
    1110,  1111,    24,    25,  1112,  1113,  1114,   784,  1115,  1117,
    1118,    26,    27,  1119,    13,  1121,  1122,  1123,    14,  1124,
    1126,  1127,  1128,  1129,  1130,  1139,  1140,  1141,  1142,  1143,
    1144,  1145,    15,    16,    17,    28,    29,  1146,  1147,  1148,
     485,    18,    19,    20,    21,    22,   370,    23,   703,  1019,
     786,   783,   535,   789,   843,   416,    30,   831,   534,    31,
      32,    33,    34,    35,    36,   835,   498,  1131,  1132,  1133,
    1134,  1135,   387,   387,  1074,   728,    37,   343,   500,    38,
      24,    25,   670,   667,   506,   798,   887,   901,     0,    26,
      27,   351,   938,     0,   672,   673,   674,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    28,    29,   675,   676,   677,     0,     0,
       0,     0,     0,     0,   678,     0,     0,     0,     0,     0,
       0,     0,     0,   679,    30,   680,     0,    31,    32,    33,
      34,    35,    36,     0,     0,   696,   697,   698,     0,     0,
       0,   690,   691,     0,    37,     0,     0,    38,    71,    72,
      73,    74,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
       0,     0,    92,    93,    94,     0,    95,    96,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    97,    98,    99,   100,   101,   102,     0,
       0,   103,   104,   105,   106,   107,   108,   109,     0,     0,
       0,     0,   570,     0,     0,     0,     0,     0,   641,     0,
       0,     0,     0,     0,     0,     0,   571,     0,   110,   572,
     573,   574,   575,     0,   576,   577,   578,   579,     0,     0,
       0,     0,     0,     0,   111,   112,     0,     0,   580,   581,
     582,   583,   584,     0,   642,     0,     0,     0,     0,     0,
       0,     0,   585,   586,   587,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   588,     0,   589,   590,   601,   602,   615,   616,
     617,   618,   570,   619,   603,   620,   604,   605,   606,     0,
       0,     0,     0,     0,     0,     0,   571,   591,     0,   572,
     573,   574,   575,     0,   576,   577,   578,   579,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   580,   581,
     582,   583,   584,     0,   614,     0,     0,     0,     0,     0,
       0,     0,   585,   586,   587,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   588,     0,   589,   590,   601,   602,   615,   616,
     617,   618,   570,   619,   603,   620,   604,   605,   606,     0,
       0,     0,     0,     0,     0,     0,   571,   591,     0,   572,
     573,   574,   575,     0,   576,   577,   578,   579,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   580,   581,
     582,   583,   584,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   585,   586,   587,     0,     0,     0,     0,     0,
       0,     0,   597,     0,   598,   599,   600,     0,     0,     0,
       0,     0,   588,     0,   589,   590,   601,   602,     0,     0,
       0,   570,     0,     0,   603,     0,   604,   605,   606,     0,
       0,     0,     0,     0,     0,   571,     0,   591,   572,   573,
     574,   575,     0,   576,   577,   578,   579,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   580,   581,   582,
     583,   584,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   585,   586,   587,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   672,   673,   674,
       0,   588,     0,   589,   590,     0,     0,   615,   616,   617,
     618,     0,   619,   603,   620,   604,   605,   606,   675,   676,
     677,     0,   672,   673,   674,     0,   591,   678,   968,     0,
       0,     0,     0,     0,     0,     0,   679,     0,   680,     0,
       0,     0,     0,   675,   676,   677,     0,     0,     0,     0,
       0,     0,   678,     0,   690,   691,     0,     0,     0,     0,
     836,   679,   862,   680,   863,   864,   865,   619,   603,   620,
     604,   605,   606,     0,     0,     0,     0,   671,     0,   690,
     691,   672,   673,   674,     0,   836,     0,     0,     0,     0,
       0,     0,     0,   603,     0,   604,   605,   606,     0,     0,
       0,     0,   675,   676,   677,     0,     0,     0,     0,     0,
       0,   678,     0,     0,     0,     0,     0,     0,     0,     0,
     679,     0,   680,     0,     0,   681,     0,     0,     0,     0,
     682,   683,   684,   685,   686,   687,   688,   689,   690,   691,
       0,   692
};

static const yytype_int16 yycheck[] =
{
       1,     2,     3,     4,   659,   501,     7,     8,     9,   503,
     195,   196,   197,   198,   484,   200,   927,   202,   203,   478,
     482,   480,   492,   523,   185,   525,   480,   729,   495,   221,
     492,   223,   224,   186,   219,   502,    62,   504,   538,   476,
     474,   226,   476,    24,   478,    24,   480,     3,     4,   875,
      20,   153,    24,   490,   149,   150,   490,   152,   713,   714,
     715,     3,     4,     5,     6,   128,    22,   130,   153,   134,
     135,     0,    10,    11,    12,    13,    14,    15,    16,    17,
      18,   146,   152,    21,    22,   132,   133,   153,     3,     4,
       5,     6,     7,     8,     9,   150,   151,   100,   101,    37,
     153,    82,   153,    82,   930,   149,   150,   762,   134,   135,
      82,   153,   156,   146,   147,   841,   842,   702,   703,   153,
     146,   739,   740,    75,    76,    77,    78,    79,    80,    81,
     155,   155,   155,   155,   155,     7,   289,  1048,   152,   841,
     842,    82,   155,   155,   155,   155,   155,   155,   129,   155,
     609,   155,   144,   155,   154,   609,   593,   129,   155,   593,
     630,   155,   656,   625,   155,   121,   122,   123,   124,   125,
     126,   127,   142,   143,   152,   609,   646,   178,   179,   180,
     181,   182,   155,   650,   646,   100,   155,  1098,   155,   131,
     142,   143,   193,   194,   694,   151,   155,   155,   199,   155,
     700,   155,   702,   703,   142,   143,   207,   208,  1119,   264,
     265,   711,   213,   214,   215,   155,   131,    25,   155,   155,
     155,   155,   155,   155,   155,    33,    34,    35,    36,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   239,   240,
     241,   242,   155,   702,   703,   155,   247,   248,   155,   155,
     155,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   422,   155,   155,   153,   761,   152,   155,   155,   270,
     271,   272,   273,   155,    82,     5,   155,   278,   279,     9,
     281,   155,   155,   468,   155,    15,    16,   154,   152,   155,
     155,    38,   100,    23,    24,    25,    43,    44,    45,    43,
      44,    45,    32,    33,    34,    35,    36,   155,    38,   155,
     155,   155,   155,   155,   155,   155,   155,    64,    65,    66,
      64,    65,    66,   155,   155,   155,    73,    74,   155,    73,
     155,   155,   155,   155,   155,    82,   154,    84,    82,   152,
      84,    71,    72,   153,    74,   146,   146,   348,   349,   146,
      80,    81,   146,   100,   101,   146,   100,   101,   146,   106,
     146,   108,   146,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   146,   104,   105,   146,   378,   146,   380,
     146,   146,   146,   146,   146,   146,   387,   146,   146,   146,
     562,    11,   146,   117,   154,   125,   152,   150,   128,   129,
     130,   131,   132,   133,   405,   406,   407,   408,   156,   155,
     155,   470,   155,     5,   155,   145,   155,     9,   148,   155,
     155,   154,   423,    15,    16,   154,   146,   155,   155,   155,
     155,    23,    24,    25,    43,    44,    45,   156,   156,   156,
      32,    33,    34,    35,    36,   156,    38,   156,   155,   154,
     156,   152,   156,   156,   156,    64,    65,    66,  1113,  1114,
     156,   156,   156,   156,    73,   156,   467,   156,   156,   156,
     156,   472,   156,    82,   156,    84,   156,   156,   156,    71,
      72,   156,    74,   156,   156,   156,   156,   156,    80,    81,
     156,   100,   101,   156,   156,   156,   156,   106,   156,   108,
     501,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   156,   104,   105,   156,   156,    11,    12,    13,    14,
      15,    16,    17,    18,    19,   156,   156,    22,    23,   156,
     156,   156,   156,   125,   726,   156,   128,   129,   130,   131,
     132,   133,    37,   156,   156,   155,   146,   155,   154,   156,
     146,   156,   156,   145,   156,   156,   148,   156,   743,   744,
     745,   746,   747,   564,   749,   750,    24,    25,    26,    27,
      28,    29,    30,    31,   766,   767,   156,   156,    36,   764,
     765,   156,   156,   156,   769,   156,   771,   779,   780,   774,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   155,   155,   155,   155,    65,    66,    67,
     155,   155,   155,   154,   156,   155,   564,   156,   156,   156,
     156,   156,   155,   155,   809,   155,    84,   155,   155,    87,
     822,   823,   155,   825,   826,   820,   821,   155,   155,   155,
     832,   833,   155,   155,   829,   155,   155,   155,   155,   155,
     146,   156,   156,   111,   156,    32,   155,   155,   659,   660,
     661,   662,   663,   664,   665,   123,   155,   668,   155,    46,
     155,   155,    49,    50,    51,    52,   155,    54,    55,    56,
      57,   155,   155,   155,   142,   143,   155,   155,   155,   155,
     155,    68,    69,    70,    71,    72,   155,   146,   155,   155,
     155,   155,   155,   155,   155,    82,    83,    84,   155,   155,
     155,   712,   713,   714,   715,   716,   717,   718,   719,   720,
     155,   155,   155,   724,   725,   102,   727,   104,   105,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     741,   155,   155,   155,   146,   156,   156,   156,   155,   155,
     127,   156,   753,   754,   755,   756,   156,   758,   155,   760,
     761,   762,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   777,   778,   156,   155,
     155,   155,   967,   155,   785,   155,   787,   155,   155,   790,
     791,   155,   155,   155,   155,   796,   155,   146,   146,   146,
     146,   993,   994,   995,   155,   806,   146,   146,   146,   152,
       5,   996,   813,   155,     9,   156,   817,   818,   819,   156,
     156,   156,   156,   156,   156,   156,   146,   828,    23,    24,
      25,   146,    32,   146,   146,   146,   146,    32,    33,    34,
      35,    36,    37,    38,   146,   146,    46,   146,   155,    49,
      50,    51,    52,   156,    54,    55,    56,    57,   156,   156,
     156,   156,   156,   156,   156,   156,   156,   156,    68,    69,
      70,    71,    72,   874,   875,   876,    71,    72,   156,   156,
     156,   156,    82,    83,    84,    80,    81,   156,   155,   155,
     155,   155,    92,     5,   155,   896,   155,     9,   152,   156,
     156,   156,   102,   156,   104,   105,   156,   156,  1093,   104,
     105,    23,    24,    25,   156,   156,   156,   156,   156,   156,
      32,    33,    34,    35,    36,   156,    38,   127,   156,   930,
     125,   156,   156,   128,   129,   130,   131,   132,   133,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   950,
     145,   146,   156,   148,   156,   156,   152,   156,   156,    71,
      72,   364,   156,   156,   156,   156,   156,   156,    80,    81,
     156,   156,   156,   156,   156,   156,     5,   156,   156,   156,
       9,   156,   156,   156,   156,   156,   156,   156,   156,   990,
     156,   992,   104,   105,    23,    24,    25,   156,   156,   156,
     156,   156,   156,    32,    33,    34,    35,    36,    37,    38,
     156,   156,   156,   125,   156,   156,   128,   129,   130,   131,
     132,   133,   156,   156,   156,   156,   156,   156,   156,   156,
     155,   155,   155,   145,   146,   156,   148,   156,   156,   155,
     155,   155,    71,    72,   155,   155,   155,   630,   156,   156,
     156,    80,    81,   155,     5,   156,   156,   156,     9,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   156,
     156,   156,    23,    24,    25,   104,   105,   156,   156,   156,
     363,    32,    33,    34,    35,    36,   251,    38,   529,   896,
     638,   625,   408,   646,   711,   283,   125,   694,   407,   128,
     129,   130,   131,   132,   133,   700,   378,  1108,  1109,  1110,
    1111,  1112,  1113,  1114,   950,   559,   145,   230,   380,   148,
      71,    72,   521,   518,   387,   656,   748,   760,    -1,    80,
      81,   236,   806,    -1,    43,    44,    45,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   104,   105,    64,    65,    66,    -1,    -1,
      -1,    -1,    -1,    -1,    73,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    82,   125,    84,    -1,   128,   129,   130,
     131,   132,   133,    -1,    -1,    94,    95,    96,    -1,    -1,
      -1,   100,   101,    -1,   145,    -1,    -1,   148,    40,    41,
      42,    43,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      -1,    -1,    64,    65,    66,    -1,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    85,    86,    87,    88,    89,    90,    -1,
      -1,    93,    94,    95,    96,    97,    98,    99,    -1,    -1,
      -1,    -1,    32,    -1,    -1,    -1,    -1,    -1,    38,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,   120,    49,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,    -1,    68,    69,
      70,    71,    72,    -1,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   102,    -1,   104,   105,   106,   107,   108,   109,
     110,   111,    32,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    46,   127,    -1,    49,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    -1,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   102,    -1,   104,   105,   106,   107,   108,   109,
     110,   111,    32,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    46,   127,    -1,    49,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    92,    -1,    94,    95,    96,    -1,    -1,    -1,
      -1,    -1,   102,    -1,   104,   105,   106,   107,    -1,    -1,
      -1,    32,    -1,    -1,   114,    -1,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,   127,    49,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    43,    44,    45,
      -1,   102,    -1,   104,   105,    -1,    -1,   108,   109,   110,
     111,    -1,   113,   114,   115,   116,   117,   118,    64,    65,
      66,    -1,    43,    44,    45,    -1,   127,    73,    74,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    82,    -1,    84,    -1,
      -1,    -1,    -1,    64,    65,    66,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    -1,   100,   101,    -1,    -1,    -1,    -1,
     106,    82,   108,    84,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    39,    -1,   100,
     101,    43,    44,    45,    -1,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   114,    -1,   116,   117,   118,    -1,    -1,
      -1,    -1,    64,    65,    66,    -1,    -1,    -1,    -1,    -1,
      -1,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
      -1,   103
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     3,     4,     5,     6,     7,     8,     9,   100,   131,
     158,   159,   161,     5,     9,    23,    24,    25,    32,    33,
      34,    35,    36,    38,    71,    72,    80,    81,   104,   105,
     125,   128,   129,   130,   131,   132,   133,   145,   148,   162,
     321,   322,   163,   321,   164,   321,   166,   321,   153,   167,
     153,   175,   168,   321,   176,   321,   165,   321,     0,   152,
     153,   153,   153,   153,     3,     4,     5,     6,   131,   169,
     170,    40,    41,    42,    43,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    64,    65,    66,    68,    69,    85,    86,    87,
      88,    89,    90,    93,    94,    95,    96,    97,    98,    99,
     120,   136,   137,   283,   284,   177,   153,   160,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    21,    22,    37,
     142,   143,   182,   183,   184,   185,   191,   213,   220,   223,
       3,     4,    22,   121,   122,   123,   124,   125,   126,   127,
     151,   155,   287,   288,   128,   130,   302,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    22,    23,    37,   231,
     232,   233,   238,   243,   265,   271,   272,   275,   155,   155,
     155,   155,   155,     7,   171,   172,   152,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   154,
     152,   153,   132,   133,   312,   313,   314,   159,   155,   155,
     155,   155,   155,   193,   192,   195,   194,   155,   155,   214,
     154,   152,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   287,   287,   149,   150,   152,   155,   155,   152,
     155,   155,   155,   155,   245,   244,   247,   246,   155,   155,
     155,   155,   154,   152,   321,   321,   321,   321,   321,   153,
      82,   173,   171,   169,   146,   146,   146,   146,   146,   146,
     321,   321,   134,   135,   146,   319,   319,   319,   319,   321,
     319,    62,   319,   320,   319,   319,   146,   146,   146,   321,
     321,   146,   146,   146,   146,   321,   321,   321,   146,   146,
     146,   319,   146,   321,   323,   323,   146,   323,   323,   146,
     319,   146,   146,   283,   100,   101,   178,   179,   155,   155,
     154,   313,   156,   186,   321,   188,   321,   198,   321,   196,
     321,   155,   155,   155,   155,   224,   321,   221,   321,   155,
     182,   321,   321,   321,    37,   146,   299,   321,   327,   300,
     301,   321,   326,   321,   321,   321,   321,   321,   324,   325,
     156,   287,   287,   154,   303,   304,   154,   234,   321,   239,
     321,   250,   321,   248,   321,   155,   155,   155,   155,   321,
     273,   321,   276,   277,   266,   321,   231,   156,   156,   156,
     156,   156,   169,   155,   154,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   156,   155,   155,   154,
     152,   321,   321,   156,   187,   156,   189,   156,   199,   156,
     197,   207,   208,   202,   203,   207,   202,   156,   225,   156,
     222,   215,   216,   293,   156,   289,   156,   156,   299,   156,
     300,   144,   290,   291,   292,   156,   325,   156,    25,    33,
      34,    35,    36,    82,   100,   307,   308,   309,   310,    11,
     305,   306,   156,   235,   156,   240,   156,   251,   156,   249,
     259,   321,   254,   321,   259,   254,   156,   156,   274,   156,
      24,    25,    26,    27,    28,    29,    30,    31,    36,    65,
      66,    67,    84,    87,   111,   123,   142,   143,   278,   279,
     156,   267,   171,   174,   321,   321,   319,   178,   316,   321,
      32,    46,    49,    50,    51,    52,    54,    55,    56,    57,
      68,    69,    70,    71,    72,    82,    83,    84,   102,   104,
     105,   127,   228,   229,    92,   190,   228,    92,    94,    95,
      96,   106,   107,   114,   116,   117,   118,   180,   200,   201,
     212,   229,   200,   156,    74,   108,   109,   110,   111,   113,
     115,   180,   181,   206,   209,   210,   212,   229,   156,   204,
     205,   206,   156,   156,    20,   142,   143,   226,   227,   228,
     156,    38,    74,   206,   212,   217,   218,    24,    82,   296,
     297,   296,   326,   296,   129,   294,   295,   297,   296,   155,
     155,   155,   155,   155,   155,   155,   156,   309,   155,   156,
     305,    39,    43,    44,    45,    64,    65,    66,    73,    82,
      84,    87,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   103,   236,   237,   281,    94,    95,    96,   241,
     242,   281,   252,   252,   156,   260,   156,   255,   156,   156,
     280,   281,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   278,   268,
     173,   156,   174,   156,   156,    24,    82,   129,   317,   318,
     315,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   228,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   200,   211,   155,   155,   155,
     155,   155,   155,   209,   204,   155,   226,   155,   219,   217,
     155,   155,   156,   296,   156,   156,   155,   156,   294,   156,
     324,   321,   321,   321,   321,   311,   321,   321,   321,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   236,   155,   155,   155,   241,   106,   180,   253,   264,
     281,   261,   256,   280,   321,   324,   324,   324,   321,   321,
     321,   321,   321,   146,   146,   146,   321,   321,   323,   321,
      38,    74,   108,   110,   111,   112,   119,   181,   257,   264,
     269,   281,   154,   152,   155,   155,   155,   156,   317,   317,
     321,   146,   319,   319,   319,   319,   319,   320,   319,   319,
     146,   146,   321,   321,   321,   230,   321,   146,   321,   146,
     147,   327,   326,   324,   319,   319,   323,   323,   146,   319,
     146,   319,   146,   146,   319,   155,   321,   321,   323,   323,
     146,   146,   321,    15,    16,    74,   321,   155,   321,   298,
     321,   321,   156,   156,   156,   156,   156,   156,   311,   156,
     156,   319,   146,   146,   146,   321,   146,   146,   146,   282,
     321,   321,   321,   319,   319,   323,   323,   146,   323,   323,
     146,   321,   319,   146,   323,   323,   146,   155,    74,   257,
     262,   119,   257,   258,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   156,
     155,   270,   155,   155,   155,   155,   155,   152,   321,   298,
     321,   152,   156,   156,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   230,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   156,   156,    75,    76,
      77,    78,    79,    80,    81,   142,   143,   285,   286,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   156,
     285,   156,   156,   298,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   282,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   156,
     156,   319,   263,   155,    15,    16,    74,   321,   155,   321,
     323,   323,   323,   319,   156,   156,   156,   152,   155,   155,
     155,   155,   155,   155,   155,   156,   285,   156,   156,   155,
     319,   156,   156,   156,   156,   285,   156,   156,   156,   156,
     156,   321,   321,   321,   321,   321,   324,   324,   285,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{


    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:

/* Line 1455 of yacc.c  */
#line 322 "cfg-grammar.y"
    {
            if (last_include_file && !cfg_lex_process_include(last_include_file))
              {
                free(last_include_file);
                last_include_file = NULL;
                YYERROR;
              }
            if (last_include_file)
              {
                free(last_include_file);
                last_include_file = NULL;
              }
          }
    break;

  case 6:

/* Line 1455 of yacc.c  */
#line 340 "cfg-grammar.y"
    { cfg_add_source(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 7:

/* Line 1455 of yacc.c  */
#line 341 "cfg-grammar.y"
    { cfg_add_dest(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 8:

/* Line 1455 of yacc.c  */
#line 342 "cfg-grammar.y"
    { cfg_add_connection(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 9:

/* Line 1455 of yacc.c  */
#line 343 "cfg-grammar.y"
    { cfg_add_filter(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 10:

/* Line 1455 of yacc.c  */
#line 344 "cfg-grammar.y"
    { cfg_add_parser(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 11:

/* Line 1455 of yacc.c  */
#line 345 "cfg-grammar.y"
    { cfg_add_rewrite(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 12:

/* Line 1455 of yacc.c  */
#line 346 "cfg-grammar.y"
    { cfg_add_template(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 13:

/* Line 1455 of yacc.c  */
#line 347 "cfg-grammar.y"
    {  }
    break;

  case 14:

/* Line 1455 of yacc.c  */
#line 348 "cfg-grammar.y"
    {  }
    break;

  case 15:

/* Line 1455 of yacc.c  */
#line 352 "cfg-grammar.y"
    { (yyval.ptr) = log_source_group_new((yyvsp[(1) - (4)].cptr), (yyvsp[(3) - (4)].ptr)); free((yyvsp[(1) - (4)].cptr)); }
    break;

  case 16:

/* Line 1455 of yacc.c  */
#line 356 "cfg-grammar.y"
    { (yyval.ptr) = log_filter_rule_new((yyvsp[(1) - (5)].cptr), (yyvsp[(3) - (5)].node)); free((yyvsp[(1) - (5)].cptr)); }
    break;

  case 17:

/* Line 1455 of yacc.c  */
#line 360 "cfg-grammar.y"
    { (yyval.ptr) = log_parser_rule_new((yyvsp[(1) - (5)].cptr), (yyvsp[(3) - (5)].ptr)); free((yyvsp[(1) - (5)].cptr)); }
    break;

  case 18:

/* Line 1455 of yacc.c  */
#line 363 "cfg-grammar.y"
    { (yyval.ptr) = log_rewrite_rule_new((yyvsp[(1) - (4)].cptr), (yyvsp[(3) - (4)].ptr)); free((yyvsp[(1) - (4)].cptr)); }
    break;

  case 19:

/* Line 1455 of yacc.c  */
#line 366 "cfg-grammar.y"
    { (yyval.ptr) = log_dest_group_new((yyvsp[(1) - (4)].cptr), (yyvsp[(3) - (4)].ptr)); free((yyvsp[(1) - (4)].cptr)); }
    break;

  case 20:

/* Line 1455 of yacc.c  */
#line 370 "cfg-grammar.y"
    { LogPipeItem *pi = log_pipe_item_append_tail((yyvsp[(2) - (5)].ptr), (yyvsp[(3) - (5)].ptr)); (yyval.ptr) = log_connection_new(pi, (yyvsp[(4) - (5)].num)); }
    break;

  case 21:

/* Line 1455 of yacc.c  */
#line 374 "cfg-grammar.y"
    { last_include_file = (yyvsp[(1) - (1)].cptr); }
    break;

  case 22:

/* Line 1455 of yacc.c  */
#line 377 "cfg-grammar.y"
    { log_pipe_item_append((yyvsp[(1) - (3)].ptr), (yyvsp[(3) - (3)].ptr)); (yyval.ptr) = (yyvsp[(1) - (3)].ptr); }
    break;

  case 23:

/* Line 1455 of yacc.c  */
#line 378 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 24:

/* Line 1455 of yacc.c  */
#line 382 "cfg-grammar.y"
    { (yyval.ptr) = log_pipe_item_new(EP_SOURCE, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 25:

/* Line 1455 of yacc.c  */
#line 383 "cfg-grammar.y"
    { (yyval.ptr) = log_pipe_item_new(EP_FILTER, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 26:

/* Line 1455 of yacc.c  */
#line 384 "cfg-grammar.y"
    { (yyval.ptr) = log_pipe_item_new(EP_PARSER, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 27:

/* Line 1455 of yacc.c  */
#line 385 "cfg-grammar.y"
    { (yyval.ptr) = log_pipe_item_new(EP_REWRITE, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 28:

/* Line 1455 of yacc.c  */
#line 386 "cfg-grammar.y"
    { (yyval.ptr) = log_pipe_item_new(EP_DESTINATION, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 29:

/* Line 1455 of yacc.c  */
#line 390 "cfg-grammar.y"
    { log_pipe_item_append((yyvsp[(1) - (2)].ptr), (yyvsp[(2) - (2)].ptr)); (yyval.ptr) = (yyvsp[(1) - (2)].ptr); }
    break;

  case 30:

/* Line 1455 of yacc.c  */
#line 391 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 31:

/* Line 1455 of yacc.c  */
#line 395 "cfg-grammar.y"
    { LogPipeItem *pi = log_pipe_item_append_tail((yyvsp[(3) - (7)].ptr), (yyvsp[(4) - (7)].ptr)); (yyval.ptr) = log_pipe_item_new_ref(EP_PIPE, log_connection_new(pi, (yyvsp[(5) - (7)].num))); }
    break;

  case 32:

/* Line 1455 of yacc.c  */
#line 399 "cfg-grammar.y"
    { (yyval.num) = (yyvsp[(3) - (5)].num); }
    break;

  case 33:

/* Line 1455 of yacc.c  */
#line 400 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 34:

/* Line 1455 of yacc.c  */
#line 405 "cfg-grammar.y"
    { (yyval.num) = log_connection_lookup_flag((yyvsp[(1) - (2)].cptr)) | (yyvsp[(2) - (2)].num); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 35:

/* Line 1455 of yacc.c  */
#line 406 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 36:

/* Line 1455 of yacc.c  */
#line 411 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 37:

/* Line 1455 of yacc.c  */
#line 416 "cfg-grammar.y"
    {
	    last_template = log_template_new((yyvsp[(1) - (1)].cptr), NULL);
	    free((yyvsp[(1) - (1)].cptr));
	  }
    break;

  case 38:

/* Line 1455 of yacc.c  */
#line 420 "cfg-grammar.y"
    { (yyval.ptr) = last_template;  }
    break;

  case 41:

/* Line 1455 of yacc.c  */
#line 429 "cfg-grammar.y"
    { last_template->template = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); if (!cfg_check_template(last_template)) { YYERROR; } }
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 430 "cfg-grammar.y"
    { log_template_set_escape(last_template, (yyvsp[(3) - (4)].num)); }
    break;

  case 43:

/* Line 1455 of yacc.c  */
#line 434 "cfg-grammar.y"
    { last_sock_options->sndbuf = (yyvsp[(3) - (4)].num); }
    break;

  case 44:

/* Line 1455 of yacc.c  */
#line 435 "cfg-grammar.y"
    { last_sock_options->rcvbuf = (yyvsp[(3) - (4)].num); }
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 436 "cfg-grammar.y"
    { last_sock_options->broadcast = (yyvsp[(3) - (4)].num); }
    break;

  case 46:

/* Line 1455 of yacc.c  */
#line 437 "cfg-grammar.y"
    { last_sock_options->keepalive = (yyvsp[(3) - (4)].num); }
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 442 "cfg-grammar.y"
    { ((InetSocketOptions *) last_sock_options)->ttl = (yyvsp[(3) - (4)].num); }
    break;

  case 49:

/* Line 1455 of yacc.c  */
#line 443 "cfg-grammar.y"
    { ((InetSocketOptions *) last_sock_options)->tos = (yyvsp[(3) - (4)].num); }
    break;

  case 50:

/* Line 1455 of yacc.c  */
#line 447 "cfg-grammar.y"
    { if ((yyvsp[(1) - (3)].ptr)) {log_drv_append((yyvsp[(1) - (3)].ptr), (yyvsp[(3) - (3)].ptr)); log_drv_unref((yyvsp[(3) - (3)].ptr)); (yyval.ptr) = (yyvsp[(1) - (3)].ptr); } else { YYERROR; } }
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 448 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 52:

/* Line 1455 of yacc.c  */
#line 452 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 453 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 54:

/* Line 1455 of yacc.c  */
#line 454 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 55:

/* Line 1455 of yacc.c  */
#line 455 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 456 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 57:

/* Line 1455 of yacc.c  */
#line 457 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 58:

/* Line 1455 of yacc.c  */
#line 461 "cfg-grammar.y"
    { (yyval.ptr) = afinter_sd_new(); }
    break;

  case 59:

/* Line 1455 of yacc.c  */
#line 465 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 466 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 471 "cfg-grammar.y"
    {
	    last_driver = affile_sd_new((yyvsp[(1) - (1)].cptr), 0);
	    free((yyvsp[(1) - (1)].cptr));
	    last_reader_options = &((AFFileSourceDriver *) last_driver)->reader_options;
	  }
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 476 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 481 "cfg-grammar.y"
    {
	    last_driver = affile_sd_new((yyvsp[(1) - (1)].cptr), AFFILE_PIPE);
	    free((yyvsp[(1) - (1)].cptr));
	    last_reader_options = &((AFFileSourceDriver *) last_driver)->reader_options;
	  }
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 486 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 65:

/* Line 1455 of yacc.c  */
#line 490 "cfg-grammar.y"
    { last_driver->optional = (yyvsp[(3) - (4)].num); }
    break;

  case 66:

/* Line 1455 of yacc.c  */
#line 491 "cfg-grammar.y"
    {}
    break;

  case 67:

/* Line 1455 of yacc.c  */
#line 495 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 68:

/* Line 1455 of yacc.c  */
#line 496 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 69:

/* Line 1455 of yacc.c  */
#line 497 "cfg-grammar.y"
    { last_addr_family = AF_INET; }
    break;

  case 70:

/* Line 1455 of yacc.c  */
#line 497 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 71:

/* Line 1455 of yacc.c  */
#line 498 "cfg-grammar.y"
    { last_addr_family = AF_INET; }
    break;

  case 72:

/* Line 1455 of yacc.c  */
#line 498 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 73:

/* Line 1455 of yacc.c  */
#line 499 "cfg-grammar.y"
    { last_addr_family = AF_INET6; }
    break;

  case 74:

/* Line 1455 of yacc.c  */
#line 499 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 75:

/* Line 1455 of yacc.c  */
#line 500 "cfg-grammar.y"
    { last_addr_family = AF_INET6; }
    break;

  case 76:

/* Line 1455 of yacc.c  */
#line 500 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 77:

/* Line 1455 of yacc.c  */
#line 505 "cfg-grammar.y"
    {
	    last_driver = afunix_sd_new(
		(yyvsp[(1) - (1)].cptr),
		AFSOCKET_DGRAM | AFSOCKET_LOCAL);
	    free((yyvsp[(1) - (1)].cptr));
	    last_reader_options = &((AFSocketSourceDriver *) last_driver)->reader_options;
	    last_sock_options = &((AFUnixSourceDriver *) last_driver)->sock_options;
	  }
    break;

  case 78:

/* Line 1455 of yacc.c  */
#line 513 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 79:

/* Line 1455 of yacc.c  */
#line 518 "cfg-grammar.y"
    {
	    last_driver = afunix_sd_new(
		(yyvsp[(1) - (1)].cptr),
		AFSOCKET_STREAM | AFSOCKET_KEEP_ALIVE | AFSOCKET_LOCAL);
	    free((yyvsp[(1) - (1)].cptr));
	    last_reader_options = &((AFSocketSourceDriver *) last_driver)->reader_options;
	    last_sock_options = &((AFUnixSourceDriver *) last_driver)->sock_options;
	  }
    break;

  case 80:

/* Line 1455 of yacc.c  */
#line 526 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 83:

/* Line 1455 of yacc.c  */
#line 536 "cfg-grammar.y"
    { afunix_sd_set_uid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 84:

/* Line 1455 of yacc.c  */
#line 537 "cfg-grammar.y"
    { afunix_sd_set_gid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 85:

/* Line 1455 of yacc.c  */
#line 538 "cfg-grammar.y"
    { afunix_sd_set_perm(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 86:

/* Line 1455 of yacc.c  */
#line 539 "cfg-grammar.y"
    { last_driver->optional = (yyvsp[(3) - (4)].num); }
    break;

  case 87:

/* Line 1455 of yacc.c  */
#line 540 "cfg-grammar.y"
    {}
    break;

  case 88:

/* Line 1455 of yacc.c  */
#line 541 "cfg-grammar.y"
    {}
    break;

  case 89:

/* Line 1455 of yacc.c  */
#line 542 "cfg-grammar.y"
    {}
    break;

  case 90:

/* Line 1455 of yacc.c  */
#line 547 "cfg-grammar.y"
    {
	    last_driver = afinet_sd_new(last_addr_family,
			NULL, 514,
			AFSOCKET_DGRAM);
	    last_reader_options = &((AFSocketSourceDriver *) last_driver)->reader_options;
	    last_sock_options = &((AFInetSourceDriver *) last_driver)->sock_options.super;
	  }
    break;

  case 91:

/* Line 1455 of yacc.c  */
#line 554 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 95:

/* Line 1455 of yacc.c  */
#line 567 "cfg-grammar.y"
    { afinet_sd_set_localip(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 96:

/* Line 1455 of yacc.c  */
#line 568 "cfg-grammar.y"
    { afinet_sd_set_localip(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 97:

/* Line 1455 of yacc.c  */
#line 569 "cfg-grammar.y"
    { afinet_sd_set_localport(last_driver, (yyvsp[(3) - (4)].cptr), afinet_sd_get_proto_name(last_driver)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 98:

/* Line 1455 of yacc.c  */
#line 570 "cfg-grammar.y"
    { afinet_sd_set_localport(last_driver, (yyvsp[(3) - (4)].cptr), afinet_sd_get_proto_name(last_driver)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 101:

/* Line 1455 of yacc.c  */
#line 577 "cfg-grammar.y"
    {
	    last_driver = afinet_sd_new(last_addr_family,
			NULL, 514,
			AFSOCKET_STREAM);
	    last_reader_options = &((AFSocketSourceDriver *) last_driver)->reader_options;
	    last_sock_options = &((AFInetSourceDriver *) last_driver)->sock_options.super;
	  }
    break;

  case 102:

/* Line 1455 of yacc.c  */
#line 584 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 106:

/* Line 1455 of yacc.c  */
#line 596 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    last_tls_context = tls_context_new(TM_SERVER);
#endif
	  }
    break;

  case 107:

/* Line 1455 of yacc.c  */
#line 602 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    afsocket_sd_set_tls_context(last_driver, last_tls_context);
#endif
          }
    break;

  case 108:

/* Line 1455 of yacc.c  */
#line 608 "cfg-grammar.y"
    {}
    break;

  case 109:

/* Line 1455 of yacc.c  */
#line 612 "cfg-grammar.y"
    { afsocket_sd_set_keep_alive(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 110:

/* Line 1455 of yacc.c  */
#line 613 "cfg-grammar.y"
    { afsocket_sd_set_max_connections(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 111:

/* Line 1455 of yacc.c  */
#line 617 "cfg-grammar.y"
    { last_addr_family = AF_INET; }
    break;

  case 112:

/* Line 1455 of yacc.c  */
#line 617 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 113:

/* Line 1455 of yacc.c  */
#line 622 "cfg-grammar.y"
    {
	    last_driver = afinet_sd_new(last_addr_family,
			NULL, 601,
			AFSOCKET_STREAM | AFSOCKET_SYSLOG_PROTOCOL);
	    last_reader_options = &((AFSocketSourceDriver *) last_driver)->reader_options;
	    last_sock_options = &((AFInetSourceDriver *) last_driver)->sock_options.super;
	  }
    break;

  case 114:

/* Line 1455 of yacc.c  */
#line 629 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 118:

/* Line 1455 of yacc.c  */
#line 639 "cfg-grammar.y"
    { afinet_sd_set_transport(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 119:

/* Line 1455 of yacc.c  */
#line 640 "cfg-grammar.y"
    { afinet_sd_set_transport(last_driver, "tcp"); }
    break;

  case 120:

/* Line 1455 of yacc.c  */
#line 641 "cfg-grammar.y"
    { afinet_sd_set_transport(last_driver, "udp"); }
    break;

  case 121:

/* Line 1455 of yacc.c  */
#line 642 "cfg-grammar.y"
    { afinet_sd_set_transport(last_driver, "tls"); }
    break;

  case 122:

/* Line 1455 of yacc.c  */
#line 644 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    last_tls_context = tls_context_new(TM_SERVER);
#endif
	  }
    break;

  case 123:

/* Line 1455 of yacc.c  */
#line 650 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    afsocket_sd_set_tls_context(last_driver, last_tls_context);
#endif
          }
    break;

  case 124:

/* Line 1455 of yacc.c  */
#line 655 "cfg-grammar.y"
    {}
    break;

  case 125:

/* Line 1455 of yacc.c  */
#line 659 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 126:

/* Line 1455 of yacc.c  */
#line 664 "cfg-grammar.y"
    {
	    last_driver = afprogram_sd_new((yyvsp[(1) - (1)].cptr));
	    free((yyvsp[(1) - (1)].cptr));
	    last_reader_options = &((AFProgramSourceDriver *) last_driver)->reader_options;
	  }
    break;

  case 127:

/* Line 1455 of yacc.c  */
#line 669 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 128:

/* Line 1455 of yacc.c  */
#line 673 "cfg-grammar.y"
    {
#if ENABLE_SUN_STREAMS
}
    break;

  case 129:

/* Line 1455 of yacc.c  */
#line 676 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 130:

/* Line 1455 of yacc.c  */
#line 677 "cfg-grammar.y"
    {
#endif
}
    break;

  case 131:

/* Line 1455 of yacc.c  */
#line 684 "cfg-grammar.y"
    {
#if ENABLE_SUN_STREAMS
	    last_driver = afstreams_sd_new((yyvsp[(1) - (1)].cptr));
	    free((yyvsp[(1) - (1)].cptr));
#endif
	  }
    break;

  case 132:

/* Line 1455 of yacc.c  */
#line 690 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 135:

/* Line 1455 of yacc.c  */
#line 699 "cfg-grammar.y"
    {
#if ENABLE_SUN_STREAMS
}
    break;

  case 136:

/* Line 1455 of yacc.c  */
#line 702 "cfg-grammar.y"
    { afstreams_sd_set_sundoor(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 137:

/* Line 1455 of yacc.c  */
#line 703 "cfg-grammar.y"
    {
#endif
}
    break;

  case 140:

/* Line 1455 of yacc.c  */
#line 714 "cfg-grammar.y"
    { last_reader_options->super.init_window_size = (yyvsp[(3) - (4)].num); }
    break;

  case 141:

/* Line 1455 of yacc.c  */
#line 715 "cfg-grammar.y"
    { last_reader_options->super.chain_hostnames = (yyvsp[(3) - (4)].num); }
    break;

  case 142:

/* Line 1455 of yacc.c  */
#line 716 "cfg-grammar.y"
    { last_reader_options->super.normalize_hostnames = (yyvsp[(3) - (4)].num); }
    break;

  case 143:

/* Line 1455 of yacc.c  */
#line 717 "cfg-grammar.y"
    { last_reader_options->super.keep_hostname = (yyvsp[(3) - (4)].num); }
    break;

  case 144:

/* Line 1455 of yacc.c  */
#line 718 "cfg-grammar.y"
    { last_reader_options->super.use_fqdn = (yyvsp[(3) - (4)].num); }
    break;

  case 145:

/* Line 1455 of yacc.c  */
#line 719 "cfg-grammar.y"
    { last_reader_options->super.use_dns = (yyvsp[(3) - (4)].num); }
    break;

  case 146:

/* Line 1455 of yacc.c  */
#line 720 "cfg-grammar.y"
    { last_reader_options->super.use_dns_cache = (yyvsp[(3) - (4)].num); }
    break;

  case 147:

/* Line 1455 of yacc.c  */
#line 721 "cfg-grammar.y"
    { last_reader_options->super.program_override = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 148:

/* Line 1455 of yacc.c  */
#line 722 "cfg-grammar.y"
    { last_reader_options->super.host_override = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 149:

/* Line 1455 of yacc.c  */
#line 723 "cfg-grammar.y"
    { gchar *p = strrchr((yyvsp[(3) - (4)].cptr), ':'); if (p) *p = 0; last_reader_options->super.program_override = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 150:

/* Line 1455 of yacc.c  */
#line 724 "cfg-grammar.y"
    { last_reader_options->recv_time_zone = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 151:

/* Line 1455 of yacc.c  */
#line 725 "cfg-grammar.y"
    { last_reader_options->check_hostname = (yyvsp[(3) - (4)].num); }
    break;

  case 152:

/* Line 1455 of yacc.c  */
#line 726 "cfg-grammar.y"
    { last_reader_options->options = (yyvsp[(3) - (4)].num); }
    break;

  case 153:

/* Line 1455 of yacc.c  */
#line 727 "cfg-grammar.y"
    { last_reader_options->msg_size = (yyvsp[(3) - (4)].num); }
    break;

  case 154:

/* Line 1455 of yacc.c  */
#line 728 "cfg-grammar.y"
    { last_reader_options->fetch_limit = (yyvsp[(3) - (4)].num); }
    break;

  case 155:

/* Line 1455 of yacc.c  */
#line 729 "cfg-grammar.y"
    { last_reader_options->padding = (yyvsp[(3) - (4)].num); }
    break;

  case 156:

/* Line 1455 of yacc.c  */
#line 730 "cfg-grammar.y"
    { last_reader_options->follow_freq = (long) ((yyvsp[(3) - (4)].fnum) * 1000); }
    break;

  case 157:

/* Line 1455 of yacc.c  */
#line 731 "cfg-grammar.y"
    { last_reader_options->follow_freq = ((yyvsp[(3) - (4)].num) * 1000); }
    break;

  case 158:

/* Line 1455 of yacc.c  */
#line 732 "cfg-grammar.y"
    { last_reader_options->super.keep_timestamp = (yyvsp[(3) - (4)].num); }
    break;

  case 159:

/* Line 1455 of yacc.c  */
#line 733 "cfg-grammar.y"
    { last_reader_options->text_encoding = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 160:

/* Line 1455 of yacc.c  */
#line 734 "cfg-grammar.y"
    { log_reader_options_set_tags(last_reader_options, (yyvsp[(3) - (4)].ptr)); }
    break;

  case 161:

/* Line 1455 of yacc.c  */
#line 736 "cfg-grammar.y"
    {
	    if (last_reader_options->default_pri == 0xFFFF)
	      last_reader_options->default_pri = LOG_USER;
	    last_reader_options->default_pri = (last_reader_options->default_pri & ~7) | (yyvsp[(3) - (4)].num);
          }
    break;

  case 162:

/* Line 1455 of yacc.c  */
#line 742 "cfg-grammar.y"
    {
	    if (last_reader_options->default_pri == 0xFFFF)
	      last_reader_options->default_pri = LOG_NOTICE;
	    last_reader_options->default_pri = (last_reader_options->default_pri & 7) | (yyvsp[(3) - (4)].num);
          }
    break;

  case 163:

/* Line 1455 of yacc.c  */
#line 750 "cfg-grammar.y"
    { (yyval.num) = log_reader_options_lookup_flag((yyvsp[(1) - (2)].cptr)) | (yyvsp[(2) - (2)].num); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 164:

/* Line 1455 of yacc.c  */
#line 751 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 165:

/* Line 1455 of yacc.c  */
#line 756 "cfg-grammar.y"
    { log_drv_append((yyvsp[(1) - (3)].ptr), (yyvsp[(3) - (3)].ptr)); log_drv_unref((yyvsp[(3) - (3)].ptr)); (yyval.ptr) = (yyvsp[(1) - (3)].ptr); }
    break;

  case 166:

/* Line 1455 of yacc.c  */
#line 757 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 167:

/* Line 1455 of yacc.c  */
#line 761 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 168:

/* Line 1455 of yacc.c  */
#line 762 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 169:

/* Line 1455 of yacc.c  */
#line 763 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 170:

/* Line 1455 of yacc.c  */
#line 764 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 171:

/* Line 1455 of yacc.c  */
#line 765 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 172:

/* Line 1455 of yacc.c  */
#line 766 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 173:

/* Line 1455 of yacc.c  */
#line 768 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 174:

/* Line 1455 of yacc.c  */
#line 773 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 175:

/* Line 1455 of yacc.c  */
#line 778 "cfg-grammar.y"
    {
	    last_driver = affile_dd_new((yyvsp[(1) - (1)].cptr), 0);
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFFileDestDriver *) last_driver)->writer_options;
	  }
    break;

  case 176:

/* Line 1455 of yacc.c  */
#line 784 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 180:

/* Line 1455 of yacc.c  */
#line 794 "cfg-grammar.y"
    { last_driver->optional = (yyvsp[(3) - (4)].num); }
    break;

  case 181:

/* Line 1455 of yacc.c  */
#line 795 "cfg-grammar.y"
    { affile_dd_set_file_uid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 182:

/* Line 1455 of yacc.c  */
#line 796 "cfg-grammar.y"
    { affile_dd_set_file_gid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 183:

/* Line 1455 of yacc.c  */
#line 797 "cfg-grammar.y"
    { affile_dd_set_file_perm(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 184:

/* Line 1455 of yacc.c  */
#line 798 "cfg-grammar.y"
    { affile_dd_set_dir_uid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 185:

/* Line 1455 of yacc.c  */
#line 799 "cfg-grammar.y"
    { affile_dd_set_dir_gid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 186:

/* Line 1455 of yacc.c  */
#line 800 "cfg-grammar.y"
    { affile_dd_set_dir_perm(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 187:

/* Line 1455 of yacc.c  */
#line 801 "cfg-grammar.y"
    { affile_dd_set_create_dirs(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 188:

/* Line 1455 of yacc.c  */
#line 802 "cfg-grammar.y"
    { affile_dd_set_overwrite_if_older(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 189:

/* Line 1455 of yacc.c  */
#line 803 "cfg-grammar.y"
    { affile_dd_set_fsync(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 190:

/* Line 1455 of yacc.c  */
#line 804 "cfg-grammar.y"
    { affile_dd_set_local_time_zone(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 191:

/* Line 1455 of yacc.c  */
#line 808 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 192:

/* Line 1455 of yacc.c  */
#line 813 "cfg-grammar.y"
    {
	    last_driver = affile_dd_new((yyvsp[(1) - (1)].cptr), AFFILE_PIPE);
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFFileDestDriver *) last_driver)->writer_options;
	    last_writer_options->flush_lines = 0;
	  }
    break;

  case 193:

/* Line 1455 of yacc.c  */
#line 819 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 197:

/* Line 1455 of yacc.c  */
#line 829 "cfg-grammar.y"
    { affile_dd_set_file_uid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 198:

/* Line 1455 of yacc.c  */
#line 830 "cfg-grammar.y"
    { affile_dd_set_file_gid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 199:

/* Line 1455 of yacc.c  */
#line 831 "cfg-grammar.y"
    { affile_dd_set_file_perm(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 200:

/* Line 1455 of yacc.c  */
#line 835 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 201:

/* Line 1455 of yacc.c  */
#line 836 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 202:

/* Line 1455 of yacc.c  */
#line 837 "cfg-grammar.y"
    { last_addr_family = AF_INET; }
    break;

  case 203:

/* Line 1455 of yacc.c  */
#line 837 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 204:

/* Line 1455 of yacc.c  */
#line 838 "cfg-grammar.y"
    { last_addr_family = AF_INET; }
    break;

  case 205:

/* Line 1455 of yacc.c  */
#line 838 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 206:

/* Line 1455 of yacc.c  */
#line 839 "cfg-grammar.y"
    { last_addr_family = AF_INET6; }
    break;

  case 207:

/* Line 1455 of yacc.c  */
#line 839 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 208:

/* Line 1455 of yacc.c  */
#line 840 "cfg-grammar.y"
    { last_addr_family = AF_INET6; }
    break;

  case 209:

/* Line 1455 of yacc.c  */
#line 840 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 210:

/* Line 1455 of yacc.c  */
#line 845 "cfg-grammar.y"
    {
	    last_driver = afunix_dd_new((yyvsp[(1) - (1)].cptr), AFSOCKET_DGRAM);
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFSocketDestDriver *) last_driver)->writer_options;
	    last_sock_options = &((AFUnixDestDriver *) last_driver)->sock_options;
	  }
    break;

  case 211:

/* Line 1455 of yacc.c  */
#line 851 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 212:

/* Line 1455 of yacc.c  */
#line 856 "cfg-grammar.y"
    {
	    last_driver = afunix_dd_new((yyvsp[(1) - (1)].cptr), AFSOCKET_STREAM);
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFSocketDestDriver *) last_driver)->writer_options;
	    last_sock_options = &((AFUnixDestDriver *) last_driver)->sock_options;
	  }
    break;

  case 213:

/* Line 1455 of yacc.c  */
#line 862 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 219:

/* Line 1455 of yacc.c  */
#line 878 "cfg-grammar.y"
    {
	    last_driver = afinet_dd_new(last_addr_family,
			(yyvsp[(1) - (1)].cptr), 514,
			AFSOCKET_DGRAM);
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFSocketDestDriver *) last_driver)->writer_options;
	    last_sock_options = &((AFInetDestDriver *) last_driver)->sock_options.super;
	  }
    break;

  case 220:

/* Line 1455 of yacc.c  */
#line 886 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 223:

/* Line 1455 of yacc.c  */
#line 896 "cfg-grammar.y"
    { afinet_dd_set_localip(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 224:

/* Line 1455 of yacc.c  */
#line 897 "cfg-grammar.y"
    { afinet_dd_set_localport(last_driver, (yyvsp[(3) - (4)].cptr), afinet_dd_get_proto_name(last_driver)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 225:

/* Line 1455 of yacc.c  */
#line 898 "cfg-grammar.y"
    { afinet_dd_set_destport(last_driver, (yyvsp[(3) - (4)].cptr), afinet_dd_get_proto_name(last_driver)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 226:

/* Line 1455 of yacc.c  */
#line 899 "cfg-grammar.y"
    { afinet_dd_set_destport(last_driver, (yyvsp[(3) - (4)].cptr), afinet_dd_get_proto_name(last_driver)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 231:

/* Line 1455 of yacc.c  */
#line 907 "cfg-grammar.y"
    { afinet_dd_set_spoof_source(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 232:

/* Line 1455 of yacc.c  */
#line 912 "cfg-grammar.y"
    {
	    last_driver = afinet_dd_new(last_addr_family,
			(yyvsp[(1) - (1)].cptr), 514,
			AFSOCKET_STREAM);
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFSocketDestDriver *) last_driver)->writer_options;
	    last_sock_options = &((AFInetDestDriver *) last_driver)->sock_options.super;
	  }
    break;

  case 233:

/* Line 1455 of yacc.c  */
#line 920 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 237:

/* Line 1455 of yacc.c  */
#line 931 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    last_tls_context = tls_context_new(TM_CLIENT);
#endif
	  }
    break;

  case 238:

/* Line 1455 of yacc.c  */
#line 937 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    afsocket_dd_set_tls_context(last_driver, last_tls_context);
#endif
          }
    break;

  case 239:

/* Line 1455 of yacc.c  */
#line 945 "cfg-grammar.y"
    { afsocket_dd_set_keep_alive(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 240:

/* Line 1455 of yacc.c  */
#line 950 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 241:

/* Line 1455 of yacc.c  */
#line 954 "cfg-grammar.y"
    {
            last_driver = afinet_dd_new(last_addr_family, (yyvsp[(1) - (1)].cptr), 601, AFSOCKET_STREAM | AFSOCKET_SYSLOG_PROTOCOL);
	    last_writer_options = &((AFSocketDestDriver *) last_driver)->writer_options;
	    last_sock_options = &((AFInetDestDriver *) last_driver)->sock_options.super;
	    free((yyvsp[(1) - (1)].cptr));
	  }
    break;

  case 242:

/* Line 1455 of yacc.c  */
#line 960 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 246:

/* Line 1455 of yacc.c  */
#line 971 "cfg-grammar.y"
    { afinet_dd_set_transport(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 247:

/* Line 1455 of yacc.c  */
#line 972 "cfg-grammar.y"
    { afinet_dd_set_transport(last_driver, "tcp"); }
    break;

  case 248:

/* Line 1455 of yacc.c  */
#line 973 "cfg-grammar.y"
    { afinet_dd_set_transport(last_driver, "udp"); }
    break;

  case 249:

/* Line 1455 of yacc.c  */
#line 974 "cfg-grammar.y"
    { afinet_dd_set_transport(last_driver, "tls"); }
    break;

  case 250:

/* Line 1455 of yacc.c  */
#line 975 "cfg-grammar.y"
    { afinet_dd_set_spoof_source(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 251:

/* Line 1455 of yacc.c  */
#line 977 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    last_tls_context = tls_context_new(TM_CLIENT);
#endif
	  }
    break;

  case 252:

/* Line 1455 of yacc.c  */
#line 983 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    afsocket_dd_set_tls_context(last_driver, last_tls_context);
#endif
          }
    break;

  case 253:

/* Line 1455 of yacc.c  */
#line 992 "cfg-grammar.y"
    { (yyval.ptr) = afuser_dd_new((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 254:

/* Line 1455 of yacc.c  */
#line 996 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 255:

/* Line 1455 of yacc.c  */
#line 1001 "cfg-grammar.y"
    {
	    last_driver = afprogram_dd_new((yyvsp[(1) - (1)].cptr));
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFProgramDestDriver *) last_driver)->writer_options;
	  }
    break;

  case 256:

/* Line 1455 of yacc.c  */
#line 1006 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 257:

/* Line 1455 of yacc.c  */
#line 1012 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 258:

/* Line 1455 of yacc.c  */
#line 1017 "cfg-grammar.y"
    {
            #if ENABLE_SQL	
            last_driver = afsql_dd_new();
            #endif /* ENABLE_SQL */
          }
    break;

  case 259:

/* Line 1455 of yacc.c  */
#line 1022 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 262:

/* Line 1455 of yacc.c  */
#line 1031 "cfg-grammar.y"
    {
#if ENABLE_SQL
}
    break;

  case 263:

/* Line 1455 of yacc.c  */
#line 1034 "cfg-grammar.y"
    { afsql_dd_set_type(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 264:

/* Line 1455 of yacc.c  */
#line 1035 "cfg-grammar.y"
    { afsql_dd_set_host(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 265:

/* Line 1455 of yacc.c  */
#line 1036 "cfg-grammar.y"
    { afsql_dd_set_port(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 266:

/* Line 1455 of yacc.c  */
#line 1037 "cfg-grammar.y"
    { afsql_dd_set_user(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 267:

/* Line 1455 of yacc.c  */
#line 1038 "cfg-grammar.y"
    { afsql_dd_set_password(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 268:

/* Line 1455 of yacc.c  */
#line 1039 "cfg-grammar.y"
    { afsql_dd_set_database(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 269:

/* Line 1455 of yacc.c  */
#line 1040 "cfg-grammar.y"
    { afsql_dd_set_table(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 270:

/* Line 1455 of yacc.c  */
#line 1041 "cfg-grammar.y"
    { afsql_dd_set_columns(last_driver, (yyvsp[(3) - (4)].ptr)); }
    break;

  case 271:

/* Line 1455 of yacc.c  */
#line 1042 "cfg-grammar.y"
    { afsql_dd_set_indexes(last_driver, (yyvsp[(3) - (4)].ptr)); }
    break;

  case 272:

/* Line 1455 of yacc.c  */
#line 1043 "cfg-grammar.y"
    { afsql_dd_set_values(last_driver, (yyvsp[(3) - (4)].ptr)); }
    break;

  case 273:

/* Line 1455 of yacc.c  */
#line 1044 "cfg-grammar.y"
    { afsql_dd_set_mem_fifo_size(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 274:

/* Line 1455 of yacc.c  */
#line 1045 "cfg-grammar.y"
    { afsql_dd_set_disk_fifo_size(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 275:

/* Line 1455 of yacc.c  */
#line 1046 "cfg-grammar.y"
    { afsql_dd_set_frac_digits(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 276:

/* Line 1455 of yacc.c  */
#line 1047 "cfg-grammar.y"
    { afsql_dd_set_send_time_zone(last_driver,(yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 277:

/* Line 1455 of yacc.c  */
#line 1048 "cfg-grammar.y"
    { afsql_dd_set_local_time_zone(last_driver,(yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 278:

/* Line 1455 of yacc.c  */
#line 1049 "cfg-grammar.y"
    { afsql_dd_set_null_value(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 279:

/* Line 1455 of yacc.c  */
#line 1051 "cfg-grammar.y"
    {
#endif /* ENABLE_SQL */
}
    break;

  case 282:

/* Line 1455 of yacc.c  */
#line 1064 "cfg-grammar.y"
    { last_writer_options->options = (yyvsp[(3) - (4)].num); }
    break;

  case 283:

/* Line 1455 of yacc.c  */
#line 1065 "cfg-grammar.y"
    { last_writer_options->mem_fifo_size = (yyvsp[(3) - (4)].num); }
    break;

  case 284:

/* Line 1455 of yacc.c  */
#line 1066 "cfg-grammar.y"
    { last_writer_options->flush_lines = (yyvsp[(3) - (4)].num); }
    break;

  case 285:

/* Line 1455 of yacc.c  */
#line 1067 "cfg-grammar.y"
    { last_writer_options->flush_timeout = (yyvsp[(3) - (4)].num); }
    break;

  case 286:

/* Line 1455 of yacc.c  */
#line 1068 "cfg-grammar.y"
    { last_writer_options->suppress = (yyvsp[(3) - (4)].num); }
    break;

  case 287:

/* Line 1455 of yacc.c  */
#line 1069 "cfg-grammar.y"
    {
	                                          last_writer_options->template = cfg_check_inline_template(configuration, (yyvsp[(3) - (4)].cptr));
                                                  if (!cfg_check_template(last_writer_options->template))
	                                            {
	                                              YYERROR;
	                                            }
	                                          free((yyvsp[(3) - (4)].cptr));
	                                        }
    break;

  case 288:

/* Line 1455 of yacc.c  */
#line 1077 "cfg-grammar.y"
    { log_writer_options_set_template_escape(last_writer_options, (yyvsp[(3) - (4)].num)); }
    break;

  case 289:

/* Line 1455 of yacc.c  */
#line 1078 "cfg-grammar.y"
    { last_writer_options->send_time_zone = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 290:

/* Line 1455 of yacc.c  */
#line 1079 "cfg-grammar.y"
    { last_writer_options->ts_format = cfg_ts_format_value((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 291:

/* Line 1455 of yacc.c  */
#line 1080 "cfg-grammar.y"
    { last_writer_options->frac_digits = (yyvsp[(3) - (4)].num); }
    break;

  case 292:

/* Line 1455 of yacc.c  */
#line 1081 "cfg-grammar.y"
    { last_writer_options->throttle = (yyvsp[(3) - (4)].num); }
    break;

  case 293:

/* Line 1455 of yacc.c  */
#line 1085 "cfg-grammar.y"
    { (yyval.num) = log_writer_options_lookup_flag((yyvsp[(1) - (2)].cptr)) | (yyvsp[(2) - (2)].num); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 294:

/* Line 1455 of yacc.c  */
#line 1086 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 295:

/* Line 1455 of yacc.c  */
#line 1091 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (3)].ptr); }
    break;

  case 296:

/* Line 1455 of yacc.c  */
#line 1092 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 297:

/* Line 1455 of yacc.c  */
#line 1096 "cfg-grammar.y"
    { configuration->mark_freq = (yyvsp[(3) - (4)].num); }
    break;

  case 298:

/* Line 1455 of yacc.c  */
#line 1097 "cfg-grammar.y"
    { configuration->stats_freq = (yyvsp[(3) - (4)].num); }
    break;

  case 299:

/* Line 1455 of yacc.c  */
#line 1098 "cfg-grammar.y"
    { configuration->stats_level = (yyvsp[(3) - (4)].num); }
    break;

  case 300:

/* Line 1455 of yacc.c  */
#line 1099 "cfg-grammar.y"
    { configuration->flush_lines = (yyvsp[(3) - (4)].num); }
    break;

  case 301:

/* Line 1455 of yacc.c  */
#line 1100 "cfg-grammar.y"
    { configuration->flush_timeout = (yyvsp[(3) - (4)].num); }
    break;

  case 302:

/* Line 1455 of yacc.c  */
#line 1101 "cfg-grammar.y"
    { configuration->chain_hostnames = (yyvsp[(3) - (4)].num); }
    break;

  case 303:

/* Line 1455 of yacc.c  */
#line 1102 "cfg-grammar.y"
    { configuration->normalize_hostnames = (yyvsp[(3) - (4)].num); }
    break;

  case 304:

/* Line 1455 of yacc.c  */
#line 1103 "cfg-grammar.y"
    { configuration->keep_hostname = (yyvsp[(3) - (4)].num); }
    break;

  case 305:

/* Line 1455 of yacc.c  */
#line 1104 "cfg-grammar.y"
    { configuration->check_hostname = (yyvsp[(3) - (4)].num); }
    break;

  case 306:

/* Line 1455 of yacc.c  */
#line 1105 "cfg-grammar.y"
    { cfg_bad_hostname_set(configuration, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 307:

/* Line 1455 of yacc.c  */
#line 1106 "cfg-grammar.y"
    { configuration->use_time_recvd = (yyvsp[(3) - (4)].num); }
    break;

  case 308:

/* Line 1455 of yacc.c  */
#line 1107 "cfg-grammar.y"
    { configuration->use_fqdn = (yyvsp[(3) - (4)].num); }
    break;

  case 309:

/* Line 1455 of yacc.c  */
#line 1108 "cfg-grammar.y"
    { configuration->use_dns = (yyvsp[(3) - (4)].num); }
    break;

  case 310:

/* Line 1455 of yacc.c  */
#line 1109 "cfg-grammar.y"
    { configuration->time_reopen = (yyvsp[(3) - (4)].num); }
    break;

  case 311:

/* Line 1455 of yacc.c  */
#line 1110 "cfg-grammar.y"
    { configuration->time_reap = (yyvsp[(3) - (4)].num); }
    break;

  case 312:

/* Line 1455 of yacc.c  */
#line 1112 "cfg-grammar.y"
    {
		  configuration->time_sleep = (yyvsp[(3) - (4)].num);
		  if ((yyvsp[(3) - (4)].num) > 500)
		    {
		      msg_notice("The value specified for time_sleep is too large", evt_tag_int("time_sleep", (yyvsp[(3) - (4)].num)), NULL);
		      configuration->time_sleep = 500;
		    }
		}
    break;

  case 313:

/* Line 1455 of yacc.c  */
#line 1120 "cfg-grammar.y"
    { configuration->log_fifo_size = (yyvsp[(3) - (4)].num); }
    break;

  case 314:

/* Line 1455 of yacc.c  */
#line 1121 "cfg-grammar.y"
    { configuration->log_iw_size = (yyvsp[(3) - (4)].num); }
    break;

  case 315:

/* Line 1455 of yacc.c  */
#line 1122 "cfg-grammar.y"
    { configuration->log_fetch_limit = (yyvsp[(3) - (4)].num); }
    break;

  case 316:

/* Line 1455 of yacc.c  */
#line 1123 "cfg-grammar.y"
    { configuration->log_msg_size = (yyvsp[(3) - (4)].num); }
    break;

  case 317:

/* Line 1455 of yacc.c  */
#line 1124 "cfg-grammar.y"
    { configuration->keep_timestamp = (yyvsp[(3) - (4)].num); }
    break;

  case 318:

/* Line 1455 of yacc.c  */
#line 1125 "cfg-grammar.y"
    { configuration->ts_format = cfg_ts_format_value((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 319:

/* Line 1455 of yacc.c  */
#line 1126 "cfg-grammar.y"
    { configuration->frac_digits = (yyvsp[(3) - (4)].num); }
    break;

  case 320:

/* Line 1455 of yacc.c  */
#line 1127 "cfg-grammar.y"
    { /* ignored */; }
    break;

  case 321:

/* Line 1455 of yacc.c  */
#line 1128 "cfg-grammar.y"
    { /* ignored */; }
    break;

  case 322:

/* Line 1455 of yacc.c  */
#line 1129 "cfg-grammar.y"
    { configuration->create_dirs = (yyvsp[(3) - (4)].num); }
    break;

  case 323:

/* Line 1455 of yacc.c  */
#line 1130 "cfg-grammar.y"
    { cfg_file_owner_set(configuration, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 324:

/* Line 1455 of yacc.c  */
#line 1131 "cfg-grammar.y"
    { cfg_file_group_set(configuration, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 325:

/* Line 1455 of yacc.c  */
#line 1132 "cfg-grammar.y"
    { cfg_file_perm_set(configuration, (yyvsp[(3) - (4)].num)); }
    break;

  case 326:

/* Line 1455 of yacc.c  */
#line 1133 "cfg-grammar.y"
    { cfg_dir_owner_set(configuration, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 327:

/* Line 1455 of yacc.c  */
#line 1134 "cfg-grammar.y"
    { cfg_dir_group_set(configuration, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 328:

/* Line 1455 of yacc.c  */
#line 1135 "cfg-grammar.y"
    { cfg_dir_perm_set(configuration, (yyvsp[(3) - (4)].num)); }
    break;

  case 329:

/* Line 1455 of yacc.c  */
#line 1136 "cfg-grammar.y"
    { configuration->use_dns_cache = (yyvsp[(3) - (4)].num); }
    break;

  case 330:

/* Line 1455 of yacc.c  */
#line 1137 "cfg-grammar.y"
    { configuration->dns_cache_size = (yyvsp[(3) - (4)].num); }
    break;

  case 331:

/* Line 1455 of yacc.c  */
#line 1138 "cfg-grammar.y"
    { configuration->dns_cache_expire = (yyvsp[(3) - (4)].num); }
    break;

  case 332:

/* Line 1455 of yacc.c  */
#line 1140 "cfg-grammar.y"
    { configuration->dns_cache_expire_failed = (yyvsp[(3) - (4)].num); }
    break;

  case 333:

/* Line 1455 of yacc.c  */
#line 1141 "cfg-grammar.y"
    { configuration->dns_cache_hosts = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 334:

/* Line 1455 of yacc.c  */
#line 1142 "cfg-grammar.y"
    { configuration->file_template_name = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 335:

/* Line 1455 of yacc.c  */
#line 1143 "cfg-grammar.y"
    { configuration->proto_template_name = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 336:

/* Line 1455 of yacc.c  */
#line 1144 "cfg-grammar.y"
    { configuration->recv_time_zone = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 337:

/* Line 1455 of yacc.c  */
#line 1145 "cfg-grammar.y"
    { configuration->send_time_zone = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 338:

/* Line 1455 of yacc.c  */
#line 1146 "cfg-grammar.y"
    { configuration->local_time_zone = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 341:

/* Line 1455 of yacc.c  */
#line 1156 "cfg-grammar.y"
    {
#if ENABLE_SSL
}
    break;

  case 342:

/* Line 1455 of yacc.c  */
#line 1161 "cfg-grammar.y"
    {
	    last_tls_context->verify_mode = tls_lookup_verify_mode((yyvsp[(3) - (4)].cptr));
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 343:

/* Line 1455 of yacc.c  */
#line 1166 "cfg-grammar.y"
    {
	    last_tls_context->key_file = g_strdup((yyvsp[(3) - (4)].cptr));
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 344:

/* Line 1455 of yacc.c  */
#line 1171 "cfg-grammar.y"
    {
	    last_tls_context->cert_file = g_strdup((yyvsp[(3) - (4)].cptr));
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 345:

/* Line 1455 of yacc.c  */
#line 1176 "cfg-grammar.y"
    {
	    last_tls_context->ca_dir = g_strdup((yyvsp[(3) - (4)].cptr));
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 346:

/* Line 1455 of yacc.c  */
#line 1181 "cfg-grammar.y"
    {
	    last_tls_context->crl_dir = g_strdup((yyvsp[(3) - (4)].cptr));
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 347:

/* Line 1455 of yacc.c  */
#line 1186 "cfg-grammar.y"
    {
            tls_session_set_trusted_fingerprints(last_tls_context, (yyvsp[(3) - (4)].ptr));
          }
    break;

  case 348:

/* Line 1455 of yacc.c  */
#line 1190 "cfg-grammar.y"
    {
            tls_session_set_trusted_dn(last_tls_context, (yyvsp[(3) - (4)].ptr));
          }
    break;

  case 349:

/* Line 1455 of yacc.c  */
#line 1193 "cfg-grammar.y"
    {
#endif
}
    break;

  case 350:

/* Line 1455 of yacc.c  */
#line 1201 "cfg-grammar.y"
    { (yyval.node) = (yyvsp[(1) - (1)].node); if (!(yyvsp[(1) - (1)].node)) return 1; }
    break;

  case 351:

/* Line 1455 of yacc.c  */
#line 1202 "cfg-grammar.y"
    { (yyvsp[(2) - (2)].node)->comp = !((yyvsp[(2) - (2)].node)->comp); (yyval.node) = (yyvsp[(2) - (2)].node); }
    break;

  case 352:

/* Line 1455 of yacc.c  */
#line 1203 "cfg-grammar.y"
    { (yyval.node) = fop_or_new((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 353:

/* Line 1455 of yacc.c  */
#line 1204 "cfg-grammar.y"
    { (yyval.node) = fop_and_new((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 354:

/* Line 1455 of yacc.c  */
#line 1205 "cfg-grammar.y"
    { (yyval.node) = (yyvsp[(2) - (3)].node); }
    break;

  case 355:

/* Line 1455 of yacc.c  */
#line 1209 "cfg-grammar.y"
    { (yyval.node) = filter_facility_new((yyvsp[(3) - (4)].num));  }
    break;

  case 356:

/* Line 1455 of yacc.c  */
#line 1210 "cfg-grammar.y"
    { (yyval.node) = filter_facility_new(0x80000000 | (yyvsp[(3) - (4)].num)); }
    break;

  case 357:

/* Line 1455 of yacc.c  */
#line 1211 "cfg-grammar.y"
    { (yyval.node) = filter_level_new((yyvsp[(3) - (4)].num)); }
    break;

  case 358:

/* Line 1455 of yacc.c  */
#line 1212 "cfg-grammar.y"
    { (yyval.node) = filter_call_new((yyvsp[(3) - (4)].cptr), configuration); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 359:

/* Line 1455 of yacc.c  */
#line 1213 "cfg-grammar.y"
    { (yyval.node) = filter_netmask_new((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 360:

/* Line 1455 of yacc.c  */
#line 1214 "cfg-grammar.y"
    { (yyval.node) = filter_tags_new((yyvsp[(3) - (4)].ptr)); }
    break;

  case 361:

/* Line 1455 of yacc.c  */
#line 1216 "cfg-grammar.y"
    {
	    last_re_filter = (FilterRE *) filter_re_new(LM_V_PROGRAM);
          }
    break;

  case 362:

/* Line 1455 of yacc.c  */
#line 1220 "cfg-grammar.y"
    {
            if(!filter_re_set_regexp(last_re_filter, (yyvsp[(3) - (6)].cptr)))
              YYERROR;
            free((yyvsp[(3) - (6)].cptr));

            (yyval.node) = &last_re_filter->super;
          }
    break;

  case 363:

/* Line 1455 of yacc.c  */
#line 1228 "cfg-grammar.y"
    {
	    last_re_filter = (FilterRE *) filter_re_new(LM_V_HOST);
          }
    break;

  case 364:

/* Line 1455 of yacc.c  */
#line 1232 "cfg-grammar.y"
    {
            if(!filter_re_set_regexp(last_re_filter, (yyvsp[(3) - (6)].cptr)))
              YYERROR;
            free((yyvsp[(3) - (6)].cptr));

            (yyval.node) = &last_re_filter->super;
          }
    break;

  case 365:

/* Line 1455 of yacc.c  */
#line 1240 "cfg-grammar.y"
    {
	    last_re_filter = (FilterRE *) filter_match_new();
	  }
    break;

  case 366:

/* Line 1455 of yacc.c  */
#line 1244 "cfg-grammar.y"
    {
            if(!filter_re_set_regexp(last_re_filter, (yyvsp[(3) - (6)].cptr)))
              YYERROR;
            free((yyvsp[(3) - (6)].cptr));
            (yyval.node) = &last_re_filter->super;

            if (last_re_filter->value_handle == 0)
              {
                static gboolean warn_written = FALSE;

                if (!warn_written)
                  {
                    msg_warning("WARNING: the match() filter without the use of the value() option is deprecated and hinders performance, please update your configuration",
                                NULL);
                    warn_written = TRUE;
                  }
              }
          }
    break;

  case 367:

/* Line 1455 of yacc.c  */
#line 1263 "cfg-grammar.y"
    {
	    last_re_filter = (FilterRE *) filter_re_new(LM_V_MESSAGE);
          }
    break;

  case 368:

/* Line 1455 of yacc.c  */
#line 1267 "cfg-grammar.y"
    {
            if(!filter_re_set_regexp(last_re_filter, (yyvsp[(3) - (6)].cptr)))
              YYERROR;
	    free((yyvsp[(3) - (6)].cptr));
            (yyval.node) = &last_re_filter->super;
          }
    break;

  case 369:

/* Line 1455 of yacc.c  */
#line 1274 "cfg-grammar.y"
    {
	    last_re_filter = (FilterRE *) filter_re_new(LM_V_SOURCE);
            filter_re_set_matcher(last_re_filter, log_matcher_string_new());
          }
    break;

  case 370:

/* Line 1455 of yacc.c  */
#line 1279 "cfg-grammar.y"
    {
            if(!filter_re_set_regexp(last_re_filter, (yyvsp[(3) - (6)].cptr)))
              YYERROR;
	    free((yyvsp[(3) - (6)].cptr));
            (yyval.node) = &last_re_filter->super;
          }
    break;

  case 374:

/* Line 1455 of yacc.c  */
#line 1295 "cfg-grammar.y"
    {
            const gchar *p = (yyvsp[(3) - (4)].cptr);
            if (p[0] == '$')
              {
                msg_warning("Value references in filters should not use the '$' prefix, those are only needed in templates",
                            evt_tag_str("value", (yyvsp[(3) - (4)].cptr)),
                            NULL);
                p++;
              }
            last_re_filter->value_handle = log_msg_get_value_handle(p);
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 377:

/* Line 1455 of yacc.c  */
#line 1316 "cfg-grammar.y"
    {
            filter_re_set_matcher(last_re_filter, log_matcher_new((yyvsp[(3) - (4)].cptr)));
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 378:

/* Line 1455 of yacc.c  */
#line 1320 "cfg-grammar.y"
    { filter_re_set_flags(last_re_filter, (yyvsp[(3) - (4)].num)); }
    break;

  case 379:

/* Line 1455 of yacc.c  */
#line 1324 "cfg-grammar.y"
    { (yyval.num) = log_matcher_lookup_flag((yyvsp[(1) - (2)].cptr)) | (yyvsp[(2) - (2)].num); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 380:

/* Line 1455 of yacc.c  */
#line 1325 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 381:

/* Line 1455 of yacc.c  */
#line 1330 "cfg-grammar.y"
    { (yyval.num) = (1 << ((yyvsp[(1) - (2)].num) >> 3)) | (yyvsp[(2) - (2)].num); }
    break;

  case 382:

/* Line 1455 of yacc.c  */
#line 1331 "cfg-grammar.y"
    { (yyval.num) = (1 << ((yyvsp[(1) - (1)].num) >> 3)); }
    break;

  case 383:

/* Line 1455 of yacc.c  */
#line 1335 "cfg-grammar.y"
    { (yyval.num) = (yyvsp[(1) - (2)].num) | (yyvsp[(2) - (2)].num); }
    break;

  case 384:

/* Line 1455 of yacc.c  */
#line 1336 "cfg-grammar.y"
    { (yyval.num) = (yyvsp[(1) - (1)].num); }
    break;

  case 385:

/* Line 1455 of yacc.c  */
#line 1341 "cfg-grammar.y"
    {
	    (yyval.num) = syslog_make_range((yyvsp[(1) - (3)].num), (yyvsp[(3) - (3)].num));
	  }
    break;

  case 386:

/* Line 1455 of yacc.c  */
#line 1345 "cfg-grammar.y"
    {
	    (yyval.num) = 1 << (yyvsp[(1) - (1)].num);
	  }
    break;

  case 387:

/* Line 1455 of yacc.c  */
#line 1353 "cfg-grammar.y"
    {
            last_parser = (LogParser *) log_csv_parser_new();
          }
    break;

  case 388:

/* Line 1455 of yacc.c  */
#line 1357 "cfg-grammar.y"
    { (yyval.ptr) = last_parser; }
    break;

  case 389:

/* Line 1455 of yacc.c  */
#line 1359 "cfg-grammar.y"
    {
            last_parser = (LogParser *) log_db_parser_new();
          }
    break;

  case 390:

/* Line 1455 of yacc.c  */
#line 1363 "cfg-grammar.y"
    { (yyval.ptr) = last_parser; }
    break;

  case 393:

/* Line 1455 of yacc.c  */
#line 1373 "cfg-grammar.y"
    { log_db_parser_set_db_file(((LogDBParser *) last_parser), (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 395:

/* Line 1455 of yacc.c  */
#line 1378 "cfg-grammar.y"
    { log_column_parser_set_columns((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].ptr)); }
    break;

  case 396:

/* Line 1455 of yacc.c  */
#line 1382 "cfg-grammar.y"
    {
                                                  LogTemplate *template = cfg_check_inline_template(configuration, (yyvsp[(3) - (4)].cptr));
                                                  if (!cfg_check_template(template))
                                                    {
                                                      YYERROR;
                                                    }
                                                  log_parser_set_template(last_parser, template);
                                                  free((yyvsp[(3) - (4)].cptr));
                                                }
    break;

  case 400:

/* Line 1455 of yacc.c  */
#line 1401 "cfg-grammar.y"
    { log_csv_parser_set_flags((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].num)); }
    break;

  case 401:

/* Line 1455 of yacc.c  */
#line 1402 "cfg-grammar.y"
    { log_csv_parser_set_delimiters((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 402:

/* Line 1455 of yacc.c  */
#line 1403 "cfg-grammar.y"
    { log_csv_parser_set_quotes((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 403:

/* Line 1455 of yacc.c  */
#line 1404 "cfg-grammar.y"
    { log_csv_parser_set_quote_pairs((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 404:

/* Line 1455 of yacc.c  */
#line 1405 "cfg-grammar.y"
    { log_csv_parser_set_null_value((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 405:

/* Line 1455 of yacc.c  */
#line 1409 "cfg-grammar.y"
    { (yyval.num) = log_csv_parser_lookup_flag((yyvsp[(1) - (2)].cptr)) | (yyvsp[(2) - (2)].num); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 406:

/* Line 1455 of yacc.c  */
#line 1410 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 407:

/* Line 1455 of yacc.c  */
#line 1414 "cfg-grammar.y"
    { (yyval.ptr) = g_list_reverse((yyvsp[(1) - (1)].ptr)); }
    break;

  case 408:

/* Line 1455 of yacc.c  */
#line 1418 "cfg-grammar.y"
    { (yyval.ptr) = g_list_append((yyvsp[(2) - (2)].ptr), (yyvsp[(1) - (2)].ptr)); }
    break;

  case 409:

/* Line 1455 of yacc.c  */
#line 1419 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 410:

/* Line 1455 of yacc.c  */
#line 1424 "cfg-grammar.y"
    {
            last_rewrite = log_rewrite_subst_new((yyvsp[(4) - (4)].cptr));
            free((yyvsp[(4) - (4)].cptr));
          }
    break;

  case 411:

/* Line 1455 of yacc.c  */
#line 1429 "cfg-grammar.y"
    {
            if(!log_rewrite_set_regexp(last_rewrite, (yyvsp[(3) - (8)].cptr)))
              YYERROR;
            free((yyvsp[(3) - (8)].cptr));
            (yyval.ptr) = last_rewrite;
          }
    break;

  case 412:

/* Line 1455 of yacc.c  */
#line 1436 "cfg-grammar.y"
    {
            last_rewrite = log_rewrite_set_new((yyvsp[(3) - (3)].cptr));
            free((yyvsp[(3) - (3)].cptr));
          }
    break;

  case 413:

/* Line 1455 of yacc.c  */
#line 1440 "cfg-grammar.y"
    { (yyval.ptr) = last_rewrite; }
    break;

  case 416:

/* Line 1455 of yacc.c  */
#line 1450 "cfg-grammar.y"
    {
            const gchar *p = (yyvsp[(3) - (4)].cptr);
            if (p[0] == '$')
              {
                msg_warning("Value references in rewrite rules should not use the '$' prefix, those are only needed in templates",
                            evt_tag_str("value", (yyvsp[(3) - (4)].cptr)),
                            NULL);
                p++;
              }
            last_rewrite->value_handle = log_msg_get_value_handle(p);
            if (log_msg_is_handle_macro(last_rewrite->value_handle))
              {
                msg_warning("Macros are read-only, they cannot be changed in rewrite rules, falling back to MESSAGE instead",
                            evt_tag_str("macro", p),
                            NULL);
                last_rewrite->value_handle = LM_V_MESSAGE;
              }
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 417:

/* Line 1455 of yacc.c  */
#line 1470 "cfg-grammar.y"
    {
            if (strcmp((yyvsp[(3) - (4)].cptr), "glob") == 0)
              {
                msg_error("Rewrite rules do not support glob expressions",
                          NULL);
                YYERROR;
              }
            log_rewrite_set_matcher(last_rewrite, log_matcher_new((yyvsp[(3) - (4)].cptr)));
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 418:

/* Line 1455 of yacc.c  */
#line 1480 "cfg-grammar.y"
    { log_rewrite_set_flags(last_rewrite, (yyvsp[(3) - (4)].num)); }
    break;

  case 419:

/* Line 1455 of yacc.c  */
#line 1484 "cfg-grammar.y"
    { (yyval.num) = 1; }
    break;

  case 420:

/* Line 1455 of yacc.c  */
#line 1485 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 421:

/* Line 1455 of yacc.c  */
#line 1486 "cfg-grammar.y"
    { (yyval.num) = (yyvsp[(1) - (1)].num); }
    break;

  case 422:

/* Line 1455 of yacc.c  */
#line 1490 "cfg-grammar.y"
    { (yyval.num) = (yyvsp[(1) - (1)].num); }
    break;

  case 423:

/* Line 1455 of yacc.c  */
#line 1491 "cfg-grammar.y"
    { (yyval.num) = 2; }
    break;

  case 426:

/* Line 1455 of yacc.c  */
#line 1497 "cfg-grammar.y"
    { (yyval.cptr) = cfg_lex_get_keyword_string((yyvsp[(1) - (1)].token)); }
    break;

  case 451:

/* Line 1455 of yacc.c  */
#line 1529 "cfg-grammar.y"
    { (yyval.cptr) = (yyvsp[(1) - (1)].cptr); }
    break;

  case 452:

/* Line 1455 of yacc.c  */
#line 1530 "cfg-grammar.y"
    { char buf[32]; snprintf(buf, sizeof(buf), "%" G_GINT64_FORMAT, (yyvsp[(1) - (1)].num)); (yyval.cptr) = strdup(buf); }
    break;

  case 453:

/* Line 1455 of yacc.c  */
#line 1534 "cfg-grammar.y"
    { (yyval.ptr) = g_list_reverse((yyvsp[(1) - (1)].ptr)); }
    break;

  case 454:

/* Line 1455 of yacc.c  */
#line 1538 "cfg-grammar.y"
    { (yyval.ptr) = g_list_append((yyvsp[(2) - (2)].ptr), g_strdup((yyvsp[(1) - (2)].cptr))); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 455:

/* Line 1455 of yacc.c  */
#line 1539 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 456:

/* Line 1455 of yacc.c  */
#line 1544 "cfg-grammar.y"
    {
	    /* return the numeric value of the "level" */
	    int n = syslog_name_lookup_level_by_name((yyvsp[(1) - (1)].cptr));
	    if (n == -1)
	      {
	        msg_error("Unknown priority level",
                          evt_tag_str("priority", (yyvsp[(1) - (1)].cptr)),
                          NULL);
	        YYERROR;
	      }
	    free((yyvsp[(1) - (1)].cptr));
            (yyval.num) = n;
	  }
    break;

  case 457:

/* Line 1455 of yacc.c  */
#line 1561 "cfg-grammar.y"
    {
            /* return the numeric value of facility */
	    int n = syslog_name_lookup_facility_by_name((yyvsp[(1) - (1)].cptr));
	    if (n == -1)
	      {
	        msg_error("Unknown facility",
	                  evt_tag_str("facility", (yyvsp[(1) - (1)].cptr)),
	                  NULL);
                YYERROR;
	      }
	    free((yyvsp[(1) - (1)].cptr));
	    (yyval.num) = n;
	  }
    break;

  case 458:

/* Line 1455 of yacc.c  */
#line 1574 "cfg-grammar.y"
    { (yyval.num) = LOG_SYSLOG; }
    break;



/* Line 1455 of yacc.c  */
#line 5785 "cfg-grammar.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 1675 of yacc.c  */
#line 1578 "cfg-grammar.y"


extern int linenum;

void
yyerror(char *msg)
{
  fprintf(stderr, "%s in %s at line %d.\n\n"
                  "syslog-ng documentation: http://www.balabit.com/support/documentation/?product=syslog-ng\n"
                  "mailing list: https://lists.balabit.hu/mailman/listinfo/syslog-ng\n", msg, cfg_lex_get_current_file(), cfg_lex_get_current_lineno());
}


