.TH "TEXMFSTART" "1" "December 2006" "texmfstart 2.0" "ConTeXt" 
.de URL
\\$2 \(laURL: \\$1 \(ra\\$3
..
.if \n[.g] .mso www.tmac
.de EX
.in +3
.nf
.ft CW
..
.de EE
.in -3
.ft R
.fi
..

.SH "NAME" 
texmfstart \- run ConTeXt scripts, make ConTeXt wrapper scripts, view documents

.SH "SYNOPSIS" 
\fB texmfstart\fP [ \fIoptions ...\fP ] [ \fIfilename\fP ] [ \fIarguments ...\fP ]

.SH "DESCRIPTION" 
ConTeXt is a typesetting system based on 
the .BR tex (1)
family of programs.
.B texmfstart
is a ConTeXt meta-script that can run subordinate
scripts (subscripts?) such as 
.BR texexec (1),
.BR ctxtools (1),
or
.BR pdftools (1).  
It can also generate short wrapper scripts to simplify common uses.
These scripts are often called
.I stubs
in the ConTeXt documentation.  The options control
.BR texmfstart 's
behaviour, and the arguments are passed
to the program identified by
.IR filename .

If the filename is a document, then 
.B texmfstart
will start a viewer for that document.  For example:
.EX
texmfstart showcase.pdf
.EE
will start an appropriate viewer for
.IR showcase.pdf .
See the
.B EXAMPLES
section.

.SH OPTIONS

.SS General:
.TP
.B --help, --version
print version information, usage, and examples.
.TP
.B --verbose
print status and progress information, for example what commands are
being executed.
.TP
.B --clear
don't pass info about locations to child processes.

.SS Running a program:
.TP
.B --arguments=\fIstr\fP
an alternative for providing the arguments to be passed.  For example,
.EX
texmfstart --arguments=b.tex texexec
.EE
will pass
.I b.tex
as the argument to
.BR texexec .
.TP
.B --report
dry run: report what command would be run, but do not run it
.TP
.B --locate
dry run: like \f(CW--report\fP but doesn't print the trailing newline.
.TP
.B --browser
view the document in a web browser (for Windows).
.TP
.B --file=\fIfilename\fP
an alternative way to specify the file (the program to run or document
to open).
.TP
.B --direct
run a program without searching for its location (assumes that the
program is on the PATH).
.TP
.B --execute
use the 
.BR ruby (1)
.I exec
function instead of its
.I system
function.
.TP
.B --program=\fIstr\fP
the program space where
.BR kpsewhich (1)
will search (default: context).  This information is given to
.B kpsewhich
as its \f(CW-progname\fP option.  Usually you don't need this option.

.SS Creating startup scripts:
.TP
.B --make
create a wrapper script or batch file to run the given file.
The wrapper scripts are put in the current path, which usually means
the current directory.  If
\fIall\fP is given as the file, e.g.
.EX
texmfstart --make all
.EE
then make all the ConTeXt wrapper scripts (the stubs).
.TP
.B --windows
when making a wrapper script (stub), create a Windows batch (.bat) file.
Usually you
do not need to specify this option, as 
.B texmfstart
will figure out what operating system you are using.
.TP
.B --linux
when making a wrapper script, create a Unix shell script.  Usually you
do not need to specify this option, as 
.B texmfstart
will figure out what operating system you are using.
.TP
.B --stubpath=\fIpath\fP
specify where to put the wrapper scripts (stubs).
.TP
.B --indirect
always use
.I texmfstart
in the wrapper script (stub).

.SS Document viewing:
.TP
.B --page=\fInumber\fP
open the document at this page.

.SS Environments and paths:
.TP
.B --path=\fIstr\fP
change to the specified path.
.TP
.B --tree=\fIstr\fP
use the given TEXMF tree.
.TP
.B --autotree
automatically determine the TEXMF tree to use (the default).
.TP
.B --environment=\fIstr\fP
use the given environment file.  Its syntax is given in the 
.I mtexmfstart.pdf
manual.
.TP
.B --showenv
print the environment variables known at runtime

.SS Conditional execution:
.TP
.B --iftouched=\fIfile1,file2\fP
run only when the given files have different timestamps.
.TP
.B --ifchanged=\fIstr\fP
run only when the given file has changed (based on its last-computed MD5
checksum).

.SS Special features:
.TP
.B --edit
open the given file in an editor.

.SH "FILENAME PREFIXES"
.SS
Optional prefixes determine the method used to search for the specified file:
.TP
.I bin:filename
expanded name based on the PATH environment variable
.TP
.I kpse:filename
expanded name based on
.BR kpsewhich (1)
result
.TP
.I rel:filename
expanded name relative to the current directory
.TP
.I env:name
expanded pathname based on environment variable
.I name
.TP
.I path:filename
path part of filename as located by 
.BR kpsewhich (1)

.SH EXAMPLES
.TP
\f(CWtexmfstart texexec.rb file.tex\fP
Locate the
.I texexec.rb
script and run it with 
.I file.tex
as its argument.  In other words, make 
.I file.pdf
from 
.IR file.tex .
If 
.BR texexec (1)
is properly installed on your system,
this common invocation can be shortened to 
.EX
\f(CWtexexec file.tex\fP
.EE
.TP
\f(CWtexmfstart texexec file.tex\fP
Locate the
.BR texexec (1)
program (currently a 
.BR ruby (1)
script, 
.IR texexec.rb )
and run it with 
.I file.tex
as its argument, producing 
.I file.pdf.
This invocation can be shortened to 
.EX
texexec file.tex
.EE
.TP
\f(CWtexmfstart ctxtools --updatecontext\fP
Run the 
.BR ctxtools (1)
script, updating the ConTeXt installation.  This
invocation is equivalent to
.EX
ctxtools --updatecontext
.EE
.TP
\f(CWtexmfstart pstopdf --method=3 cow.eps\fP
Convert
.I cow.eps
to PDF using method 3 of
.BR pstopdf (1).
This invocation is equivalent to 
.EX
pstopdf --method=3 cow.eps
.EE
.TP
\f(CWtexmfstart --make --stubpath=/usr/local/bin texexec\fP
Make a wrapper script (stub), either a shell script
.I /usr/local/bin/texexec
on Unix, or a batch file \fI\\usr\\local\\bin\\texexec.bat\fP
on Windows.  On Unix (and maybe on Windows?), you need to make
the script executable; see 
.BR chmod (1).
.TP
\f(CWtexmfstart --edit kpse:cont-sys.tex\fP
Locate and edit the \fIcont-sys.tex\fP configuration file.
.TP
\f(CWtexmfstart --ifchanged=whatever.mp texexec --mpgraphic whatever.mp\fP
Rerun
.B texexec
if
.I whatever.mp
has changed since the last use of 
.IR --ifchanged .
.TP
\f(CWtexmfstart --ifchanged=whatever.mp bin:echo rerun MetaPost\fP
If the
.I whatever.mp
source file has changed since the last use of 
.IR --ifchanged ,
then use the 
.BR echo (1)
command to tell the user to rerun MetaPost
.RB "(see " mpost (1)).
This example shows that 
.B texmfstart
can be used to run any script, not just ConTeXt scripts.  The
\f(CWbin:\fP prefix tells 
.B texmfstart
not to search for 
.I echo
in the TEXMF tree(s), but to assume that it's an executable somewhere 
on the PATH.
.TP
\f(CWtexmfstart --ifchanged=whatever.mp --direct echo rerun MetaPost\fP
This invocation has the same effect as the preceding example, but
using \f(CW--direct\fP instead of the \f(CWbin:\fP prefix, again to tell 
.B texmfstart
not to search for the 
.I echo
command.

.SH FILES
.TP
.I file.md5
MD5 checksum file used for the \f(CW--ifchanged\fP option.

.SH ENVIRONMENT
.TP
PATH
For expanding filenames given with a
.I bin
prefix.
.TP
TEXMFSTART_EDITOR, EDITOR, editor
Editor to use with
.IR --edit .
The environment variables are looked up in that order, with the first
setting found taking priority.

.SH "SEE ALSO" 
.PP
.BR ctxtools (1),
.BR kpsewhich (1),
.BR makempy (1),
.BR mpost (1),
.BR pdftools (1),
.BR pstopdf (1),
.BR texexec (1),
.BR texfont (1),
.BR texutil (1).
.PP
.URL "http://www.contextgarden.net" "ConTeXt wiki" .
.PP
The
.B texmfstart
manual,
.IR mtexmfstart.pdf ,
available from
.URL "http://www.pragma-ade.com/dir/general/manuals/" "PRAGMA ADE" .

.SH BUGS
On Unix, opening a PDF document first tries
.B pdfopen
then 
.BR acroread ,
neither of which may be present on your system.

The \f(CW--report\fP option doesn't work if you specify a filename
prefix (i.e. it does a real run instead of a dry run).

.SH "AUTHOR" 
ConTeXt is written and maintained by 
.URL "http://www.pragma-ade.com" "Hans Hagen" .
This man page, which is in the public domain, was written by Sanjoy
Mahajan <sanjoy@mit.edu> based on the
.I mtexmfstart.pdf
manual.
