/* emacs: -*- Mode: C; c-style: "bsd"; c-basic-offset: 4; c-recognize-knr-p: nil; -*- */
#ifndef TEXTEDITOR_H 
#define TEXTEDITOR_H

#include <qmainwindow.h>
#include <qtextedit.h>
#include <qaction.h>
#include <qfontdatabase.h>
#include <qcombobox.h>


enum EditorState {inactiveEditor,emptyEditor,filledEditor};

class MyTextEdit;

class TextEditor : public QMainWindow {
    Q_OBJECT
public:
    TextEditor();
    ~TextEditor();

	bool isEmpty();
	void setShowWithMain (bool);
	bool showWithMain ();
	void setFontHint(const QString&);
	QString getFontHint();
	QString getFontHintDefault();
	void setFilename (const QString&);
	QString getFilename ();
	void setFilenameHint (const QString&);
	QString getFilenameHint ();
	bool findText(const QString &, const bool &); // find Text 

protected:
	void setupFileActions();
	void setupEditActions();
	void setupFormatActions();
	void setupSettingsActions();
    void closeEvent( QCloseEvent* );
	

public:
	QString getText();

public slots:
	void editorChanged();	// received when text() changed
	void setText(QString);	// set Text (by MapEditor)
	void setInactive();		// Nothing can be entered
	void editCopyAll();

signals:
	void textHasChanged();
	void fontFamilyHasChanged();
	void fontSizeHasChanged();
	
private slots:
    void textLoad();
    void textSaveAs();
    void textSave();
	void textConvertPar();
	void textJoinLines();
	void textExportAsASCII();
    void textPrint();
	void textEditUndo();
    void toggleFonthint();
    void setFixedFont();
    void setVarFont();
    void textBold();
    void textUnderline();
    void textItalic();
    void textFamily( const QString &f );
    void textSize( const QString &p );
	void textColor();
	void textAlign(QAction*);
	void textVAlign();
    void fontChanged( const QFont &f );
    void colorChanged( const QColor &c );
    void alignmentChanged( int a );
    void verticalAlignmentChanged(int a);
	void enableActions();
	void disableActions();

private:
    QPrinter *printer;
    MyTextEdit *e;
	QPoint lastPos;			// save last position of window
    QString filename;
    QString filenameHint;

	QBrush emptyPaper;		// setting the background color
	QBrush filledPaper;		// depending on the state
	QBrush inactivePaper;	// depending on the state
	EditorState state;
	bool showwithmain;		// same visibility as mainwindow?

	QFont varFont;
	QFont fixedFont;
    QComboBox
	*comboFont,
	*comboSize;
	
	QAction *actionFileLoad,
	*actionFileSave,
	*actionFileSaveAs,
	*actionFilePrint,
	*actionEditUndo,
	*actionEditRedo,
	*actionEditCopy,
	*actionEditCut,
	*actionEditPaste,
	*actionEditDeleteAll,
	*actionEditConvertPar,
	*actionEditJoinLines,
	*actionFormatUseFixedFont,
	*actionSettingsVarFont,
	*actionSettingsFixedFont,
	*actionSettingsFonthintDefault,
    *actionTextBold,
	*actionTextUnderline,
	*actionTextItalic,
	*actionTextColor,
	*actionAlignLeft,
	*actionAlignCenter,
	*actionAlignRight,
	*actionAlignJustify,
	*actionAlignSubScript,
	*actionAlignSuperScript;
};

/* Wraps currentVerticalAlignmentChanged(VerticalAlignment)
 * to currentVerticalAlignmentChanged(int) 
 * this way the signal can be used without use of the internal 
 * VerticalAlignment enum of QTextEdit 
 * If VerticalAlignment has been a global like the normal alignment there
 * have been no problems!
 */
 
class MyTextEdit : public QTextEdit 
{
    Q_OBJECT;
 public:
    MyTextEdit(QWidget *parent, const char *name) : QTextEdit(parent, name) {
	connect(this, 
		SIGNAL(currentVerticalAlignmentChanged(VerticalAlignment)),
		this, 
		SLOT(verticalAlignmentChanged(VerticalAlignment)));
    }
    int verticalAlignment() const { return m_verticalAlignment; } 
 signals:
    void currentVerticalAlignmentChanged(int a);
 public slots:
    void verticalAlignmentChanged(VerticalAlignment a) {
     m_verticalAlignment = a;
	emit currentVerticalAlignmentChanged((int)a);
    }
 private: 
 int m_verticalAlignment;
};

#endif
