/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.Collection;

public abstract class TransformedList
extends AbstractEventList
implements ListEventListener {
    protected EventList source;

    protected TransformedList(EventList source) {
        super(source.getPublisher());
        this.source = source;
        this.readWriteLock = source.getReadWriteLock();
    }

    protected int getSourceIndex(int mutationIndex) {
        return mutationIndex;
    }

    protected boolean isWritable() {
        return false;
    }

    public abstract void listChanged(ListEvent var1);

    public void add(int index, Object value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Cannot add at " + index + " on list of size " + this.size());
        }
        int sourceIndex = index < this.size() ? this.getSourceIndex(index) : this.source.size();
        this.source.add(sourceIndex, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection values) {
        this.updates.beginEvent(true);
        try {
            boolean bl = super.addAll(index, values);
            return bl;
        }
        finally {
            this.updates.commitEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.updates.beginEvent(true);
        try {
            super.clear();
        }
        finally {
            this.updates.commitEvent();
        }
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot get at " + index + " on list of size " + this.size());
        }
        return this.source.get(this.getSourceIndex(index));
    }

    public Object remove(int index) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot remove at " + index + " on list of size " + this.size());
        }
        return this.source.remove(this.getSourceIndex(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        this.updates.beginEvent(true);
        try {
            boolean bl = super.removeAll(collection);
            return bl;
        }
        finally {
            this.updates.commitEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection values) {
        this.updates.beginEvent(true);
        try {
            boolean bl = super.retainAll(values);
            return bl;
        }
        finally {
            this.updates.commitEvent();
        }
    }

    public Object set(int index, Object value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List " + this.getClass().getName() + " cannot be modified in the current state");
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot set at " + index + " on list of size " + this.size());
        }
        return this.source.set(this.getSourceIndex(index), value);
    }

    public int size() {
        return this.source.size();
    }

    public void dispose() {
        this.source.removeListEventListener(this);
    }
}

