/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.GroupingList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class UniqueList
extends TransformedList {
    private final GroupingList groupingList;
    private final Comparator comparator;

    public UniqueList(EventList source) {
        this(source, GlazedLists.comparableComparator());
    }

    public UniqueList(EventList source, Comparator comparator) {
        this(new GroupingList(source, comparator), comparator);
    }

    private UniqueList(GroupingList groupingList, Comparator comparator) {
        super(new FunctionList(groupingList, new ListElementZeroFunction(), new WrapInListFunction()));
        this.groupingList = groupingList;
        this.comparator = comparator;
        this.source.addListEventListener(this);
    }

    public int indexOf(Object element) {
        int index = Collections.binarySearch(this.source, element, this.comparator);
        return index < 0 ? -1 : index;
    }

    protected boolean isWritable() {
        return true;
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.forwardEvent(listChanges);
    }

    public int getCount(int index) {
        return this.getAll(index).size();
    }

    public int getCount(Object value) {
        int index = this.indexOf(value);
        return index == -1 ? 0 : this.getCount(index);
    }

    public List getAll(int index) {
        return (List)this.groupingList.get(index);
    }

    public List getAll(Object value) {
        int index = this.indexOf(value);
        return index == -1 ? Collections.EMPTY_LIST : this.getAll(index);
    }

    public void dispose() {
        this.groupingList.dispose();
        ((FunctionList)this.source).dispose();
        super.dispose();
    }

    private static class WrapInListFunction
    implements FunctionList.Function {
        private WrapInListFunction() {
        }

        public Object evaluate(Object x0) {
            Object value = x0;
            return Collections.singletonList(value);
        }
    }

    private static class ListElementZeroFunction
    implements FunctionList.Function {
        private ListElementZeroFunction() {
        }

        public Object evaluate(Object x0) {
            List value = (List)x0;
            return value.get(0);
        }
    }
}

