/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: WordNumbers.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:42:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.tree;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.Name;
import com.sun.xmlsearch.util.*;

public final class WordNumbers {
  private Hashtable _arrays = new Hashtable();
  private Vector _substituted = new Vector();

  public void addNumber(Object key, int n) {
    IntegerArray array = (IntegerArray)_arrays.get(key);
    if (array == null)
      _arrays.put(key, array = new IntegerArray(8));
    array.add(n);
  }
  
  public void revertTree(NodeFactory factory) {
    for (int i = 0; i < _substituted.size(); i++)
      factory.revertToOriginal((Node)_substituted.elementAt(i));
  }

  public void apply(Tokenizer tokenizer,
		    NodeFactory factory,
		    Name highlightedName,
		    Node startHighlight,
		    Node endHighlight) {
    Enumeration keys = _arrays.keys();
    while (keys.hasMoreElements()) {
      Vector children = new Vector();
      Node textNode = (Node)keys.nextElement();
      IntegerArray numbers = (IntegerArray)_arrays.get(textNode);
      numbers.sort();		// word numbers in ascending order
      String text = textNode.getData();
      tokenizer.setText(text);
      int tokenNumber = 0;
      int lastOffset = 0;
      for (int i = 0; i < numbers.cardinality(); i++) {
	int n = numbers.at(i);
	Token token;
	do {
	  token = tokenizer.nextToken();
	}
	while (++tokenNumber < n);
	int start = token.getStart();
	int end   = token.getEnd();
	if (lastOffset < start)
	  children
	    .addElement(factory.makeTextNode(text.substring(lastOffset, start)));
	children.addElement(startHighlight);
	children.addElement(factory.makeTextNode(token.getData()));
	children.addElement(endHighlight);
	lastOffset = end;
      }
      if (lastOffset < text.length())
	children.addElement(factory.makeTextNode(text.substring(lastOffset)));
      Node2[] childrenArray = new Node2[children.size()];
      children.toArray(childrenArray);
      Node highlighted = factory.makeSubstituteElement(highlightedName,
						       childrenArray,
						       textNode);
      Node2 parent = (Node2)textNode.getParent();
      for (int i = 0; i < childrenArray.length; i++)
	((Node2)childrenArray[i]).setParent(highlighted);
      // actually substitute
      int index = parent.getChildIndex(textNode);
      parent.setChild(index, highlighted);
      ((Node2)highlighted).setParent(parent);
      _substituted.addElement(highlighted);
    }
  }
}
