/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: axisobj.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:42:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// header for SdrObjListIter
#ifndef _SVDITER_HXX
#include <svx/svditer.hxx>
#endif
// header for SdrHdlList
#ifndef _SVDHDL_HXX
#include <svx/svdhdl.hxx>
#endif

#include "axisobj.hxx"

// ==================== SchAxisObj ====================

TYPEINIT1( SchAxisObj, SchObjGroup );

SchAxisObj::SchAxisObj( ChartModel *pModel ) :
		SchObjGroup( pModel )
{
}

void SchAxisObj::AddToHdlList( SdrHdlList& rHdlList ) const
{
	// don't use method overloaded by Schgroup
	SdrObject::AddToHdlList( rHdlList );
}

USHORT SchAxisObj::GetHdlCount() const
{
	// there are just two handles: the start and end of the main axis line
	return GetSubList()? 2: 0;
}

SdrHdl* SchAxisObj::GetHdl( USHORT nHdlNum ) const
{
	// return the handles of the first line in the axis group
	SdrObjList* pList = GetSubList();
	if( pList )
	{
		SdrObjListIter aListIter( *this );
		if( aListIter.IsMore() )
		{
			return aListIter.Next()->GetHdl( nHdlNum );
		}
	}

	return NULL;
}

// ==================== Sch3dAxisObj ====================

TYPEINIT1( Sch3dAxisObj, SchE3dObject );

Sch3dAxisObj::Sch3dAxisObj()
		: SchE3dObject()
{
}

void Sch3dAxisObj::AddToHdlList( SdrHdlList& rHdlList ) const
{
	SdrObjList* pList = GetSubList();
	if( pList &&
		pList->GetObjCount() )
	{
		pList->GetObj( 0 )->AddToHdlList( rHdlList );
	}
	else
		E3dObject::AddToHdlList( rHdlList );
}

