/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fudgraut.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:46:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_FUDGRAUT_HXX
#define _SCH_FUDGRAUT_HXX

#include "fupoor.hxx"

/*************************************************************************
|*
|* Funktion fuer Diagramm-Autopiloten
|*
\************************************************************************/

class SchFuDiagramAutoPilot : public SchFuPoor
{
public:
	TYPEINFO();

	SchFuDiagramAutoPilot(SchViewShell* pViewSh, SchWindow* pWin,
						  SchView* pView, ChartModel* pDoc,
						  SfxRequest& rReq);

	virtual void Activate();
	virtual void Deactivate();
	
	/**
		@descr	Check the data range of the chart model with respect to the 
				new chart type.  If the data range does not comply with the
				chart type, one or two warning dialogs are displayed.
			
		@param	pChartModel		Check this models data range.
		@param	nStyle			This is the new chart style.
	*/
	void	CheckRange	(ChartModel * pChartModel,
						SvxChartStyle nStyle);
};

#endif // _SCH_FUDGRAUT_HXX


