/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: groupset.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 09:35:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _GROUPSET_HXX
#define _GROUPSET_HXX

#ifndef _CTRL_HXX
#include <vcl/ctrl.hxx>
#endif
#ifndef _SV_SYMBOL_HXX
#include <vcl/symbol.hxx>
#endif

class MouseEvent;
class TrackingEvent;
class HelpEvent;
class KeyEvent;
class DataChangedEvent;
class ScrollBar;
class ImplGroupSet;
struct ImplGroup;
class Timer;
class NotifyEvent;
class PushButton;

/*************************************************************************

Beschreibung
============

class GroupSet






Querverweise

--------------------------------------------------------------------------

WinBits

WB_GROUPS_MOVEABLE

--------------------------------------------------------------------------

**************************************************************************/

#define GROUPSET_APPEND					0xffff
#define GROUPSET_GROUP_NOTFOUND			0xffff

#define WB_GROUPS_MOVEABLE		WB_WORDBREAK

class GroupSet : public Control
{
friend class ImplGroupSet;

private:
	Link			maSelectHdl;
	Link			maContentScrolledHdl;
	Window*			mpContentWindow;
	USHORT			mnCurGroupId;
	PushButton*		mpUp, *mpDown, *mpLeft, *mpRight;
	PushButton*		mpPageUp, *mpPageDown, *mpPageLeft, *mpPageRight;
	ImplGroupSet*	mpImpl;

#ifdef _GROUPSET_CXX
	void			ImplFormat( BOOL bForce = FALSE,
								BOOL bInvalidateChangedRects = FALSE );
	void			ImplInvalidateGroup( ImplGroup& );
	void			ImplInitSettings();
	void			ImplStartDrag( const Point& rPosPixel, BOOL bCommand );
	void			ImplEndDrag( BOOL bCancel );
	void			ImplDrag( const Point& rPosPixel );
	void			ImplDrawGroup( USHORT nPos, BOOL bHigh, BOOL bDrag,
						BOOL bClipIt = FALSE, const Rectangle* pRect = 0);
	BOOL			ImplInDrag() const;
	PushButton* 	ImplCreateButton( SymbolType eSymbol, const Link& rHdl );
	void 			ImplCreateButtons( int bUp, int bDown, int bLeft, int bRight );
	void 			ImplPositionButtons();
	void			ImplReleaseScrollButtons();
	void			ImplUpdateScrollButtons();
	void 			ImplDrawMoveToEmphasis( USHORT nPos, BOOL bShow );
	void			ImplSetMoveToPos( USHORT nPos = GROUPSET_GROUP_NOTFOUND );

					DECL_LINK( ImplDropTimeoutHdl, Timer* );
					DECL_LINK( ImplEditedHdl, void* );
					DECL_LINK( ImplScrollBtnClickHdl, PushButton* );
#endif

protected:

	virtual void	Resize();
	virtual void	Paint( const Rectangle& );
	virtual void	RequestHelp( const HelpEvent& rHEvt );
	virtual void	StateChanged( StateChangedType nStateChange );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
	virtual void	MouseMove( const MouseEvent& rMEvt );
	virtual void	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void	MouseButtonUp( const MouseEvent& rMEvt );
	virtual void	Tracking( const TrackingEvent& rTEvt );
	virtual BOOL	QueryDrop( DropEvent& rDEvt );
	virtual BOOL	Drop( const DropEvent& rDEvt );
	virtual long	PreNotify( NotifyEvent& rNEvt );
	virtual BOOL	GroupRenamed( USHORT nGroupId, const XubString& rStr );
	virtual void	ContentWindowScrolled();
	virtual void	SetContentWindowPosSizePixel(
						const Point& rPos,
						const Size& rSize );

	// Default-Impl. ruft SetGroupPos
	virtual void	MoveGroup( USHORT nGroupId, USHORT nPos );

public:
					GroupSet( Window* pParent,
							  WinBits nWinStyle = WB_BORDER );
					GroupSet( Window* pParent, const ResId& rResId );
					~GroupSet();

	virtual void	Select();
	virtual void 	Command( const CommandEvent& rCEvt );

	void			InsertGroup( USHORT nGroupId, const XubString& rStr,
								USHORT nPos = GROUPSET_APPEND );
	void			InsertGroup( USHORT nGroupId, const XubString& rStr,
								const Image& rImage,
								USHORT nPos = GROUPSET_APPEND );

	void			RemoveGroup( USHORT nGroupId, BOOL bAutoSelect = TRUE);

	void			Clear();

	USHORT			GetGroupCount() const;
	USHORT			GetGroupPos( USHORT nGroupId ) const;
	BOOL			SetGroupPos( USHORT nGroupId, USHORT nNewPos );
	USHORT			GetGroupId( USHORT nPos ) const;
	USHORT			GetGroupId( const Point& rPosPixel ) const;
	USHORT			GetGroupPos( const Point& rPosPixel ) const;
	Rectangle		GetGroupRect( USHORT nGroupId ) const;

	void			SetCurGroupId( USHORT nGroupId );
	USHORT			GetCurGroupId() const { return mnCurGroupId; }

	void			SetGroupText( USHORT nGroupId, const XubString& rStr );
	XubString		GetGroupText( USHORT nGroupId ) const;
	void			SetGroupImage( USHORT nGroupId, const Image& rImage );
	Image			GetGroupImage( USHORT nGroupId ) const;
	void			SetGroupData( USHORT nGroupId, void* pData );
	void*			GetGroupData( USHORT nGroupId ) const;

	void			SetGroupHelpId( USHORT nGroupId, ULONG nHelpId );
	void			SetGroupHelpText( USHORT nGroupId, const XubString& rStr );
	ULONG			GetGroupHelpId( USHORT nGroupId ) const;
	XubString		GetGroupHelpText( USHORT nGroupId ) const;

	void			SetSelectHdl( const Link& rLink ) { maSelectHdl = rLink; }
	const Link& 	GetSelectHdl() const { return maSelectHdl; }

	void			SetContentWindow( Window* pWindow );
	Window* 		GetContentWindow() const { return mpContentWindow; }
	const Point&	GetContentWindowPos() const;
	const Size&		GetContentWindowSize() const;
	// Setzt die Dokumentgroesse des angezeigten Content-Windows
	void			SetContentWindowArea( const Rectangle& );
	// Setzt die im Control sichtbare Teilflaeche des Dokumentes
	void			SetContentWindowVisArea( const Rectangle& );
	// Setzt die Offsets fuer horizontales & vertikales Scrollen
	void			SetContentWindowLineSize( const Size& );
	void			SetContentWindowPageSize( const Size& );
	void			SetContentWindowScrolledHdl( const Link& rLink )
						{ maContentScrolledHdl = rLink; }
	Rectangle		GetContentWindowArea() const;
	Rectangle		GetContentWindowVisArea() const;
	Size			GetContentWindowLineSize() const;
	Size			GetContentWindowPageSize() const;
	const Link& 	GetContentWindowScrolledHdl() const
						{ return maContentScrolledHdl; }

	void			RenameGroup( USHORT nGroupId, const String* pText = 0 );
	BOOL			IsRenamingGroup() const;
	void			EndRenamingGroup( BOOL bCancel );

	USHORT			GetMovePos( const Point&, USHORT nCurGroupId = GROUPSET_GROUP_NOTFOUND ) const;
};


#endif	// _GROUPSET_HXX
