/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: impl_struct.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:26:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_IMPL_STRUCT_HXX
#define UDM_IMPL_STRUCT_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/i_struct.hxx>
	// COMPONENTS
	// PARAMETERS
#include <udm/keyset.hxx>
#include <udm/tt_struct.hxx>


namespace udm
{

template <class SRC>
inline const struct_traits<SRC> &
TStruct<SRC>::my_traits() const
{
 	return static_cast< const struct_traits<SRC> & >(type_traits<SRC>::get_());
}

template <class SRC>
void
TStruct<SRC>::do_Dispose()
{
 	delete this;
}

template <class SRC>
member_id
TStruct<SRC>::size() const
{
 	return aMembers.size(); 
}

template <class SRC>
Object
TStruct<SRC>::inq_Member( member_id i_m ) const
{
    if ( i_m < aMembers.size() AND pObj != 0 )
    {
        if (aMembers[i_m])
        {
            return aMembers[i_m];
        }
        else
        {
            return aMembers[i_m]
                = my_traits().create_member_data_for(i_m, *pObj);
        }
    }
    return Object();
}

template <class SRC>
Object
TStruct<SRC>::inq_SearchByKey( int i_nKey ) const
{
    const KeySet<SRC> * pKeys = my_traits().get_keyset();
    return pKeys != 0
            ?   pKeys->search_by_key( i_nKey, *this )
            :   Object();
}

}   // namespace udm


#endif


