/*
 * XMoveMouseCompact.java
 *
 * Created on 6. M?rz 2003, 14:58
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.util.Hashtable;

/**
 * Mouse movement handling interface.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public interface XMoveMouseCompact {
    /**
     * Move mouse to Accessibility object.
     *
     * @param Accessibility object path
     */
    public void moveMousetoObject(String[] path);

    /**
     * Move mouse to Accessibility object and click.
     *
     * @param Accessibility object path
     */
    public void moveMousetoObject_Click(String[] path);

    /**
     * Move mouse to Accessibility object and click.
     *
     * @param Accessibility object path
     * @param Click type are 'LEFT', 'RIGHT' or 'CENTER'
     * @param Time to click in milliseconds
     */
    public void moveMousetoObject_Click(String[] path, String mousClickTyp, int mouseClickTime);

    /**
     * DOCUMENT ME!
     *
     * @param path DOCUMENT ME!
     * @param mouseSleepTime DOCUMENT ME!
     */
    public void moveMousetoObject_Time(String[] path, int mouseSleepTime);

    /**
     * DOCUMENT ME!
     *
     * @param path DOCUMENT ME!
     * @param mouseSleepTime DOCUMENT ME!
     */
    public void moveMousetoObject_Click_Time(String[] path, int mouseSleepTime);

    /**
     * DOCUMENT ME!
     *
     * @param path DOCUMENT ME!
     * @param mousClickTyp DOCUMENT ME!
     * @param mouseClickTime DOCUMENT ME!
     * @param mouseSleepTime DOCUMENT ME!
     */
    public void moveMousetoObject_Click_Time(String[] path, String mousClickTyp, int mouseClickTime, int mouseSleepTime);

    /**
     * This class returns the methods of this interface. This class is very important for
     * the TutorialCreator class.
     *
     * @author $author$
     * @version $Revision: 1.3 $
     */
    public class XMoveMouseCompactMethods {
        private static final Hashtable m_xhash;

        static {
            m_xhash = getXMoveMouseCompact();
        }

        /**
         * Get methods.
         *
         * @return hashtable
         */
        public static Hashtable getMethods() {
            return m_xhash;
        }

        /**
         * Creates the hashtable with all methods of this interface.
         *
         * @return hashtable
         */
        private static Hashtable getXMoveMouseCompact() {
            String[][] moveMousetoObject = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject" }, {
                    "path", "" }
            };

            String[][] moveMousetoObject_Click = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_Click" }, {
                    "path", "" }
            };

            String[][] moveMousetoObject_Click1 = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_Click" }, {
                    "path", "" }, {
                    "mousClickTyp", "" }, {
                    "mouseClickTime", "" }
            };

            String[][] moveMousetoObject_Time = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_Time" }, {
                    "path", "" }, {
                    "mouseSleepTime", "" }
            };

            String[][] moveMousetoObject_Click_Time = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_Click_Time" }, {
                    "path", "" }, {
                    "mouseSleepTime", "" }
            };

            String[][] moveMousetoObject_Click_Time1 = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_Click_Time" }, {
                    "path", "" }, {
                    "mousClickTyp", "" }, {
                    "mouseClickTime", "" }, {
                    "mouseSleepTime", "" }
            };

            Hashtable xmoveMouseCompact = new Hashtable();
            xmoveMouseCompact.put("moveMouse", moveMousetoObject);
            xmoveMouseCompact.put("moveMouseClick", moveMousetoObject_Click);
            xmoveMouseCompact.put("moveMouseClick with TYP and TIME", moveMousetoObject_Click1);
            xmoveMouseCompact.put("moveMouse with sleep Time", moveMousetoObject_Time);
            xmoveMouseCompact.put("moveMouseClick with sleep Time", moveMousetoObject_Click_Time);
            xmoveMouseCompact.put("moveMouseClick with TYP, click TIME and sleep Time", moveMousetoObject_Click_Time1);

            return xmoveMouseCompact;
        }
    }
}
