/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccessibleChartElement.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:39:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SCH_ACCESSIBLECHARTELEMENT_HXX_
#define _SCH_ACCESSIBLECHARTELEMENT_HXX_

#ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLEEXTENDEDCOMPONENT_HPP_
#include <com/sun/star/accessibility/XAccessibleExtendedComponent.hpp>
#endif

#ifndef _SCH_ACCESSIBLEBASE_HXX_
#include "AccessibleBase.hxx"
#endif
// auto strip #ifndef _SFXITEMSET_HXX 
// auto strip #include <svtools/itemset.hxx>
// auto strip #endif
class SfxItemSet;
namespace binfilter {


class SdrObject;

namespace accessibility
{

/** Class for all Chart Accessiblilty objects except the document-view (see
    AccessibleDocumentView)

    by deriving from AccessibleBase this class supports:

    ::com::sun::star::lang::XTypeProvider
    ::com::sun::star::lang::XComponent,
    ::com::sun::star::accessibility::XAccessible,
    ::com::sun::star::accessibility::XAccessibleContext,
    ::com::sun::star::accessibility::XAccessibleComponent,    
    ::com::sun::star::lang::XServiceInfo,
    ::com::sun::star::uno::XEventListener

    additionally this class implements

    ::com::sun::star::accessibility::XAccessibleExtendedComponent
 */
class AccessibleChartElement : public AccessibleBase,
    public ::com::sun::star::accessibility::XAccessibleExtendedComponent
{
public:
	AccessibleChartElement( const AccessibleUniqueId & rId,
                            AccessibleBase * pParent,
                            bool bMayHaveChildren = false,
                            bool bAlwaysTransparent = false );
	virtual ~AccessibleChartElement();

    // ________ AccessibleBase ________
    virtual bool NotifyEvent( EventType eType,
                              const AccessibleUniqueId & rId,
                              const SfxHint * pHint );

    // ________ XInterface ________
    virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type& aType ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL acquire() throw ();
    virtual void SAL_CALL release() throw ();

    // ________ XTypeProvider ________
    virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL getImplementationId() throw (::com::sun::star::uno::RuntimeException);

    // ________ XServiceInfo ________
    virtual ::rtl::OUString SAL_CALL getImplementationName() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames() throw (::com::sun::star::uno::RuntimeException);

    // ________ XComponent ________
    virtual void SAL_CALL dispose() throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleContext ________
    virtual ::rtl::OUString SAL_CALL getAccessibleDescription() throw (::com::sun::star::uno::RuntimeException);
    virtual ::rtl::OUString SAL_CALL getAccessibleName() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleStateSet > SAL_CALL getAccessibleStateSet() throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleExtendedComponent ________
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::awt::XFont > SAL_CALL getFont() throw (::com::sun::star::uno::RuntimeException);
    virtual ::rtl::OUString SAL_CALL getTitledBorderText() throw (::com::sun::star::uno::RuntimeException);
    virtual ::rtl::OUString SAL_CALL getToolTipText() throw (::com::sun::star::uno::RuntimeException);

    // the following interface is implemented in AccessibleBase, however it is
    // also a (non-virtual) base class of XAccessibleExtendedComponent Thus
    // these methods have to be overloaded and forward to AccessibleBase

    // ________ XAccessibleComponent ________
    virtual sal_Bool SAL_CALL containsPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleAtPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::awt::Rectangle SAL_CALL getBounds() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::awt::Point SAL_CALL getLocation() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::awt::Point SAL_CALL getLocationOnScreen() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::awt::Size SAL_CALL getSize() throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL grabFocus() throw (::com::sun::star::uno::RuntimeException);
    virtual sal_Int32 SAL_CALL getForeground() throw (::com::sun::star::uno::RuntimeException);
    virtual sal_Int32 SAL_CALL getBackground() throw (::com::sun::star::uno::RuntimeException);

protected:
    /** This method should be overloaded to return an object in the drawing
        layer representing the current object.  It is only used temporarily.
     */
    virtual SdrObject * GetDrawObject() const;

    /** A copy of this ItemSet is used to get foreground and background colors
     */
    void SetItemSet( const SfxItemSet & pNewItemSet );

    /** @return the current internal item set.  Note that this is an immutable
                copy of the item set given in SetItemSet.
     */
    const SfxItemSet * GetItemSet() const;

private:
    const SfxItemSet *  m_pItemSet;
    const bool          m_bAlwaysTransparent;
    /** denotes if the state-set is initialized.  On initialization the selected
        state is checked.

        This variable is monitored by the solar mutex!

        Note: declared volatile to enable double-check-locking
     */
    volatile bool       m_bStateSetInitialized;
};
 
}  // namespace accessibility

// _SCH_ACCESSIBLECHARTELEMENT_HXX_
} //namespace binfilter
#endif
