/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: accessibility.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:58:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _ACCESSIBILITY_HXX_
#define _ACCESSIBILITY_HXX_

//STRIP001 //#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
//STRIP001 //#include <com/sun/star/lang/XComponent.hpp>
//STRIP001 //#endif
//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLE_HPP_
//STRIP001 #include <com/sun/star/accessibility/XAccessible.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLECOMPONENT_HPP_
//STRIP001 #include <com/sun/star/accessibility/XAccessibleComponent.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLECONTEXT_HPP_
//STRIP001 #include <com/sun/star/accessibility/XAccessibleContext.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLETEXT_HPP_
//STRIP001 #include <com/sun/star/accessibility/XAccessibleText.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLEEVENTBROADCASTER_HPP_
//STRIP001 #include <com/sun/star/accessibility/XAccessibleEventBroadcaster.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
//STRIP001 #include <com/sun/star/accessibility/AccessibleEventId.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_lang_XSERVICEINFO_HPP_
//STRIP001 #include <com/sun/star/lang/XServiceInfo.hpp>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
//STRIP001 #include <com/sun/star/uno/Reference.h>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _OSL_MUTEX_HXX_
//STRIP001 #include <osl/mutex.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _CPPUHELPER_INTERFACECONTAINER_H_
//STRIP001 #include <cppuhelper/interfacecontainer.h>
//STRIP001 #endif
//STRIP001 #ifndef _CPPUHELPER_IMPLBASE5_HXX_
//STRIP001 #include <cppuhelper/implbase5.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _CPPUHELPER_IMPLBASE6_HXX_
//STRIP001 #include <cppuhelper/implbase6.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXBRDCST_HXX
//STRIP001 #include <svtools/brdcst.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include <bf_svx/editeng.hxx>
//STRIP001 
//STRIP001 #ifndef _SVX_UNOEDSRC_HXX
//STRIP001 #include <bf_svx/unoedsrc.hxx> // SvxEditSource, SvxTextForwarder, SvxViewForwarder, SvxEditViewForwarder
//STRIP001 #endif
//STRIP001 #ifndef _SVX_ACCESSILE_TEXT_HELPER_HXX_
//STRIP001 #include <bf_svx/AccessibleTextHelper.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 class Window; 
//STRIP001 class SmGraphicWindow;
//STRIP001 class SmEditWindow;
//STRIP001 class SmDocShell;
//STRIP001 
//STRIP001 namespace com { namespace sun { namespace star { namespace accessibility {
//STRIP001 struct AccessibleEventObject;
//STRIP001 }}}};
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////
//STRIP001 //
//STRIP001 // classes and helper-classes used for accessibility in the graphic-window
//STRIP001 //
//STRIP001 
//STRIP001 typedef
//STRIP001 cppu::WeakImplHelper6
//STRIP001     <
//STRIP001         ::com::sun::star::lang::XServiceInfo,
//STRIP001         ::com::sun::star::accessibility::XAccessible,
//STRIP001         ::com::sun::star::accessibility::XAccessibleComponent,
//STRIP001         ::com::sun::star::accessibility::XAccessibleContext,
//STRIP001         ::com::sun::star::accessibility::XAccessibleText,
//STRIP001         ::com::sun::star::accessibility::XAccessibleEventBroadcaster
//STRIP001     >
//STRIP001 SmGraphicAccessibleBaseClass;
//STRIP001 
//STRIP001 class SmGraphicAccessible :
//STRIP001     public SmGraphicAccessibleBaseClass
//STRIP001 {
//STRIP001     //vos::ORefCount    aRefCount;  // number of references to object
//STRIP001     osl::Mutex                          aListenerMutex;
//STRIP001     String                              aAccName;
//STRIP001     /// client id in the AccessibleEventNotifier queue
//STRIP001     sal_uInt32                          nClientId;
//STRIP001 
//STRIP001     SmGraphicWindow     *pWin;
//STRIP001 
//STRIP001     // disallow copy-ctor and assignment-operator for now
//STRIP001     SmGraphicAccessible( const SmGraphicAccessible & );
//STRIP001     SmGraphicAccessible & operator = ( const SmGraphicAccessible & );
//STRIP001 
//STRIP001 protected:
//STRIP001     SmDocShell *    GetDoc_Impl();
//STRIP001     String          GetAccessibleText_Impl();
//STRIP001 
//STRIP001 public:
//STRIP001     SmGraphicAccessible( SmGraphicWindow *pGraphicWin );
//STRIP001     virtual ~SmGraphicAccessible();
//STRIP001 
//STRIP001     SmGraphicWindow *   GetWin()    { return pWin; }
//STRIP001     void                ClearWin();     // to be called when view is destroyed
//STRIP001     void                LaunchEvent(
//STRIP001                             const sal_Int16 nAccesibleEventId,
//STRIP001                             const ::com::sun::star::uno::Any &rOldVal,
//STRIP001                             const ::com::sun::star::uno::Any &rNewVal);
//STRIP001 
//STRIP001     // XAccessible
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleContext > SAL_CALL getAccessibleContext(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     // XAccessibleComponent
//STRIP001     virtual sal_Bool SAL_CALL containsPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleAtPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Rectangle SAL_CALL getBounds(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Point SAL_CALL getLocation(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Point SAL_CALL getLocationOnScreen(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Size SAL_CALL getSize(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual void SAL_CALL grabFocus(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getForeground(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getBackground(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     // XAccessibleContext
//STRIP001     virtual sal_Int32 SAL_CALL getAccessibleChildCount(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleChild( sal_Int32 i ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleParent(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getAccessibleIndexInParent(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int16 SAL_CALL getAccessibleRole(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::rtl::OUString SAL_CALL getAccessibleDescription(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::rtl::OUString SAL_CALL getAccessibleName(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleRelationSet > SAL_CALL getAccessibleRelationSet(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleStateSet > SAL_CALL getAccessibleStateSet(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::lang::Locale SAL_CALL getLocale(  ) throw (::com::sun::star::accessibility::IllegalAccessibleComponentStateException, ::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     // XAccessibleEventBroadcaster
//STRIP001     virtual void SAL_CALL addEventListener( const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleEventListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual void SAL_CALL removeEventListener( const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleEventListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     // XAccessibleText
//STRIP001     virtual sal_Int32 SAL_CALL getCaretPosition(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Bool SAL_CALL setCaretPosition ( sal_Int32 nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Unicode SAL_CALL getCharacter( sal_Int32 nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > SAL_CALL getCharacterAttributes( sal_Int32 nIndex, const ::com::sun::star::uno::Sequence< ::rtl::OUString >& aRequestedAttributes ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Rectangle SAL_CALL getCharacterBounds( sal_Int32 nIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getCharacterCount(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getIndexAtPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::rtl::OUString SAL_CALL getSelectedText(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getSelectionStart(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getSelectionEnd(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Bool SAL_CALL setSelection( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::rtl::OUString SAL_CALL getText(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::rtl::OUString SAL_CALL getTextRange( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::accessibility::TextSegment SAL_CALL getTextAtIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::accessibility::TextSegment SAL_CALL getTextBeforeIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::accessibility::TextSegment SAL_CALL getTextBehindIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Bool SAL_CALL copyText( sal_Int32 nStartIndex, sal_Int32 nEndIndex ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     // XServiceInfo
//STRIP001     virtual ::rtl::OUString SAL_CALL getImplementationName(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Bool SAL_CALL supportsService( const ::rtl::OUString& ServiceName ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 };
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////
//STRIP001 //
//STRIP001 // classes and helper-classes used for accessibility in the command-window
//STRIP001 //
//STRIP001 
//STRIP001 class SmEditSource;
//STRIP001 class EditEngine;
//STRIP001 class EditView;
//STRIP001 class SvxFieldItem;
//STRIP001 struct ESelection;
//STRIP001 
//STRIP001 
//STRIP001 class SmViewForwarder :
//STRIP001     public SvxViewForwarder
//STRIP001 {
//STRIP001     EditView &          rEditView;
//STRIP001 
//STRIP001     // disallow copy-ctor and assignment-operator for now
//STRIP001     SmViewForwarder( const SmViewForwarder & );
//STRIP001     SmViewForwarder & operator = ( const SmViewForwarder & );
//STRIP001 
//STRIP001 public:
//STRIP001                         SmViewForwarder( EditView &rView );
//STRIP001     virtual             ~SmViewForwarder();
//STRIP001 
//STRIP001     virtual BOOL        IsValid() const;
//STRIP001     virtual Rectangle   GetVisArea() const;
//STRIP001     virtual Point       LogicToPixel( const Point& rPoint, const MapMode& rMapMode ) const;
//STRIP001     virtual Point       PixelToLogic( const Point& rPoint, const MapMode& rMapMode ) const;
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 class SmTextForwarder :     /* analog to SvxEditEngineForwarder */
//STRIP001     public SvxTextForwarder
//STRIP001 {
//STRIP001     EditEngine &        rEditEngine;
//STRIP001     SmEditSource &      rEditSource;
//STRIP001 
//STRIP001     DECL_LINK( NotifyHdl, EENotify * );
//STRIP001 
//STRIP001     // disallow copy-ctor and assignment-operator for now
//STRIP001     SmTextForwarder( const SmTextForwarder & );
//STRIP001     SmTextForwarder & operator = ( const SmTextForwarder & );
//STRIP001 
//STRIP001 public:
//STRIP001     SmTextForwarder( EditEngine& rEngine, SmEditSource & rSource );
//STRIP001     virtual ~SmTextForwarder();
//STRIP001 
//STRIP001 	virtual USHORT		GetParagraphCount() const;
//STRIP001 	virtual USHORT		GetTextLen( USHORT nParagraph ) const;
//STRIP001 	virtual String		GetText( const ESelection& rSel ) const;
//STRIP001 	virtual SfxItemSet	GetAttribs( const ESelection& rSel, BOOL bOnlyHardAttrib = EditEngineAttribs_All ) const;
//STRIP001 	virtual	SfxItemSet	GetParaAttribs( USHORT nPara ) const;
//STRIP001 	virtual void		SetParaAttribs( USHORT nPara, const SfxItemSet& rSet );
//STRIP001 	virtual void		GetPortions( USHORT nPara, SvUShorts& rList ) const;
//STRIP001 
//STRIP001 	virtual USHORT		GetItemState( const ESelection& rSel, USHORT nWhich ) const;
//STRIP001 	virtual USHORT		GetItemState( USHORT nPara, USHORT nWhich ) const;
//STRIP001 
//STRIP001 	virtual void		QuickInsertText( const String& rText, const ESelection& rSel );
//STRIP001 	virtual void		QuickInsertField( const SvxFieldItem& rFld, const ESelection& rSel );
//STRIP001 	virtual void		QuickSetAttribs( const SfxItemSet& rSet, const ESelection& rSel );
//STRIP001 	virtual void		QuickInsertLineBreak( const ESelection& rSel );
//STRIP001 
//STRIP001 	virtual SfxItemPool* GetPool() const;
//STRIP001 
//STRIP001 	virtual XubString    CalcFieldValue( const SvxFieldItem& rField, USHORT nPara, USHORT nPos, Color*& rpTxtColor, Color*& rpFldColor );
//STRIP001 	virtual BOOL		 IsValid() const;
//STRIP001 
//STRIP001     virtual LanguageType 	GetLanguage( USHORT, USHORT ) const;
//STRIP001     virtual USHORT			GetFieldCount( USHORT nPara ) const;
//STRIP001     virtual EFieldInfo		GetFieldInfo( USHORT nPara, USHORT nField ) const;
//STRIP001     virtual EBulletInfo     GetBulletInfo( USHORT nPara ) const;
//STRIP001     virtual Rectangle		GetCharBounds( USHORT nPara, USHORT nIndex ) const;
//STRIP001     virtual Rectangle		GetParaBounds( USHORT nPara ) const;
//STRIP001     virtual MapMode			GetMapMode() const;
//STRIP001 	virtual OutputDevice*	GetRefDevice() const;
//STRIP001     virtual sal_Bool		GetIndexAtPoint( const Point&, USHORT& nPara, USHORT& nIndex ) const;
//STRIP001     virtual sal_Bool		GetWordIndices( USHORT nPara, USHORT nIndex, USHORT& nStart, USHORT& nEnd ) const;
//STRIP001     virtual sal_Bool 		GetAttributeRun( USHORT& nStartIndex, USHORT& nEndIndex, USHORT nPara, USHORT nIndex ) const;
//STRIP001     virtual USHORT			GetLineCount( USHORT nPara ) const;
//STRIP001     virtual USHORT			GetLineLen( USHORT nPara, USHORT nLine ) const;
//STRIP001     virtual sal_Bool		Delete( const ESelection& );
//STRIP001     virtual sal_Bool		InsertText( const String&, const ESelection& );
//STRIP001     virtual sal_Bool		QuickFormatDoc( BOOL bFull=FALSE );
//STRIP001 
//STRIP001     virtual USHORT          GetDepth( USHORT nPara ) const;
//STRIP001     virtual sal_Bool        SetDepth( USHORT nPara, USHORT nNewDepth );
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 class SmEditViewForwarder :     /* analog to SvxEditEngineViewForwarder */
//STRIP001     public SvxEditViewForwarder
//STRIP001 {
//STRIP001     EditView &          rEditView;
//STRIP001 
//STRIP001     // disallow copy-ctor and assignment-operator for now
//STRIP001     SmEditViewForwarder( const SmEditViewForwarder & );
//STRIP001     SmEditViewForwarder & operator = ( const SmEditViewForwarder & );
//STRIP001 
//STRIP001 public:
//STRIP001                         SmEditViewForwarder( EditView& rView );
//STRIP001     virtual             ~SmEditViewForwarder();
//STRIP001 
//STRIP001 	virtual BOOL		IsValid() const;
//STRIP001 
//STRIP001     virtual Rectangle	GetVisArea() const;
//STRIP001     virtual Point		LogicToPixel( const Point& rPoint, const MapMode& rMapMode ) const;
//STRIP001     virtual Point		PixelToLogic( const Point& rPoint, const MapMode& rMapMode ) const;
//STRIP001 
//STRIP001     virtual sal_Bool	GetSelection( ESelection& rSelection ) const;
//STRIP001     virtual sal_Bool	SetSelection( const ESelection& rSelection );
//STRIP001     virtual sal_Bool	Copy();
//STRIP001     virtual sal_Bool	Cut();
//STRIP001     virtual sal_Bool	Paste();
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 class SmEditSource :
//STRIP001     public SvxEditSource
//STRIP001 {
//STRIP001     SfxBroadcaster          aBroadCaster;
//STRIP001     SmViewForwarder         aViewFwd;
//STRIP001     SmTextForwarder         aTextFwd;
//STRIP001     SmEditViewForwarder     aEditViewFwd;
//STRIP001 
//STRIP001     EditEngine &            rEditEngine;
//STRIP001     EditView &              rEditView;
//STRIP001 
//STRIP001     // disallow copy-ctor and assignment-operator for now
//STRIP001     SmEditSource( const SmEditSource &rSrc );
//STRIP001     SmEditSource & operator = ( const SmEditSource & );
//STRIP001 
//STRIP001 public:
//STRIP001             SmEditSource( SmEditWindow *pWin, EditEngine &rEditEngine, EditView &rEditView );
//STRIP001     virtual ~SmEditSource();
//STRIP001 
//STRIP001     virtual SvxEditSource*      Clone() const;
//STRIP001     virtual SvxTextForwarder*   GetTextForwarder();
//STRIP001  	virtual SvxViewForwarder*	GetViewForwarder();
//STRIP001  	virtual SvxEditViewForwarder*	GetEditViewForwarder( sal_Bool bCreate = sal_False );
//STRIP001     virtual void                UpdateData();
//STRIP001     virtual SfxBroadcaster&		GetBroadcaster() const;
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 typedef
//STRIP001 cppu::WeakImplHelper5
//STRIP001     <
//STRIP001         ::com::sun::star::lang::XServiceInfo,
//STRIP001         ::com::sun::star::accessibility::XAccessible,
//STRIP001         ::com::sun::star::accessibility::XAccessibleComponent,
//STRIP001         ::com::sun::star::accessibility::XAccessibleContext,
//STRIP001         ::com::sun::star::accessibility::XAccessibleEventBroadcaster
//STRIP001     >
//STRIP001 SmEditAccessibleBaseClass;
//STRIP001 
//STRIP001 class SmEditAccessible :
//STRIP001     public SmEditAccessibleBaseClass
//STRIP001 {
//STRIP001     osl::Mutex                              aListenerMutex;
//STRIP001     String                                  aAccName;
//STRIP001     ::accessibility::AccessibleTextHelper    *pTextHelper;
//STRIP001     SmEditWindow                           *pWin;
//STRIP001 
//STRIP001     // disallow copy-ctor and assignment-operator for now
//STRIP001     SmEditAccessible( const SmEditAccessible & );
//STRIP001     SmEditAccessible & operator = ( const SmEditAccessible & );
//STRIP001 
//STRIP001 protected:
//STRIP001     SmDocShell *    GetDoc_Impl();
//STRIP001 
//STRIP001 public:
//STRIP001     SmEditAccessible( SmEditWindow *pEditWin );
//STRIP001     virtual ~SmEditAccessible();
//STRIP001 
//STRIP001     ::accessibility::AccessibleTextHelper *   GetTextHelper() { return pTextHelper; }
//STRIP001 
//STRIP001     void                Init();
//STRIP001     SmEditWindow *      GetWin()    { return pWin; }
//STRIP001     void                ClearWin();     // to be called when view is destroyed
//STRIP001 
//STRIP001     // XAccessible
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleContext > SAL_CALL getAccessibleContext(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     // XAccessibleComponent
//STRIP001     virtual sal_Bool SAL_CALL containsPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleAtPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Rectangle SAL_CALL getBounds(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Point SAL_CALL getLocation(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Point SAL_CALL getLocationOnScreen(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Size SAL_CALL getSize(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual void SAL_CALL grabFocus(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getForeground(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getBackground(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     // XAccessibleContext
//STRIP001     virtual sal_Int32 SAL_CALL getAccessibleChildCount(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleChild( sal_Int32 i ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleParent(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getAccessibleIndexInParent(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int16 SAL_CALL getAccessibleRole(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::rtl::OUString SAL_CALL getAccessibleDescription(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::rtl::OUString SAL_CALL getAccessibleName(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleRelationSet > SAL_CALL getAccessibleRelationSet(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleStateSet > SAL_CALL getAccessibleStateSet(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::lang::Locale SAL_CALL getLocale(  ) throw (::com::sun::star::accessibility::IllegalAccessibleComponentStateException, ::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     // XAccessibleEventBroadcaster
//STRIP001     virtual void SAL_CALL addEventListener( const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleEventListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual void SAL_CALL removeEventListener( const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleEventListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     // XServiceInfo
//STRIP001     virtual ::rtl::OUString SAL_CALL getImplementationName(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Bool SAL_CALL supportsService( const ::rtl::OUString& ServiceName ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 };

//////////////////////////////////////////////////////////////////////

#endif

