/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: galobj.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:53:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVX_GALOBJ_HXX_
#define _SVX_GALOBJ_HXX_

// auto strip #include <tools/urlobj.hxx>
// auto strip #include <vcl/graph.hxx>
namespace binfilter {

// -----------
// - Defines -
// -----------

#define S_THUMB 80

// -----------------------------------------------------------------------------

#define SGA_FORMAT_NONE					0x00000000L
#define	SGA_FORMAT_STRING				0x00000001L
#define	SGA_FORMAT_GRAPHIC				0x00000010L
#define	SGA_FORMAT_SOUND				0x00000100L
#define	SGA_FORMAT_OLE					0x00001000L
#define	SGA_FORMAT_SVDRAW				0x00010000L
#define SGA_FORMAT_ALL					0xFFFFFFFFL

// --------------
// - SgaObjKind -
// --------------

enum SgaObjKind
{
	SGA_OBJ_NONE = 0,	// Abstraktes Objekt
	SGA_OBJ_BMP	= 1,	// Bitmap-Objekt
	SGA_OBJ_SOUND =	2,	// Sound-Objekt
	SGA_OBJ_VIDEO =	3, 	// Video-Objekt
	SGA_OBJ_ANIM = 4,	// Animations-Objekt
	SGA_OBJ_SVDRAW = 5,	// Svdraw-Objekt
	SGA_OBJ_INET = 6	// Grafik aus dem Internet
};

// ----------------
// - GalSoundType -
// ----------------

enum GalSoundType
{
	SOUND_STANDARD = 0,
	SOUND_COMPUTER = 1,
	SOUND_MISC = 2,
	SOUND_MUSIC = 3,
	SOUND_NATURE = 4,
	SOUND_SPEECH = 5,
	SOUND_TECHNIC = 6,
	SOUND_ANIMAL = 7
};

// -------------
// - SgaObject -
// -------------

//STRIP001 class SgaObject
//STRIP001 {
//STRIP001 	friend class GalleryTheme;
//STRIP001 
//STRIP001 private:
//STRIP001 
//STRIP001 	void					ImplUpdateURL( const INetURLObject& rNewURL ) { aURL = rNewURL; } 
//STRIP001 
//STRIP001 protected:
//STRIP001 
//STRIP001 	Bitmap					aThumbBmp;
//STRIP001 	GDIMetaFile				aThumbMtf;
//STRIP001 	INetURLObject			aURL;
//STRIP001 	String					aUserName;
//STRIP001 	String					aTitle;
//STRIP001 	BOOL					bIsValid;
//STRIP001 	BOOL					bIsThumbBmp;
//STRIP001 
//STRIP001 	virtual void 			WriteData( SvStream& rOut ) const;
//STRIP001 	virtual void 			ReadData( SvStream& rIn, UINT16& rReadVersion );
//STRIP001 
//STRIP001 	BOOL					CreateThumb( const Graphic& rGraphic );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 							SgaObject();
//STRIP001 	virtual					~SgaObject() {};
//STRIP001 
//STRIP001 	virtual SgaObjKind		GetObjKind() const = 0;
//STRIP001 	virtual UINT16			GetVersion() const = 0;
//STRIP001 
//STRIP001 	virtual Bitmap 			GetThumbBmp() const { return aThumbBmp; }
//STRIP001 	const GDIMetaFile&		GetThumbMtf() const { return aThumbMtf; }
//STRIP001 	const INetURLObject&	GetURL() const { return aURL; }
//STRIP001 	BOOL					IsValid() const { return bIsValid; }
//STRIP001 	BOOL					IsThumbBitmap() const { return bIsThumbBmp; }
//STRIP001 
//STRIP001 	const String			GetTitle() const;
//STRIP001 	void					SetTitle( const String& rTitle );
//STRIP001 
//STRIP001 	friend SvStream& 		operator<<( SvStream& rOut, const SgaObject& rObj );
//STRIP001 	friend SvStream& 		operator>>( SvStream& rIn, SgaObject& rObj );
//STRIP001 };

// ------------------
// - SgaObjectSound -
// ------------------

//STRIP001 class SgaObjectSound : public SgaObject
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	GalSoundType		eSoundType;
//STRIP001 
//STRIP001 	virtual void 		WriteData( SvStream& rOut ) const;
//STRIP001 	virtual void 		ReadData( SvStream& rIn, UINT16& rReadVersion );
//STRIP001 
//STRIP001 	virtual UINT16		GetVersion() const { return 6; }
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						SgaObjectSound();
//STRIP001 						SgaObjectSound( const INetURLObject& rURL );
//STRIP001 	virtual 	   	   ~SgaObjectSound();
//STRIP001 
//STRIP001 	virtual SgaObjKind	GetObjKind() const { return SGA_OBJ_SOUND; }
//STRIP001 	virtual Bitmap 		GetThumbBmp() const;
//STRIP001 	GalSoundType		GetSoundType() const { return eSoundType; }
//STRIP001 };

// -------------------
// - SgaObjectSvDraw -
// -------------------

class FmFormModel;

//STRIP001 class SgaObjectSvDraw : public SgaObject
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	BOOL				CreateThumb( const FmFormModel& rModel );
//STRIP001 
//STRIP001 	virtual void 		WriteData( SvStream& rOut ) const;
//STRIP001 	virtual void 		ReadData( SvStream& rIn, UINT16& rReadVersion );
//STRIP001 
//STRIP001 	virtual UINT16		GetVersion() const { return 5; }
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						SgaObjectSvDraw();
//STRIP001 						SgaObjectSvDraw( const FmFormModel& rModel, const INetURLObject& rURL );
//STRIP001 						SgaObjectSvDraw( SvStream& rIStm, const INetURLObject& rURL );
//STRIP001 	virtual 	   	   ~SgaObjectSvDraw() {};
//STRIP001 
//STRIP001 	virtual SgaObjKind	GetObjKind() const { return SGA_OBJ_SVDRAW; }
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001     static BOOL         DrawCentered( OutputDevice* pOut, const FmFormModel& rModel );
//STRIP001 };

// ----------------
// - SgaObjectBmp -
// ----------------

//STRIP001 class SgaObjectBmp: public SgaObject
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	void				Init( const Graphic& rGraphic, const INetURLObject& rURL );
//STRIP001 
//STRIP001 	virtual void   		WriteData( SvStream& rOut ) const;
//STRIP001 	virtual void   		ReadData( SvStream& rIn, UINT16& rReadVersion );
//STRIP001 
//STRIP001 	virtual UINT16		GetVersion() const { return 5; }
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						SgaObjectBmp();
//STRIP001 						SgaObjectBmp( const INetURLObject& rURL );
//STRIP001 						SgaObjectBmp( const Graphic& rGraphic, const INetURLObject& rURL, const String& rFormat );
//STRIP001 	virtual				~SgaObjectBmp() {};
//STRIP001 
//STRIP001 	virtual SgaObjKind	GetObjKind() const { return SGA_OBJ_BMP; }
//STRIP001 };

// -----------------
// - SgaObjectAnim -
// -----------------

//STRIP001 class SgaObjectAnim : public SgaObjectBmp
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 						SgaObjectAnim( const INetURLObject& rURL ) {};
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						SgaObjectAnim();
//STRIP001 						SgaObjectAnim( const Graphic& rGraphic, const INetURLObject& rURL, const String& rFormatName );
//STRIP001 
//STRIP001 	virtual 	   	   ~SgaObjectAnim() {};
//STRIP001 
//STRIP001 	virtual SgaObjKind	GetObjKind() const { return SGA_OBJ_ANIM; }
//STRIP001 };

// -----------------
// - SgaObjectINet -
// -----------------

//STRIP001 class SgaObjectINet : public SgaObjectAnim
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 						SgaObjectINet( const INetURLObject& rURL ) {};
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						SgaObjectINet();
//STRIP001 						SgaObjectINet( const Graphic& rGraphic, const INetURLObject& rURL, const String& rFormatName );
//STRIP001 
//STRIP001 	virtual 	   	   ~SgaObjectINet() {};
//STRIP001 
//STRIP001 	virtual SgaObjKind	GetObjKind() const { return SGA_OBJ_INET; }
//STRIP001 };
}//end of namespace binfilter
#endif
