/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_docst.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 03:51:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include <hintids.hxx>

#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFX_TEMPLDLG_HXX //autogen
#include <bf_sfx2/templdlg.hxx>
#endif
#ifndef _SFX_TPLPITEM_HXX //autogen
#include <bf_sfx2/tplpitem.hxx>
#endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _NEWSTYLE_HXX //autogen
// auto strip #include <bf_sfx2/newstyle.hxx>
// auto strip #endif
// auto strip #ifndef _SFXMACITEM_HXX //autogen
// auto strip #include <svtools/macitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_BRSHITEM_HXX //autogen
// auto strip #include <bf_svx/brshitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_HTMLMODE_HXX
// auto strip #include <bf_svx/htmlmode.hxx>
// auto strip #endif
// auto strip #ifndef _SWMODULE_HXX
// auto strip #include <swmodule.hxx>
// auto strip #endif
// auto strip #ifndef _SWWDOCSH_HXX //autogen
// auto strip #include <wdocsh.hxx>
// auto strip #endif
// auto strip #ifndef _FMTFSIZE_HXX //autogen
// auto strip #include <fmtfsize.hxx>
// auto strip #endif
// auto strip #ifndef _FCHRFMT_HXX //autogen
// auto strip #include <fchrfmt.hxx>
// auto strip #endif
#ifndef _OFA_HTMLCFG_HXX //autogen
#include <bf_offmgr/htmlcfg.hxx>
#endif
#ifndef _OFF_APP_HXX //autogen
#include <bf_offmgr/app.hxx>
#endif
#ifndef _SWSTYLENAMEMAPPER_HXX
#include <SwStyleNameMapper.hxx>
#endif

#include "view.hxx"

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#include "wrtsh.hxx"
#include "docsh.hxx"
// auto strip #include "uitool.hxx"
#include "cmdid.h"
#include "globals.hrc"
// auto strip #include "viewopt.hxx"
#include "doc.hxx"
#include "swstyle.h"
// auto strip #include "frmfmt.hxx"
#include "charfmt.hxx"
#include "poolfmt.hxx"
// auto strip #include "pagedesc.hxx"
// auto strip #include "tmpdlg.hxx"
// auto strip #include "docstyle.hxx"
#include "uiitems.hxx"
#include "fmtcol.hxx"
#include "frmmgr.hxx"		//SwFrmValid
// auto strip #include "swevent.hxx"
#include "edtwin.hxx"

#include "app.hrc"
namespace binfilter {


/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


/*N*/ void  SwDocShell::StateStyleSheet(SfxItemSet& rSet, SwWrtShell* pSh)
/*N*/ {
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 	USHORT 	nWhich 	= aIter.FirstWhich();
/*N*/ 	USHORT nActualFamily = USHRT_MAX;
/*N*/ 
/*N*/ 	SwWrtShell* pShell = pSh ? pSh : GetWrtShell();
/*N*/     if(!pShell)
/*N*/ 	{
/*?*/ 		while (nWhich)
/*?*/ 		{
/*?*/ 			rSet.DisableItem(nWhich);
/*?*/ 			nWhich = aIter.NextWhich();
/*?*/ 		}
/*?*/ 		return;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SfxViewFrame* pFrame = pShell->GetView().GetViewFrame();
/*N*/ 		const ISfxTemplateCommon* pCommon = SFX_APP()->GetCurrentTemplateCommon(pFrame->GetBindings());
/*N*/ 		if( pCommon )
/*N*/ 			nActualFamily = pCommon->GetActualFamily();
/*N*/ 	}

/*N*/ 	while (nWhich)
/*N*/ 	{
/*N*/ 		// aktuelle Vorlage zu jeder Familie ermitteln
/*N*/ 		//
/*N*/ 		String aName;
/*N*/ 		switch (nWhich)
/*N*/ 		{
/*N*/ 			case SID_STYLE_APPLY:
/*N*/ 			{//hier wird die Vorlage und ihre Familie an die StyleBox
/*N*/ 			 //uebergeben, damit diese Familie angezeigt wird
/*N*/ 				if(pShell->IsFrmSelected())
/*N*/ 				{
/*?*/ 					SwFrmFmt* pFmt = pShell->GetCurFrmFmt();
/*?*/ 					if( pFmt )
/*?*/ 						aName = pFmt->GetName();
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					SwTxtFmtColl* pColl = pShell->GetCurTxtFmtColl();
/*N*/ 					if(pColl)
/*N*/ 						aName = pColl->GetName();
/*N*/ 				}
/*N*/ 				rSet.Put(SfxTemplateItem(nWhich, aName));
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case SID_STYLE_FAMILY1:
/*N*/ 				if( !pShell->IsFrmSelected() )
/*N*/ 				{
/*N*/ 					SwCharFmt* pFmt = pShell->GetCurCharFmt();
/*N*/ 					if(pFmt)
/*N*/ 						aName = pFmt->GetName();
/*N*/ 					else
/*N*/ 						aName = *SwStyleNameMapper::GetTextUINameArray()[
/*N*/ 							RES_POOLCOLL_STANDARD - RES_POOLCOLL_TEXT_BEGIN ];
/*N*/                     rSet.Put(SfxTemplateItem(nWhich, aName));
/*N*/                 }
/*N*/                 break;
/*N*/ 
/*N*/ 			case SID_STYLE_FAMILY2:
/*N*/ 				if(!pShell->IsFrmSelected())
/*N*/ 				{
/*N*/ 					SwTxtFmtColl* pColl = pShell->GetCurTxtFmtColl();
/*N*/ 					if(pColl)
/*N*/ 						aName = pColl->GetName();
/*N*/ 
/*N*/ 					SfxTemplateItem aItem(nWhich, aName);
/*N*/ 
/*N*/ 					USHORT nMask = 0;
/*N*/ 					if( pDoc->IsHTMLMode() )
/*N*/ 						nMask = SWSTYLEBIT_HTML;
/*N*/ 					else
/*N*/ 					{
/*N*/ 						const int nSelection = pShell->GetFrmType(0,TRUE);
/*N*/ 						if(pShell->GetCurTOX())
/*N*/ 							nMask = SWSTYLEBIT_IDX	;
/*N*/ 						else if(nSelection & FRMTYPE_HEADER 	||
/*N*/ 								nSelection & FRMTYPE_FOOTER 	||
/*N*/ 								nSelection & FRMTYPE_TABLE 		||
/*N*/ 								nSelection & FRMTYPE_FLY_ANY 	||
/*N*/ 								nSelection & FRMTYPE_FOOTNOTE 	||
/*N*/ 								nSelection & FRMTYPE_FTNPAGE)
/*N*/ 							nMask = SWSTYLEBIT_EXTRA;
/*N*/ 						else
/*N*/ 							nMask = SWSTYLEBIT_TEXT;
/*N*/ 					}
/*N*/ 
/*N*/ 					aItem.SetValue(nMask);
/*N*/ 					rSet.Put(aItem);
/*N*/ 				}
/*N*/ 
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STYLE_FAMILY3:
/*N*/ 
/*N*/ 				if( pDoc->IsHTMLMode() )
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 				{
/*N*/ 					SwFrmFmt* pFmt = pShell->GetCurFrmFmt();
/*N*/ 					if(pFmt && pShell->IsFrmSelected())
/*N*/                     {
/*?*/ 						aName = pFmt->GetName();
/*?*/                         rSet.Put(SfxTemplateItem(nWhich, aName));
/*N*/                     }
/*N*/                 }
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STYLE_FAMILY4:
/*N*/ 			{
/*N*/ 				OfaHtmlOptions* pHtmlOpt = OFF_APP()->GetHtmlOptions();
/*N*/ 				if( pDoc->IsHTMLMode() && !pHtmlOpt->IsPrintLayoutExtension())
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 				{
/*N*/ 					USHORT n = pShell->GetCurPageDesc( FALSE );
/*N*/ 					if( n < pShell->GetPageDescCnt() )
/*N*/ 						aName = pShell->GetPageDesc( n ).GetName();
/*N*/ 
/*N*/ 					rSet.Put(SfxTemplateItem(nWhich, aName));
/*N*/ 				}
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case SID_STYLE_FAMILY5:
/*N*/ 				{
/*N*/ 					const SwNumRule* pRule = pShell->GetCurNumRule();
/*N*/ 					if( pRule )
/*N*/ 						aName = pRule->GetName();
/*N*/ 
/*N*/ 					rSet.Put(SfxTemplateItem(nWhich, aName));
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STYLE_WATERCAN:
/*N*/ 			{
/*N*/                 SwEditWin& rEdtWin = pShell->GetView().GetEditWin();
/*N*/                 SwApplyTemplate* pApply = rEdtWin.GetApplyTemplate();
/*N*/                 rSet.Put(SfxBoolItem(nWhich, pApply && pApply->eType != 0));
/*N*/ 			}
/*N*/             break;
/*N*/ 			case SID_STYLE_UPDATE_BY_EXAMPLE:
/*N*/ 				if( pShell->IsFrmSelected()
/*N*/ 						? SFX_STYLE_FAMILY_FRAME != nActualFamily
/*N*/ 						: ( SFX_STYLE_FAMILY_FRAME == nActualFamily ||
/*N*/ 							SFX_STYLE_FAMILY_PAGE == nActualFamily ||
/*N*/ 							(SFX_STYLE_FAMILY_PSEUDO == nActualFamily && !pShell->GetCurNumRule())) )
/*N*/ 				{
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STYLE_NEW_BY_EXAMPLE:
/*N*/ 				if( (pShell->IsFrmSelected()
/*N*/ 						? SFX_STYLE_FAMILY_FRAME != nActualFamily
/*N*/ 						: SFX_STYLE_FAMILY_FRAME == nActualFamily) ||
/*N*/ 					(SFX_STYLE_FAMILY_PSEUDO == nActualFamily && !pShell->GetCurNumRule()) )
/*N*/ 				{
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			default:
/*?*/ 				DBG_ERROR( "Invalid SlotId");
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }


/*--------------------------------------------------------------------
	Beschreibung:	StyleSheet-Requeste auswerten
 --------------------------------------------------------------------*/


/*N*/ void SwDocShell::ExecStyleSheet( SfxRequest& rReq )
/*N*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001  	USHORT 	nSlot 	= rReq.GetSlot();
//STRIP001 	USHORT 	nRet 	= 0xffff;
//STRIP001 
//STRIP001 	const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	SwWrtShell* pActShell = 0;
//STRIP001 	BOOL bSetReturn = TRUE;
//STRIP001 	switch (nSlot)
//STRIP001 	{
//STRIP001 	case SID_STYLE_NEW:
//STRIP001 		if( pArgs && SFX_ITEM_SET == pArgs->GetItemState( SID_STYLE_FAMILY,
//STRIP001 			FALSE, &pItem ))
//STRIP001 		{
//STRIP001 			USHORT nFamily = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 
//STRIP001 			String sName;
//STRIP001 			USHORT nMask = 0;
//STRIP001 			if( SFX_ITEM_SET == pArgs->GetItemState( SID_STYLE_NEW,
//STRIP001 				FALSE, &pItem ))
//STRIP001 				sName = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 			if( SFX_ITEM_SET == pArgs->GetItemState( SID_STYLE_MASK,
//STRIP001 				FALSE, &pItem ))
//STRIP001 				nMask = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 			String sParent;
//STRIP001 			if( SFX_ITEM_SET == pArgs->GetItemState( SID_STYLE_REFERENCE,
//STRIP001 				FALSE, &pItem ))
//STRIP001 				sParent = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 
//STRIP001 			nRet = Edit( sName, sParent, nFamily, nMask, TRUE, FALSE, 0, rReq.IsAPI() );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_STYLE_APPLY:
//STRIP001 			if( !pArgs )
//STRIP001 			{
//STRIP001 				GetView()->GetViewFrame()->GetDispatcher()->Execute(SID_STYLE_DESIGNER, FALSE);
//STRIP001 				break;
//STRIP001 			}	// Fall through
//STRIP001 		case SID_STYLE_EDIT:
//STRIP001 		case SID_STYLE_DELETE:
//STRIP001 		case SID_STYLE_WATERCAN:
//STRIP001 		case SID_STYLE_FAMILY:
//STRIP001 		case SID_STYLE_UPDATE_BY_EXAMPLE:
//STRIP001 		case SID_STYLE_NEW_BY_EXAMPLE:
//STRIP001 		{
//STRIP001 			String aParam;
//STRIP001 			USHORT nFamily, nMask = 0;
//STRIP001 
//STRIP001 			if( !pArgs )
//STRIP001 			{
//STRIP001 				nFamily = SFX_STYLE_FAMILY_PARA;
//STRIP001 
//STRIP001 				switch (nSlot)
//STRIP001 				{
//STRIP001 					case SID_STYLE_NEW_BY_EXAMPLE:
//STRIP001 					{
//STRIP001 						SfxNewStyleDlg *pDlg = new SfxNewStyleDlg( 0,
//STRIP001 													*GetStyleSheetPool());
//STRIP001 						if(RET_OK == pDlg->Execute())
//STRIP001                         {
//STRIP001 							aParam = pDlg->GetName();
//STRIP001 							rReq.AppendItem(SfxStringItem(nSlot, aParam));
//STRIP001                         }
//STRIP001 
//STRIP001 						delete pDlg;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					case SID_STYLE_UPDATE_BY_EXAMPLE:
//STRIP001 					case SID_STYLE_EDIT:
//STRIP001 					{
//STRIP001 						SwTxtFmtColl* pColl = GetWrtShell()->GetCurTxtFmtColl();
//STRIP001 						if(pColl)
//STRIP001 						{
//STRIP001 							aParam = pColl->GetName();
//STRIP001 							rReq.AppendItem(SfxStringItem(nSlot, aParam));
//STRIP001 						}
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ASSERT( pArgs->Count(), "SfxBug ItemSet ist leer");
//STRIP001 
//STRIP001 				SwWrtShell* pShell = GetWrtShell();
//STRIP001 				if( SFX_ITEM_SET == pArgs->GetItemState(nSlot, FALSE, &pItem ))
//STRIP001 					aParam = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 
//STRIP001 				if( SFX_ITEM_SET == pArgs->GetItemState(SID_STYLE_FAMILY,
//STRIP001 					FALSE, &pItem ))
//STRIP001 					nFamily = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 
//STRIP001 				if( SFX_ITEM_SET == pArgs->GetItemState(SID_STYLE_MASK,
//STRIP001 					FALSE, &pItem ))
//STRIP001 					nMask = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 				if( SFX_ITEM_SET == pArgs->GetItemState(FN_PARAM_WRTSHELL,
//STRIP001 					FALSE, &pItem ))
//STRIP001 					pActShell = pShell = (SwWrtShell*)((SwPtrItem*)pItem)->GetValue();
//STRIP001 
//STRIP001 				if( nSlot == SID_STYLE_UPDATE_BY_EXAMPLE )
//STRIP001 				{
//STRIP001 					switch( nFamily )
//STRIP001 					{
//STRIP001 						case SFX_STYLE_FAMILY_PARA:
//STRIP001 						{
//STRIP001 							SwTxtFmtColl* pColl = pShell->GetCurTxtFmtColl();
//STRIP001 							if(pColl)
//STRIP001 								aParam = pColl->GetName();
//STRIP001 						}
//STRIP001 						break;
//STRIP001 						case SFX_STYLE_FAMILY_FRAME:
//STRIP001 						{
//STRIP001 							SwFrmFmt* pFrm = pWrtShell->GetCurFrmFmt();
//STRIP001 							if( pFrm )
//STRIP001 								aParam = pFrm->GetName();
//STRIP001 						}
//STRIP001 						break;
//STRIP001 						case SFX_STYLE_FAMILY_CHAR:
//STRIP001 						{
//STRIP001 							SwCharFmt* pChar = pWrtShell->GetCurCharFmt();
//STRIP001 							if( pChar )
//STRIP001 								aParam = pChar->GetName();
//STRIP001 						}
//STRIP001 						break;
//STRIP001 						case SFX_STYLE_FAMILY_PSEUDO:
//STRIP001 						if(SFX_ITEM_SET == pArgs->GetItemState(SID_STYLE_UPD_BY_EX_NAME, FALSE, &pItem))
//STRIP001 						{
//STRIP001 							aParam = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 						}
//STRIP001 						break;
//STRIP001 					}
//STRIP001 					rReq.AppendItem(SfxStringItem(nSlot, aParam));
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if (aParam.Len() || nSlot == SID_STYLE_WATERCAN )
//STRIP001 			{
//STRIP001 				switch(nSlot)
//STRIP001 				{
//STRIP001 					case SID_STYLE_EDIT:
//STRIP001 						nRet = Edit(aParam, aEmptyStr, nFamily, nMask, FALSE, FALSE, pActShell );
//STRIP001 						break;
//STRIP001 					case SID_STYLE_DELETE:
//STRIP001 						nRet = Delete(aParam, nFamily);
//STRIP001 						break;
//STRIP001 					case SID_STYLE_APPLY:
//STRIP001 						// Shellwechsel in ApplyStyles
//STRIP001                         nRet = ApplyStyles(aParam, nFamily, pActShell, rReq.GetModifier() );
//STRIP001 						break;
//STRIP001 					case SID_STYLE_WATERCAN:
//STRIP001 						nRet = DoWaterCan(aParam, nFamily);
//STRIP001 						break;
//STRIP001 					case SID_STYLE_UPDATE_BY_EXAMPLE:
//STRIP001 						nRet = UpdateStyle(aParam, nFamily, pActShell);
//STRIP001 						break;
//STRIP001 					case SID_STYLE_NEW_BY_EXAMPLE:
//STRIP001 					{
//STRIP001 						nRet = MakeByExample(aParam, nFamily, nMask, pActShell );
//STRIP001 						SfxTemplateDialog* pDlg = SFX_APP()->GetTemplateDialog();
//STRIP001 
//STRIP001 						if(pDlg && pDlg->IsVisible())
//STRIP001 							pDlg->Update();
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					default:
//STRIP001 						DBG_ERROR( "Falsche Slot-Id");
//STRIP001 				}
//STRIP001 
//STRIP001                 rReq.Done();
//STRIP001 			}
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if(bSetReturn)
//STRIP001 	{
//STRIP001 		if(rReq.IsAPI()) // Basic bekommt nur TRUE oder FALSE
//STRIP001 			rReq.SetReturnValue(SfxUInt16Item(nSlot, nRet !=0));
//STRIP001 		else
//STRIP001 			rReq.SetReturnValue(SfxUInt16Item(nSlot, nRet));
//STRIP001 	}
//STRIP001 
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Edit
 --------------------------------------------------------------------*/


//STRIP001 USHORT SwDocShell::Edit( const String &rName, const String &rParent, USHORT nFamily, USHORT nMask,
//STRIP001 						 BOOL bNew, BOOL bColumn, SwWrtShell* pActShell,
//STRIP001 						 BOOL bBasic )
//STRIP001 {
//STRIP001 	ASSERT(GetWrtShell(), "Keine Shell, keine Styles");
//STRIP001 	SfxStyleSheetBase *pStyle = 0;
//STRIP001 
//STRIP001 	USHORT nRet = nMask;
//STRIP001 	BOOL bModified = pDoc->IsModified();
//STRIP001 
//STRIP001 	if( bNew )
//STRIP001 	{
//STRIP001 		if( SFXSTYLEBIT_ALL != nMask && SFXSTYLEBIT_USED != nMask )
//STRIP001 			nMask |= SFXSTYLEBIT_USERDEF;
//STRIP001 		else
//STRIP001 			nMask = SFXSTYLEBIT_USERDEF;
//STRIP001 
//STRIP001 		pStyle = &pBasePool->Make( rName, (SfxStyleFamily)nFamily, nMask );
//STRIP001 
//STRIP001 		// die aktuellen als Parent setzen
//STRIP001 		SwDocStyleSheet* pDStyle = (SwDocStyleSheet*)pStyle;
//STRIP001 		switch( nFamily )
//STRIP001 		{
//STRIP001 			case SFX_STYLE_FAMILY_PARA:
//STRIP001 			{
//STRIP001 				if(rParent.Len())
//STRIP001 				{
//STRIP001 					SwTxtFmtColl* pColl = pWrtShell->FindTxtFmtCollByName( rParent );
//STRIP001                     if(!pColl)
//STRIP001                     {
//STRIP001                         USHORT nId = SwStyleNameMapper::GetPoolIdFromUIName(rParent, GET_POOLID_TXTCOLL);
//STRIP001                         if(USHRT_MAX != nId)
//STRIP001                             pColl =  pWrtShell->GetTxtCollFromPool( nId );
//STRIP001                     }            
//STRIP001 					pDStyle->GetCollection()->SetDerivedFrom( pColl );
//STRIP001 					pDStyle->PresetParent( rParent );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SwTxtFmtColl* pColl = pWrtShell->GetCurTxtFmtColl();
//STRIP001 					pDStyle->GetCollection()->SetDerivedFrom( pColl );
//STRIP001 					if( pColl )
//STRIP001 						pDStyle->PresetParent( pColl->GetName() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case SFX_STYLE_FAMILY_CHAR:
//STRIP001 			{
//STRIP001 				if(rParent.Len())
//STRIP001 				{
//STRIP001 					SwCharFmt* pCFmt = pWrtShell->FindCharFmtByName( rParent );
//STRIP001                     if(!pCFmt)
//STRIP001                     {
//STRIP001                         USHORT nId = SwStyleNameMapper::GetPoolIdFromUIName(rParent, GET_POOLID_CHRFMT);
//STRIP001                         if(USHRT_MAX != nId)
//STRIP001                             pCFmt =  pWrtShell->GetCharFmtFromPool( nId );
//STRIP001                     }            
//STRIP001 
//STRIP001 					pDStyle->GetCharFmt()->SetDerivedFrom( pCFmt );
//STRIP001 					pDStyle->PresetParent( rParent );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SwCharFmt* pCFmt = pWrtShell->GetCurCharFmt();
//STRIP001 					pDStyle->GetCharFmt()->SetDerivedFrom( pCFmt );
//STRIP001 						if( pCFmt )
//STRIP001 							pDStyle->PresetParent( pCFmt->GetName() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case SFX_STYLE_FAMILY_FRAME :
//STRIP001 			{
//STRIP001 				if(rParent.Len())
//STRIP001 				{
//STRIP001 					SwFrmFmt* pFFmt = pWrtShell->GetDoc()->FindFrmFmtByName( rParent );
//STRIP001                     if(!pFFmt)
//STRIP001                     {
//STRIP001                         USHORT nId = SwStyleNameMapper::GetPoolIdFromUIName(rParent, GET_POOLID_FRMFMT);
//STRIP001                         if(USHRT_MAX != nId)
//STRIP001                             pFFmt =  pWrtShell->GetFrmFmtFromPool( nId );
//STRIP001                     }            
//STRIP001                     pDStyle->GetFrmFmt()->SetDerivedFrom( pFFmt );
//STRIP001 					pDStyle->PresetParent( rParent );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pStyle = pBasePool->Find( rName, (SfxStyleFamily)nFamily );
//STRIP001 		ASSERT(pStyle, "Vorlage nicht gefunden");
//STRIP001 	}
//STRIP001 
//STRIP001 	if(!pStyle)
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	// Dialoge zusammenstoepseln
//STRIP001 	//
//STRIP001 	SwDocStyleSheet aTmp( *(SwDocStyleSheet*)pStyle );
//STRIP001 	if( SFX_STYLE_FAMILY_PARA == nFamily )
//STRIP001 	{
//STRIP001 		SfxItemSet& rSet = aTmp.GetItemSet();
//STRIP001 		::SwToSfxPageDescAttr( rSet );
//STRIP001 		// erstmal nur eine Null
//STRIP001 		rSet.Put(SwBackgroundDestinationItem(SID_PARA_BACKGRND_DESTINATION, 0));
//STRIP001 	}
//STRIP001 /*	else if( SFX_STYLE_FAMILY_FRAME == nFamily )
//STRIP001 	{
//STRIP001 		// Auskommentiert wegen Bug #45776 (per default keine Breite&Groesse in Rahmenvorlagen)
//STRIP001 		SfxItemSet& rSet = aTmp.GetItemSet();
//STRIP001 		if( SFX_ITEM_SET != rSet.GetItemState( RES_FRM_SIZE ))
//STRIP001 		{
//STRIP001 			// dann sollten wir spaetesten hier eines anlegen
//STRIP001 			SwFrmValid aFrmDefValues;
//STRIP001 			rSet.Put( SwFmtFrmSize( ATT_VAR_SIZE, aFrmDefValues.nWidth,
//STRIP001 									aFrmDefValues.nHeight ));
//STRIP001 		}
//STRIP001 	}*/
//STRIP001 	else if( SFX_STYLE_FAMILY_CHAR == nFamily )
//STRIP001 	{
//STRIP001 		SfxItemSet& rSet = aTmp.GetItemSet();
//STRIP001 		const SfxPoolItem *pTmpBrush;
//STRIP001 		if( SFX_ITEM_SET == rSet.GetItemState( RES_CHRATR_BACKGROUND,
//STRIP001 			TRUE, &pTmpBrush ) )
//STRIP001 		{
//STRIP001 			SvxBrushItem aTmpBrush( *((SvxBrushItem*)pTmpBrush) );
//STRIP001 			aTmpBrush.SetWhich( RES_BACKGROUND );
//STRIP001 			rSet.Put( aTmpBrush );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (!bBasic)
//STRIP001 	{
//STRIP001 		// vor dem Dialog wird der HtmlMode an der DocShell versenkt
//STRIP001 		USHORT nHtmlMode = ::binfilter::GetHtmlMode(this);
//STRIP001 
//STRIP001         // In HTML mode, we do not always have a printer. In order to show
//STRIP001         // the correct page size in the Format - Page dialog, we have to
//STRIP001         // get one here.
//STRIP001         SwWrtShell* pCurrShell = ( pActShell ? pActShell : pWrtShell );
//STRIP001         if( ( HTMLMODE_ON & nHtmlMode ) &&
//STRIP001             !pCurrShell->GetDoc()->GetPrt() )
//STRIP001             pCurrShell->InitPrt( pCurrShell->GetPrt( sal_True ) );
//STRIP001 
//STRIP001 		PutItem(SfxUInt16Item(SID_HTML_MODE, nHtmlMode));
//STRIP001 		FieldUnit eMetric = ::GetDfltMetric(0 != (HTMLMODE_ON&nHtmlMode));
//STRIP001 		SW_MOD()->PutItem(SfxUInt16Item(SID_ATTR_METRIC, eMetric));
//STRIP001 		SwTemplateDlg* pDlg = new SwTemplateDlg( 0, aTmp, nFamily, bColumn,
//STRIP001 							pActShell ? pActShell : pWrtShell, bNew);
//STRIP001 		if(RET_OK == pDlg->Execute())
//STRIP001 		{
//STRIP001 			GetWrtShell()->StartAllAction();
//STRIP001 
//STRIP001 			// nur bei Absatz-Vorlagen die Maske neu setzen
//STRIP001 			if( bNew )
//STRIP001 			{
//STRIP001 				nRet = SFX_STYLE_FAMILY_PARA == pStyle->GetFamily()
//STRIP001 						? aTmp.GetMask()
//STRIP001 						: SFXSTYLEBIT_USERDEF;
//STRIP001 			}
//STRIP001 			else if( pStyle->GetMask() != aTmp.GetMask() )
//STRIP001 				nRet = aTmp.GetMask();
//STRIP001 
//STRIP001 			if( SFX_STYLE_FAMILY_PARA == nFamily )
//STRIP001 			{
//STRIP001 				SfxItemSet aSet( *pDlg->GetOutputItemSet() );
//STRIP001 				::SfxToSwPageDescAttr( *GetWrtShell(), aSet  );
//STRIP001 				aTmp.SetItemSet( aSet );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001                 if(SFX_STYLE_FAMILY_PAGE == nFamily)
//STRIP001                 {
//STRIP001                     static const USHORT aInval[] = {
//STRIP001                         SID_IMAGE_ORIENTATION, 
//STRIP001 						SID_ATTR_CHAR_FONT,	
//STRIP001 						FN_INSERT_CTRL, FN_INSERT_OBJ_CTRL, 0};
//STRIP001                     pView->GetViewFrame()->GetBindings().Invalidate(aInval);
//STRIP001                 }
//STRIP001                 SfxItemSet aTmpSet( *pDlg->GetOutputItemSet() );
//STRIP001 				if( SFX_STYLE_FAMILY_CHAR == nFamily )
//STRIP001 				{
//STRIP001 					const SfxPoolItem *pTmpBrush;
//STRIP001 					if( SFX_ITEM_SET == aTmpSet.GetItemState( RES_BACKGROUND,
//STRIP001 						FALSE, &pTmpBrush ) )
//STRIP001 					{
//STRIP001 						SvxBrushItem aTmpBrush( *((SvxBrushItem*)pTmpBrush) );
//STRIP001 						aTmpBrush.SetWhich( RES_CHRATR_BACKGROUND );
//STRIP001 						aTmpSet.Put( aTmpBrush );
//STRIP001 					}
//STRIP001 					aTmpSet.ClearItem( RES_BACKGROUND );
//STRIP001 				}
//STRIP001 				aTmp.SetItemSet( aTmpSet );
//STRIP001 			}
//STRIP001 			if(SFX_STYLE_FAMILY_PAGE == nFamily)
//STRIP001 				pView->InvalidateRulerPos();
//STRIP001 
//STRIP001 			if( bNew )
//STRIP001 				pBasePool->Broadcast( SfxStyleSheetHint( SFX_STYLESHEET_CREATED, aTmp ) );
//STRIP001 
//STRIP001 			// JP 19.09.97:
//STRIP001 			// Dialog vorm EndAction zerstoeren - bei Seitenvorlagen kann
//STRIP001 			// muss der ItemSet zerstoert werden, damit die Cursor aus den
//STRIP001 			// Kopf-/Fusszeilen entfernt werden. Sonst kommts zu GPFs!!!
//STRIP001 			delete pDlg;
//STRIP001 
//STRIP001 			pDoc->SetModified();
//STRIP001 			if( !bModified )	// Bug 57028
//STRIP001 				pDoc->SetUndoNoResetModified();
//STRIP001 
//STRIP001 			GetWrtShell()->EndAllAction();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if( bNew )
//STRIP001 				pBasePool->Erase( &aTmp );
//STRIP001 			if( !bModified )
//STRIP001 				pDoc->ResetModified();
//STRIP001 			delete pDlg;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// vor dem Dialog wird der HtmlMode an der DocShell versenkt
//STRIP001 		PutItem(SfxUInt16Item(SID_HTML_MODE, ::binfilter::GetHtmlMode(this)));
//STRIP001 
//STRIP001 		GetWrtShell()->StartAllAction();
//STRIP001 
//STRIP001 		// nur bei Absatz-Vorlagen die Maske neu setzen
//STRIP001 		if( bNew )
//STRIP001 		{
//STRIP001 			nRet = SFX_STYLE_FAMILY_PARA == pStyle->GetFamily()
//STRIP001 					? aTmp.GetMask()
//STRIP001 					: SFXSTYLEBIT_USERDEF;
//STRIP001 		}
//STRIP001 		else if( pStyle->GetMask() != aTmp.GetMask() )
//STRIP001 			nRet = aTmp.GetMask();
//STRIP001 
//STRIP001 		if( SFX_STYLE_FAMILY_PARA == nFamily )
//STRIP001 			::SfxToSwPageDescAttr( *GetWrtShell(), aTmp.GetItemSet() );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SfxItemSet aTmpSet( aTmp.GetItemSet() );
//STRIP001 			if( SFX_STYLE_FAMILY_CHAR == nFamily )
//STRIP001 			{
//STRIP001 				const SfxPoolItem *pTmpBrush;
//STRIP001 				if( SFX_ITEM_SET == aTmpSet.GetItemState( RES_BACKGROUND,
//STRIP001 					FALSE, &pTmpBrush ) )
//STRIP001 				{
//STRIP001 					SvxBrushItem aTmpBrush( *((SvxBrushItem*)pTmpBrush) );
//STRIP001 					aTmpBrush.SetWhich( RES_CHRATR_BACKGROUND );
//STRIP001 					aTmpSet.Put( aTmpBrush );
//STRIP001 				}
//STRIP001 				aTmpSet.ClearItem( RES_BACKGROUND );
//STRIP001 			}
//STRIP001 			aTmp.SetItemSet( aTmpSet );
//STRIP001 		}
//STRIP001 		if(SFX_STYLE_FAMILY_PAGE == nFamily)
//STRIP001 			pView->InvalidateRulerPos();
//STRIP001 
//STRIP001 		if( bNew )
//STRIP001 			pBasePool->Broadcast( SfxStyleSheetHint( SFX_STYLESHEET_CREATED, aTmp ) );
//STRIP001 
//STRIP001 		pDoc->SetModified();
//STRIP001 		if( !bModified )		// Bug 57028
//STRIP001 			pDoc->SetUndoNoResetModified();
//STRIP001 		GetWrtShell()->EndAllAction();
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Delete
 --------------------------------------------------------------------*/


//STRIP001 USHORT SwDocShell::Delete(const String &rName, USHORT nFamily)
//STRIP001 {
//STRIP001 	SfxStyleSheetBase *pStyle = pBasePool->Find(rName, (SfxStyleFamily)nFamily);
//STRIP001 
//STRIP001 	if(pStyle)
//STRIP001 	{
//STRIP001 		ASSERT(GetWrtShell(), "Keine Shell, keine Styles");
//STRIP001 
//STRIP001 		GetWrtShell()->StartAllAction();
//STRIP001 		pBasePool->Erase(pStyle);
//STRIP001 		GetWrtShell()->EndAllAction();
//STRIP001 
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Vorlage anwenden
 --------------------------------------------------------------------*/


//STRIP001 USHORT SwDocShell::ApplyStyles(const String &rName, USHORT nFamily,
//STRIP001 							   SwWrtShell* pShell, USHORT nMode )
//STRIP001 {
//STRIP001 	SwDocStyleSheet* pStyle =
//STRIP001 		(SwDocStyleSheet*)pBasePool->Find(rName, (SfxStyleFamily)nFamily);
//STRIP001 
//STRIP001 	ASSERT(pStyle, "Wo ist der StyleSheet");
//STRIP001 	if(!pStyle)
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	SwWrtShell *pSh = pShell ? pShell : GetWrtShell();
//STRIP001 
//STRIP001 	ASSERT( pSh, "Keine Shell, keine Styles");
//STRIP001 
//STRIP001 	pSh->StartAllAction();
//STRIP001 
//STRIP001 	switch(nFamily)
//STRIP001 	{
//STRIP001 		case SFX_STYLE_FAMILY_CHAR:
//STRIP001 		{
//STRIP001 			SwFmtCharFmt aFmt(pStyle->GetCharFmt());
//STRIP001 			pSh->SetAttr( aFmt, (nMode & KEY_SHIFT) ? SETATTR_DONTREPLACE : SETATTR_DEFAULT );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SFX_STYLE_FAMILY_PARA:
//STRIP001 		{
//STRIP001 			pSh->SetTxtFmtColl(pStyle->GetCollection());
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SFX_STYLE_FAMILY_FRAME:
//STRIP001 		{
//STRIP001 			if ( pSh->IsFrmSelected() )
//STRIP001 				pSh->SetFrmFmt( pStyle->GetFrmFmt() );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SFX_STYLE_FAMILY_PAGE:
//STRIP001 		{
//STRIP001 			pSh->SetPageStyle(pStyle->GetPageDesc()->GetName());
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SFX_STYLE_FAMILY_PSEUDO:
//STRIP001 		{
//STRIP001 			pSh->SetCurNumRule( *pStyle->GetNumRule() );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		default:
//STRIP001 			DBG_ERROR("Unbekannte Familie");
//STRIP001 	}
//STRIP001 	pSh->EndAllAction();
//STRIP001 
//STRIP001 	return nFamily;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Giesskanne starten
 --------------------------------------------------------------------*/



//STRIP001 USHORT SwDocShell::DoWaterCan(const String &rName, USHORT nFamily)
//STRIP001 {
//STRIP001 	ASSERT(GetWrtShell(), "Keine Shell, keine Styles");
//STRIP001 
//STRIP001 	SwEditWin& rEdtWin = pView->GetEditWin();
//STRIP001 	SwApplyTemplate* pApply = rEdtWin.GetApplyTemplate();
//STRIP001 	BOOL bWaterCan = !(pApply && pApply->eType != 0);
//STRIP001 	if( !rName.Len() )
//STRIP001 		bWaterCan = FALSE;
//STRIP001 	SwApplyTemplate aTemplate;
//STRIP001 	aTemplate.eType = nFamily;
//STRIP001 
//STRIP001 	if(bWaterCan)
//STRIP001 	{
//STRIP001 		SwDocStyleSheet* pStyle =
//STRIP001 			(SwDocStyleSheet*)pBasePool->Find(rName, (SfxStyleFamily)nFamily);
//STRIP001 
//STRIP001 		ASSERT(pStyle, "Wo ist der StyleSheet");
//STRIP001 		if(!pStyle) return nFamily;
//STRIP001 
//STRIP001 		switch(nFamily)
//STRIP001 		{
//STRIP001 			case SFX_STYLE_FAMILY_CHAR:
//STRIP001 				aTemplate.aColl.pCharFmt = pStyle->GetCharFmt();
//STRIP001 				break;
//STRIP001 			case SFX_STYLE_FAMILY_PARA:
//STRIP001 				aTemplate.aColl.pTxtColl = pStyle->GetCollection();
//STRIP001 				break;
//STRIP001 			case SFX_STYLE_FAMILY_FRAME:
//STRIP001 				aTemplate.aColl.pFrmFmt = pStyle->GetFrmFmt();
//STRIP001 				break;
//STRIP001 			case SFX_STYLE_FAMILY_PAGE:
//STRIP001 				aTemplate.aColl.pPageDesc = (SwPageDesc*)pStyle->GetPageDesc();
//STRIP001 				break;
//STRIP001 			case SFX_STYLE_FAMILY_PSEUDO:
//STRIP001 				aTemplate.aColl.pNumRule = (SwNumRule*)pStyle->GetNumRule();
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				DBG_ERROR( "Unbekannte Familie");
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aTemplate.eType = 0;
//STRIP001 
//STRIP001 	// Template anwenden
//STRIP001 	pView->GetEditWin().SetApplyTemplate(aTemplate);
//STRIP001 
//STRIP001 	return nFamily;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Vorlage Updaten
 --------------------------------------------------------------------*/


//STRIP001 USHORT SwDocShell::UpdateStyle(const String &rName, USHORT nFamily, SwWrtShell* pShell)
//STRIP001 {
//STRIP001 	SwWrtShell* pWrtShell = pShell ? pShell : GetWrtShell();
//STRIP001 	ASSERT(GetWrtShell(), "Keine Shell, keine Styles");
//STRIP001 
//STRIP001 	SwDocStyleSheet* pStyle =
//STRIP001 		(SwDocStyleSheet*)pBasePool->Find(rName, (SfxStyleFamily)nFamily);
//STRIP001 
//STRIP001 	if(!pStyle)
//STRIP001 		return nFamily;
//STRIP001 
//STRIP001 	switch(nFamily)
//STRIP001 	{
//STRIP001 		case SFX_STYLE_FAMILY_PARA:
//STRIP001 		{
//STRIP001 			SwTxtFmtColl* pColl = pStyle->GetCollection();
//STRIP001 			if(pColl && !pColl->IsDefault())
//STRIP001 			{
//STRIP001 				GetWrtShell()->StartAllAction();
//STRIP001 				GetWrtShell()->FillByEx(pColl);
//STRIP001 					// Vorlage auch anwenden, um harte Attributierung
//STRIP001 					// zu entfernen
//STRIP001 				GetWrtShell()->SetTxtFmtColl( pColl );
//STRIP001 				GetWrtShell()->EndAllAction();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SFX_STYLE_FAMILY_FRAME:
//STRIP001 		{
//STRIP001 			SwFrmFmt* pFrm = pStyle->GetFrmFmt();
//STRIP001 			if( pWrtShell->IsFrmSelected() && pFrm && !pFrm->IsDefault() )
//STRIP001 			{
//STRIP001 				SfxItemSet aSet( GetPool(), aFrmFmtSetRange );
//STRIP001 				pWrtShell->StartAllAction();
//STRIP001 				pWrtShell->GetFlyFrmAttr( aSet );
//STRIP001 
//STRIP001 				// JP 10.06.98: nur automatische Orientierungen uebernehmen
//STRIP001 /*				#61359# jetzt auch wieder alle Orientierungen
//STRIP001  * 				const SfxPoolItem* pItem;
//STRIP001 				if( SFX_ITEM_SET == aSet.GetItemState( RES_VERT_ORIENT,
//STRIP001 					FALSE, &pItem ) &&
//STRIP001 					VERT_NONE == ((SwFmtVertOrient*)pItem)->GetVertOrient())
//STRIP001 					aSet.ClearItem( RES_VERT_ORIENT );
//STRIP001 
//STRIP001 				if( SFX_ITEM_SET == aSet.GetItemState( RES_HORI_ORIENT,
//STRIP001 					FALSE, &pItem ) &&
//STRIP001 					HORI_NONE == ((SwFmtHoriOrient*)pItem)->GetHoriOrient())
//STRIP001 					aSet.ClearItem( RES_HORI_ORIENT );*/
//STRIP001 
//STRIP001 				pFrm->SetAttr( aSet );
//STRIP001 
//STRIP001 					// Vorlage auch anwenden, um harte Attributierung
//STRIP001 					// zu entfernen
//STRIP001 				pWrtShell->SetFrmFmt( pFrm, TRUE );
//STRIP001 				pWrtShell->EndAllAction();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SFX_STYLE_FAMILY_CHAR:
//STRIP001 		{
//STRIP001 			SwCharFmt* pChar = pStyle->GetCharFmt();
//STRIP001 			if( pChar && !pChar->IsDefault() )
//STRIP001 			{
//STRIP001 				pWrtShell->StartAllAction();
//STRIP001 				pWrtShell->FillByEx(pChar);
//STRIP001 					// Vorlage auch anwenden, um harte Attributierung
//STRIP001 					// zu entfernen
//STRIP001 				pWrtShell->EndAllAction();
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SFX_STYLE_FAMILY_PSEUDO:
//STRIP001 		{
//STRIP001 			const SwNumRule* pCurRule;
//STRIP001 			if( pStyle->GetNumRule() &&
//STRIP001 				0 != ( pCurRule = pWrtShell->GetCurNumRule() ))
//STRIP001 			{
//STRIP001 				SwNumRule aRule( *pCurRule );
//STRIP001 				aRule.SetName( pStyle->GetNumRule()->GetName() );
//STRIP001 				pWrtShell->ChgNumRuleFmts( aRule );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	return nFamily;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	NewByExample
 --------------------------------------------------------------------*/


//STRIP001 USHORT SwDocShell::MakeByExample( const String &rName, USHORT nFamily,
//STRIP001 									USHORT nMask, SwWrtShell* pShell )
//STRIP001 {
//STRIP001 	SwWrtShell* pWrtShell = pShell ? pShell : GetWrtShell();
//STRIP001 	SwDocStyleSheet* pStyle = (SwDocStyleSheet*)pBasePool->Find(
//STRIP001 											rName, (SfxStyleFamily)nFamily );
//STRIP001 	if(!pStyle)
//STRIP001 	{
//STRIP001 		// JP 07.07.95: behalte die akt. Maske vom PI bei, dadurch werden
//STRIP001 		//				neue sofort in den sichtbaren Bereich einsortiert
//STRIP001 		if( SFXSTYLEBIT_ALL == nMask || SFXSTYLEBIT_USED == nMask )
//STRIP001 			nMask = SFXSTYLEBIT_USERDEF;
//STRIP001 		else
//STRIP001 			nMask |= SFXSTYLEBIT_USERDEF;
//STRIP001 
//STRIP001 		pStyle = (SwDocStyleSheet*)&pBasePool->Make(rName,
//STRIP001 								(SfxStyleFamily)nFamily, nMask );
//STRIP001 	}
//STRIP001 
//STRIP001 	switch(nFamily)
//STRIP001 	{
//STRIP001 		case  SFX_STYLE_FAMILY_PARA:
//STRIP001 		{
//STRIP001 			SwTxtFmtColl* pColl = pStyle->GetCollection();
//STRIP001 			if(pColl && !pColl->IsDefault())
//STRIP001 			{
//STRIP001 				pWrtShell->StartAllAction();
//STRIP001 				pWrtShell->FillByEx(pColl);
//STRIP001 					// Vorlage auch anwenden, um harte Attributierung
//STRIP001 					// zu entfernen
//STRIP001 				pColl->SetDerivedFrom(pWrtShell->GetCurTxtFmtColl());
//STRIP001 
//STRIP001 					// setze die Maske noch an der Collection:
//STRIP001 				USHORT nId = pColl->GetPoolFmtId() & 0x87ff;
//STRIP001 				switch( nMask & 0x0fff )
//STRIP001 				{
//STRIP001 				case SWSTYLEBIT_TEXT:
//STRIP001 					nId |= COLL_TEXT_BITS;
//STRIP001 					break;
//STRIP001 				case SWSTYLEBIT_CHAPTER:
//STRIP001 					nId |= COLL_DOC_BITS;
//STRIP001 					break;
//STRIP001 				case SWSTYLEBIT_LIST:
//STRIP001 					nId |= COLL_LISTS_BITS;
//STRIP001 					break;
//STRIP001 				case SWSTYLEBIT_IDX:
//STRIP001 					nId |= COLL_REGISTER_BITS;
//STRIP001 					break;
//STRIP001 				case SWSTYLEBIT_EXTRA:
//STRIP001 					nId |= COLL_EXTRA_BITS;
//STRIP001 					break;
//STRIP001 				case SWSTYLEBIT_HTML:
//STRIP001 					nId |= COLL_HTML_BITS;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				pColl->SetPoolFmtId(nId);
//STRIP001 
//STRIP001 				pWrtShell->SetTxtFmtColl(pColl);
//STRIP001 				pWrtShell->EndAllAction();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SFX_STYLE_FAMILY_FRAME:
//STRIP001 		{
//STRIP001 			SwFrmFmt* pFrm = pStyle->GetFrmFmt();
//STRIP001 			if(pWrtShell->IsFrmSelected() && pFrm && !pFrm->IsDefault())
//STRIP001 			{
//STRIP001 				pWrtShell->StartAllAction();
//STRIP001 
//STRIP001 				SfxItemSet aSet(GetPool(), aFrmFmtSetRange );
//STRIP001 				pWrtShell->GetFlyFrmAttr( aSet );
//STRIP001 
//STRIP001 				// JP 10.06.98: nur automatische Orientierungen uebernehmen
//STRIP001 /*				#61359# jetzt auch wieder alle Orientierungen
//STRIP001 				const SfxPoolItem* pItem;
//STRIP001 				if( SFX_ITEM_SET == aSet.GetItemState( RES_VERT_ORIENT,
//STRIP001 					FALSE, &pItem ) &&
//STRIP001 					VERT_NONE == ((SwFmtVertOrient*)pItem)->GetVertOrient())
//STRIP001 					aSet.ClearItem( RES_VERT_ORIENT );
//STRIP001 
//STRIP001 				if( SFX_ITEM_SET == aSet.GetItemState( RES_HORI_ORIENT,
//STRIP001 					FALSE, &pItem ) &&
//STRIP001 					HORI_NONE == ((SwFmtHoriOrient*)pItem)->GetHoriOrient())
//STRIP001 					aSet.ClearItem( RES_HORI_ORIENT );
//STRIP001  */
//STRIP001 
//STRIP001 				pFrm->SetAttr( aSet );
//STRIP001 					// Vorlage auch anwenden, um harte Attributierung
//STRIP001 					// zu entfernen
//STRIP001 				pWrtShell->SetFrmFmt( pFrm );
//STRIP001 				pWrtShell->EndAllAction();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SFX_STYLE_FAMILY_CHAR:
//STRIP001 		{
//STRIP001 			SwCharFmt* pChar = pStyle->GetCharFmt();
//STRIP001 			if(pChar && !pChar->IsDefault())
//STRIP001 			{
//STRIP001 				pWrtShell->StartAllAction();
//STRIP001 				pWrtShell->FillByEx( pChar );
//STRIP001 				pChar->SetDerivedFrom( pWrtShell->GetCurCharFmt() );
//STRIP001 				SwFmtCharFmt aFmt( pChar );
//STRIP001 				pWrtShell->SetAttr( aFmt );
//STRIP001 				pWrtShell->EndAllAction();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SFX_STYLE_FAMILY_PAGE:
//STRIP001 		{
//STRIP001 			pWrtShell->StartAllAction();
//STRIP001 			USHORT nPgDsc = pWrtShell->GetCurPageDesc();
//STRIP001 			SwPageDesc& rSrc = (SwPageDesc&)pWrtShell->GetPageDesc( nPgDsc );
//STRIP001 			SwPageDesc& rDest = *(SwPageDesc*)pStyle->GetPageDesc();
//STRIP001 
//STRIP001 			USHORT nPoolId = rDest.GetPoolFmtId();
//STRIP001 			USHORT nHId = rDest.GetPoolHelpId();
//STRIP001 			BYTE nHFId = rDest.GetPoolHlpFileId();
//STRIP001 
//STRIP001 			pWrtShell->GetDoc()->CopyPageDesc( rSrc, rDest );
//STRIP001 
//STRIP001 			// PoolId darf NIE kopiert werden!
//STRIP001 			rDest.SetPoolFmtId( nPoolId );
//STRIP001 			rDest.SetPoolHelpId( nHId );
//STRIP001 			rDest.SetPoolHlpFileId( nHFId );
//STRIP001 
//STRIP001 			// werden Kopf-/Fusszeilen angelegt, so gibt es kein Undo mehr!
//STRIP001 			pWrtShell->GetDoc()->DelAllUndoObj();
//STRIP001 
//STRIP001 			pWrtShell->EndAllAction();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SFX_STYLE_FAMILY_PSEUDO:
//STRIP001 		{
//STRIP001 			pWrtShell->StartAllAction();
//STRIP001 
//STRIP001 			SwNumRule aRule( *pWrtShell->GetCurNumRule() );
//STRIP001 			String sOrigRule( aRule.GetName() );
//STRIP001 			aRule.SetName( pStyle->GetNumRule()->GetName() );
//STRIP001 			pWrtShell->ChgNumRuleFmts( aRule );
//STRIP001 
//STRIP001 			pWrtShell->ReplaceNumRule( sOrigRule, aRule.GetName() );
//STRIP001 
//STRIP001 
//STRIP001 			pWrtShell->EndAllAction();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	return nFamily;
//STRIP001 }

//STRIP001 void  SwDocShell::LoadStyles( SfxObjectShell& rSource )
//STRIP001 {
//STRIP001     _LoadStyles(rSource, FALSE);
//STRIP001 }
/* -----------------16.05.2003 15:45-----------------            
    bPreserveCurrentDocument determines whether SetFixFields() is called
    This call modifies the source document. This mustn't happen when the source 
    is a document the user is working on.
    Calls of ::LoadStyles() normally use files especially loaded for the purpose 
    of importing styles.
 --------------------------------------------------*/
//STRIP001 void SwDocShell::_LoadStyles( SfxObjectShell& rSource, BOOL bPreserveCurrentDocument )
//STRIP001 {
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Diese Methode wird vom SFx gerufen, wenn aus einer Dokument-Vorlage
//STRIP001 	Styles nachgeladen werden sollen. Bestehende Styles soll dabei
//STRIP001 	"uberschrieben werden. Das Dokument mu"s daher neu formatiert werden.
//STRIP001 	Daher werden die Applikationen in der Regel diese Methode "uberladen
//STRIP001 	und in ihrer Implementierung die Implementierung der Basisklasse
//STRIP001 	rufen.
//STRIP001 */
//STRIP001 	// ist die Source unser Document, dann uebernehmen wir das
//STRIP001 	// abpruefen selbst (wesentlich schneller und laeuft nicht ueber
//STRIP001 	// die Kruecke SfxStylePool
//STRIP001 	if( rSource.ISA( SwDocShell ))
//STRIP001 	{
//STRIP001 		//JP 28.05.99: damit die Kopf-/Fusszeilen nicht den fixen Inhalt
//STRIP001 		// 				der Vorlage erhalten, einmal alle FixFelder der
//STRIP001 		//				Source aktualisieren
//STRIP001      if(!bPreserveCurrentDocument)
//STRIP001 		((SwDocShell&)rSource).pDoc->SetFixFields();
//STRIP001 		if( pWrtShell )
//STRIP001 		{
//STRIP001 			pWrtShell->StartAllAction();
//STRIP001 			pDoc->ReplaceStyles( *((SwDocShell&)rSource).pDoc );
//STRIP001 			pWrtShell->EndAllAction();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			BOOL bModified = pDoc->IsModified();
//STRIP001 			pDoc->ReplaceStyles( *((SwDocShell&)rSource).pDoc );
//STRIP001 			if( !bModified && pDoc->IsModified() && !pView )
//STRIP001 			{
//STRIP001 				// die View wird spaeter angelegt, ueberschreibt aber das
//STRIP001 				// Modify-Flag. Per Undo ist sowieso nichts mehr zu machen
//STRIP001 				pDoc->SetUndoNoResetModified();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SfxObjectShell::LoadStyles( rSource );
//STRIP001 }


//STRIP001 void SwDocShell::FormatPage( const String& rPage, BOOL bColumn, SwWrtShell* 	pActShell )
//STRIP001 {
//STRIP001 	Edit( rPage, aEmptyStr, SFX_STYLE_FAMILY_PAGE, 0, FALSE, bColumn, pActShell);
//STRIP001 }

//STRIP001 Bitmap SwDocShell::GetStyleFamilyBitmap( SfxStyleFamily eFamily, BmpColorMode eColorMode )
//STRIP001 {
//STRIP001 	if( SFX_STYLE_FAMILY_PSEUDO == eFamily )
//STRIP001 	{
//STRIP001 		if ( eColorMode == BMP_COLOR_NORMAL )
//STRIP001 			return Bitmap( SW_RES( BMP_STYLES_FAMILY_NUM ));
//STRIP001 		else
//STRIP001 			return Bitmap( SW_RES( BMP_STYLES_FAMILY_NUM_HC ));
//STRIP001 	}
//STRIP001 
//STRIP001 	return SfxObjectShell::GetStyleFamilyBitmap( eFamily, eColorMode );
//STRIP001 }



}
