/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SchRangeChecker.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:39:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/**	$Revision  
	@descr A RangeChecker has the task to test if the y value range of a given
		data set complies with a given chart type.
	
	@author
		Andre Fischer (af)
*/

#ifndef CHART_RANGE_CHECKER_HEADER
#define CHART_RANGE_CHECKER_HEADER

// auto strip #ifndef _SVX_CHRTITEM_HXX
// auto strip #include <bf_svx/chrtitem.hxx>
// auto strip #endif
namespace binfilter {

class	ChartModel;

//STRIP001 class	SchRangeChecker
//STRIP001 {
//STRIP001 public:
//STRIP001 	/**
//STRIP001 		@descr The constructor stores a pointer to a chart model so that the
//STRIP001 			testing methods can derive information from it.
//STRIP001 			
//STRIP001 		@param pChartModel	
//STRIP001 			Chart model from which the data values are taken and tested.
//STRIP001 	*/
//STRIP001 	SchRangeChecker		(ChartModel * pChartModel);
//STRIP001 	
//STRIP001 	///	@descr	Destroy the object.
//STRIP001 	~SchRangeChecker	(void);
//STRIP001 
//STRIP001 	/**
//STRIP001 		@descr Test if there are positive and negative y-values and the given 
//STRIP001 			chart style does not allow signed values.
//STRIP001 			
//STRIP001 		@param eChartStyle
//STRIP001 			Chart style that defines the valid value range.
//STRIP001 			
//STRIP001 		@return
//STRIP001 			TRUE if y-values comply with the valid value range.
//STRIP001 	*/
//STRIP001 	BOOL	TestAbsoluteValues		(SvxChartStyle eChartStyle);
//STRIP001 	
//STRIP001 	/**
//STRIP001 		@descr Test if there are negative y-values and the given chart 
//STRIP001 			style does not allow them.
//STRIP001 			
//STRIP001 		@param eChartStyle
//STRIP001 			Chart style that defines the valid value range.
//STRIP001 			
//STRIP001 		@return
//STRIP001 			TRUE if y-values comply with the valid value range.
//STRIP001 	*/
//STRIP001 	BOOL	TestNegativeValues		(SvxChartStyle eChartStyle);
//STRIP001 	
//STRIP001 	/**
//STRIP001 		@descr Test if there are negative or zero y-values on a logarithmic
//STRIP001 			scale.
//STRIP001 			
//STRIP001 		@return
//STRIP001 			TRUE if y-values comply with the valid value range.
//STRIP001 	*/
//STRIP001 	BOOL	TestLogarithmicValues	(void);
//STRIP001 	
//STRIP001 private:
//STRIP001 	/**	@descr	Chart model used for testing value ranges.  This shoud be a 
//STRIP001 		const pointer because the model is not modified in this class, but 
//STRIP001 		all relevant Get methods are non const :(
//STRIP001 	*/
//STRIP001 	ChartModel	*	mpChartModel;
//STRIP001 	double			mfMin,	//	Minimum value of all data points.
//STRIP001 					mfMax;	//	Maximum value of all data points.
//STRIP001 };

} //namespace binfilter
#endif
