// pkg_changelog.cc
//
//  Copyright 2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.

#include "pkg_changelog.h"
#include "pkg_acqfile.h"

#include "../../config.h"
#include "../aptitude.h"

#include "apt.h"

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/stat.h>

#include <apt-pkg/error.h>
#include <apt-pkg/configuration.h>
#include <apt-pkg/acquire-item.h>
#include <apt-pkg/strutl.h>

using namespace std;

pkg_changelog::pkg_changelog(string _filename):filename(_filename)
{
}

pkg_changelog::~pkg_changelog()
{
  if(unlink(filename.c_str())==-1)
    _error->WarningE("unlink", "%s", filename.c_str());
}

/** HACK: This just overrides the failure method to catch 404s. */
class AcqWithFail:public pkgAcqFileSane
{
  bool &failed;
public:
  AcqWithFail(pkgAcquire *Owner, string URI,
	      string Description, string ShortDesc, string filename,
	      bool &_failed):
    pkgAcqFileSane(Owner, URI, Description, ShortDesc, filename),
    failed(_failed)
  {
    failed=false;
  }

  void Failed(string Message, pkgAcquire::MethodConfig *Cnf)
  {
    failed=true;
  }

  void get_failed();
};

pkg_changelog *get_changelog(pkgCache::VerIterator ver,
			     pkgAcquireStatus *status)
{
  if(ver.FileList().end())
    return NULL;

  string filename="aptitudeXXXXXX";

  // Look up the source package.
  pkgRecords::Parser &rec=apt_package_records->Lookup(ver.FileList());
  string srcpkg=rec.SourcePkg().empty()?ver.ParentPkg().Name():rec.SourcePkg();

  if(getenv("HOME"))
    {
      string dotdir(getenv("HOME"));
      dotdir+="/.aptitude";
      if(mkdir(dotdir.c_str(), 0700)<0 && errno!=EEXIST)
	{
	  _error->Errno("mkdir", "%s", dotdir.c_str());
	  return NULL;
	}
      string tmpdotdir(dotdir+"/.tmp");
      if(mkdir(tmpdotdir.c_str(), 0700)<0 && errno!=EEXIST)
	{
	  _error->Errno("mkdir", "%s", tmpdotdir.c_str());
	  return NULL;
	}
      filename=tmpdotdir+"/"+filename;
    }
  else
    {
      _error->Warning(_("Can't get value of $HOME, using TMPDIR (insecure)"));
      if(getenv("TMPDIR"))
	filename=getenv("TMPDIR")+("/"+filename);
      else
	filename="/tmp/"+filename;
    }
  filename=mktemp((char *) filename.c_str());

  char uribuf[1024];

  string section=ver.Section();

  if(section.find('/')!=section.npos)
    section=string(section, 0, section.find('/'));
  else
    section="main";

  string prefix;

  prefix+=srcpkg[0];

  if(srcpkg.size()>3 && srcpkg[0]=='l' && srcpkg[1]=='i' && srcpkg[2]=='b')
    prefix=std::string("lib")+srcpkg[3];

  // packages.d.o uses a munged version number.
  string verstr=ver.VerStr();

  if(verstr.find(':')!=verstr.npos)
    verstr=string(verstr, verstr.find(':')+1);

  snprintf(uribuf,
	   sizeof(uribuf),
	   "http://packages.debian.org/changelogs/pool/%s/%s/%s/%s_%s/changelog",
	   section.c_str(),
	   prefix.c_str(),
	   srcpkg.c_str(),
	   srcpkg.c_str(),
	   verstr.c_str());

  pkgAcquire fetcher(status);

  char buf[512];
  snprintf(buf, 512, _("ChangeLog of %s"), ver.ParentPkg().Name());

  bool failed=false;
  new AcqWithFail(&fetcher,
		  uribuf,
		  buf,
		  buf,
		  filename,
		  failed);

  sigset_t signals,oldsigs;
  sigemptyset(&signals);
  sigaddset(&signals, SIGWINCH);
  sigprocmask(SIG_UNBLOCK, &signals, &oldsigs);

  if(fetcher.Run()!=pkgAcquire::Continue || failed)
    {
      _error->Error("Couldn't fetch URL %s", uribuf);

      sigprocmask(SIG_SETMASK, &oldsigs, &signals);
      if(unlink(filename.c_str())<0 && errno!=EEXIST)
	_error->WarningE("unlink", "%s", filename.c_str());
      return NULL;
    }

  sigprocmask(SIG_SETMASK, &oldsigs, &signals);
  return new pkg_changelog(filename);
}
