module Xml =

  let comment = del /(<!--(--[^>]|-[^-]|[^-])*-->|[ \t\n]+)/ ""
  let wso = /[ \t\n]*/
  let wsp = /[ \t\n]+/
  let s = del wso ""
  let sep = del wsp " "

  let name_re = /[A-Za-z_:][A-Za-z0-9._:-]+/
  let val_re = /("[^"]*"|'[^']*')/   (* " Emacs: relax *)

  let attrs = [ sep . key name_re . del (wso . "=" . wso) "=" . store val_re ]*

  let stag (n:string) = 
   Util.del_str "<" . label n . attrs . del (wso . ">") ">"

  let etag (n:string) = 
   let t = "</" . n in
   del (t . wso . ">") (t . ">")

  let mtag (n:string) = 
   Util.del_str "<" . label n . attrs . del (wso . "/>") "/>"
