// Brutal Chess
//
// File : movelog.cpp
// Date : 07/08/05
// Authors : Maxwell Lazaroff
//
// Description : Glorified stack that tracks movement and taking.

#include <vector>
#include "board.h"
#include <string>
#include <fstream>
#include "movelog.h"

using namespace std;

void
MoveLog::reset()
{
	_log.clear();
	return;
}
void
MoveLog::push(const Board & board, const BoardMove & move)
{
	LogEntry entry;
	Piece piece;
	piece.setUnit(EMPTY);
	piece.setColor(BLANK);

	piece.setUnit(board._board[move.getEndx()][move.getEndy()].getUnit());
	piece.setColor(board._board[move.getEndx()][move.getEndy()].getColor());

	entry.piece = piece;
	entry.move = move;

	_log.push_back(entry);

	return;
}
LogEntry
MoveLog::pop()
{
	LogEntry entry = _log.back();
	_log.pop_back();
	return entry;
}

void
MoveLog::write(string & filename)
{
	ofstream out(filename.c_str(), ios::out);

	LogEntry entry;
	BoardMove tempmove;

	for( unsigned int i = 0; i < _log.size(); i++ )
	{
		entry = _log.at(i);
		tempmove = entry.move;
		out << tempmove.getStartFile() << tempmove.getStartRank();
		if(entry.piece.getUnit() != EMPTY)
			out << 'x';
		else
			out << '-';
		out << tempmove.getEndFile() << tempmove.getEndRank();
		out << endl;
	}

}
