/***************************************************************************
*	Brutal Chess Pre-Alpha Build
*	- randomplayer.cpp
*
*	Authors: Maxwell Lazaroff, Michael Cook, and Joe Flint
*	Date Created : May 3th, 2005
*	Last Modified: June 2nd, 2005
*
*	- description - Implements the methods of RandomPlayer.
***************************************************************************/

#include <time.h>

#include "randomplayer.h"

BoardMove
RandomPlayer::decide_move(const Board & board, bool & white)
{
	bool checkedstarts[8][8];
	bool checkedends[8][8];
	for(int i = 0; i < 8; i++)
	{
		for(int j = 0; j < 8; j++)
		{
			checkedstarts[i][j] = false;
		}
	}

	srand((unsigned)time(NULL));

	uint startrow = 0;
	uint startcol = 0;

	uint endrow;
	uint endcol;

	int endmovecount = 0;

	BoardMove move;

	bool goodmove = false;
	while(!goodmove)
	{
		startrow = rand()%8;
		startcol = rand()%8;
		while(checkedstarts[startrow][startcol]) {
			startrow = rand()%8;
			startcol = rand()%8;
		}

		for(int i = 0; i < 8; i++)
		{
			for(int j = 0; j < 8; j++)
			{
				checkedends[i][j] = false;
			}
		}

		endmovecount = 0;

		if(white && board._board[startrow][startcol].getColor() == WHITE)
		{
			while(endmovecount < 64 && !goodmove)
			{
				endrow = rand()%8;
				endcol = rand()%8;
				while(checkedends[endrow][endcol])
				{
					endrow = rand()%8;
					endcol = rand()%8;
				}

				move.setStartx(startrow);
				move.setStarty(startcol);
				move.setEndx(endrow);
				move.setEndy(endcol);

				goodmove = check_move(move, board, white);
				checkedends[endrow][endcol] = true;
				endmovecount++;
			}
		}
		if(!white && board._board[startrow][startcol].getColor() == BLACK)
		{
			while(endmovecount < 64 && !goodmove)
			{
				endrow = rand()%8;
				endcol = rand()%8;
				while(checkedends[endrow][endcol])
				{
					endrow = rand()%8;
					endcol = rand()%8;
				}

				move.setStartx(startrow);
				move.setStarty(startcol);
				move.setEndx(endrow);
				move.setEndy(endcol);

				goodmove = check_move(move, board, white);
				checkedends[endrow][endcol] = true;
				endmovecount++;
			}
		}
		checkedstarts[startrow][startcol] = true;
	}
	return move;
}

// End of file randomplayer.cpp
