/***************************************************************************
                          kmesslistviewitem.h  -  description
                             -------------------
    begin                : Fri Mar 28 2003
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2005 by Diederik van der Boor
    email                : mkb137b@hotmail.com
                           vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSLISTVIEWITEM_H
#define KMESSLISTVIEWITEM_H

#include <qlistview.h>

// Forward declarations
class QSimpleRichText;
class QString;


/**
 * @author Mike K. Bennett
 */
class KMessListViewItem : public QListViewItem
{
  public:
    enum ListTypes
    {
      LISTTYPE_BASE    = -1,
      LISTTYPE_GROUP   =  0,
      LISTTYPE_CONTACT =  1
    };

    // The constructor
                         KMessListViewItem(QListView *parent);
    // The constructor
                         KMessListViewItem(QListViewItem *parent);
    // The destructor
                        ~KMessListViewItem();

    // Compare
//     virtual int          compare( QListViewItem *item, int column, bool ascending ) const;
    // Return the type of the item
    virtual int          getType() const;
    // Paint a cell (column 0, always) - this allows us emoticons, through QSimpleRichText
    void                 paintCell( QPainter * painter, const QColorGroup & colourGroup, int column, int width, int align );
    // dummy setText method
    void                 setHTMLText(const QString &text);

  protected:
    // Re-sort the parent nodes
    void                 resortParent();

  private: // Private methods
    // Recreate the rich text
    void                 recreateRichText(const QString &text);
    // returns the width of the text in the column
    int                  width ( const QFontMetrics & fm, const QListView * lv, int c ) const;

  private: // Private attributes

    // The rich text painter
    QSimpleRichText     *richText_;
    // The rich text painter used to get the real width
    QSimpleRichText     *widthText_;

    // TODO: Remove this, temporary fix
    QListView           *listParent_;
};

#endif
