/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * CompoundFontRecord.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.merge;

import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;

/**
 * Creation-Date: 20.07.2007, 18:55:08
 *
 * @author Thomas Morgner
 */
public class CompoundFontRecord implements FontRecord
{
  /*
   * Specifiying the boldSpecified and italicsSpecified is a dirty hack and should be removed pretty soon.  
   */

  private FontRecord base;
  private CompoundFontFamily family;
  private boolean boldSpecified;
  private boolean italicsSpecified;
  private FontIdentifier identifier;


  public CompoundFontRecord(final FontRecord base,
                            final CompoundFontFamily family,
                            final boolean boldSpecified,
                            final boolean italicsSpecified)
  {
    this.base = base;
    this.family = family;
    this.boldSpecified = boldSpecified;
    this.italicsSpecified = italicsSpecified;
  }

  public FontRecord getBase()
  {
    return base;
  }

  public FontFamily getFamily()
  {
    return family;
  }

  public boolean isBold()
  {
    return base.isBold();
  }

  public boolean isItalic()
  {
    return base.isItalic();
  }

  public boolean isOblique()
  {
    return base.isOblique();
  }

  public FontIdentifier getIdentifier()
  {
    if (identifier == null)
    {
      identifier = new CompoundFontIdentifier
          (base.getIdentifier(), family.getRegistry(), boldSpecified, italicsSpecified);
    }
    return identifier;
  }
}
