/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml.css;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jhotdraw.xml.css.CSSRule;
import org.jhotdraw.xml.css.StyleManager;

public class CSSParser {
    public void parse(String string, StyleManager styleManager) throws IOException {
        this.parse(new StringReader(string), styleManager);
    }

    public void parse(Reader reader, StyleManager styleManager) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(160, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.commentChar(47);
        streamTokenizer.slashStarComments(true);
        this.parseStylesheet(streamTokenizer, styleManager);
    }

    private void parseStylesheet(StreamTokenizer streamTokenizer, StyleManager styleManager) throws IOException {
        while (streamTokenizer.nextToken() != -1) {
            streamTokenizer.pushBack();
            this.parseRuleset(streamTokenizer, styleManager);
        }
    }

    private void parseRuleset(StreamTokenizer streamTokenizer, StyleManager styleManager) throws IOException {
        List<String> list = this.parseSelectorList(streamTokenizer);
        if (streamTokenizer.nextToken() != 123) {
            throw new IOException("Ruleset '{' missing for " + list);
        }
        Map<String, String> map = this.parseDeclarationMap(streamTokenizer);
        if (streamTokenizer.nextToken() != 125) {
            throw new IOException("Ruleset '}' missing for " + list);
        }
        for (String string : list) {
            styleManager.add(new CSSRule(string, map));
        }
    }

    private List<String> parseSelectorList(StreamTokenizer streamTokenizer) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        block4: while (streamTokenizer.nextToken() != -1 && streamTokenizer.ttype != 123) {
            switch (streamTokenizer.ttype) {
                case -3: {
                    if (bl) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(streamTokenizer.sval);
                    bl = true;
                    continue block4;
                }
                case 44: {
                    linkedList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    bl = false;
                    continue block4;
                }
            }
            if (bl) {
                stringBuilder.append(' ');
            }
            stringBuilder.append((char)streamTokenizer.ttype);
            bl = false;
        }
        if (stringBuilder.length() != 0) {
            linkedList.add(stringBuilder.toString());
        }
        streamTokenizer.pushBack();
        return linkedList;
    }

    private Map<String, String> parseDeclarationMap(StreamTokenizer streamTokenizer) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        do {
            StringBuilder stringBuilder = new StringBuilder();
            block7: while (streamTokenizer.nextToken() != -1 && streamTokenizer.ttype != 125 && streamTokenizer.ttype != 58 && streamTokenizer.ttype != 59) {
                switch (streamTokenizer.ttype) {
                    case -3: {
                        stringBuilder.append(streamTokenizer.sval);
                        continue block7;
                    }
                }
                stringBuilder.append((char)streamTokenizer.ttype);
            }
            if (streamTokenizer.ttype == 125 && stringBuilder.length() == 0) break;
            if (streamTokenizer.ttype != 58) {
                throw new IOException("Declaration ':' missing for " + stringBuilder);
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl = false;
            block8: while (streamTokenizer.nextToken() != -1 && streamTokenizer.ttype != 59 && streamTokenizer.ttype != 125) {
                switch (streamTokenizer.ttype) {
                    case -3: {
                        if (bl) {
                            stringBuilder2.append(' ');
                        }
                        stringBuilder2.append(streamTokenizer.sval);
                        bl = true;
                        continue block8;
                    }
                }
                stringBuilder2.append((char)streamTokenizer.ttype);
                bl = false;
            }
            hashMap.put(stringBuilder.toString(), stringBuilder2.toString());
        } while (streamTokenizer.ttype != 125 && streamTokenizer.ttype != -1);
        streamTokenizer.pushBack();
        return hashMap;
    }
}

