/*
 * Decompiled with CFR 0.152.
 */
package org.anywikidraw.mediawiki;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.anywikidraw.any.AbstractDrawingApplet;
import org.anywikidraw.any.DrawingPanel;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.ImageInputFormat;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.gui.DrawingComponent;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;
import org.jhotdraw.samples.svg.io.SVGZOutputFormat;

public class MediaWikiDrawingApplet
extends AbstractDrawingApplet {
    public MediaWikiDrawingApplet() {
        this.setName(MessageFormat.format("AnyWikiDraw {0} for MediaWiki", this.getVersion()));
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MediaWikiDrawingApplet mediaWikiDrawingApplet = new MediaWikiDrawingApplet();
                JFrame jFrame = new JFrame(mediaWikiDrawingApplet.getName());
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.setDefaultCloseOperation(3);
                jFrame.getContentPane().add((Component)mediaWikiDrawingApplet, "Center");
                jFrame.setSize(400, 400);
                mediaWikiDrawingApplet.init();
                jFrame.setVisible(true);
            }
        });
    }

    @Override
    protected Drawing createDrawing() {
        DefaultDrawing defaultDrawing = new DefaultDrawing();
        LinkedList<InputFormat> linkedList = new LinkedList<InputFormat>();
        linkedList.add(new SVGZInputFormat());
        linkedList.add(new ImageInputFormat(new SVGImageFigure()));
        linkedList.add(new ImageInputFormat(new SVGImageFigure(), "JPEG", "JPEG", "jpg", 1));
        LinkedList<OutputFormat> linkedList2 = new LinkedList<OutputFormat>();
        linkedList2.add(new SVGOutputFormat());
        linkedList2.add(new SVGZOutputFormat());
        linkedList2.add(new ImageOutputFormat());
        linkedList2.add(new ImageOutputFormat("JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        linkedList2.add(new ImageOutputFormat("BMP", "Windows Bitmap (BMP)", "bmp", 13));
        defaultDrawing.setInputFormats(linkedList);
        defaultDrawing.setOutputFormats(linkedList2);
        if (this.getParameter("DrawingWidth") != null && this.getParameter("DrawingHeight") != null) {
            try {
                double d = Double.parseDouble(this.getParameter("DrawingWidth"));
                double d2 = Double.parseDouble(this.getParameter("DrawingHeight"));
                if (d > 0.0 && d2 > 0.0) {
                    SVGAttributeKeys.CANVAS_WIDTH.set(defaultDrawing, d);
                    SVGAttributeKeys.CANVAS_HEIGHT.set(defaultDrawing, d2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultDrawing;
    }

    @Override
    protected DrawingComponent createDrawingComponent() {
        return new DrawingPanel();
    }

    @Override
    protected DrawingPanel getDrawingComponent() {
        return (DrawingPanel)super.getDrawingComponent();
    }

    private void initComponents() {
    }
}

