//
// OpCodes.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// Generated by /CodeGen/cecil-gen.rb do not edit
// Fri Jun 06 13:04:02 +0200 2008
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Mono.Cecil.Cil {

	public sealed class OpCodes {

		internal static readonly OpCode [] OneByteOpCode = new OpCode [0xe0 + 1];
		internal static readonly OpCode [] TwoBytesOpCode = new OpCode [0x1e + 1];

		public static readonly OpCode Nop = new OpCode (
			0xff, 0x00,
			Code.Nop, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Break = new OpCode (
			0xff, 0x01,
			Code.Break, FlowControl.Break,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Ldarg_0 = new OpCode (
			0xff, 0x02,
			Code.Ldarg_0, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldarg_1 = new OpCode (
			0xff, 0x03,
			Code.Ldarg_1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldarg_2 = new OpCode (
			0xff, 0x04,
			Code.Ldarg_2, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldarg_3 = new OpCode (
			0xff, 0x05,
			Code.Ldarg_3, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloc_0 = new OpCode (
			0xff, 0x06,
			Code.Ldloc_0, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloc_1 = new OpCode (
			0xff, 0x07,
			Code.Ldloc_1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloc_2 = new OpCode (
			0xff, 0x08,
			Code.Ldloc_2, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloc_3 = new OpCode (
			0xff, 0x09,
			Code.Ldloc_3, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Stloc_0 = new OpCode (
			0xff, 0x0a,
			Code.Stloc_0, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Stloc_1 = new OpCode (
			0xff, 0x0b,
			Code.Stloc_1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Stloc_2 = new OpCode (
			0xff, 0x0c,
			Code.Stloc_2, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Stloc_3 = new OpCode (
			0xff, 0x0d,
			Code.Stloc_3, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Ldarg_S = new OpCode (
			0xff, 0x0e,
			Code.Ldarg_S, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineParam,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldarga_S = new OpCode (
			0xff, 0x0f,
			Code.Ldarga_S, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineParam,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Starg_S = new OpCode (
			0xff, 0x10,
			Code.Starg_S, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineParam,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Ldloc_S = new OpCode (
			0xff, 0x11,
			Code.Ldloc_S, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineVar,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloca_S = new OpCode (
			0xff, 0x12,
			Code.Ldloca_S, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineVar,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Stloc_S = new OpCode (
			0xff, 0x13,
			Code.Stloc_S, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineVar,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Ldnull = new OpCode (
			0xff, 0x14,
			Code.Ldnull, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushref);

		public static readonly OpCode Ldc_I4_M1 = new OpCode (
			0xff, 0x15,
			Code.Ldc_I4_M1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_0 = new OpCode (
			0xff, 0x16,
			Code.Ldc_I4_0, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_1 = new OpCode (
			0xff, 0x17,
			Code.Ldc_I4_1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_2 = new OpCode (
			0xff, 0x18,
			Code.Ldc_I4_2, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_3 = new OpCode (
			0xff, 0x19,
			Code.Ldc_I4_3, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_4 = new OpCode (
			0xff, 0x1a,
			Code.Ldc_I4_4, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_5 = new OpCode (
			0xff, 0x1b,
			Code.Ldc_I4_5, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_6 = new OpCode (
			0xff, 0x1c,
			Code.Ldc_I4_6, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_7 = new OpCode (
			0xff, 0x1d,
			Code.Ldc_I4_7, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_8 = new OpCode (
			0xff, 0x1e,
			Code.Ldc_I4_8, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_S = new OpCode (
			0xff, 0x1f,
			Code.Ldc_I4_S, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineI,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4 = new OpCode (
			0xff, 0x20,
			Code.Ldc_I4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineI,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I8 = new OpCode (
			0xff, 0x21,
			Code.Ldc_I8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineI8,
			StackBehaviour.Pop0, StackBehaviour.Pushi8);

		public static readonly OpCode Ldc_R4 = new OpCode (
			0xff, 0x22,
			Code.Ldc_R4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.ShortInlineR,
			StackBehaviour.Pop0, StackBehaviour.Pushr4);

		public static readonly OpCode Ldc_R8 = new OpCode (
			0xff, 0x23,
			Code.Ldc_R8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineR,
			StackBehaviour.Pop0, StackBehaviour.Pushr8);

		public static readonly OpCode Dup = new OpCode (
			0xff, 0x25,
			Code.Dup, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push1_push1);

		public static readonly OpCode Pop = new OpCode (
			0xff, 0x26,
			Code.Pop, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Jmp = new OpCode (
			0xff, 0x27,
			Code.Jmp, FlowControl.Call,
			OpCodeType.Primitive, OperandType.InlineMethod,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Call = new OpCode (
			0xff, 0x28,
			Code.Call, FlowControl.Call,
			OpCodeType.Primitive, OperandType.InlineMethod,
			StackBehaviour.Varpop, StackBehaviour.Varpush);

		public static readonly OpCode Calli = new OpCode (
			0xff, 0x29,
			Code.Calli, FlowControl.Call,
			OpCodeType.Primitive, OperandType.InlineSig,
			StackBehaviour.Varpop, StackBehaviour.Varpush);

		public static readonly OpCode Ret = new OpCode (
			0xff, 0x2a,
			Code.Ret, FlowControl.Return,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Varpop, StackBehaviour.Push0);

		public static readonly OpCode Br_S = new OpCode (
			0xff, 0x2b,
			Code.Br_S, FlowControl.Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Brfalse_S = new OpCode (
			0xff, 0x2c,
			Code.Brfalse_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Brtrue_S = new OpCode (
			0xff, 0x2d,
			Code.Brtrue_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Beq_S = new OpCode (
			0xff, 0x2e,
			Code.Beq_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bge_S = new OpCode (
			0xff, 0x2f,
			Code.Bge_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bgt_S = new OpCode (
			0xff, 0x30,
			Code.Bgt_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Ble_S = new OpCode (
			0xff, 0x31,
			Code.Ble_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Blt_S = new OpCode (
			0xff, 0x32,
			Code.Blt_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bne_Un_S = new OpCode (
			0xff, 0x33,
			Code.Bne_Un_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bge_Un_S = new OpCode (
			0xff, 0x34,
			Code.Bge_Un_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bgt_Un_S = new OpCode (
			0xff, 0x35,
			Code.Bgt_Un_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Ble_Un_S = new OpCode (
			0xff, 0x36,
			Code.Ble_Un_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Blt_Un_S = new OpCode (
			0xff, 0x37,
			Code.Blt_Un_S, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Br = new OpCode (
			0xff, 0x38,
			Code.Br, FlowControl.Branch,
			OpCodeType.Primitive, OperandType.InlineBrTarget,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Brfalse = new OpCode (
			0xff, 0x39,
			Code.Brfalse, FlowControl.Cond_Branch,
			OpCodeType.Primitive, OperandType.InlineBrTarget,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Brtrue = new OpCode (
			0xff, 0x3a,
			Code.Brtrue, FlowControl.Cond_Branch,
			OpCodeType.Primitive, OperandType.InlineBrTarget,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Beq = new OpCode (
			0xff, 0x3b,
			Code.Beq, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bge = new OpCode (
			0xff, 0x3c,
			Code.Bge, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bgt = new OpCode (
			0xff, 0x3d,
			Code.Bgt, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Ble = new OpCode (
			0xff, 0x3e,
			Code.Ble, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Blt = new OpCode (
			0xff, 0x3f,
			Code.Blt, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bne_Un = new OpCode (
			0xff, 0x40,
			Code.Bne_Un, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bge_Un = new OpCode (
			0xff, 0x41,
			Code.Bge_Un, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bgt_Un = new OpCode (
			0xff, 0x42,
			Code.Bgt_Un, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Ble_Un = new OpCode (
			0xff, 0x43,
			Code.Ble_Un, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Blt_Un = new OpCode (
			0xff, 0x44,
			Code.Blt_Un, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Switch = new OpCode (
			0xff, 0x45,
			Code.Switch, FlowControl.Cond_Branch,
			OpCodeType.Primitive, OperandType.InlineSwitch,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Ldind_I1 = new OpCode (
			0xff, 0x46,
			Code.Ldind_I1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_U1 = new OpCode (
			0xff, 0x47,
			Code.Ldind_U1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_I2 = new OpCode (
			0xff, 0x48,
			Code.Ldind_I2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_U2 = new OpCode (
			0xff, 0x49,
			Code.Ldind_U2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_I4 = new OpCode (
			0xff, 0x4a,
			Code.Ldind_I4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_U4 = new OpCode (
			0xff, 0x4b,
			Code.Ldind_U4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_I8 = new OpCode (
			0xff, 0x4c,
			Code.Ldind_I8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi8);

		public static readonly OpCode Ldind_I = new OpCode (
			0xff, 0x4d,
			Code.Ldind_I, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_R4 = new OpCode (
			0xff, 0x4e,
			Code.Ldind_R4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushr4);

		public static readonly OpCode Ldind_R8 = new OpCode (
			0xff, 0x4f,
			Code.Ldind_R8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushr8);

		public static readonly OpCode Ldind_Ref = new OpCode (
			0xff, 0x50,
			Code.Ldind_Ref, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushref);

		public static readonly OpCode Stind_Ref = new OpCode (
			0xff, 0x51,
			Code.Stind_Ref, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stind_I1 = new OpCode (
			0xff, 0x52,
			Code.Stind_I1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stind_I2 = new OpCode (
			0xff, 0x53,
			Code.Stind_I2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stind_I4 = new OpCode (
			0xff, 0x54,
			Code.Stind_I4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stind_I8 = new OpCode (
			0xff, 0x55,
			Code.Stind_I8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi8, StackBehaviour.Push0);

		public static readonly OpCode Stind_R4 = new OpCode (
			0xff, 0x56,
			Code.Stind_R4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popr4, StackBehaviour.Push0);

		public static readonly OpCode Stind_R8 = new OpCode (
			0xff, 0x57,
			Code.Stind_R8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popr8, StackBehaviour.Push0);

		public static readonly OpCode Add = new OpCode (
			0xff, 0x58,
			Code.Add, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Sub = new OpCode (
			0xff, 0x59,
			Code.Sub, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Mul = new OpCode (
			0xff, 0x5a,
			Code.Mul, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Div = new OpCode (
			0xff, 0x5b,
			Code.Div, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Div_Un = new OpCode (
			0xff, 0x5c,
			Code.Div_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Rem = new OpCode (
			0xff, 0x5d,
			Code.Rem, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Rem_Un = new OpCode (
			0xff, 0x5e,
			Code.Rem_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode And = new OpCode (
			0xff, 0x5f,
			Code.And, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Or = new OpCode (
			0xff, 0x60,
			Code.Or, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Xor = new OpCode (
			0xff, 0x61,
			Code.Xor, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Shl = new OpCode (
			0xff, 0x62,
			Code.Shl, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Shr = new OpCode (
			0xff, 0x63,
			Code.Shr, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Shr_Un = new OpCode (
			0xff, 0x64,
			Code.Shr_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Neg = new OpCode (
			0xff, 0x65,
			Code.Neg, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push1);

		public static readonly OpCode Not = new OpCode (
			0xff, 0x66,
			Code.Not, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push1);

		public static readonly OpCode Conv_I1 = new OpCode (
			0xff, 0x67,
			Code.Conv_I1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_I2 = new OpCode (
			0xff, 0x68,
			Code.Conv_I2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_I4 = new OpCode (
			0xff, 0x69,
			Code.Conv_I4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_I8 = new OpCode (
			0xff, 0x6a,
			Code.Conv_I8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Conv_R4 = new OpCode (
			0xff, 0x6b,
			Code.Conv_R4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushr4);

		public static readonly OpCode Conv_R8 = new OpCode (
			0xff, 0x6c,
			Code.Conv_R8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushr8);

		public static readonly OpCode Conv_U4 = new OpCode (
			0xff, 0x6d,
			Code.Conv_U4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_U8 = new OpCode (
			0xff, 0x6e,
			Code.Conv_U8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Callvirt = new OpCode (
			0xff, 0x6f,
			Code.Callvirt, FlowControl.Call,
			OpCodeType.Objmodel, OperandType.InlineMethod,
			StackBehaviour.Varpop, StackBehaviour.Varpush);

		public static readonly OpCode Cpobj = new OpCode (
			0xff, 0x70,
			Code.Cpobj, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Ldobj = new OpCode (
			0xff, 0x71,
			Code.Ldobj, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi, StackBehaviour.Push1);

		public static readonly OpCode Ldstr = new OpCode (
			0xff, 0x72,
			Code.Ldstr, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineString,
			StackBehaviour.Pop0, StackBehaviour.Pushref);

		public static readonly OpCode Newobj = new OpCode (
			0xff, 0x73,
			Code.Newobj, FlowControl.Call,
			OpCodeType.Objmodel, OperandType.InlineMethod,
			StackBehaviour.Varpop, StackBehaviour.Pushref);

		public static readonly OpCode Castclass = new OpCode (
			0xff, 0x74,
			Code.Castclass, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref, StackBehaviour.Pushref);

		public static readonly OpCode Isinst = new OpCode (
			0xff, 0x75,
			Code.Isinst, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref, StackBehaviour.Pushi);

		public static readonly OpCode Conv_R_Un = new OpCode (
			0xff, 0x76,
			Code.Conv_R_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushr8);

		public static readonly OpCode Unbox = new OpCode (
			0xff, 0x79,
			Code.Unbox, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineType,
			StackBehaviour.Popref, StackBehaviour.Pushi);

		public static readonly OpCode Throw = new OpCode (
			0xff, 0x7a,
			Code.Throw, FlowControl.Throw,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref, StackBehaviour.Push0);

		public static readonly OpCode Ldfld = new OpCode (
			0xff, 0x7b,
			Code.Ldfld, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Popref, StackBehaviour.Push1);

		public static readonly OpCode Ldflda = new OpCode (
			0xff, 0x7c,
			Code.Ldflda, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Popref, StackBehaviour.Pushi);

		public static readonly OpCode Stfld = new OpCode (
			0xff, 0x7d,
			Code.Stfld, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Popref_pop1, StackBehaviour.Push0);

		public static readonly OpCode Ldsfld = new OpCode (
			0xff, 0x7e,
			Code.Ldsfld, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldsflda = new OpCode (
			0xff, 0x7f,
			Code.Ldsflda, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Stsfld = new OpCode (
			0xff, 0x80,
			Code.Stsfld, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Stobj = new OpCode (
			0xff, 0x81,
			Code.Stobj, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi_pop1, StackBehaviour.Push0);

		public static readonly OpCode Conv_Ovf_I1_Un = new OpCode (
			0xff, 0x82,
			Code.Conv_Ovf_I1_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I2_Un = new OpCode (
			0xff, 0x83,
			Code.Conv_Ovf_I2_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I4_Un = new OpCode (
			0xff, 0x84,
			Code.Conv_Ovf_I4_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I8_Un = new OpCode (
			0xff, 0x85,
			Code.Conv_Ovf_I8_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Conv_Ovf_U1_Un = new OpCode (
			0xff, 0x86,
			Code.Conv_Ovf_U1_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U2_Un = new OpCode (
			0xff, 0x87,
			Code.Conv_Ovf_U2_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U4_Un = new OpCode (
			0xff, 0x88,
			Code.Conv_Ovf_U4_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U8_Un = new OpCode (
			0xff, 0x89,
			Code.Conv_Ovf_U8_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Conv_Ovf_I_Un = new OpCode (
			0xff, 0x8a,
			Code.Conv_Ovf_I_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U_Un = new OpCode (
			0xff, 0x8b,
			Code.Conv_Ovf_U_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Box = new OpCode (
			0xff, 0x8c,
			Code.Box, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineType,
			StackBehaviour.Pop1, StackBehaviour.Pushref);

		public static readonly OpCode Newarr = new OpCode (
			0xff, 0x8d,
			Code.Newarr, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi, StackBehaviour.Pushref);

		public static readonly OpCode Ldlen = new OpCode (
			0xff, 0x8e,
			Code.Ldlen, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref, StackBehaviour.Pushi);

		public static readonly OpCode Ldelema = new OpCode (
			0xff, 0x8f,
			Code.Ldelema, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_I1 = new OpCode (
			0xff, 0x90,
			Code.Ldelem_I1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_U1 = new OpCode (
			0xff, 0x91,
			Code.Ldelem_U1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_I2 = new OpCode (
			0xff, 0x92,
			Code.Ldelem_I2, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_U2 = new OpCode (
			0xff, 0x93,
			Code.Ldelem_U2, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_I4 = new OpCode (
			0xff, 0x94,
			Code.Ldelem_I4, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_U4 = new OpCode (
			0xff, 0x95,
			Code.Ldelem_U4, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_I8 = new OpCode (
			0xff, 0x96,
			Code.Ldelem_I8, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi8);

		public static readonly OpCode Ldelem_I = new OpCode (
			0xff, 0x97,
			Code.Ldelem_I, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_R4 = new OpCode (
			0xff, 0x98,
			Code.Ldelem_R4, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushr4);

		public static readonly OpCode Ldelem_R8 = new OpCode (
			0xff, 0x99,
			Code.Ldelem_R8, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushr8);

		public static readonly OpCode Ldelem_Ref = new OpCode (
			0xff, 0x9a,
			Code.Ldelem_Ref, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushref);

		public static readonly OpCode Stelem_I = new OpCode (
			0xff, 0x9b,
			Code.Stelem_I, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stelem_I1 = new OpCode (
			0xff, 0x9c,
			Code.Stelem_I1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stelem_I2 = new OpCode (
			0xff, 0x9d,
			Code.Stelem_I2, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stelem_I4 = new OpCode (
			0xff, 0x9e,
			Code.Stelem_I4, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stelem_I8 = new OpCode (
			0xff, 0x9f,
			Code.Stelem_I8, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popi8, StackBehaviour.Push0);

		public static readonly OpCode Stelem_R4 = new OpCode (
			0xff, 0xa0,
			Code.Stelem_R4, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popr4, StackBehaviour.Push0);

		public static readonly OpCode Stelem_R8 = new OpCode (
			0xff, 0xa1,
			Code.Stelem_R8, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popr8, StackBehaviour.Push0);

		public static readonly OpCode Stelem_Ref = new OpCode (
			0xff, 0xa2,
			Code.Stelem_Ref, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popref, StackBehaviour.Push0);

		public static readonly OpCode Ldelem_Any = new OpCode (
			0xff, 0xa3,
			Code.Ldelem_Any, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref_popi, StackBehaviour.Push1);

		public static readonly OpCode Stelem_Any = new OpCode (
			0xff, 0xa4,
			Code.Stelem_Any, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref_popi_popref, StackBehaviour.Push0);

		public static readonly OpCode Unbox_Any = new OpCode (
			0xff, 0xa5,
			Code.Unbox_Any, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref, StackBehaviour.Push1);

		public static readonly OpCode Conv_Ovf_I1 = new OpCode (
			0xff, 0xb3,
			Code.Conv_Ovf_I1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U1 = new OpCode (
			0xff, 0xb4,
			Code.Conv_Ovf_U1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I2 = new OpCode (
			0xff, 0xb5,
			Code.Conv_Ovf_I2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U2 = new OpCode (
			0xff, 0xb6,
			Code.Conv_Ovf_U2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I4 = new OpCode (
			0xff, 0xb7,
			Code.Conv_Ovf_I4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U4 = new OpCode (
			0xff, 0xb8,
			Code.Conv_Ovf_U4, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I8 = new OpCode (
			0xff, 0xb9,
			Code.Conv_Ovf_I8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Conv_Ovf_U8 = new OpCode (
			0xff, 0xba,
			Code.Conv_Ovf_U8, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Refanyval = new OpCode (
			0xff, 0xc2,
			Code.Refanyval, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineType,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Ckfinite = new OpCode (
			0xff, 0xc3,
			Code.Ckfinite, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushr8);

		public static readonly OpCode Mkrefany = new OpCode (
			0xff, 0xc6,
			Code.Mkrefany, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineType,
			StackBehaviour.Popi, StackBehaviour.Push1);

		public static readonly OpCode Ldtoken = new OpCode (
			0xff, 0xd0,
			Code.Ldtoken, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineTok,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Conv_U2 = new OpCode (
			0xff, 0xd1,
			Code.Conv_U2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_U1 = new OpCode (
			0xff, 0xd2,
			Code.Conv_U1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_I = new OpCode (
			0xff, 0xd3,
			Code.Conv_I, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I = new OpCode (
			0xff, 0xd4,
			Code.Conv_Ovf_I, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U = new OpCode (
			0xff, 0xd5,
			Code.Conv_Ovf_U, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Add_Ovf = new OpCode (
			0xff, 0xd6,
			Code.Add_Ovf, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Add_Ovf_Un = new OpCode (
			0xff, 0xd7,
			Code.Add_Ovf_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Mul_Ovf = new OpCode (
			0xff, 0xd8,
			Code.Mul_Ovf, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Mul_Ovf_Un = new OpCode (
			0xff, 0xd9,
			Code.Mul_Ovf_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Sub_Ovf = new OpCode (
			0xff, 0xda,
			Code.Sub_Ovf, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Sub_Ovf_Un = new OpCode (
			0xff, 0xdb,
			Code.Sub_Ovf_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Endfinally = new OpCode (
			0xff, 0xdc,
			Code.Endfinally, FlowControl.Return,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Leave = new OpCode (
			0xff, 0xdd,
			Code.Leave, FlowControl.Branch,
			OpCodeType.Primitive, OperandType.InlineBrTarget,
			StackBehaviour.PopAll, StackBehaviour.Push0);

		public static readonly OpCode Leave_S = new OpCode (
			0xff, 0xde,
			Code.Leave_S, FlowControl.Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.PopAll, StackBehaviour.Push0);

		public static readonly OpCode Stind_I = new OpCode (
			0xff, 0xdf,
			Code.Stind_I, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Conv_U = new OpCode (
			0xff, 0xe0,
			Code.Conv_U, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Arglist = new OpCode (
			0xfe, 0x00,
			Code.Arglist, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ceq = new OpCode (
			0xfe, 0x01,
			Code.Ceq, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Pushi);

		public static readonly OpCode Cgt = new OpCode (
			0xfe, 0x02,
			Code.Cgt, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Pushi);

		public static readonly OpCode Cgt_Un = new OpCode (
			0xfe, 0x03,
			Code.Cgt_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Pushi);

		public static readonly OpCode Clt = new OpCode (
			0xfe, 0x04,
			Code.Clt, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Pushi);

		public static readonly OpCode Clt_Un = new OpCode (
			0xfe, 0x05,
			Code.Clt_Un, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Pushi);

		public static readonly OpCode Ldftn = new OpCode (
			0xfe, 0x06,
			Code.Ldftn, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineMethod,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldvirtftn = new OpCode (
			0xfe, 0x07,
			Code.Ldvirtftn, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineMethod,
			StackBehaviour.Popref, StackBehaviour.Pushi);

		public static readonly OpCode Ldarg = new OpCode (
			0xfe, 0x09,
			Code.Ldarg, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineParam,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldarga = new OpCode (
			0xfe, 0x0a,
			Code.Ldarga, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineParam,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Starg = new OpCode (
			0xfe, 0x0b,
			Code.Starg, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineParam,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Ldloc = new OpCode (
			0xfe, 0x0c,
			Code.Ldloc, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineVar,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloca = new OpCode (
			0xfe, 0x0d,
			Code.Ldloca, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineVar,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Stloc = new OpCode (
			0xfe, 0x0e,
			Code.Stloc, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineVar,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Localloc = new OpCode (
			0xfe, 0x0f,
			Code.Localloc, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Endfilter = new OpCode (
			0xfe, 0x11,
			Code.Endfilter, FlowControl.Return,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Unaligned = new OpCode (
			0xfe, 0x12,
			Code.Unaligned, FlowControl.Meta,
			OpCodeType.Prefix, OperandType.ShortInlineI,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Volatile = new OpCode (
			0xfe, 0x13,
			Code.Volatile, FlowControl.Meta,
			OpCodeType.Prefix, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Tail = new OpCode (
			0xfe, 0x14,
			Code.Tail, FlowControl.Meta,
			OpCodeType.Prefix, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Initobj = new OpCode (
			0xfe, 0x15,
			Code.Initobj, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Constrained = new OpCode (
			0xfe, 0x16,
			Code.Constrained, FlowControl.Next,
			OpCodeType.Prefix, OperandType.InlineType,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Cpblk = new OpCode (
			0xfe, 0x17,
			Code.Cpblk, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Initblk = new OpCode (
			0xfe, 0x18,
			Code.Initblk, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode No = new OpCode (
			0xfe, 0x19,
			Code.No, FlowControl.Next,
			OpCodeType.Prefix, OperandType.ShortInlineI,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Rethrow = new OpCode (
			0xfe, 0x1a,
			Code.Rethrow, FlowControl.Throw,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Sizeof = new OpCode (
			0xfe, 0x1c,
			Code.Sizeof, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineType,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Refanytype = new OpCode (
			0xfe, 0x1d,
			Code.Refanytype, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Readonly = new OpCode (
			0xfe, 0x1e,
			Code.Readonly, FlowControl.Next,
			OpCodeType.Prefix, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		OpCodes ()
		{
		}

		public static OpCode GetOpCode (Code code)
		{
			switch (code) {
			case Code.Nop : return OpCodes.Nop;
			case Code.Break : return OpCodes.Break;
			case Code.Ldarg_0 : return OpCodes.Ldarg_0;
			case Code.Ldarg_1 : return OpCodes.Ldarg_1;
			case Code.Ldarg_2 : return OpCodes.Ldarg_2;
			case Code.Ldarg_3 : return OpCodes.Ldarg_3;
			case Code.Ldloc_0 : return OpCodes.Ldloc_0;
			case Code.Ldloc_1 : return OpCodes.Ldloc_1;
			case Code.Ldloc_2 : return OpCodes.Ldloc_2;
			case Code.Ldloc_3 : return OpCodes.Ldloc_3;
			case Code.Stloc_0 : return OpCodes.Stloc_0;
			case Code.Stloc_1 : return OpCodes.Stloc_1;
			case Code.Stloc_2 : return OpCodes.Stloc_2;
			case Code.Stloc_3 : return OpCodes.Stloc_3;
			case Code.Ldarg_S : return OpCodes.Ldarg_S;
			case Code.Ldarga_S : return OpCodes.Ldarga_S;
			case Code.Starg_S : return OpCodes.Starg_S;
			case Code.Ldloc_S : return OpCodes.Ldloc_S;
			case Code.Ldloca_S : return OpCodes.Ldloca_S;
			case Code.Stloc_S : return OpCodes.Stloc_S;
			case Code.Ldnull : return OpCodes.Ldnull;
			case Code.Ldc_I4_M1 : return OpCodes.Ldc_I4_M1;
			case Code.Ldc_I4_0 : return OpCodes.Ldc_I4_0;
			case Code.Ldc_I4_1 : return OpCodes.Ldc_I4_1;
			case Code.Ldc_I4_2 : return OpCodes.Ldc_I4_2;
			case Code.Ldc_I4_3 : return OpCodes.Ldc_I4_3;
			case Code.Ldc_I4_4 : return OpCodes.Ldc_I4_4;
			case Code.Ldc_I4_5 : return OpCodes.Ldc_I4_5;
			case Code.Ldc_I4_6 : return OpCodes.Ldc_I4_6;
			case Code.Ldc_I4_7 : return OpCodes.Ldc_I4_7;
			case Code.Ldc_I4_8 : return OpCodes.Ldc_I4_8;
			case Code.Ldc_I4_S : return OpCodes.Ldc_I4_S;
			case Code.Ldc_I4 : return OpCodes.Ldc_I4;
			case Code.Ldc_I8 : return OpCodes.Ldc_I8;
			case Code.Ldc_R4 : return OpCodes.Ldc_R4;
			case Code.Ldc_R8 : return OpCodes.Ldc_R8;
			case Code.Dup : return OpCodes.Dup;
			case Code.Pop : return OpCodes.Pop;
			case Code.Jmp : return OpCodes.Jmp;
			case Code.Call : return OpCodes.Call;
			case Code.Calli : return OpCodes.Calli;
			case Code.Ret : return OpCodes.Ret;
			case Code.Br_S : return OpCodes.Br_S;
			case Code.Brfalse_S : return OpCodes.Brfalse_S;
			case Code.Brtrue_S : return OpCodes.Brtrue_S;
			case Code.Beq_S : return OpCodes.Beq_S;
			case Code.Bge_S : return OpCodes.Bge_S;
			case Code.Bgt_S : return OpCodes.Bgt_S;
			case Code.Ble_S : return OpCodes.Ble_S;
			case Code.Blt_S : return OpCodes.Blt_S;
			case Code.Bne_Un_S : return OpCodes.Bne_Un_S;
			case Code.Bge_Un_S : return OpCodes.Bge_Un_S;
			case Code.Bgt_Un_S : return OpCodes.Bgt_Un_S;
			case Code.Ble_Un_S : return OpCodes.Ble_Un_S;
			case Code.Blt_Un_S : return OpCodes.Blt_Un_S;
			case Code.Br : return OpCodes.Br;
			case Code.Brfalse : return OpCodes.Brfalse;
			case Code.Brtrue : return OpCodes.Brtrue;
			case Code.Beq : return OpCodes.Beq;
			case Code.Bge : return OpCodes.Bge;
			case Code.Bgt : return OpCodes.Bgt;
			case Code.Ble : return OpCodes.Ble;
			case Code.Blt : return OpCodes.Blt;
			case Code.Bne_Un : return OpCodes.Bne_Un;
			case Code.Bge_Un : return OpCodes.Bge_Un;
			case Code.Bgt_Un : return OpCodes.Bgt_Un;
			case Code.Ble_Un : return OpCodes.Ble_Un;
			case Code.Blt_Un : return OpCodes.Blt_Un;
			case Code.Switch : return OpCodes.Switch;
			case Code.Ldind_I1 : return OpCodes.Ldind_I1;
			case Code.Ldind_U1 : return OpCodes.Ldind_U1;
			case Code.Ldind_I2 : return OpCodes.Ldind_I2;
			case Code.Ldind_U2 : return OpCodes.Ldind_U2;
			case Code.Ldind_I4 : return OpCodes.Ldind_I4;
			case Code.Ldind_U4 : return OpCodes.Ldind_U4;
			case Code.Ldind_I8 : return OpCodes.Ldind_I8;
			case Code.Ldind_I : return OpCodes.Ldind_I;
			case Code.Ldind_R4 : return OpCodes.Ldind_R4;
			case Code.Ldind_R8 : return OpCodes.Ldind_R8;
			case Code.Ldind_Ref : return OpCodes.Ldind_Ref;
			case Code.Stind_Ref : return OpCodes.Stind_Ref;
			case Code.Stind_I1 : return OpCodes.Stind_I1;
			case Code.Stind_I2 : return OpCodes.Stind_I2;
			case Code.Stind_I4 : return OpCodes.Stind_I4;
			case Code.Stind_I8 : return OpCodes.Stind_I8;
			case Code.Stind_R4 : return OpCodes.Stind_R4;
			case Code.Stind_R8 : return OpCodes.Stind_R8;
			case Code.Add : return OpCodes.Add;
			case Code.Sub : return OpCodes.Sub;
			case Code.Mul : return OpCodes.Mul;
			case Code.Div : return OpCodes.Div;
			case Code.Div_Un : return OpCodes.Div_Un;
			case Code.Rem : return OpCodes.Rem;
			case Code.Rem_Un : return OpCodes.Rem_Un;
			case Code.And : return OpCodes.And;
			case Code.Or : return OpCodes.Or;
			case Code.Xor : return OpCodes.Xor;
			case Code.Shl : return OpCodes.Shl;
			case Code.Shr : return OpCodes.Shr;
			case Code.Shr_Un : return OpCodes.Shr_Un;
			case Code.Neg : return OpCodes.Neg;
			case Code.Not : return OpCodes.Not;
			case Code.Conv_I1 : return OpCodes.Conv_I1;
			case Code.Conv_I2 : return OpCodes.Conv_I2;
			case Code.Conv_I4 : return OpCodes.Conv_I4;
			case Code.Conv_I8 : return OpCodes.Conv_I8;
			case Code.Conv_R4 : return OpCodes.Conv_R4;
			case Code.Conv_R8 : return OpCodes.Conv_R8;
			case Code.Conv_U4 : return OpCodes.Conv_U4;
			case Code.Conv_U8 : return OpCodes.Conv_U8;
			case Code.Callvirt : return OpCodes.Callvirt;
			case Code.Cpobj : return OpCodes.Cpobj;
			case Code.Ldobj : return OpCodes.Ldobj;
			case Code.Ldstr : return OpCodes.Ldstr;
			case Code.Newobj : return OpCodes.Newobj;
			case Code.Castclass : return OpCodes.Castclass;
			case Code.Isinst : return OpCodes.Isinst;
			case Code.Conv_R_Un : return OpCodes.Conv_R_Un;
			case Code.Unbox : return OpCodes.Unbox;
			case Code.Throw : return OpCodes.Throw;
			case Code.Ldfld : return OpCodes.Ldfld;
			case Code.Ldflda : return OpCodes.Ldflda;
			case Code.Stfld : return OpCodes.Stfld;
			case Code.Ldsfld : return OpCodes.Ldsfld;
			case Code.Ldsflda : return OpCodes.Ldsflda;
			case Code.Stsfld : return OpCodes.Stsfld;
			case Code.Stobj : return OpCodes.Stobj;
			case Code.Conv_Ovf_I1_Un : return OpCodes.Conv_Ovf_I1_Un;
			case Code.Conv_Ovf_I2_Un : return OpCodes.Conv_Ovf_I2_Un;
			case Code.Conv_Ovf_I4_Un : return OpCodes.Conv_Ovf_I4_Un;
			case Code.Conv_Ovf_I8_Un : return OpCodes.Conv_Ovf_I8_Un;
			case Code.Conv_Ovf_U1_Un : return OpCodes.Conv_Ovf_U1_Un;
			case Code.Conv_Ovf_U2_Un : return OpCodes.Conv_Ovf_U2_Un;
			case Code.Conv_Ovf_U4_Un : return OpCodes.Conv_Ovf_U4_Un;
			case Code.Conv_Ovf_U8_Un : return OpCodes.Conv_Ovf_U8_Un;
			case Code.Conv_Ovf_I_Un : return OpCodes.Conv_Ovf_I_Un;
			case Code.Conv_Ovf_U_Un : return OpCodes.Conv_Ovf_U_Un;
			case Code.Box : return OpCodes.Box;
			case Code.Newarr : return OpCodes.Newarr;
			case Code.Ldlen : return OpCodes.Ldlen;
			case Code.Ldelema : return OpCodes.Ldelema;
			case Code.Ldelem_I1 : return OpCodes.Ldelem_I1;
			case Code.Ldelem_U1 : return OpCodes.Ldelem_U1;
			case Code.Ldelem_I2 : return OpCodes.Ldelem_I2;
			case Code.Ldelem_U2 : return OpCodes.Ldelem_U2;
			case Code.Ldelem_I4 : return OpCodes.Ldelem_I4;
			case Code.Ldelem_U4 : return OpCodes.Ldelem_U4;
			case Code.Ldelem_I8 : return OpCodes.Ldelem_I8;
			case Code.Ldelem_I : return OpCodes.Ldelem_I;
			case Code.Ldelem_R4 : return OpCodes.Ldelem_R4;
			case Code.Ldelem_R8 : return OpCodes.Ldelem_R8;
			case Code.Ldelem_Ref : return OpCodes.Ldelem_Ref;
			case Code.Stelem_I : return OpCodes.Stelem_I;
			case Code.Stelem_I1 : return OpCodes.Stelem_I1;
			case Code.Stelem_I2 : return OpCodes.Stelem_I2;
			case Code.Stelem_I4 : return OpCodes.Stelem_I4;
			case Code.Stelem_I8 : return OpCodes.Stelem_I8;
			case Code.Stelem_R4 : return OpCodes.Stelem_R4;
			case Code.Stelem_R8 : return OpCodes.Stelem_R8;
			case Code.Stelem_Ref : return OpCodes.Stelem_Ref;
			case Code.Ldelem_Any : return OpCodes.Ldelem_Any;
			case Code.Stelem_Any : return OpCodes.Stelem_Any;
			case Code.Unbox_Any : return OpCodes.Unbox_Any;
			case Code.Conv_Ovf_I1 : return OpCodes.Conv_Ovf_I1;
			case Code.Conv_Ovf_U1 : return OpCodes.Conv_Ovf_U1;
			case Code.Conv_Ovf_I2 : return OpCodes.Conv_Ovf_I2;
			case Code.Conv_Ovf_U2 : return OpCodes.Conv_Ovf_U2;
			case Code.Conv_Ovf_I4 : return OpCodes.Conv_Ovf_I4;
			case Code.Conv_Ovf_U4 : return OpCodes.Conv_Ovf_U4;
			case Code.Conv_Ovf_I8 : return OpCodes.Conv_Ovf_I8;
			case Code.Conv_Ovf_U8 : return OpCodes.Conv_Ovf_U8;
			case Code.Refanyval : return OpCodes.Refanyval;
			case Code.Ckfinite : return OpCodes.Ckfinite;
			case Code.Mkrefany : return OpCodes.Mkrefany;
			case Code.Ldtoken : return OpCodes.Ldtoken;
			case Code.Conv_U2 : return OpCodes.Conv_U2;
			case Code.Conv_U1 : return OpCodes.Conv_U1;
			case Code.Conv_I : return OpCodes.Conv_I;
			case Code.Conv_Ovf_I : return OpCodes.Conv_Ovf_I;
			case Code.Conv_Ovf_U : return OpCodes.Conv_Ovf_U;
			case Code.Add_Ovf : return OpCodes.Add_Ovf;
			case Code.Add_Ovf_Un : return OpCodes.Add_Ovf_Un;
			case Code.Mul_Ovf : return OpCodes.Mul_Ovf;
			case Code.Mul_Ovf_Un : return OpCodes.Mul_Ovf_Un;
			case Code.Sub_Ovf : return OpCodes.Sub_Ovf;
			case Code.Sub_Ovf_Un : return OpCodes.Sub_Ovf_Un;
			case Code.Endfinally : return OpCodes.Endfinally;
			case Code.Leave : return OpCodes.Leave;
			case Code.Leave_S : return OpCodes.Leave_S;
			case Code.Stind_I : return OpCodes.Stind_I;
			case Code.Conv_U : return OpCodes.Conv_U;
			case Code.Arglist : return OpCodes.Arglist;
			case Code.Ceq : return OpCodes.Ceq;
			case Code.Cgt : return OpCodes.Cgt;
			case Code.Cgt_Un : return OpCodes.Cgt_Un;
			case Code.Clt : return OpCodes.Clt;
			case Code.Clt_Un : return OpCodes.Clt_Un;
			case Code.Ldftn : return OpCodes.Ldftn;
			case Code.Ldvirtftn : return OpCodes.Ldvirtftn;
			case Code.Ldarg : return OpCodes.Ldarg;
			case Code.Ldarga : return OpCodes.Ldarga;
			case Code.Starg : return OpCodes.Starg;
			case Code.Ldloc : return OpCodes.Ldloc;
			case Code.Ldloca : return OpCodes.Ldloca;
			case Code.Stloc : return OpCodes.Stloc;
			case Code.Localloc : return OpCodes.Localloc;
			case Code.Endfilter : return OpCodes.Endfilter;
			case Code.Unaligned : return OpCodes.Unaligned;
			case Code.Volatile : return OpCodes.Volatile;
			case Code.Tail : return OpCodes.Tail;
			case Code.Initobj : return OpCodes.Initobj;
			case Code.Constrained : return OpCodes.Constrained;
			case Code.Cpblk : return OpCodes.Cpblk;
			case Code.Initblk : return OpCodes.Initblk;
			case Code.No : return OpCodes.No;
			case Code.Rethrow : return OpCodes.Rethrow;
			case Code.Sizeof : return OpCodes.Sizeof;
			case Code.Refanytype : return OpCodes.Refanytype;
			case Code.Readonly : return OpCodes.Readonly;
			default : return OpCodes.Nop;
			}
		}
	}
}
