/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.StructMemberTranslator;
import com.sap.dbtech.jdbc.translators.Structure;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;

public class ABAPStreamArray
implements Array {
    StructMemberTranslator[] memberTranslator;
    StructuredBytes rawData;
    int elementCount;
    int recordSize;
    ArrayList elements;
    String baseTypeName;

    public ABAPStreamArray(StructuredBytes structuredBytes, StructMemberTranslator[] structMemberTranslatorArray, int n, String string) throws SQLException {
        this.rawData = structuredBytes;
        this.memberTranslator = structMemberTranslatorArray;
        this.elementCount = n;
        this.elements = new ArrayList();
        if (this.rawData.size() % n != 0) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.oddsize"));
        }
        this.recordSize = this.rawData.size() / n;
        this.baseTypeName = string;
        this.rawData.traceOn(System.err);
    }

    public int getBaseType() throws SQLException {
        return 0;
    }

    public Object getArray() throws SQLException {
        this.checkArray(0L, this.elementCount);
        return this.elements.toArray();
    }

    public Object getArray(long l, int n) throws SQLException {
        return null;
    }

    public String getBaseTypeName() throws SQLException {
        return this.baseTypeName;
    }

    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        return null;
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        return null;
    }

    public Object getArray(Map map) throws SQLException {
        return null;
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        return null;
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        return null;
    }

    private void checkArray(long l, int n) throws SQLException {
        long l2;
        for (l2 = l; l2 < (long)n && l2 < (long)this.elements.size(); ++l2) {
            if (this.elements.get((int)l2) != null) continue;
            this.elements.set((int)l2, this.getObject(l2));
        }
        for (l2 = (long)this.elements.size(); l2 < (long)n; ++l2) {
            this.elements.add(this.getObject(l2));
        }
    }

    private Object getObject(long l) throws SQLException {
        if (this.memberTranslator.length == 1) {
            return this.memberTranslator[0].getObject(this.rawData, (int)l * this.recordSize);
        }
        Object[] objectArray = new Object[this.memberTranslator.length];
        for (int i = 0; i < this.memberTranslator.length; ++i) {
            objectArray[i] = this.memberTranslator[i].getObject(this.rawData, (int)l * this.recordSize);
        }
        Structure structure = new Structure(objectArray, this.baseTypeName);
        return structure;
    }

    public String toString() {
        try {
            Object[] objectArray = (Object[])this.getArray();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("ARRAY [" + objectArray.length + "] = {");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    printWriter.println(",");
                }
                printWriter.print(objectArray[i].toString());
            }
            printWriter.println("");
            printWriter.println("}");
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return "*** not available ***";
        }
    }
}

