#ifndef _IMSDEV_H
#define _IMSDEV_H

#define SS_DEVTYPE 3
#define SS_PLAYER 0
#define SS_SAMPLER 1
#define SS_WAVETABLE 2
#define SS_MIDI 3
#define SS_NEEDPLAYER 4
#define SS_NEEDWAVETABLE 8

struct sounddevice;

struct deviceinfo
{
	struct sounddevice *dev;
	int16_t port;
	int16_t port2;
/*	signed char irq;
	signed char irq2;
	signed char dma;
	signed char dma2;*/
	uint32_t opt;
	int8_t subtype;
	uint8_t chan;
	uint32_t mem;
	char path[128]; /* can be like 127.0.0.1:32000, or stuff like /tmp/.esd .... or whatever you prefer or just empty for no force*/
	char mixer[128];
};

struct sounddevice
{
	char type;
	char name[32];
	int (*Detect)(struct deviceinfo *c);
	int (*Init)(const struct deviceinfo *c);
	void (*Close)(void);
};

#endif
