/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Fri Jul 12 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef TRANSFER_LIST_H
#define TRANSFER_LIST_H


#include <qlistview.h>
#include <qsimplerichtext.h>
#include <string>
#include "../prg/transfer.h"
#include "../prg/refpointer.h"


#define TRANSFER_LISTVIEW_COLUMNS 7

class TransferListView;
class TransferListViewItem;


class TransferListViewItem: public QListViewItem {
private:
  RefPointer<Transfer> _transfer;
  QSimpleRichText *_cell[TRANSFER_LISTVIEW_COLUMNS];
  int _ht;
  std::string _colour;

  void _populate();

public:
  TransferListViewItem(TransferListView *parent,
                       RefPointer<Transfer> t);
  TransferListViewItem(TransferListView *parent,
                       QListViewItem *after,
                       RefPointer<Transfer> t);
  TransferListViewItem(const TransferListViewItem &item);

  virtual ~TransferListViewItem();

  RefPointer<Transfer> getTransfer();

  virtual void paintCell(QPainter * p,
                         const QColorGroup & cg,
                         int column,
                         int width,
                         int align);
  virtual int width(const QFontMetrics &,
                    const QListView *,
                    int column) const;
  virtual void setup();
  virtual QString key(int column, bool ascending) const;

  void redrawItem();

  void setColour(const QString &c);
};



class TransferListView: public QListView {
  Q_OBJECT
private:
public:
  TransferListView(QWidget *parent=0, const char *name=0);
  virtual ~TransferListView();

  void addTransfer(RefPointer<Transfer> t);
  void addTransfers(const std::list<RefPointer<Transfer> > &ts);

  RefPointer<Transfer> getCurrentTransfer();
  std::list<RefPointer<Transfer> > getSelectedTransfers();
  void getSelectedTransfersToList(std::list<RefPointer<Transfer> > &tl);

public slots:
  void slotHeaderChanged(int section,
                         int oldSize,
                         int newSize);

};



#endif //TRANSFER_LIST_H







