/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collection;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.runtime.Frame;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CallsiteHook
extends RcovHook {
    private static CallsiteHook callsiteHook;
    private boolean active;
    private RubyHash defsites;
    private RubyHash callsites;

    public static CallsiteHook getCallsiteHook() {
        if (callsiteHook == null) {
            callsiteHook = new CallsiteHook();
        }
        return callsiteHook;
    }

    private CallsiteHook() {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public boolean isInterestedInEvent(RubyEvent rubyEvent) {
        return rubyEvent == RubyEvent.CALL || rubyEvent == RubyEvent.C_CALL;
    }

    public RubyArray getCallsiteInfo(Ruby ruby) {
        RubyArray rubyArray = ruby.newArray();
        rubyArray.add((Object)this.getCallsites(ruby));
        rubyArray.add((Object)this.getDefsites(ruby));
        return rubyArray;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    public RubyHash resetDefsites() {
        this.defsites.clear();
        return this.defsites;
    }

    public void eventHandler(ThreadContext threadContext, String string, String string2, int n, String string3, IRubyObject iRubyObject) {
        RubyArray rubyArray = threadContext.getRuntime().newArray();
        rubyArray.add((Object)threadContext.getFrameKlazz());
        rubyArray.add((Object)threadContext.getRuntime().newSymbol(string3));
        RubyArray rubyArray2 = threadContext.getRuntime().newArray();
        rubyArray2.add((Object)string2);
        rubyArray2.add((Object)n);
        this.defsites = this.getDefsites(threadContext.getRuntime());
        if (!threadContext.isWithinTrace()) {
            RubyArray rubyArray3;
            RubyHash rubyHash;
            threadContext.setWithinTrace(true);
            this.defsites.put((Object)rubyArray, (Object)rubyArray2);
            this.callsites = this.getCallsites(threadContext.getRuntime());
            if (!this.callsites.containsKey((Object)rubyArray)) {
                this.callsites.put((Object)rubyArray, (Object)RubyHash.newHash((Ruby)threadContext.getRuntime()));
            }
            if (!(rubyHash = (RubyHash)this.callsites.get((Object)rubyArray)).containsKey((Object)(rubyArray3 = this.customBacktrace(threadContext)))) {
                rubyHash.put((Object)rubyArray3, (Object)0L);
            }
            Long l = (Long)rubyHash.get((Object)rubyArray3);
            long l2 = l + 1L;
            rubyHash.put((Object)rubyArray3, (Object)l2);
            threadContext.setWithinTrace(false);
        }
    }

    private RubyArray customBacktrace(ThreadContext threadContext) {
        Frame[] frameArray = threadContext.createBacktrace(1, false);
        RubyArray rubyArray = threadContext.getRuntime().newArray();
        rubyArray.addAll((Collection)this.formatBacktrace(threadContext.getRuntime(), frameArray[frameArray.length - 1]));
        return threadContext.getRuntime().newArray((IRubyObject)rubyArray);
    }

    private RubyArray formatBacktrace(Ruby ruby, Frame frame) {
        RubyArray rubyArray = ruby.newArray();
        if (frame == null) {
            rubyArray.add((Object)ruby.getNil());
            rubyArray.add((Object)ruby.getNil());
            rubyArray.add((Object)"");
            rubyArray.add((Object)0L);
        } else {
            rubyArray.add((Object)frame.getKlazz());
            rubyArray.add(frame.getName() == null ? ruby.getNil() : ruby.newSymbol(frame.getName()));
            rubyArray.add((Object)frame.getFile());
            rubyArray.add((Object)(frame.getLine() + 1));
        }
        return rubyArray;
    }

    private RubyHash getCallsites(Ruby ruby) {
        if (this.callsites == null) {
            this.callsites = RubyHash.newHash((Ruby)ruby);
        }
        return this.callsites;
    }

    private RubyHash getDefsites(Ruby ruby) {
        if (this.defsites == null) {
            this.defsites = RubyHash.newHash((Ruby)ruby);
        }
        return this.defsites;
    }
}

